/* EmbeddingView.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphs;

/**
 * <p>
 * Interface representing a embedding of a graph into Euclidian n-space.<p>
 *
 * The abstract graph for which this is an embedding is called
 * the <i>peer</i> of this embedding and is of type {@link GraphView}. 
 * Note that the same abstract graph may act as a peer to different
 * embedded graphs at the same time.<p>
 *
 * When the peer graph is mutable, every embedding is supposed to also keep
 * track of the coordinates of the zombie vertices of that peer, 
 * i.e., vertices that used to belong to the graph but were removed later.
 *
 * <p>
 * This interface only provides read access to the embedded graph. Use the interface
 * {@link Embedding} if you also need write access.
 * </p>
 */
public interface EmbeddingView {
    
    /**
     * Returns the peer graph for this embedding.
     */
    public GraphView getPeer ();
    
    /**
     * Returns the dimension of the Euclidian space into which this graph
     * is embedded.
     */
    public int getDimension ();
        
    /**
     * Return the coordinates of the given vertex.
     * @throws IllegalArgumentException when the parameter is not a vertex
     * of the peer graph.
     */
    public double[] getCoordinates (Vertex v);
    
}
