package com.ibm.bsf.util.event;

import java.util.EventObject;

/**
 * <em>EventProcessor</em> is the interface that event adapters use to
 * delegate events they received to be delivered to the appropriate target.
 * They can simply deliver the event using processEvent or, if the event
 * can be excepted to, via processExceptionableEvent (in which case the
 * adapter is expected to forward on an exception to the source bean).
 * 
 * @author   Sanjiva Weerawarana
 * @author   Matthew J. Duftler
 * @see      EventAdapter
 */
public interface EventProcessor {
  public void processEvent (String filter, Object[] eventInfo);
  public void processExceptionableEvent (String filter, Object[] eventInfo) 
       throws Exception;
}

