/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:45 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 9 */

/*
 * This function contains 197 FP additions, 149 FP multiplications,
 * (or, 145 additions, 97 multiplications, 52 fused multiply/add),
 * 48 stack variables, and 72 memory accesses
 */
static const fftw_real K342020143 = FFTW_KONST(+0.342020143325668733044099614682259580763083368);
static const fftw_real K813797681 = FFTW_KONST(+0.813797681349373692844693217248393223289101568);
static const fftw_real K939692620 = FFTW_KONST(+0.939692620785908384054109277324731469936208134);
static const fftw_real K296198132 = FFTW_KONST(+0.296198132726023843175338011893050938967728390);
static const fftw_real K852868531 = FFTW_KONST(+0.852868531952443209628250963940074071936020296);
static const fftw_real K173648177 = FFTW_KONST(+0.173648177666930348851716626769314796000375677);
static const fftw_real K556670399 = FFTW_KONST(+0.556670399226419366452912952047023132968291906);
static const fftw_real K766044443 = FFTW_KONST(+0.766044443118978035202392650555416673935832457);
static const fftw_real K984807753 = FFTW_KONST(+0.984807753012208059366743024589523013670643252);
static const fftw_real K150383733 = FFTW_KONST(+0.150383733180435296639271897612501926072238258);
static const fftw_real K642787609 = FFTW_KONST(+0.642787609686539326322643409907263432907559884);
static const fftw_real K663413948 = FFTW_KONST(+0.663413948168938396205421319635891297216863310);
static const fftw_real K866025403 = FFTW_KONST(+0.866025403784438646763723170752936183471402627);
static const fftw_real K500000000 = FFTW_KONST(+0.500000000000000000000000000000000000000000000);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_9(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (9 * iostride);
     {
	  fftw_real tmp190;
	  fftw_real tmp204;
	  fftw_real tmp209;
	  fftw_real tmp208;
	  fftw_real tmp193;
	  fftw_real tmp216;
	  fftw_real tmp199;
	  fftw_real tmp207;
	  fftw_real tmp210;
	  fftw_real tmp191;
	  fftw_real tmp192;
	  fftw_real tmp194;
	  fftw_real tmp205;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp190 = X[0];
	  {
	       fftw_real tmp200;
	       fftw_real tmp201;
	       fftw_real tmp202;
	       fftw_real tmp203;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp200 = X[2 * iostride];
	       tmp201 = X[5 * iostride];
	       tmp202 = X[8 * iostride];
	       tmp203 = tmp201 + tmp202;
	       tmp204 = tmp200 + tmp203;
	       tmp209 = tmp200 - (K500000000 * tmp203);
	       tmp208 = tmp202 - tmp201;
	  }
	  tmp191 = X[3 * iostride];
	  tmp192 = X[6 * iostride];
	  tmp193 = tmp191 + tmp192;
	  tmp216 = tmp192 - tmp191;
	  {
	       fftw_real tmp195;
	       fftw_real tmp196;
	       fftw_real tmp197;
	       fftw_real tmp198;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp195 = X[iostride];
	       tmp196 = X[4 * iostride];
	       tmp197 = X[7 * iostride];
	       tmp198 = tmp196 + tmp197;
	       tmp199 = tmp195 + tmp198;
	       tmp207 = tmp195 - (K500000000 * tmp198);
	       tmp210 = tmp197 - tmp196;
	  }
	  Y[-3 * iostride] = K866025403 * (tmp204 - tmp199);
	  tmp194 = tmp190 + tmp193;
	  tmp205 = tmp199 + tmp204;
	  X[3 * iostride] = tmp194 - (K500000000 * tmp205);
	  X[0] = tmp194 + tmp205;
	  {
	       fftw_real tmp218;
	       fftw_real tmp214;
	       fftw_real tmp215;
	       fftw_real tmp217;
	       fftw_real tmp206;
	       fftw_real tmp211;
	       fftw_real tmp212;
	       fftw_real tmp213;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp218 = K866025403 * tmp216;
	       tmp214 = (K663413948 * tmp210) - (K642787609 * tmp207);
	       tmp215 = (K150383733 * tmp208) - (K984807753 * tmp209);
	       tmp217 = tmp214 + tmp215;
	       tmp206 = tmp190 - (K500000000 * tmp193);
	       tmp211 = (K766044443 * tmp207) + (K556670399 * tmp210);
	       tmp212 = (K173648177 * tmp209) + (K852868531 * tmp208);
	       tmp213 = tmp211 + tmp212;
	       X[iostride] = tmp206 + tmp213;
	       X[4 * iostride] = tmp206 + (K866025403 * (tmp214 - tmp215)) - (K500000000 * tmp213);
	       X[2 * iostride] = tmp206 + (K173648177 * tmp207) - (K296198132 * tmp208) - (K939692620 * tmp209) - (K852868531 * tmp210);
	       Y[-iostride] = tmp218 + tmp217;
	       Y[-4 * iostride] = (K866025403 * (tmp216 + (tmp212 - tmp211))) - (K500000000 * tmp217);
	       Y[-2 * iostride] = (K813797681 * tmp208) - (K342020143 * tmp209) - (K150383733 * tmp210) - (K984807753 * tmp207) - tmp218;
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 8) {
	  fftw_real tmp78;
	  fftw_real tmp176;
	  fftw_real tmp129;
	  fftw_real tmp175;
	  fftw_real tmp182;
	  fftw_real tmp181;
	  fftw_real tmp89;
	  fftw_real tmp126;
	  fftw_real tmp124;
	  fftw_real tmp146;
	  fftw_real tmp163;
	  fftw_real tmp172;
	  fftw_real tmp151;
	  fftw_real tmp162;
	  fftw_real tmp107;
	  fftw_real tmp135;
	  fftw_real tmp159;
	  fftw_real tmp171;
	  fftw_real tmp140;
	  fftw_real tmp160;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp83;
	       fftw_real tmp127;
	       fftw_real tmp88;
	       fftw_real tmp128;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp78 = X[0];
	       tmp176 = Y[-8 * iostride];
	       {
		    fftw_real tmp80;
		    fftw_real tmp82;
		    fftw_real tmp79;
		    fftw_real tmp81;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp80 = X[3 * iostride];
		    tmp82 = Y[-5 * iostride];
		    tmp79 = c_re(W[2]);
		    tmp81 = c_im(W[2]);
		    tmp83 = (tmp79 * tmp80) - (tmp81 * tmp82);
		    tmp127 = (tmp81 * tmp80) + (tmp79 * tmp82);
	       }
	       {
		    fftw_real tmp85;
		    fftw_real tmp87;
		    fftw_real tmp84;
		    fftw_real tmp86;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp85 = X[6 * iostride];
		    tmp87 = Y[-2 * iostride];
		    tmp84 = c_re(W[5]);
		    tmp86 = c_im(W[5]);
		    tmp88 = (tmp84 * tmp85) - (tmp86 * tmp87);
		    tmp128 = (tmp86 * tmp85) + (tmp84 * tmp87);
	       }
	       tmp129 = K866025403 * (tmp127 - tmp128);
	       tmp175 = tmp127 + tmp128;
	       tmp182 = tmp176 - (K500000000 * tmp175);
	       tmp181 = K866025403 * (tmp88 - tmp83);
	       tmp89 = tmp83 + tmp88;
	       tmp126 = tmp78 - (K500000000 * tmp89);
	  }
	  {
	       fftw_real tmp112;
	       fftw_real tmp148;
	       fftw_real tmp117;
	       fftw_real tmp143;
	       fftw_real tmp122;
	       fftw_real tmp144;
	       fftw_real tmp123;
	       fftw_real tmp149;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp109;
		    fftw_real tmp111;
		    fftw_real tmp108;
		    fftw_real tmp110;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp109 = X[2 * iostride];
		    tmp111 = Y[-6 * iostride];
		    tmp108 = c_re(W[1]);
		    tmp110 = c_im(W[1]);
		    tmp112 = (tmp108 * tmp109) - (tmp110 * tmp111);
		    tmp148 = (tmp110 * tmp109) + (tmp108 * tmp111);
	       }
	       {
		    fftw_real tmp114;
		    fftw_real tmp116;
		    fftw_real tmp113;
		    fftw_real tmp115;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp114 = X[5 * iostride];
		    tmp116 = Y[-3 * iostride];
		    tmp113 = c_re(W[4]);
		    tmp115 = c_im(W[4]);
		    tmp117 = (tmp113 * tmp114) - (tmp115 * tmp116);
		    tmp143 = (tmp115 * tmp114) + (tmp113 * tmp116);
	       }
	       {
		    fftw_real tmp119;
		    fftw_real tmp121;
		    fftw_real tmp118;
		    fftw_real tmp120;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp119 = X[8 * iostride];
		    tmp121 = Y[0];
		    tmp118 = c_re(W[7]);
		    tmp120 = c_im(W[7]);
		    tmp122 = (tmp118 * tmp119) - (tmp120 * tmp121);
		    tmp144 = (tmp120 * tmp119) + (tmp118 * tmp121);
	       }
	       tmp123 = tmp117 + tmp122;
	       tmp149 = tmp143 + tmp144;
	       {
		    fftw_real tmp142;
		    fftw_real tmp145;
		    fftw_real tmp147;
		    fftw_real tmp150;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp124 = tmp112 + tmp123;
		    tmp142 = tmp112 - (K500000000 * tmp123);
		    tmp145 = K866025403 * (tmp143 - tmp144);
		    tmp146 = tmp142 + tmp145;
		    tmp163 = tmp142 - tmp145;
		    tmp172 = tmp148 + tmp149;
		    tmp147 = K866025403 * (tmp122 - tmp117);
		    tmp150 = tmp148 - (K500000000 * tmp149);
		    tmp151 = tmp147 + tmp150;
		    tmp162 = tmp150 - tmp147;
	       }
	  }
	  {
	       fftw_real tmp95;
	       fftw_real tmp137;
	       fftw_real tmp100;
	       fftw_real tmp132;
	       fftw_real tmp105;
	       fftw_real tmp133;
	       fftw_real tmp106;
	       fftw_real tmp138;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp92;
		    fftw_real tmp94;
		    fftw_real tmp91;
		    fftw_real tmp93;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp92 = X[iostride];
		    tmp94 = Y[-7 * iostride];
		    tmp91 = c_re(W[0]);
		    tmp93 = c_im(W[0]);
		    tmp95 = (tmp91 * tmp92) - (tmp93 * tmp94);
		    tmp137 = (tmp93 * tmp92) + (tmp91 * tmp94);
	       }
	       {
		    fftw_real tmp97;
		    fftw_real tmp99;
		    fftw_real tmp96;
		    fftw_real tmp98;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp97 = X[4 * iostride];
		    tmp99 = Y[-4 * iostride];
		    tmp96 = c_re(W[3]);
		    tmp98 = c_im(W[3]);
		    tmp100 = (tmp96 * tmp97) - (tmp98 * tmp99);
		    tmp132 = (tmp98 * tmp97) + (tmp96 * tmp99);
	       }
	       {
		    fftw_real tmp102;
		    fftw_real tmp104;
		    fftw_real tmp101;
		    fftw_real tmp103;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp102 = X[7 * iostride];
		    tmp104 = Y[-iostride];
		    tmp101 = c_re(W[6]);
		    tmp103 = c_im(W[6]);
		    tmp105 = (tmp101 * tmp102) - (tmp103 * tmp104);
		    tmp133 = (tmp103 * tmp102) + (tmp101 * tmp104);
	       }
	       tmp106 = tmp100 + tmp105;
	       tmp138 = tmp132 + tmp133;
	       {
		    fftw_real tmp131;
		    fftw_real tmp134;
		    fftw_real tmp136;
		    fftw_real tmp139;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp107 = tmp95 + tmp106;
		    tmp131 = tmp95 - (K500000000 * tmp106);
		    tmp134 = K866025403 * (tmp132 - tmp133);
		    tmp135 = tmp131 + tmp134;
		    tmp159 = tmp131 - tmp134;
		    tmp171 = tmp137 + tmp138;
		    tmp136 = K866025403 * (tmp105 - tmp100);
		    tmp139 = tmp137 - (K500000000 * tmp138);
		    tmp140 = tmp136 + tmp139;
		    tmp160 = tmp139 - tmp136;
	       }
	  }
	  {
	       fftw_real tmp173;
	       fftw_real tmp90;
	       fftw_real tmp125;
	       fftw_real tmp170;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp173 = K866025403 * (tmp171 - tmp172);
	       tmp90 = tmp78 + tmp89;
	       tmp125 = tmp107 + tmp124;
	       tmp170 = tmp90 - (K500000000 * tmp125);
	       X[0] = tmp90 + tmp125;
	       X[3 * iostride] = tmp170 + tmp173;
	       Y[-6 * iostride] = tmp170 - tmp173;
	  }
	  {
	       fftw_real tmp179;
	       fftw_real tmp174;
	       fftw_real tmp177;
	       fftw_real tmp178;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp179 = K866025403 * (tmp124 - tmp107);
	       tmp174 = tmp171 + tmp172;
	       tmp177 = tmp175 + tmp176;
	       tmp178 = tmp177 - (K500000000 * tmp174);
	       Y[0] = tmp174 + tmp177;
	       Y[-3 * iostride] = tmp179 + tmp178;
	       X[6 * iostride] = -(tmp178 - tmp179);
	  }
	  {
	       fftw_real tmp130;
	       fftw_real tmp183;
	       fftw_real tmp153;
	       fftw_real tmp185;
	       fftw_real tmp157;
	       fftw_real tmp180;
	       fftw_real tmp154;
	       fftw_real tmp184;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp130 = tmp126 + tmp129;
	       tmp183 = tmp181 + tmp182;
	       {
		    fftw_real tmp141;
		    fftw_real tmp152;
		    fftw_real tmp155;
		    fftw_real tmp156;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp141 = (K766044443 * tmp135) + (K642787609 * tmp140);
		    tmp152 = (K173648177 * tmp146) + (K984807753 * tmp151);
		    tmp153 = tmp141 + tmp152;
		    tmp185 = K866025403 * (tmp152 - tmp141);
		    tmp155 = (K766044443 * tmp140) - (K642787609 * tmp135);
		    tmp156 = (K173648177 * tmp151) - (K984807753 * tmp146);
		    tmp157 = K866025403 * (tmp155 - tmp156);
		    tmp180 = tmp155 + tmp156;
	       }
	       X[iostride] = tmp130 + tmp153;
	       tmp154 = tmp130 - (K500000000 * tmp153);
	       Y[-7 * iostride] = tmp154 - tmp157;
	       X[4 * iostride] = tmp154 + tmp157;
	       Y[-iostride] = tmp180 + tmp183;
	       tmp184 = tmp183 - (K500000000 * tmp180);
	       X[7 * iostride] = -(tmp184 - tmp185);
	       Y[-4 * iostride] = tmp185 + tmp184;
	  }
	  {
	       fftw_real tmp158;
	       fftw_real tmp187;
	       fftw_real tmp165;
	       fftw_real tmp186;
	       fftw_real tmp169;
	       fftw_real tmp188;
	       fftw_real tmp166;
	       fftw_real tmp189;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp158 = tmp126 - tmp129;
	       tmp187 = tmp182 - tmp181;
	       {
		    fftw_real tmp161;
		    fftw_real tmp164;
		    fftw_real tmp167;
		    fftw_real tmp168;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp161 = (K173648177 * tmp159) + (K984807753 * tmp160);
		    tmp164 = (K342020143 * tmp162) - (K939692620 * tmp163);
		    tmp165 = tmp161 + tmp164;
		    tmp186 = K866025403 * (tmp164 - tmp161);
		    tmp167 = (K173648177 * tmp160) - (K984807753 * tmp159);
		    tmp168 = (K342020143 * tmp163) + (K939692620 * tmp162);
		    tmp169 = K866025403 * (tmp167 + tmp168);
		    tmp188 = tmp167 - tmp168;
	       }
	       X[2 * iostride] = tmp158 + tmp165;
	       tmp166 = tmp158 - (K500000000 * tmp165);
	       Y[-8 * iostride] = tmp166 - tmp169;
	       Y[-5 * iostride] = tmp166 + tmp169;
	       Y[-2 * iostride] = tmp188 + tmp187;
	       tmp189 = tmp187 - (K500000000 * tmp188);
	       X[5 * iostride] = -(tmp186 + tmp189);
	       X[8 * iostride] = -(tmp189 - tmp186);
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp23;
	  fftw_real tmp62;
	  fftw_real tmp58;
	  fftw_real tmp63;
	  fftw_real tmp64;
	  fftw_real tmp60;
	  fftw_real tmp30;
	  fftw_real tmp53;
	  fftw_real tmp4;
	  fftw_real tmp35;
	  fftw_real tmp7;
	  fftw_real tmp37;
	  fftw_real tmp8;
	  fftw_real tmp38;
	  fftw_real tmp12;
	  fftw_real tmp49;
	  fftw_real tmp45;
	  fftw_real tmp50;
	  fftw_real tmp51;
	  fftw_real tmp47;
	  fftw_real tmp19;
	  fftw_real tmp40;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  {
	       fftw_real tmp29;
	       fftw_real tmp57;
	       fftw_real tmp26;
	       fftw_real tmp55;
	       fftw_real tmp22;
	       fftw_real tmp21;
	       fftw_real tmp61;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp22 = X[2 * iostride];
	       tmp21 = c_re(W[1]);
	       tmp23 = tmp21 * tmp22;
	       tmp61 = c_im(W[1]);
	       tmp62 = tmp61 * tmp22;
	       {
		    fftw_real tmp28;
		    fftw_real tmp27;
		    fftw_real tmp56;
		    fftw_real tmp25;
		    fftw_real tmp24;
		    fftw_real tmp54;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp28 = X[8 * iostride];
		    tmp27 = c_re(W[7]);
		    tmp29 = tmp27 * tmp28;
		    tmp56 = c_im(W[7]);
		    tmp57 = tmp56 * tmp28;
		    tmp25 = X[5 * iostride];
		    tmp24 = c_re(W[4]);
		    tmp26 = tmp24 * tmp25;
		    tmp54 = c_im(W[4]);
		    tmp55 = tmp54 * tmp25;
	       }
	       tmp58 = K866025403 * (tmp55 - tmp57);
	       tmp63 = tmp55 + tmp57;
	       tmp64 = tmp62 - (K500000000 * tmp63);
	       tmp60 = K866025403 * (tmp29 - tmp26);
	       tmp30 = tmp26 + tmp29;
	       tmp53 = tmp23 - (K500000000 * tmp30);
	  }
	  {
	       fftw_real tmp3;
	       fftw_real tmp2;
	       fftw_real tmp34;
	       fftw_real tmp6;
	       fftw_real tmp5;
	       fftw_real tmp36;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp3 = X[3 * iostride];
	       tmp2 = c_re(W[2]);
	       tmp4 = tmp2 * tmp3;
	       tmp34 = c_im(W[2]);
	       tmp35 = tmp34 * tmp3;
	       tmp6 = X[6 * iostride];
	       tmp5 = c_re(W[5]);
	       tmp7 = tmp5 * tmp6;
	       tmp36 = c_im(W[5]);
	       tmp37 = tmp36 * tmp6;
	  }
	  tmp8 = tmp4 + tmp7;
	  tmp38 = K866025403 * (tmp35 - tmp37);
	  {
	       fftw_real tmp18;
	       fftw_real tmp44;
	       fftw_real tmp15;
	       fftw_real tmp42;
	       fftw_real tmp11;
	       fftw_real tmp10;
	       fftw_real tmp48;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp11 = X[iostride];
	       tmp10 = c_re(W[0]);
	       tmp12 = tmp10 * tmp11;
	       tmp48 = c_im(W[0]);
	       tmp49 = tmp48 * tmp11;
	       {
		    fftw_real tmp17;
		    fftw_real tmp16;
		    fftw_real tmp43;
		    fftw_real tmp14;
		    fftw_real tmp13;
		    fftw_real tmp41;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp17 = X[7 * iostride];
		    tmp16 = c_re(W[6]);
		    tmp18 = tmp16 * tmp17;
		    tmp43 = c_im(W[6]);
		    tmp44 = tmp43 * tmp17;
		    tmp14 = X[4 * iostride];
		    tmp13 = c_re(W[3]);
		    tmp15 = tmp13 * tmp14;
		    tmp41 = c_im(W[3]);
		    tmp42 = tmp41 * tmp14;
	       }
	       tmp45 = K866025403 * (tmp42 - tmp44);
	       tmp50 = tmp42 + tmp44;
	       tmp51 = tmp49 - (K500000000 * tmp50);
	       tmp47 = K866025403 * (tmp18 - tmp15);
	       tmp19 = tmp15 + tmp18;
	       tmp40 = tmp12 - (K500000000 * tmp19);
	  }
	  {
	       fftw_real tmp9;
	       fftw_real tmp33;
	       fftw_real tmp39;
	       fftw_real tmp20;
	       fftw_real tmp31;
	       fftw_real tmp32;
	       fftw_real tmp75;
	       fftw_real tmp76;
	       fftw_real tmp77;
	       fftw_real tmp67;
	       fftw_real tmp68;
	       fftw_real tmp66;
	       fftw_real tmp74;
	       fftw_real tmp69;
	       fftw_real tmp71;
	       fftw_real tmp72;
	       fftw_real tmp70;
	       fftw_real tmp73;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp9 = tmp1 + tmp8;
	       tmp33 = tmp1 - (K500000000 * tmp8);
	       tmp39 = tmp33 + tmp38;
	       tmp20 = tmp12 + tmp19;
	       tmp31 = tmp23 + tmp30;
	       tmp32 = tmp20 + tmp31;
	       tmp75 = tmp49 + tmp50;
	       tmp76 = tmp62 + tmp63;
	       tmp77 = tmp75 + tmp76;
	       {
		    fftw_real tmp46;
		    fftw_real tmp65;
		    fftw_real tmp52;
		    fftw_real tmp59;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp46 = tmp40 + tmp45;
		    tmp65 = tmp60 + tmp64;
		    tmp52 = tmp47 + tmp51;
		    tmp59 = tmp53 + tmp58;
		    tmp67 = (K766044443 * tmp52) - (K642787609 * tmp46);
		    tmp68 = (K173648177 * tmp65) - (K984807753 * tmp59);
		    tmp66 = (K766044443 * tmp46) + (K642787609 * tmp52) + (K173648177 * tmp59) + (K984807753 * tmp65);
	       }
	       tmp74 = tmp40 - tmp45;
	       tmp69 = K866025403 * (tmp7 - tmp4);
	       tmp71 = tmp51 - tmp47;
	       tmp72 = tmp64 - tmp60;
	       tmp70 = tmp35 + tmp37;
	       tmp73 = tmp53 - tmp58;
	       X[0] = tmp9 + tmp32;
	       X[3 * iostride] = tmp9 + (K866025403 * (tmp75 - tmp76)) - (K500000000 * tmp32);
	       X[iostride] = tmp39 + tmp66;
	       X[4 * iostride] = tmp39 + (K866025403 * (tmp67 - tmp68)) - (K500000000 * tmp66);
	       Y[0] = tmp70 + tmp77;
	       Y[-3 * iostride] = tmp70 + (K866025403 * (tmp31 - tmp20)) - (K500000000 * tmp77);
	       Y[-iostride] = tmp69 + tmp67 + tmp68 - (K500000000 * tmp70);
	       Y[-2 * iostride] = (K173648177 * tmp71) - (K939692620 * tmp72) - (K342020143 * tmp73) - (K984807753 * tmp74) - (K500000000 * tmp70) - tmp69;
	       X[2 * iostride] = tmp33 + (K173648177 * tmp74) + (K984807753 * tmp71) + (K342020143 * tmp72) - (K939692620 * tmp73) - tmp38;
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7, 8};
fftw_codelet_desc fftw_hc2hc_forward_9_desc =
{
     "fftw_hc2hc_forward_9",
     (void (*)()) fftw_hc2hc_forward_9,
     9,
     FFTW_FORWARD,
     FFTW_HC2HC,
     147,
     8,
     twiddle_order,
};
