/***********************************************************
Copyright 1991-1995 by Stichting Mathematisch Centrum, Amsterdam,
The Netherlands.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the names of Stichting Mathematisch
Centrum or CWI or Corporation for National Research Initiatives or
CNRI not be used in advertising or publicity pertaining to
distribution of the software without specific, written prior
permission.

While CWI is the initial source for this software, a modified version
is made available by the Corporation for National Research Initiatives
(CNRI) at the Internet address ftp://ftp.python.org.

STICHTING MATHEMATISCH CENTRUM AND CNRI DISCLAIM ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL STICHTING MATHEMATISCH
CENTRUM OR CNRI BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.

******************************************************************/

/* This header file includes some new APIs that are not available in
   older API versions, yet are used by the mx-Extensions. Since there
   is no supporting documentation other than this file itself, no
   copyright notice appears in packages using this header file.  */

/*
  ----------------------------------------------------------------
  Stuff new in Python 1.5.2:
  ----------------------------------------------------------------
*/

#ifndef PyList_SET_ITEM
# define PyList_SET_ITEM(l,i,w) PyList_GET_ITEM(l,i) = w
#endif

/*
  ----------------------------------------------------------------
  Stuff new in Python 1.5:
  ----------------------------------------------------------------
*/

#if PYTHON_API_VERSION < 1007

/* New in Python1.5: */
# undef  PyString_AS_STRING
# define PyString_AS_STRING(op) (((PyStringObject *)(op))->ob_sval)
# define PyString_GET_SIZE(op)  (((PyStringObject *)(op))->ob_size)
# define PyTuple_GET_SIZE(op)    (((PyTupleObject *)(op))->ob_size)
# define PyList_GET_SIZE(op)    (((PyListObject *)(op))->ob_size)

/* Changed since 1.4 */
# undef PyList_GET_ITEM
# define PyList_GET_ITEM(op, i) (((PyListObject *)(op))->ob_item[i])
# undef  PyInt_AS_LONG
# define PyInt_AS_LONG(op) (((PyIntObject *)(op))->ob_ival)
# undef PyFloat_AS_DOUBLE
# define PyFloat_AS_DOUBLE(op) (((PyFloatObject *)(op))->ob_fval)

/* This function is taken from error.c in Python 1.5 */
#ifdef HAVE_STDARG_PROTOTYPES
PyObject *
PyErr_Format(PyObject *exception, const char *format, ...)
#else
PyObject *
PyErr_Format(exception, format, va_alist)
	PyObject *exception;
	const char *format;
	va_dcl
#endif
{
	va_list vargs;
	char buffer[500]; /* Caller is responsible for limiting the format */

#ifdef HAVE_STDARG_PROTOTYPES
	va_start(vargs, format);
#else
	va_start(vargs);
#endif

	vsprintf(buffer, format, vargs);
	PyErr_SetString(exception, buffer);
	return NULL;
}

/* Python 1.5 uses instances as exceptions, the 1.4 API only knows
   about strings. */
#define PyErr_NewException(name,base,dict) PyString_FromString(fullname);

/* Missing from rename2.h in Python 1.4 */
#if PYTHON_API_VERSION < 1007
# define PyVarObject varobject
#endif

#endif
