
// the format used for the python representation of the GnomeUIInfo structure
// is a tuple of the form:
//   (type, label, hint, moreinfo, pixmap_type, pixmap_info,
//    accelerator_key, ac_mods)
// This is basically the same as the normal structure, except that signal
// definitions are slimmed down to the single argument.
//
// Note that GNOME_APP_PIXMAP_DATA is not supported
%{

/* This is needed because a NULL signal handler is taken to mean that the
 * python signal handler should be called using the user data as a function.
 * This function is used to prevent seg faults where we really don't want a
 * python signal handler invoked.
 */
static void dummy_handler(GtkWidget *w, gpointer data) {
}

static GnomeUIInfo *list_to_ui_info(PyObject *list) {
  GnomeUIInfo *ret, *sub;
  PyObject *item, *moreinfo;
  int len, i;
  int type, pix_type;
  char buf[100];

  if (!PyList_Check(list)) {
    PyErr_SetString(PyExc_TypeError, "object not a list");
    return NULL;
  }
  len = PyList_Size(list);
  ret = g_new(GnomeUIInfo, len + 1);
  ret[len].type = GNOME_APP_UI_ENDOFINFO; /* set terminator */
  
  for (i = 0; i < len; i++) {
    item = PyList_GetItem(list, i);
    if (!PyTuple_Check(item) || !PyArg_ParseTuple(item, "izzOizci",
						  &(ret[i].type),
						  &(ret[i].label),
						  &(ret[i].hint),
						  &moreinfo,
						  &(ret[i].pixmap_type),
						  &(ret[i].pixmap_info),
						  &(ret[i].accelerator_key),
						  &(ret[i].ac_mods))) {
      PyErr_Clear();
      sprintf(buf, "badly formed tuple for \"%s\" (type %i)", ret[i].label,
              ret[i].type);
      PyErr_SetString(PyExc_TypeError, buf);
      g_free(ret);
      return NULL;
    }
    type = ret[i].type; pix_type = ret[i].pixmap_type;
    if (type < GNOME_APP_UI_ENDOFINFO || type > GNOME_APP_UI_JUSTIFY_RIGHT ||
	pix_type < GNOME_APP_PIXMAP_NONE ||
	pix_type > GNOME_APP_PIXMAP_FILENAME ||
	pix_type == GNOME_APP_PIXMAP_DATA) {
      sprintf(buf, "bad info or pixmap type for label \"%s\"", ret[i].label);
      PyErr_SetString(PyExc_TypeError, buf);
      g_free(ret);
      return NULL;
    }
    switch(type) {
    case GNOME_APP_UI_ENDOFINFO:
    case GNOME_APP_UI_SEPARATOR:
    case GNOME_APP_UI_JUSTIFY_RIGHT:
      ret[i].moreinfo = dummy_handler;
      ret[i].user_data = NULL;
      break;
    case GNOME_APP_UI_ITEM:
    case GNOME_APP_UI_TOGGLEITEM:
      if (moreinfo == Py_None) {
        ret[i].moreinfo = dummy_handler;
        ret[i].user_data = NULL;
        break;
      }
      if (!PyCallable_Check(moreinfo)) {
	sprintf(buf, "additional info not callable (label \"%s\")",
		ret[i].label);
	PyErr_SetString(PyExc_TypeError, buf);
	g_free(ret);
	return NULL;
      }
      ret[i].moreinfo = NULL;
      Py_INCREF(moreinfo);
      ret[i].user_data = moreinfo;
      break;
    case GNOME_APP_UI_RADIOITEMS:
      sub = list_to_ui_info(moreinfo);
      if (sub == NULL) {
	g_free(ret);
	return NULL;
      }
      ret[i].moreinfo = sub;
      break;
    case GNOME_APP_UI_SUBTREE:
      sub = list_to_ui_info(moreinfo);
      if (sub == NULL) {
	g_free(ret);
	return NULL;
      }
      ret[i].moreinfo = sub;
      break;
    case GNOME_APP_UI_HELP:
      if (moreinfo != Py_None && !PyString_Check(moreinfo)) {
	PyErr_SetString(PyExc_TypeError, "additional info should be a string for help");
	g_free(ret);
	return NULL;
      }
      if (moreinfo == Py_None)
	ret[i].moreinfo = NULL;
      else
	ret[i].moreinfo = PyString_AsString(moreinfo);
      break;
    }
  }
  return ret;
}

static void free_ui_info(GnomeUIInfo *inf) {
  int i = 0;
  
  while (inf[i].type != GNOME_APP_UI_ENDOFINFO) {
    if (inf[i].type == GNOME_APP_UI_RADIOITEMS ||
	inf[i].type == GNOME_APP_UI_SUBTREE)
      if (inf[i].moreinfo !=  NULL)
	free_ui_info(inf[i].moreinfo);
    i++;
  }
  g_free(inf);
}
%}

// now the typemaps for the GnomeUIInfo structure ...
%typemap(python,in) GnomeUIInfo * {
  if (($target = list_to_ui_info($source)) == NULL)
    return NULL;
}
%typemap(python,freearg) GnomeUIInfo * {
  free_ui_info($source);
  /* $target */
}

%typemap(python,freearg) GnomeUIInfo *nofree {
}
