#ifndef _BOXES_H_
#define _BOXES_H_

#ifdef LOG
#include <stdarg.h>
void dinstall_log(const char * pattern, ...);
#endif	

#define DLG_ERROR               -1
#define DLG_OKAY                0
#define DLG_CANCEL              1


void boxResume(void);
void boxSuspend(void);
void boxPopWindow(void);
void boxFinished(void);

int pleaseWaitBox(const char *text);
int problemBox(const char *text, const char *title);
int wideMessageBox(const char *text, const char *title);
int perrorBox(const char *text);
int twoButtonBox(const char *text, const char *title, const char *button1, const char* button2);
int yesNoBox(const char *text, const char *title);
char *inputBox(const char *text, const char *title, const char *proto);

#define SCALE_CREATE	0
#define SCALE_REFRESH	1
#define SCALE_DELETE	2
int scaleBox(const char *text, const char *title, long long length, int action);

struct d_choices
 {
   char* tag;
   char* string;
   int   state;
};

int menuBox(const char* text, const char* title,
		struct d_choices* choices, int nchoices, int cancel);
int check_box(const char* text, const char* title, int height, int width,
		char** choices, char** values, int nchoices);
#ifdef _TESTING_
void initScreen (char *msg);
void finishScreen(void);
#endif

#endif
