/*
 * proto.h - common function prototypes for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: proto.h,v 1.21 96/04/05 10:02:46 abe Exp $
 */


/*
 * The _PROTOTYPE macro provides strict ANSI C prototypes if __STDC__
 * is defined, and old-style K&R prototypes otherwise.
 *
 * (With thanks to Andy Tanenbaum)
 */

#if	defined(__STDC__)
#define	_PROTOTYPE(function, params)	function params
#else
#define	_PROTOTYPE(function, params)	function()
#endif /* defined(__STDC__) */


_PROTOTYPE(extern void alloc_lfile,(char *nm, int num));
_PROTOTYPE(extern void alloc_lproc,(int pid, int pgrp, UID_ARG uid, char *cmd, int pss, int sf));
_PROTOTYPE(extern int ck_file_arg,(int i, int ac, char *av[]));
_PROTOTYPE(extern int compdev,(COMP_P *a1, COMP_P *a2));
_PROTOTYPE(extern int comppid,(COMP_P *a1, COMP_P *a2));

#if	defined(WILLDROPGID)
_PROTOTYPE(extern void dropgid,(void));
#endif	/* defined(WILLDROPGID) */

_PROTOTYPE(extern void childx,(void));
_PROTOTYPE(extern char *endnm,(void));
_PROTOTYPE(extern void enter_dev_ch,(char *m));
_PROTOTYPE(extern int enter_fd,(char *f));
_PROTOTYPE(extern int enter_network_address,(char *na));
_PROTOTYPE(extern int enter_id,(enum IDType ty, char *p));
_PROTOTYPE(extern void enter_nm,(char *m));
_PROTOTYPE(extern int enter_str_lst,(char *opt, char *s, struct str_lst **lp));
_PROTOTYPE(extern int enter_uid,(char *u));
_PROTOTYPE(extern int examine_lproc,(void));
_PROTOTYPE(extern void Exit,(int xv));
_PROTOTYPE(extern void find_ch_ino,(void));
_PROTOTYPE(extern void gather_proc_info,(void));
_PROTOTYPE(extern char *gethostnm,(struct in_addr *ia));
_PROTOTYPE(extern void initialize,(void));
_PROTOTYPE(extern void iporttab,(void));
_PROTOTYPE(extern int is_cmd_excl,(char *cmd, short *pss, short *sf));
_PROTOTYPE(extern int is_file_sel,(struct lfile *lf));
_PROTOTYPE(extern int is_nw_addr,(struct in_addr *ia, int p));
_PROTOTYPE(extern int is_proc_excl,(int pid, int pgrp, UID_ARG uid, short *pss, short *sf));
_PROTOTYPE(extern int is_readable,(char *path, int msg));
_PROTOTYPE(extern void iuidcache,(int np));
_PROTOTYPE(extern int kread,(KA_T addr, char *buf, READLEN_T len));
_PROTOTYPE(extern void link_lfile,(void));
_PROTOTYPE(extern struct l_dev *lkupdev,(dev_t *dev, int i));
_PROTOTYPE(extern int main,(int argc, char *argv[]));
_PROTOTYPE(extern int printchdevname,(dev_t *rdev, int f));
_PROTOTYPE(extern void print_file,(void));
_PROTOTYPE(extern void printinaddr,(struct in_addr *ia, int p));
_PROTOTYPE(extern void printiproto,(int p));
_PROTOTYPE(extern void printname,(int nl));
_PROTOTYPE(extern void print_proc,(void));
_PROTOTYPE(extern void printrawaddr,(struct sockaddr *sa));
_PROTOTYPE(extern char *printuid,(UID_ARG u, int *ty));
_PROTOTYPE(extern void printunkaf,(int fam));
_PROTOTYPE(extern void process_file,(struct file *fp));
_PROTOTYPE(extern void process_node,(caddr_t f));
_PROTOTYPE(extern char *Readlink,(char *arg));
_PROTOTYPE(extern void readdev,(void));
_PROTOTYPE(extern int readmnt,(void));
_PROTOTYPE(extern int statsafely,(char *path, struct stat *buf));
_PROTOTYPE(extern void usage,(int xv, int fh, int version));
_PROTOTYPE(extern char *x2dev,(char *s, dev_t *d));

#if	defined(HASCDRNODE)
_PROTOTYPE(extern int readcdrnode,(caddr_t ca, struct cdrnode *c));
#endif	/* defined(HASCDRNODE) */

#if	defined(HASDCACHE)
_PROTOTYPE(extern void alloc_dcache,(void));
_PROTOTYPE(extern void crc,(char *b, int l, unsigned *s));
_PROTOTYPE(extern void crdbld,(void));
_PROTOTYPE(extern int ctrl_dcache,(char *p));
_PROTOTYPE(extern int dcpath,(int rw, int npw));
_PROTOTYPE(extern int open_dcache,(int m, int r, struct stat *sb));
_PROTOTYPE(extern int read_dcache,(void));
_PROTOTYPE(extern int wr2DCfd,(char *b, unsigned *c));
_PROTOTYPE(extern void write_dcache,(void));
#endif	/* defined(HASDCACHE) */

#if	defined(HASFIFONODE)
_PROTOTYPE(extern int readfifonode,(caddr_t fa, struct fifonode *f));
#endif	/* defined(HASFIFONODE) */

#if	defined(HASGNODE)
_PROTOTYPE(extern int readgnode,(caddr_t ga, struct gnode *g));
#endif	/* defined(HASGNODE) */

#if	defined(HASHSNODE)
_PROTOTYPE(extern int readhsnode,(caddr_t ha, struct hsnode *h));
#endif	/* defined(HASHSNODE) */

#if	defined(HASINODE)
_PROTOTYPE(extern int readinode,(struct inode *ia, struct inode *i));
#endif	/* defined(HASINODE) */

#if	defined(HASNCACHE)
_PROTOTYPE(extern char *ncache_lookup,(char *buf, int blen, int *fp));
#endif	/* defined(HASNCACHE) */

#if	defined(HASPIPENODE)
_PROTOTYPE(extern int readpipenode,(caddr_t pa, struct pipenode *p));
#endif	/* defined(HASPIPENODE) */

#if	defined(HASRNODE)
_PROTOTYPE(extern int readrnode,(caddr_t ra, struct rnode *r));
#endif	/* defined(HASRNODE) */

#if	defined(HASSNODE)
_PROTOTYPE(extern int readsnode,(caddr_t sa, struct snode *s));
#endif	/* defined(HASSNODE) */

#if	defined(HASSTREAMS)
_PROTOTYPE(extern int readstdata,(struct stdata *addr, struct stdata *buf));
_PROTOTYPE(extern int readsthead,(struct queue *addr, struct queue *buf));
_PROTOTYPE(extern int readstidnm,(char *addr, char *buf, READLEN_T len));
_PROTOTYPE(extern int readstmin,(struct module_info *addr, struct module_info *buf));
_PROTOTYPE(extern int readstqinit,(struct qinit *addr, struct qinit *buf));
#endif	/* defined(HASSTREAMS) */

#if	defined(HASTMPNODE)
_PROTOTYPE(extern int readtmpnode,(caddr_t tmpa, struct tmpnode *t));
#endif	/* defined(HASTMPNODE) */

#if	defined(HASVNODE)
_PROTOTYPE(extern int readvnode,(caddr_t va, struct vnode *v));
#endif	/* defined(HASVNODE) */
