<?php
/*
 * Session Management for PHP3
 *
 * Copyright (c) 1998,1999 NetUSE GmbH
 *                    Boris Erdmann, Kristian Koehntopp
 *
 * $Id: local.inc,v 1.31 1999/10/29 13:55:13 kk Exp $
 *
 * All functions in this file are example classes, which can be used
 * by your application to get you going. Once you get the hang of it,
 * you should backup this file and start over with a clean local.inc
 * which contains only your own classes and only the classes you need.
 */ 

class DB_Example extends DB_Sql {
  var $Host     = "localhost";
  var $Database = "example_database";
  var $User     = "example_user";
  var $Password = "";
}

##
## Session needs to use a storage container (ct). 
## Select exactly one of the following and set $that_class 
## in Example_Session appropriately.
##

class Example_CT_Sql extends CT_Sql {
  var $database_class = "DB_Example";          ## Which database to connect...
  var $database_table = "active_sessions"; ## and find our session data in this table.
}

#class Example_CT_Split_Sql extends CT_Split_Sql {
#  var $database_class = "DB_Example";         ## Which database to connect...
#  var $database_table = "active_sessions_split"; ## and find our session data in this table.
#  var $split_length = 4096                    ## Split rows every 4096 bytes
#}

#class Example_CT_Shm extends CT_Shm {
#  var $max_sessions   = 500;               ## number of maximum sessions
#  var $shm_key        = 0x123754;          ## unique shm identifier
#  var $shm_size       = 64000;             ## size of segment
#}

#class Example_CT_Ldap extends CT_Ldap {
#   var $ldap_host = "localhost";
#   var $ldap_port = 389;
#   var $basedn    = "dc=your-domain, dc=com";
#   var $rootdn    = "cn=root, dc=your-domain, dc=com";
#   var $rootpw    = "secret";
#   var $objclass  = "phplibdata";
#}

#class Example_CT_Dbm extends CT_DBM {
#   var $dbm_file  = "must_exist.dbm";
#}

class Example_Session extends Session {
  var $classname = "Example_Session";

  var $cookiename     = "";                ## defaults to classname
  var $magic          = "Hocuspocus";      ## ID seed
  var $mode           = "cookie";          ## We propagate session IDs with cookies
  var $fallback_mode  = "get";
  var $lifetime       = 0;                 ## 0 = do session cookies, else minutes
  var $that_class     = "Example_CT_Sql";  ## name of data storage container class
  var $gc_probability = 5;  
  var $allowcache     = "no";              ## "public", "private", or "no"
}

class Example_User extends User {
  var $classname = "Example_User";

  var $magic          = "Abracadabra";     ## ID seed
  var $that_class     = "Example_CT_Sql";  ## name of data storage container class
}

##
## The following Auth subclasses present different flavors of the
## PHPLIB authentication schemes. In reality you would select one
## and drop all the others from this file.
## 

# An Auth class which authenticates against a database table.
# Has examples for log mode (login only) and reg mode (registration).

class Example_Auth extends Auth {
  var $classname      = "Example_Auth";

  var $lifetime       =  15;

  var $mode           = "log";  ## also try "reg"

  var $database_class = "DB_Example";
  var $database_table = "auth_user";

  ## show login form
  ## this is a CI-less generic login form. Feel free to
  ## customize.  
  function auth_loginform() {
    global $sess, $auth, $_PHPLIB, $PHP_SELF;

    include($_PHPLIB["libdir"] . "loginform.ihtml");
  }
  
  ## validate login information.
  ## please remember to adapt the global statements here to match the
  ## variables used in your loginform.ihtml.
  ## this function has to return false, if the login fails, or
  ## a valid user_id.
  function auth_validatelogin() {
    global $username, $password, $mode;

    if (isset($mode) && $mode == "reg") {
      $this->mode = "reg";
      $this->auth["uname"] = $username;
      $this->auth["error"] = "Please fill in the required registration information. Thank you.";
      return false;
    }

    if(isset($username)) {
      $this->auth["uname"]=$username;        ## This provides access for "loginform.ihtml"
    }
    
    $uid = false;
    
    $this->db->query(sprintf("select user_id, perms ".
                             "        from %s ".
                             "       where username = '%s' ".
                             "         and password = '%s'",
                          $this->database_table,
                          addslashes($username),
                          addslashes($password)));

    while($this->db->next_record()) {
      $uid = $this->db->f("user_id");
      $this->auth["perm"] = $this->db->f("perms");
    }
    if ($uid == false)
      $this->auth["error"] = "Either your username or password are invalid.<br>Please try again.";
    else
      SetCookie("auth_username", $username, pow(2, 31)-1, "/");

    return $uid;
  }

  function auth_preauth() {
    global $HTTP_COOKIE_VARS;
    
    if ($HTTP_COOKIE_VARS["auth_username"]) {
      $this->auth["uname"] = $HTTP_COOKIE_VARS["auth_username"];
      $this->mode = "log";
    }
    return false;
  }
  
  ## show registration form.
  ## this is a very basic one, you certainly want to
  ## add columns to that table and this form.
  function auth_registerform() {
    global $sess, $auth, $_PHPLIB, $PHP_SELF;

    include("registerform.ihtml");
  }
  
  function auth_doregister() {
    ## Import form variables
    global $username, $pass1, $pass2, $mode;
    
    ## Save the username for use in registerform.ihtml,
    ## should registration fail. If you add more fields,
    ## you will want to save them here, too.
    $this->auth["uname"] = $username;

    if (isset($mode) && $mode == "log") {
      $this->mode = "log";
      $this->auth["error"] = "Please enter your username and password. Thank you.";
      return false;
    }

    ## Check the passwords for validity.    
    if ($pass1 != $pass2) {
      $this->auth["error"] = "Password and repeated password do not match. Please try again.";
      return false;
    }
    
    ## See if the user is already present
    $query = sprintf("select user_id, username, password, perms from %s where username = '%s'",
      $this->database_table,
      $username);
    $this->db->query($query);
    while($this->db->next_record()) {
      ## If user is present and password matches, silently log
      ## the user in.
      if ($this->db->f("password") == $pass1) {
        $this->auth["perm"] = $this->db->f("perms");
        return $this->db->f("user_id");
      }

      ## If user is present and password does not match,
      ## complain and fail.
      $this->auth["error"] = "This username is already taken. Please choose a different one.";
      return false;
    }

    ## password is good and user is new, create a uid
    ## and a user entry. The new user has no permissions (you
    ## might want to add some?)
    $uid = md5(uniqid($this->magic));
    $query = sprintf("insert into %s ( user_id, username, password ) values ('%s', '%s', '%s')",
      $this->database_table,
      $uid,
      $username,
      $pass1);
    $this->db->query($query);

    ## Set a cookie to remember the username.
    SetCookie("auth_username", $username, pow(2, 31)-1, "/");

    ## log in that new user. The new user has no permissions.
    ## If the user should have permissions, you put them
    ## into $auth->auth["perm"].
    return $uid;
  }
}

# This is Example_Auth with the $nobody flag set. Read up
# on Default Authentication in the Documentation. You do not
# need to derive this from Example_Auth, in fact it would be
# better to set $nobody directly in Example_Auth.

class Example_Default_Auth extends Example_Auth {
  var $classname = "Example_Default_Auth";
  
  var $nobody    = true;
}

# A variation of Example_Auth which uses a Challenge-Response
# Authentication. The password never crosses the net in clear,
# if the remote system supports JavaScript. Please read the
# Documentation section about CR Authentication to understand
# what is going on.

class Example_Challenge_Auth extends Auth {
  var $classname      = "Example_Challenge_Auth";

  var $lifetime       =  1;

  var $magic          = "Simsalabim";  ## Challenge seed
  var $database_class = "DB_Example";
  var $database_table = "auth_user";

  function auth_loginform() {
    global $sess;
    global $challenge;
    global $_PHPLIB;
    
    $challenge = md5(uniqid($this->magic));
    $sess->register("challenge");
    
    include($_PHPLIB["libdir"] . "crloginform.ihtml");
  }
  
  function auth_validatelogin() {
    global $username, $password, $challenge, $response;

    if(isset($username)) {
      $this->auth["uname"]=$username;        ## This provides access for "loginform.ihtml"
    }
    $this->db->query(sprintf("select user_id,perms,password ".
                "from %s where username = '%s'",
                          $this->database_table,
                          addslashes($username)));

    while($this->db->next_record()) {
      $uid   = $this->db->f("user_id");
      $perm  = $this->db->f("perms");
      $pass  = $this->db->f("password");
    }
    $exspected_response = md5("$username:$pass:$challenge");

    ## True when JS is disabled
    if ($response == "") {
      if ($password != $pass) {
        $this->auth["error"] = "Either your username or password are invalid.<br>Please try again.";
        return false;
      } else {
        $this->auth["perm"] = $perm;
        return $uid;
      }
    }
    
    ## Response is set, JS is enabled
    if ($exspected_response != $response) {
      $this->auth["error"] = "Either your username or password are invalid.<br>Please try again.";
      return false;
    } else {
      $this->auth["perm"] = $perm;
      return $uid;
    }
  }
}

##
## Another variation of Challenge-Response authentication,
## done slightly differently. This one does not keep cleartext
## passwords in your database table. It uses a slightly different
## authentication table format, thus a different table is being used.

class Example_Challenge_Crypt_Auth extends Auth {
  var $classname      = "Example_Challenge_Crypt_Auth";

  var $lifetime       =  1;

  var $magic          = "Frobozzica";  ## Challenge seed
  var $database_class = "DB_Example";
  var $database_table = "auth_user_md5";

  function auth_loginform() {
    global $sess;
    global $challenge;
    
    $challenge = md5(uniqid($this->magic));
    $sess->register("challenge");
    
    include("crcloginform.ihtml");
  }
  
  function auth_validatelogin() {
    global $username, $password, $challenge, $response;

    $this->auth["uname"]=$username;        ## This provides access for "loginform.ihtml"
    
    $this->db->query(sprintf("select user_id,perms,password ".
                "from %s where username = '%s'",
                          $this->database_table,
                          addslashes($username)));

    while($this->db->next_record()) {
      $uid   = $this->db->f("user_id");
      $perm  = $this->db->f("perms");
      $pass  = $this->db->f("password");   ## Password is stored as a md5 hash
    }
    $exspected_response = md5("$username:$pass:$challenge");

    ## True when JS is disabled
    if ($response == "") {
      if (md5($password) != $pass) {       ## md5 hash for non-JavaScript browsers
        $this->auth["error"] = "Either your username or password are invalid.<br>Please try again.";
        return false;
      } else {
        $this->auth["perm"] = $perm;
        return $uid;
      }
    }
    
    ## Response is set, JS is enabled
    if ($exspected_response != $response) {
      $this->auth["error"] = "Either your username or password are invalid.<br>Please try again.";
      return false;
    } else {
      $this->auth["perm"] = $perm;
      return $uid;
    }
  }
}

## An example implementation of a Perm subclass, implementing
## a few atomic permissions. You want to read up on Permission
## schemata design in the documentation.

class Example_Perm extends Perm {
  var $classname = "Example_Perm";
  
  var $permissions = array(
                            "user"       => 1,
                            "author"     => 2,
                            "editor"     => 4,
                            "supervisor" => 8,
                            "admin"      => 16
                          );

  function perm_invalid($does_have, $must_have) {
    global $perm, $auth, $sess;
    global $_PHPLIB;
    
    include($_PHPLIB["libdir"] . "perminvalid.ihtml");
  }
}

##
## Example_Menu may extend Menu or Menu_Button
## If you name this class differently, you must also
## rename its constructor function - this is a PHP3 language 
## design stupidity.
##
## To use this, you must enable the require statement for
## menu.inc in prepend.php3. If you are using Menu_Button
## instead of Menu, you must also enable menu_button.inc in
## prepend.php3.
##
## See /pages/menu for an example application of Example_Menu.
##

# class Example_Menu extends Menu {
#   # Map of PHP_SELF URL strings to menu positions
#   var $urlmap = array(
#     "/menu/index.php3"   => "",
#     "/menu/item1.php3"   => "/1",
#     "/menu/item11.php3"  => "/1/1",
#     "/menu/item12.php3"  => "/1/2",
#     "/menu/item13.php3"  => "/1/3",
#     "/menu/item2.php3"   => "/2",
#     "/menu/item21.php3"  => "/2/1",
#     "/menu/item22.php3"  => "/2/2",
#     "/menu/item221.php3" => "/2/2/1",
#     "/menu/item222.php3" => "/2/2/2",
#     "/menu/item23.php3"  => "/2/3",
#     "/menu/item24.php3"  => "/2/4"
#   );
#   
#   # Information about each menu item
#   var $item = array(
#     ""      => array("title" => "Main"),
#     "/1"    => array("title" => "Text 1"),
#     "/1/1"  => array("title" => "Text 1.1"),
#     "/1/2"  => array("title" => "Text 1.2"),
#     "/1/3"  => array("title" => "Text 1.3"),
#     "/2"    => array("title" => "Text 2"),
#     "/2/1"  => array("title" => "Text 2.1"),
#     "/2/2"  => array("title" => "Text 2.2"),
#     "/2/2/1"=> array("title" => "Text 2.2.1"),
#     "/2/2/2"=> array("title" => "Text 2.2.2"),
#     "/2/3"  => array("title" => "Text 2.3"),
#     "/2/4"  => array("title" => "Text 2.4")
#   );
#   
#   function Example_Menu() {
#     $this->setup();
#   }
# }

?>
