/*
 * dstore.c - Ultrix global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.5 99/05/09 14:57:08 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *             (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {

#if    ULTRIXV==20200
	{ X_NCACHE,	"_nch"			},
	{ X_NCSIZE,	"_nchsize"		},
	{ "nfsgops",	"_nfs_gnode_ops"	},
	{ "nproc",	"_nproc"		},
	{ "proc",	"_proc"			},
#else	/* ULTRIX!=20200 */
# if	defined(VAXULTRIX)
	{ "cgops",	"_Cdfs_gnode_ops"	},
	{ "fgops",	"_FIFO_gnode_ops"	},
	{ "fids",	"_fids"			},
	{ X_NCACHE,	"_nch"			},
	{ X_NCSIZE,	"_nchsize"		},
	{ "nfsgops",	"_NFS_gnode_ops"	},
	{ "nproc",	"_nproc"		},
	{ "proc",	"_proc"			},
	{ "ugops",	"_Ufs_gnode_ops"	},
# else	/* !defined(VAXULTRIX) */
	{ "cgops",	"Cdfs_gnode_ops"	},
	{ "fgops",	"FIFO_gnode_ops"	},
	{ "fids",	"fids"			},
	{ X_NCACHE,	"nch"			},
	{ X_NCSIZE,	"nchsize"		},
	{ "nfsgops",	"NFS_gnode_ops"		},
	{ "nproc",	"nproc"			},
	{ "proc",	"proc"			},
	{ "ugops",	"Ufs_gnode_ops"		},
# endif	/* defined(VAXULTRIX) */
#endif	/* ULTRIX==20200 */
	{ "",		""			},
	{ NULL<		NULL			}
};

struct file *Fileptr;			/* for process_file() in lib/prfp.c */
int Kd = -1;				/* /dev/kmem file descriptor */
int Mem = -1;				/* /dev/mem file descriptor */

#if	defined(HASFSTRUCT)
/*
 * Pff_tab[] - table for printing file flags
 */

struct pff_tab Pff_tab[] = {
	{ (long)FREAD,		FF_READ		},
	{ (long)FWRITE,		FF_WRITE	},
	{ (long)FNBLOCK,	FF_NBLOCK	},
	{ (long)FNDELAY,	FF_NDELAY	},
	{ (long)FAPPEND,	FF_APPEND	},
	{ (long)FMARK,		FF_MARK		},
	{ (long)FDEFER,		FF_DEFER	},
	{ (long)FASYNC,		FF_ASYNC	},
	{ (long)FDEFER,		FF_DEFER	},
	{ (long)FSHLOCK,	FF_SHLOCK	},
	{ (long)FEXLOCK,	FF_EXLOCK	},
	{ (long)FBLKINUSE,	FF_BLKINUSE	},
	{ (long)FBLKANDSET,	FF_BLKANDSET	},
	{ (long)FSYNCRON,	FF_SYNCRON	},
	{ (long)FNBUF,		FF_NBUF		},
	{ (long)FNBLOCK,	FF_NBLOCK	},
	{ (long)FTERMIO,	FF_TERMIO	},
	{ (long)FNOCTTY,	FF_NOCTTY	},
	{ (long)0,		NULL		}
};


/*
 * Pof_tab[] - table for print process open file flags
 */

struct pff_tab Pof_tab[] = {

# if	defined(UF_EXCLOSE)
	{ (long)UF_EXCLOSE,	POF_CLOEXEC	},
# endif	/* defined(UF_EXCLOSE) */

# if	defined(UF_MAPPED)
	{ (long)UF_MAPPED,	POF_MAPPED	},
# endif	/* defined(UF_MAPPED) */

# if	defined(UF_INUSE)
	{ (long)UF_INUSE,	POF_INUSE	},
# endif	/* defined(UF_INUSE) */

# if	defined(UF_FDLOCK)
	{ (long)UF_FDLOCK,	POF_FDLOCK	},
# endif	/* defined(UF_FDLOCK) */

	{ (long)0,		NULL		}
};
#endif	/* defined(HASFSTRUCT) */

int Swap = -1;				/* swap device file descriptor */
