#!/usr/bin/perl -w

use strict;

# Converts calendar data files from US-style dates (MM/DD 01/15) into
# human-readable dates (Jan 15) which everyone should be able to read
# without mental gymnastics.

my %monthhash = (
	'01','Jan',	'02','Feb',	'03','Mar',	'04','Apr',
	'05','May',	'06','Jun',	'07','Jul',	'08','Aug',
	'09','Sep',	'10','Oct',	'11','Nov',	'12','Dec'
);

my $month; 
my $day;
my $desc;

while(<>)
{
	s,^([0-9][0-9])[/\\ ](.*),$monthhash{$1} $2,;
	print;
}

