REM		GMT EXAMPLE 17
REM
REM		@(#)job17.bat	1.4  06/08/99
REM
REM Purpose:	Illustrates clipping of images using coastlines
REM GMT progs:	grd2cpt, grdgradient, grdimage, pscoast, pstext
REM DOS calls:	del, echo
REM
echo GMT EXAMPLE 17
set master=y
if exist job17.bat set master=n
if %master%==y cd ex17
REM Get Geoid and Topography for the region
REM grdraster 1 -R60/90/-10/25 -Getopo5.grd
REM grdraster 4 -R60/90/-10/25 -Ggeoid.grd

REM First generate geoid image w/ shading

grd2cpt geoid.grd -Crainbow > geoid.cpt
grdgradient geoid.grd -Nt1 -A45 -Ggeoid_i.grd
grdimage geoid.grd -Igeoid_i.grd -JM6.5i -Cgeoid.cpt -P -K -U"Example 17 in Cookbook" > example_17.ps

REM Then use pscoast to initiate clip path for land

pscoast -R60/90/-10/25 -JM -O -K -Dl -Gc >> example_17.ps

REM Now generate topography image w/shading

echo -10000 150 10000 150 > gray.cpt
grdgradient etopo5.grd -Nt1 -A45 -Getopo5_i.grd
grdimage etopo5.grd -Ietopo5_i.grd -JM -Cgray.cpt -O -K >> example_17.ps

REM Finally undo clipping and overlay basemap

pscoast -R -JM -O -K -Q -B10f5:."Clipping of Images": >> example_17.ps

REM Add a text paragraph (Note double %% to get a single % in DOS)
echo # 90 -10 12 0 4 RB 12p 3i j > tmp
echo @_@%%5%%Example 17.@%%%%@_  We first plot the color geoid image >> tmp
echo for the entire region, followed by a gray-shaded @#etopo5@# >> tmp
echo image that is clipped so it is only visible inside the coastlines. >> tmp

pstext -R -JM -O -M# -W255O0.5p -D-0.1i/0.1i tmp >> example_17.ps

REM Clean up

del *.cpt
del *_i.grd
del tmp
del .gmt*
if %master%==y cd ..
