/* Let's tell EMACS what language this is: -*- C -*- */

/* Used by separable libraries to enable PSPP-specific features. */
#define PSPP 1

/*
 *
 * Debugging
 *
 */

/* Define to get lots of info printed by procedures. */
/*#define DEBUGGING 1*/

#if DEBUGGING
#define GLOBAL_DEBUGGING 1
#endif

/* Define these if DEBUGGING is off and you want to make certain
   additional optimizations. */
#if !DEBUGGING
/* #define PRODUCTION 1 */		/* disable extra function calls */
/* #define NDEBUG 1 */			/* disable assert() sanity checks */
#endif

#include "debug-print.h"

/* Compilers. */

/* Fix Windows lossage. */
#ifdef __WIN32__
#undef __WIN32__
#define __WIN32__ 1
#undef __MSDOS__
#define __MSDOS__ 1
#endif

/* Fix DJGPP lossage. */
#if __DJGPP__
#undef unix
#undef __unix__
#endif

/* Fix Cygnus Windows lossage. */
#if defined (__CYGWIN32__)
#define unix 1
#endif

/* Ensure that unix and __unix__ are equivalent. */
#if defined (unix) || defined (__unix__) || defined (__unix)
#undef unix
#define unix 1

#undef __unix__
#define __unix__ 1

#undef __unix
#define __unix 1
#endif

/* Make sure to use the proper keywords. */
#if __GNUC__ > 1 && !defined (inline)
#define inline __inline__
#endif

/* GNU C allows the programmer to declare that certain functions take
   printf-like arguments, never return, etc.  Conditionalize these
   declarations on whether gcc is in use. */
#if __GNUC__ > 1
#define __attribute__(X) __attribute__ (X)
#else
#define __attribute__(X)
#endif

/* GNU C allows unused variables and parameters to be declared as
   such. */
/* gccs older than 2.8.x are picky about where attributes can
   appear. */
#if __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 8)
#define unused __attribute__ ((__unused__))
#else
#define unused
#endif

/* CPUs. */

/* Stores a two-byte unsigned little-endian integer I at the location
   of pointer P, which might not be word-aligned.  Not trivial outside
   of x86...

   Note: *MUST* use little-endian format because such two-byte
   unsigned little-endian values are hard-coded into string literals
   elsewhere in the program! */
#if __i386__
#define STORE_2(P, I) 				\
	*((short int *) (P)) = (I)
#else
#define STORE_2(P, I)							\
	do								\
	  {								\
	    ((unsigned char *) (P))[0] = ((unsigned) (I)) % 256;	\
	    ((unsigned char *) (P))[1] = ((unsigned) (I)) / 256;	\
	  }								\
	while (0)
#endif

/* Returns the value of a two-byte unsigned little-endian integer at
   location P, which might not be word-aligned.  Not trivial outside
   of x86... */
#if __i386__
#define LOAD_2(P) 				\
	(*(short int *) (P))
#else
#define LOAD_2(P) 					\
	((unsigned) (((unsigned char *) (P))[0]) +	\
	(unsigned) (((unsigned char *) (P))[1] * 256))
#endif

/* Check that the floating-point representation is one that we
   understand. */
#if FPREP==FPREP_IEEE754
     
#if SIZEOF_DOUBLE == 8
#define second_lowest_flt64 second_lowest_value
#else
#error Must define second_lowest_flt64 for your architecture.
#endif

/* This trick borrowed from gcc-lib/.../include/float.h. */
#if __GNUC__ && (ENDIAN==BIG || ENDIAN==LITTLE)
#ifndef __DBL_UNION__
#define __DBL_UNION__
union blp_convert_double {
  unsigned char convert_double_i[8];
  double convert_double_d;
};
#endif /* !defined __DBL_UNION__ */
#if ENDIAN==LITTLE
#define SECOND_LOWEST_VALUE 						\
	(__extension__ ((union blp_convert_double)			\
			{{0xfe,0xff,0xff,0xff, 0xff,0xff,0xef,0xff}})	\
	 .convert_double_d)
#elif ENDIAN==BIG
#define SECOND_LOWEST_VALUE 						\
	(__extension__ ((union blp_convert_double)			\
			{{0xff,0xef,0xff,0xff, 0xff,0xff,0xff,0xfe}})	\
	 .convert_double_d)
#endif /* endianness */
#endif /* __GNUC__ and known endianness */

#else /* FPREP != FPREP_IEEE754 */
#error Floating point representation must be known at compile time.
#endif /* fprep */

/* Figure out which integer type on this system is a signed 32-bit
   integer. */
#if SIZEOF_SHORT==4
  #define int32 short
#elif SIZEOF_INT==4
  #define int32 int
#elif SIZEOF_LONG==4
  #define int32 long
#else
  #error Which one of your basic types is 32-bit signed integer?
#endif

#if SIZEOF_FLOAT==8
  #define flt64 float
  #define FLT64_MAX FLT_MAX
#elif SIZEOF_DOUBLE==8
  #define flt64 double
  #define FLT64_MAX DBL_MAX
#elif SIZEOF_LONG_DOUBLE==8
  #define flt64 long double
  #define FLT64_MAX LDBL_MAX
#else
  #error Which one of your basic types is 64-bit floating point?
  #define flt64 double
  #define FLT64_MAX DBL_MAX
#endif

/* Environments. */

/* Internationalization. */
#include <libintl.h>

#if !ENABLE_NLS
/* If we don't do this then gettext() still monkeys with the string,
   which causes gcc not to do its checking on printf() format
   types. */
#undef gettext
#define gettext(STRING) 			\
	STRING
#endif

#define _(STRING) 				\
	gettext(STRING)
     
#define N_(STRING) 				\
	STRING

/* Even C emulation of alloca counts as an alloca implementation. */
#define HAVE_ALLOCA 1

/* Define PAGED_STACK if alloca() is supported and the stack can
   expand arbitrarily.  (Under some broken OSes like DOS and
   Windows the stack is small and fixed in size.)  This will prevent
   big alloca() requests (like 1MB). */
#if HAVE_ALLOCA && unix
#define PAGED_STACK 1
#endif

/* Saves on #if's. */
#if HAVE_ALLOCA && !__CHECKER__
#define local_alloc(X)				\
	alloca(X)

#define local_free(P)				\
	do					\
	  {					\
	  }					\
	while (0)
#elif !__CHECKER__
#define local_alloc(X)				\
	xmalloc (X)
     
#define local_free(P) 				\
	free (P)
#else /* __CHECKER__ */
/* Why define these this way?  Because if you do it this way then if
   you try to free a block returned by local_alloc() with the free()
   function, you get an error message. */
#define local_alloc(X)					\
	((void *) (((char *) (xmalloc (X+16))) + 16))

#define local_free(P)				\
	free (((char *) P) - 16)
#endif /* __CHECKER__ */

/* Filesystems. */

/* Directory separator character for this OS, if applicable. */
#if !__MSDOS__
#define DIR_SEPARATOR '/'
#elif
#define DIR_SEPARATOR '\\'
#endif

/* Path delimiter character. */
#if !__MSDOS__
#define PATH_DELIMITER ':'
#else
#define PATH_DELIMITER ';'
#endif

/* MSDOS mkdir() takes only one argument. */
#if __MSDOS__ && !__DJGPP__
#define mkdir(path, mode) 			\
	mkdir (path)
#endif

/* Options. */

/* Approximate amount of memory, in bytes, to allocate before paging
   to disk.  */
#define MAX_WORKSPACE (4*1024*1024)	/* 4 MBytes */

/* (libhistory) The location for the history file that records
   commands entered interactively.  Tilde expansion is performed. */
#define HISTORY_FILE "~/.pspp_history"

/* (libhistory) Maximum number of commands to record in history
   file. */
#define MAX_HISTORY 500

/* Output drivers. */

/* Define to exclude the HTML output driver. */
/* #define NO_HTML 1 */

/* Define to exclude the PostScript and Encapsulated PostScript
   driver. */
/* #define NO_POSTSCRIPT 1 */

/* Procedure-specific options. */

/* CROSSTABS: Maximum number of tables to process in one pass. */
#define MAX_CROSSTAB_TABLES 32

/* FREQUENCIES: Define to allow bars greater than 1/2" wide. */
/* #define ALLOW_HUGE_BARS 1 */

/* FREQUENCIES: Minimum, maximum number of bars in a histogram.  The
   number is based on the number of unique values of the variable,
   unless overridden.  */
#define MIN_HIST_BARS 3
#define MAX_HIST_BARS 20

/* FREQUENCIES: Density of polyline used to approximate the normal
   curve.  The value is the number of samples taken per chart.  Higher
   values give finer curves.  */
#define POLYLINE_DENSITY (MAX_HIST_BARS*4)

