/* PSPP - computes sample statistics.
   Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   Written by Ben Pfaff <blp@gnu.org>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA. */

#include <config.h>
#include <stdlib.h>
#include "common.h"
#include "error.h"
#include "str.h"
#include "lexer.h"
#include "var.h"

int
cmd_split_file (void)
{
  match_id (SPLIT);
  match_id (FILE);
  if (match_id (OFF))
    {
      if (token != '.')
	return syntax_error (_("expecting end of command"));

      default_dict.n_splits = 0;
      free (default_dict.splits);
      default_dict.splits = NULL;
    }
  else
    {
      variable **v;
      int n;

      match_tok (BY);
      if (!parse_variables (NULL, &v, &n, PV_NO_DUPLICATE))
	return 0;
      if (token != '.')
	return syntax_error (_("expecting end of command"));

      default_dict.n_splits = n;
      default_dict.splits = v = xrealloc (v, sizeof (variable *) * (n + 1));
      v[n] = NULL;
    }
  return 1;
}
