function [n driver]= figure (n, device, file)

# usage: [id driver] = figure ([n, [device, [file]]])
#
# Set the current plot window to plot window n or creates a new figure,
# returning the window id and driver 
# If device is specified, it is opened. Default is 'xwin'.
# If file is specified, it is passed to PLplot for use.

global __pl_inited __pl

if (!exist("__pl_inited") || plglevel == 0)
	plplot_stub;
	__pl_inited = 1;
endif
      			
if (nargin == 0)
  	n = plgstrm;
else  	
   	__pl.hold(plgstrm+1) = ishold;	# save current hold state
   	plsstrm(n);
   	n = plgstrm;
   	__pl_strm = n+1;

   	if ( plglevel == 0)	# no device open yet
		if (nargin == 3)
			plsfnam(file)
		else
			plsfnam(getenv("DISPLAY")); # The tk driver needs this
		endif

		if (nargin >= 2 )
			if (isstr(device))
				plsdev(device);
			else
				error("pldef: `device' must be a string");
			endif
		else
			plsdev("xwin");
		endif
		__pl.type = 1;
		__pl.legend_xpos(__pl_strm) = 1;	# legend x position
		__pl.legend_ypos(__pl_strm) = 1;	# legend y position
		__pl.legend(__pl_strm) = 2;			# legend type
		__pl.lab_pos(__pl_strm) = 0;		# label position
		__pl.lab_lsty(__pl_strm,1) = 0;		# label (line) style
		__pl.lab_col(__pl_strm,1) = 0;		# label color
		__pl.multi_row(__pl_strm) = 1;		# multiplot state
		__pl.multi_col(__pl_strm) = 1;		# multiplot columns
		__pl.multi(__pl_strm) = 0;			# multiplot	rows
		__pl.axis_st(__pl_strm) = 0;		# axis state
		__pl.axis(__pl_strm,:) = [];		# current axis
		__pl.xticks(__pl_strm,:) = [0 0];	# xtick interval, number of minor xticks
		__pl.yticks(__pl_strm,:) = [0 0];			#
		__pl.zticks(__pl_strm,:) = [0 0];			# 		
		if (struct_contains(__pl, "xlabel"))
			__pl.xlabel = __pl_matstr( __pl.xlabel, "X", __pl_strm); # x,y,z,title labels text
			__pl.ylabel = __pl_matstr( __pl.ylabel, "Y", __pl_strm);
			__pl.zlabel = __pl_matstr( __pl.zlabel, "Z", __pl_strm);
			__pl.tlabel = __pl_matstr( __pl.tlabel, "Title", __pl_strm);
		else
			__pl.xlabel(__pl_strm,:) = "X";
			__pl.ylabel(__pl_strm,:) = "Y";
			__pl.zlabel(__pl_strm,:) = "Z";
			__pl.tlabel(__pl_strm,:) = "Title";
		endif
		__pl.lstlyle(__pl_strm) = 0;					# increase line style after plot
		__pl.az(__pl_strm) = -60;			# azimuth
		__pl.alt(__pl_strm) = 30;			# altitude
		__pl.grid(__pl_strm) = 0;			# grid state
		__pl.plcol(__pl_strm) = 1;			# current plot color
		__pl.pllsty(__pl_strm) = 1;			# current plot style
		__pl.line_count(__pl_strm) = 1;		# current label counter
		__pl.hold(__pl_strm) = 0; hold off;	# hold state
		__pl.open(__pl_strm) = 1;			# figure state
   		pldef(n)	# defaults/init 
   	else
   		if (__pl.hold(__pl_strm))
   			hold on
   		endif
#   		warning("figure already opened");
   	endif
endif

driver = sprintf("%s",plgdev');
    
endfunction
