.TH "hmmer" 1 "Dec 1998" "HMMER 2.1.1" "HMMER Manual"

.SH NAME
.TP 
HMMER - profile hidden Markov model software

.SH SYNOPSIS
.TP
.B hmmalign
Align multiple sequences to a profile HMM.

.TP
.B hmmbuild
Build a profile HMM from a given multiple sequence alignment.

.TP
.B hmmcalibrate
Determine appropriate statistical significance parameters 
for a profile HMM prior to doing database searches.

.TP 
.B hmmconvert
Convert HMMER profile HMMs to other formats, such as GCG profiles.

.TP
.B hmmemit
Generate sequences probabilistically from a profile HMM.

.TP
.B hmmpfam
Search a profile HMM database with a sequence (i.e., annotate various
kinds of domains in the query sequence).

.TP
.B hmmsearch
Search a sequence database with a profile HMM (i.e., find additional
homologues of a modeled family). 

.SH DESCRIPTION

These programs use profile hidden Markov models (profile HMMs) to
model the primary structure consensus of a family of protein or
nucleic acid sequences. 

.SH OPTIONS

.PP
All
.B HMMER 
programs give a brief summary of their command-line syntax and options
if invoked without any arguments.
When invoked with the single argument,
.B -h
(i.e., help), a program will report more verbose command-line usage
information, including rarely used, experimental, and expert options.
.B -h
will report version numbers which are useful if
you need to report a bug or problem to me.

.PP
Each
.B HMMER
program has its own man page briefly summarizing command line usage.
There is also a user's guide that came
with the software distribution, which includes a tutorial introduction
and more detailed descriptions of the programs.

See http://hmmer.wustl.edu/ for on-line documentation and
the current HMMER release.

.PP
In general, no command line options should be needed by beginning users.
The defaults are set up for optimum performance in most situations.
Options that are single lowercase letters (e.g. 
.B -a
) are "common" options that are expected to be frequently used
and will be important in many applications.
Options that are single uppercase letters (e.g. 
.B -B
) are usually less common options, but also may be important
in some applications.
Options that are full words (e.g. 
.B --verbose
) are either rarely used, experimental, or expert options. 
Some experimental options are only there for my own ongoing experiments
with HMMER, and may not be supported or documented adequately. 


.SH SEQUENCE FILE FORMATS

In general,
.B HMMER
attempts to read most common biological sequence file formats.
It autodetects the format of the file. It also autodetects
whether the sequences are protein or nucleic acid. 
Standard IUPAC degeneracy codes are allowed in addition
to the usual 4-letter or 20-letter codes. 

.TP
.B Unaligned sequences
Unaligned sequence files may be in FASTA, Swissprot, EMBL, GenBank,
PIR, Intelligenetics, Strider, or GCG format. 
These formats
are documented in the User's Guide.

.TP 
.B Sequence alignments
Multiple sequence alignments may be in CLUSTALW, SELEX, or GCG MSF
format. These formats
are documented in the User's Guide.

.SH ENVIRONMENT VARIABLES

For ease of using large stable sequence and HMM databases,
.B HMMER
looks for sequence files and HMM files in the current
working directory as well as in system directories specified
by environment variables.

.TP
.B BLASTDB
Specifies the directory location of sequence databases. Example:
.B /seqlibs/blast-db/.
In installations that use BLAST software, this environment variable
is likely to already be set.

.TP
.B HMMERDB
Specifies the directory location of HMM databases. Example:
.B /seqlibs/pfam/.

.SH SEE ALSO

.PP
hmmalign hmmbuild hmmcalibrate hmmconvert hmmemit hmmfetch hmmindex hmmpfam hmmsearch
.PP
User guide and tutorial: Userguide.ps
.PP
WWW: 
.B http://hmmer.wustl.edu/

.SH AUTHOR

This software and documentation is Copyright (C) 1992-1998 Washington
University School of Medicine.  It is freely distributable under terms
of the GNU General Public License. See COPYING in the source code
distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


