/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * z2z2_def.c
 */

#include  <model_headers.h>
/* Z2 x Z2 symmetric system*/
/* This system is a reduction of the equations describing interacting
   surface waves in a rectangular container
   References: Meron and Procaccia, Phy. Rev. A (1986) 34, 3221-3237.
   Simonelli and Gollub, J. Fluid. Mech. (1989) 199, 471-494. */
/* ------------------------------------------------------------------------
   proc used to define the vector field or map
   ------------------------------------------------------------------------ */

int 
z2( double* f, double* x, double* p )
{
        double  v0sq,v2sq;
        double  delta,gema1,gema2,omega1,omega2,a1,a2,a3,b1,b2,b3;
	delta = -0.0003215434083601271*p[1];
	gema1 = .0000003129178076161342*p[0]*p[1]*p[1];
	gema2 = .0000003150359098364779*p[0]*p[1]*p[1];
	omega1 = -0.6430868167202544*(-.5*p[1] + 49.449);
	omega2 = -0.6430868167202544*(-.5*p[1] + 50.2265);
	a1 = 0.003215434083601272*p[1];
	a2 = -0.05466237942122163*p[1];
	a3 = 0;
	b1 = -0.004180064308681654*p[1];
	b2 = -0.05466237942122163*p[1];
	b3 = 0;
	v0sq = x[0] * x[0] + x[1] * x[1];
	v2sq = x[2] * x[2] + x[3] * x[3];
	f[0] = (-omega1 + gema1) * x[1] + delta * x[0] - x[1] * (a1 * v0sq + a2 * v2sq) - 2 * a3 * x[0] * x[2] * x[3]
  	       + a3 * x[1] * (x[2] * x[2] - x[3] * x[3]);
	f[1] = (omega1 + gema1) * x[0] + delta * x[1] + x[0] * (a1 * v0sq + a2 * v2sq) + 2 * a3 * x[1] * x[2] * x[3]
 	       + a3 * x[0] * (x[2] * x[2] - x[3] * x[3]);
	f[2] = (-omega2 + gema2) * x[3] + delta * x[2] - x[3] * (b1 * v2sq + b2 * v0sq) - 2 * b3 * x[0] * x[2] * x[1]
 	       + b3 * x[3] * (x[0] * x[0] - x[1] * x[1]);
        f[3] = (omega2 + gema2) * x[2] + delta * x[3] + x[2] * (b1 * v2sq + b2 * v0sq) + 2 * b3 * x[0] * x[1] * x[3] 
	       + b3 * x[2] * (x[0] * x[0] - x[1] * x[1]);

        return 0;
}

/* ------------------------------------------------------------------------
   proc used to define functions of the variable, parameters or derivatives
   ------------------------------------------------------------------------ */
int 
z2_func( double* f, double* x, double* p )
{

        f[0] =  sqrt(x[0] * x[0] + x[1] * x[1]); 
        f[1] =  sqrt(x[2] * x[2] + x[3] * x[3]);
	f[2] = -0.0003215434083601271*p[1];
	f[3] = .0000003129178076161342*p[0]*p[1]*p[1];
	f[4] = .0000003150359098364779*p[0]*p[1]*p[1];
	f[5] = -0.6430868167202544*(-.5*p[1] + 49.449);
	f[6] = -0.6430868167202544*(-.5*p[1] + 50.2265);
	f[7] = 0.003215434083601272*p[1];
	f[8] = -0.05466237942122163*p[1];
	f[9] = 0;
	f[10] = -0.004180064308681654*p[1];
	f[11] = -0.05466237942122163*p[1];
	f[12] = 0;

        return 0;
}

/* ------------------------------------------------------------------------
   proc used to define jacobian
   ------------------------------------------------------------------------ */
/*
int 
z2_jac( double** m, double* x, double* p )
{
  return 0;
}
*/
/* ------------------------------------------------------------------------
   proc to define the default data for the dynamical system
   Note: You may change the entries for each variable but
	 DO NOT change the list of items.  If a variable is
	 unused, NULL or zero the entry, as appropriate.
   ------------------------------------------------------------------------ */
int 
z2_init(void)
{

  /* define the dynamical system in this segment 
     ---------------------------------------------------------------------- */
  int            n_varb=4;					/* dim of phase space */
  static char    *variable_names[]={"x","y","z","w"};		/* list of phase varb names */
  static double  variables[]={0.,0.,0.,0.};			/* default varb initial values */
  static double  variable_min[]={-.5,-.5,-.5,-.5};		/* default varb min for display */
  static double  variable_max[]={.5,.5,.5,.5};			/* default varb max for display */
  static char    *indep_varb_name="time";			/* name of indep variable  */
  double         indep_varb_min=0.;				/* default indep varb min for display */
  double         indep_varb_max=1000.;				/* default indep varb max for display */

  int            n_param=2;					/* dim of parameter space */
  static char    *parameter_names[]={"A","omega"};
								/* list of param names */
  static double  parameters[]= {82.,99.7};
								/* initial parameter values */
  static double  parameter_min[]={77.,99.6};
								/* default param min for display */
  static double  parameter_max[]={85.,99.8};
								/* default param max for display */

  int            n_funct=13;					/* number of user-defined functions */
  static char    *funct_names[]={"|z1|", "|z2|","delta","gema1","gema2","omega1","omega2","a1","a2","a3","b1","b2","b3"};
								/* list of funct names */
  static double  funct_min[]={-.1,-.1,-1.,-1.,-1.,-1.,-1.,-1.,-10.,-1.,-1.,-10.,-1.};
								/* default funct min for display */
  static double  funct_max[]={.1,.1,1.,1.,1.,1.,1.,1.,10.,1.,1.,10.,1.};
								/* default funct max for display */

  int            manifold_type=EUCLIDEAN;			/* PERIODIC (a periodic varb) or EUCLIDEAN */
  static int     periodic_varb[]={FALSE, FALSE, FALSE, FALSE};	/* if PERIODIC, which varbs are periodic? */
  static double  period_start[]={0.,0.,0.,0.};			/* if PERIODIC, begin fundamental domain */
  static double  period_end[]={1.,1.,1.,1.};			/* if PERIODIC, end of fundamental domain */

  int            mapping_toggle=FALSE;				/* is this a map? TRUE or FALSE */
  int            inverse_toggle=FALSE;				/* if so, is inverse FALSE, APPROX_INV,
								   or EXPLICIT_INV? FALSE for vec field */
  /*  In this section, input NULL or the name of the function which contains... */
  int            (*def_name)()=z2;				/* the eqns of motion */
  int            (*jac_name)()=NULL;				/* the jacobian (deriv w.r.t. space) */
  int            (*aux_func_name)()=z2_func;			/* the auxiliary functions */
  int            (*inv_name)()=NULL;				/* the inverse or approx inverse */
  int            (*dfdt_name)()=NULL;				/* the deriv w.r.t time */
  int            (*dfdparam_name)()=NULL;			/* the derivs w.r.t. parameters */

  c_filename = __FILE__;  /* display this file for help with this system */

  /* end of dynamical system definition 
     ----------------------------------------------------------------------- */

#include <ds_define.c>

  return 0;
}

