/*
 * =========================================================================
 * utilities - A library of utility functions used by the drawmap program.
 * Copyright (c) 1997  Fred M. Erickson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * =========================================================================
 */


/*
 * Convert latitudes in degree/min/sec format into decimal degrees.
 *
 * We assume that there is no decimal point, or other punctuation,
 * and that the numeric latitude is in the DDMMSS format,
 * and that the latitude is immediately followed by 'N' or 'S'.
 */
double lat_conv(unsigned char *ptr)
{
	double lat;
	double min;
	double sec;

	lat = *ptr - '0';
	lat = lat * 10.0 + *(ptr + 1) - '0';
	min = *(ptr + 2) - '0';
	min = min * 10.0 + *(ptr + 3) - '0';
	sec = *(ptr + 4) - '0';
	sec = sec * 10.0 + *(ptr + 5) - '0';
	lat = lat + min / 60.0 + sec / 3600.0;
	if (*(ptr + 6) == 'S')  {
		lat = -lat;
	}
	return(lat);
}


/*
 * Convert longitudes in degree/min/sec format into decimal degrees.
 *
 * We assume that there is no decimal point, or other punctuation,
 * and that the numeric longitude is in the DDDMMSS format,
 * and that the longitude is immediately followed by 'W' or 'E'.
 */
double lon_conv(unsigned char *ptr)
{
	double lon;
	double min;
	double sec;

	lon = *ptr - '0';
	lon = lon * 10.0 + *(ptr + 1) - '0';
	lon = lon * 10.0 + *(ptr + 2) - '0';
	min = *(ptr + 3) - '0';
	min = min * 10.0 + *(ptr + 4) - '0';
	sec = *(ptr + 5) - '0';
	sec = sec * 10.0 + *(ptr + 6) - '0';
	lon = lon + min / 60.0 + sec / 3600.0;
	if (*(ptr + 7) == 'W')  {
		lon = -lon;
	}
	return(lon);
}




/* Round double values to long integers. */
long
round(double f)
{
	long i;
	double ff;

	i = (long)f;
	ff = (double)i;

	if (f < 0.0)  {
		if ((ff - f) >= 0.5)  {
			return(i - 1);
		}
	}
	else  {
		if ((f - ff) >= 0.5)  {
			return(i + 1);
		}
	}

	return(i);
}



/* Find the maximum of two long integers. */
long
max(long a, long b)
{
	if (a > b)  {
		return(a);
	}
	else  {
		return(b);
	}
}



/* Find the minimum of three doubles */
double
min3(double a, double b, double c)
{
	if (a < b)  {
		if (a < c)  {
			return(a);
		}
		else  {
			return(c);
		}
	}
	else  {
		if (b < c)  {
			return(b);
		}
		else  {
			return(c);
		}
	}
}



/* Find the maximum of three doubles */
double
max3(double a, double b, double c)
{
	if (a > b)  {
		if (a > c)  {
			return(a);
		}
		else  {
			return(c);
		}
	}
	else  {
		if (b > c)  {
			return(b);
		}
		else  {
			return(c);
		}
	}
}
