// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: window.h,v 1.5 1998/09/15 05:57:26 jgg Exp $
/* ######################################################################

   GUIWindow - GUI Window widget
   
   If you are looking for the 'base class' look in widget.h.
   
   This widget represents a window in a GUI application. Most GUI windows
   have a title bar, a way to change the size of the widget and a close
   button. All of these things are reflected here which is a cover for
   the GenGC region managment functions
   
   The widget should really only be constructed inside of the root widget
   for the GUI.
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_WINDOW_H
#define DEITY_WINDOW_H

#ifdef __GNUG__
#pragma interface "deity/window.h"
#endif  
#include <deity/basic.h>

// Notifications generated by GUIWindow
#define Nt_CloseReq Notifyer::Tag(GUIWindow::Type,1) // Data -> 0

class GUIWindow : public BasicWidget
{
   protected:
   
   string iTitle;
   
   virtual void Render(CombinedGC &GC);
      
   public:
   static void *Type;

   virtual void Realize();
   virtual void Describe(ostream &stream) const;
   
   GUIWindow(string Title,Widget *Parent = 0);
};

#endif
