/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import org.openxml.dom.CharacterDataImpl;
import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.DocumentImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class TextImpl
extends CharacterDataImpl
implements Text {
    TextImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl, "#text", string);
    }

    TextImpl(DocumentImpl documentImpl, String string, String string2) {
        super(documentImpl, string, string2);
    }

    public Object clone() {
        TextImpl textImpl = new TextImpl(this._ownerDocument, this.getNodeValue());
        this.cloneInto(textImpl, true);
        return textImpl;
    }

    public Node cloneNode(boolean bl) {
        TextImpl textImpl = new TextImpl(this._ownerDocument, this.getNodeValue());
        this.cloneInto(textImpl, bl);
        return textImpl;
    }

    public short getNodeType() {
        return 3;
    }

    public final synchronized Text splitText(int n) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (n < 0 || n > this.getLength()) {
            throw new DOMExceptionImpl(1, "Offest is negative or greater than text size.");
        }
        TextImpl textImpl = new TextImpl(this._ownerDocument, this.substringData(0, n));
        if (this.getParentNode() != null) {
            this.getParentNode().insertBefore(textImpl, this);
        }
        this.setData(this.substringData(n, this.getLength() - n));
        return textImpl;
    }

    public String toString() {
        String string = this.getData();
        if (string.length() > 64) {
            string = String.valueOf(string.substring(0, 64)) + "..";
        }
        string = string.replace('\n', '|');
        return "Text node: [" + string + "]";
    }
}

