// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>
//
// Note: see triangulation.C for original sources this code is based on.

//<file>
//
// Name:        monotone.h
//
// Purpose:     interface to triangulation routines; monotone polygons
//
// Created:      4 Apr 96   Richard Persche
//
// Changed:     18 Apr 96   Richard Persche
//
// Changed:     18 Jun 96   Michael Pichler
//
// $Id: monotone.h,v 1.2 1997/02/25 17:03:58 mpichler Exp $
//
//</file>


#ifndef harmony_scene_monotone_h
#define harmony_scene_monotone_h


/* Main routine to get monotone polygons from the trapezoidation of 
 * the polygon.
 */

int monotonate_trapezoids (int n);


/* recursively visit all the trapezoids */
int traverse_polygon (int mcur, int trnum, int from, int dir);


void triangulate_monotone_polygons (int nmonpoly, int op[][3]);

/* A greedy corner-cutting algorithm to triangulate a y-monotone 
 * polygon in O(n) time.
 * Joseph O-Rourke, Computational Geometry in C.
 */

void triangulate_single_polygon (int posmax, int side, int op[][3]);


/* The points constituting the polygon are specified in anticlockwise
 * order. If there are n points in the polygon, i/p would be the
 * points p0, p1....p(n) (where p0 and pn are the same point). The
 * output is contained in the array "triangles".
 * Every triangle is output in anticlockwise order and the 3
 * integers are the indices of the points. Thus, the triangle (i, j, k)
 * refers to the triangle formed by the points (pi, pj, pk). Before
 * using this routine, please check-out that you do not conflict with
 * the global variables  defined in basic.h.
 *
 * n:         number of points in polygon (p0 = pn)
 * vertices:  the vertices p0, p1..., p(n) of the polygon
 * triangles: output array containing the triangles 
 */


void triangulate_polygon (int n, double vertices[][2], int triangles[][3]);


#endif
