//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        attributes.C
//
// Purpose:     Interface to 
//
// Created:     23 Feb 1996  Georg Meszaros
//
// Modified:  
//
//
// Description:
//
// Implementation of the class FaceAttr.
//
//</file>


//<class>
//
// Name:    
//
// Purpose: Indexed faceset with light, material settings.
//
//
// Public Interface:
//
//
//</class>


#include "attributes.h"
#include "clipping.h"
#include "ge3d/ge3d.h"

#include <iostream.h>


void AnyLight::print()
{
  cerr << "AnyLight:\n";
}



PosDirLight::PosDirLight(const colorRGB& color,
                const point3D& point,
                int pos_dir,
                int camlg)
{
   index_ = -1;
   color_ = color;
   point_ = point;
   pos_dir_ = pos_dir;
   camlg_ = camlg;
}


void PosDirLight::setLight(int index) 
{
//TODO sort problems with index out
  index_ = index;
  ge3dSetLightSource (index, &color_, &point_, pos_dir_, camlg_);
  ge3d_switchlight (index, 1);
}


void PosDirLight::switchOff()
{
  ge3d_switchlight (index_, 0);
}


void PosDirLight::showLight()
{
// to make the light source visible
  ge3d_wirecube(point_.x-0.1, point_.y-0.1, point_.z-0.1, 
                point_.x+0.1, point_.y+0.1, point_.z+0.1);
}


void PosDirLight::print()
{
   cerr << "PosDir-Light:\n" << index_ << "\n";
   Clipping::printRGB(color_);
   Clipping::print3D(point_);
   cerr << pos_dir_ << "\n" << camlg_ << "\n\n";
}


SpotLight::SpotLight(const colorRGB& color,
              const point3D& point,
              const vector3D& dir,
              float droprate,
              float cutangle)
{
  index_ = -1;
  color_ = color;
  point_ = point;
  dir_ = dir;
  droprate_ = droprate; 
  cutangle_ = cutangle;
}  



void SpotLight::setLight(int index) 
{
//TODO sort problems with index out
  index_ = index;
  ge3dSpotLight (index, &color_, &point_, &dir_, droprate_, cutangle_);
  ge3d_switchlight (index, 1);
} 


void SpotLight::switchOff()
{
  ge3d_switchlight (index_, 0);
}



void SpotLight::showLight()
{
// to make the light source visible
  ge3d_wirecube(point_.x-0.1, point_.y-0.1, point_.z-0.1, 
                point_.x+0.1, point_.y+0.1, point_.z+0.1);
  ge3d_line(point_.x, point_.y, point_.z,
            point_.x + dir_.x, point_.y + dir_.y, point_.z + dir_.z);
}


void SpotLight::print()
{
   cerr << "Spot-Light\n" << index_ << "\n";
   Clipping::printRGB(color_);
   Clipping::print3D(point_);
   Clipping::print3D(dir_);
   cerr << droprate_ << "\n" << cutangle_ << "\n\n";
}
