// -*- C++ -*-
//<copyright>
//
// Copyright (c) 1997
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:    dependon.h
//
// Purpose: dependencies from other binaries
//
// Created: 21 Jan 1997 Till Vollmer
//
// $Id: dependon.h,v 1.1 1997/01/22 13:13:07 tvollmer Exp $
//
// Description:
//   
//</file>
//
// $Log: dependon.h,v $
// Revision 1.1  1997/01/22 13:13:07  tvollmer
// Initial revision
//
//

#ifndef hg_path_dependon_h
#define hg_path_dependon_h

#include <hyperg/utils/smartptr.h>
#include <hyperg/utils/strfield.h>

class DependVersion
{
public:
    DependVersion(const RString&);
    bool operator == (const DependVersion&) const;
    bool operator != (const DependVersion& it) const {return !(*this == it);}
    bool operator <= (const DependVersion& it) const {return *this == it || *this < it;}
    bool operator >= (const DependVersion& it) const {return *this == it || *this > it;}
    bool operator >  (const DependVersion& it) const {return it < *this ;}
    bool operator <  (const DependVersion& it) const ;
    
    operator  RString() const;
private:
    int major_;
    int minor_;
};


class DependAtom : public RefCounted
{
public:
    virtual bool evaluate(RStringField&) const {return true;}
    virtual ~DependAtom() {}
};

SmartPtrdeclare(DependAtomPtr,DependAtom)


class DependAND : public DependAtom
{
public:
    DependAND(const DependAtomPtr& a1,const DependAtomPtr& a2) :atom1_(a1),atom2_(a2) {}
    virtual bool evaluate(RStringField&) const;
private:
    DependAtomPtr atom1_;
    DependAtomPtr atom2_;
};

class DependOR : public DependAtom
{
public:
    DependOR(const DependAtomPtr& a1,const DependAtomPtr& a2) :atom1_(a1),atom2_(a2) {}
    virtual bool evaluate(RStringField&) const;
private:
    DependAtomPtr atom1_;
    DependAtomPtr atom2_;
};

class DependEntry : public DependAtom
{
public:    
    enum Operator{EQUAL,NOT_EQUAL,LESS,LESS_EQUAL,GREATER,GREATER_EQUAL};

    DependEntry (const RString& com,const Operator& op,const RString& ver):command_(com),op_(op),version_(ver) {}
    virtual bool evaluate(RStringField&) const;
private:    
    RString command_;
    Operator op_;
    DependVersion  version_;
};



#endif /* hg_path_dependon_h */
