/*
 * common.h  -  Common definitions for all mknbi programs
 *
 * Copyright (C) 1996-1998 Gero Kuhlmann   <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 * General definitions for compiling on different systems
 */
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef __STDC__
# define voidstar void *
#else
# define voidstar char *
#endif

#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#ifdef STDC_HEADERS
# include <stdlib.h>
#else
# ifdef HAVE_MALLOC_H
#  include <malloc.h>
# else
extern voidstar malloc();
extern void free();
# endif
#endif

#ifndef __P
# if defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#  define __P(args) args
# else
#  define __P(args) ()
# endif
#endif

#include <errno.h>
#ifndef errno
extern int errno;
#endif

#ifdef HAVE_SYS_PARAM_H
# include <sys/param.h>
#endif
#ifndef MAXPATHLEN
# ifdef PATH_MAX
#  define MAXPATHLEN PATH_MAX
# else
#  define MAXPATHLEN 1024
# endif
#endif

#if defined(M_XENIX) && defined(I_286)
#undef __XENIX__
#define __XENIX__
#endif


/*
 * Check for packed attribute. This is necessary to match some C
 * structures to what the bootrom and the assembler modules expect.
 * Without the packed attribute at least the GNU C compiler aligns
 * byte variables to word boundaries which is not always correct.
 * Other compilers might be able to use the pack or align pragmas.
 */
#ifdef USE_PACKED
# define PACKED __attribute__((packed))
# undef USE_PRAGMA_PACK
# undef USE_PRAGMA_ALIGN
#endif

#ifdef USE_PRAGMA_PACK
# define PACKED
# undef USE_PACKED
# undef USE_PRAGMA_ALIGN
#endif

#ifdef USE_PRAGMA_ALIGN
# define PACKED
# undef USE_PACKED
# undef USE_PRAGMA_PACK
#endif


/*
 * sys/types.h and unistd.h are required to include variable types
 * which define certain bit sized units.
 */
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <sys/types.h>
#ifdef HAVE_SYS_BITYPES_H
# include <sys/bitypes.h>
#endif


/*
 * Check if we have proper networking support
 */
#if !defined(HAVE_NETDB_H) || !defined(HAVE_NETINET_IN_H) || !defined(HAVE_ARPA_INET_H)
#undef HAVE_INET
#else
#define HAVE_INET
#endif


/*
 * Different variants of UNIX use different ways accessing directories. Make
 * everything so that it looks like in dirent.h.
 */
#if defined(DIRENT) || defined(_POSIX_VERSION)
# include <dirent.h>
# define NLENGTH(dirent) (strlen((dirent)->d_name))
#else
# define dirent direct
# define NLENGTH(dirent) ((dirent)->d_namlen)
# ifdef SYSNDIR
#  include <sys/ndir.h>
# endif
# ifdef SYSDIR
#  include <sys/dir.h>
# endif
# ifdef NDIR
#  include <dir.h>
# endif
#endif


/*
 * Check for include files which define struct tm.
 */
#ifdef TIME_WITH_SYS_TIME
# ifdef TM_IN_SYS_TIME
#  include <sys/time.h>
# endif
# include <time.h>
#else
# if defined(HAS_SYS_TIME_H) && defined(TM_IN_SYS_TIME)
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif


/*
 * Do the usual checks for memory and string handling functions.
 */
#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
# include <string.h>
# if !defined(STDC_HEADERS) && defined(HAVE_MEMORY_H)
#  include <memory.h>
# endif
#else
# include <strings.h>
# ifndef memcpy
#  define memcpy(D, S, N) bcopy((S), (D), (N))
# endif
# ifndef strchr
#  define strchr(S, C) index ((S), (C))
# endif
# ifndef strrchr
#  define strrchr(S, C) rindex ((S), (C))
# endif
# ifndef bcopy
void bcopy();
# endif
#endif


/*
 * Next check for type definitions for 8, 16 and 32 bit variables.
 * The assembler modules expect most values in a specific size, and
 * we must ensure that the C programs produce the correct size.
 */
#ifdef USE_U_INT
# define __u8 u_int8_t
# define __u16 u_int16_t
# define __u32 u_int32_t
#else
# ifndef USE__UXX
#  ifndef U8_TYPE
#   if SIZEOF_UNSIGNED_CHAR == 1
#    define U8_TYPE unsigned char
#   else
#    error Unable to set 8-bit-type
#   endif
#  endif
#  ifndef U16_TYPE
#   if SIZEOF_UNSIGNED_INT == 2
#    define U16_TYPE unsigned int
#   else
#    if SIZEOF_UNSIGNED_SHORT == 2
#     define U16_TYPE unsigned short
#    else
#     error Unable to set 16-bit-type
#    endif
#   endif
#  endif
#  ifndef U32_TYPE
#   if SIZEOF_UNSIGNED_LONG == 4
#    define U32_TYPE unsigned long
#   else
#    if SIZEOF_UNSIGNED_INT == 4
#     define U32_TYPE unsigned int
#    else
#     error Unable to set 32-bit-type
#    endif
#   endif
#  endif
typedef U8_TYPE  __u8;
typedef U16_TYPE __u16;
typedef U32_TYPE __u32;
# endif
#endif


/*
 * Define some macros to allow a non-intel host system to produce
 * correct byte ordering code for the intel target system.
 */
#ifndef NO_BINARY  /* No need to include this for utility programs */
# define swapbytes(a)	((((__u16)(a) & 0x00ff) << 8) | (((__u16)(a) & 0xff00) >> 8))
# define low_word(a)	((a) & 0x0000ffff)
# define high_word(a)	(((a) >> 16) & 0x0000ffff)
# define get_long(a)	((unsigned long)((ttoh(getval((a).high)) << 16) | \
						ttoh(getval((a).low))))
# ifndef WORDS_BIGENDIAN
#  define htot(a)		((__u16)(a))
#  define ttoh(a)		((unsigned short)(a))
# else
#  define htot(a)		((__u16)swapbytes(a))
#  define ttoh(a)		((unsigned short)swapbytes(a))
# endif
#endif /* NO_BINARY */


/*
 * On some systems like SPARCs it is not possible to have integer variables
 * on misaligned addresses, so we have to use memcpy in that case.
 */
#ifndef NO_BINARY  /* No need to include this for utility programs */
# ifdef USE_COPY

#  define assign(a, b)	mycopy(&(a), (b))
	/*
	 * Copy a value out of a host system variable into a target system
	 * structure
	 */
	static inline void mycopy(a, b)
	  __u16 *a;
	  __u16 b;
	{
	  memcpy(a, &b, sizeof(__u16));
	}

#  define getval(a)	mygetval(&(a))
	/*
	 * Return a value out of a target system structure
	 */
	static inline __u16 mygetval(a)
	  __u16 *a;
	{
	  __u16 b;
	  memcpy(&b, a, sizeof(__u16));
	  return(b);
	}

# else /* USE_COPY */

#  define assign(a, b)	a = b
#  define getval(a)	(a)

# endif /* USE_COPY */
#endif /* NO_BINARY */


/*
 * Define the layout of Intel addresses and long words in memory.
 */
#ifdef USE_PRAGMA
#pragma pack(1)
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=packed
#endif
struct i_addr {
  __u16 offset	PACKED;
  __u16 segment	PACKED;
};


struct i_long {
  __u16 low	PACKED;
  __u16 high	PACKED;
};
#ifdef USE_PRAGMA
#pragma pack()
#endif
#ifdef USE_PRAGMA_ALIGN
#pragma options align=reset
#endif


/*
 * General definitions
 */
#ifndef TRUE
# define TRUE 1
#endif
#ifndef FALSE
# define FALSE 0
#endif


/*
 * Definition of exit codes
 *   0x000 - 0x0ff  general exit codes for all programs
 *   0x100 - 0x1ff  exit codes for makerom
 *   0x200 - 0x2ff  exit codes for mknbi-linux
 *   0x300 - 0x3ff  exit codes for mknbi-dos
 *   0x400 - 0x4ff  exit codes for mknbi-mgl
 */
#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS		0x000		/* no error */
#endif
#define EXIT_USAGE		0x001		/* usage */
#define EXIT_MEMORY		0x002		/* not enough memory */
#define EXIT_OPEN		0x003		/* cannot open file */
#define EXIT_CREATE		0x004		/* cannot create file */
#define EXIT_READ		0x005		/* read error */
#define EXIT_WRITE		0x006		/* write error */
#define EXIT_ACCESS		0x007		/* error accessing file */
#define EXIT_TEMPNAME		0x008		/* error generating temp name */
#define EXIT_SEEK		0x009		/* seek error */
#define EXIT_OPENDIR		0x00A		/* error opening directory */
#define EXIT_INTERNAL		0x00B		/* internal error */
#define EXIT_HOSTNAME		0x00C		/* invalid hostname */
#define EXIT_HOSTADDR		0x00D		/* invalid host address */
#define EXIT_INET		0x00E		/* no INET support */
#define EXIT_STAT		0x00F		/* cannot stat file or dir */

#define EXIT_MAKEROM_CONFIG	0x100		/* error in config file */
#define EXIT_MAKEROM_DBFILE	0x101		/* unable to open dbase file */
#define EXIT_MAKEROM_DBERR	0x102		/* error in dbase file */
#define EXIT_MAKEROM_NOKERN	0x103		/* no kernel file given */
#define EXIT_MAKEROM_NOOUT	0x104		/* no output file given */
#define EXIT_MAKEROM_NOLOADER	0x105		/* no loader specified */
#define EXIT_MAKEROM_NODRIVER	0x106		/* no driver specified */
#define EXIT_MAKEROM_NODB	0x107		/* no database specified */
#define EXIT_MAKEROM_NOSYS	0x108		/* system not in database */
#define EXIT_MAKEROM_OPENKERN	0x109		/* unable to open kernel */
#define EXIT_MAKEROM_READKERN	0x10A		/* unable to read kernel */
#define EXIT_MAKEROM_INVKERN	0x10B		/* invalid kernel version */
#define EXIT_MAKEROM_OPENDRV	0x10C		/* unable to open driver */
#define EXIT_MAKEROM_EXEEOF	0x10D		/* unexpected end of EXE file */
#define EXIT_MAKEROM_SIZE64	0x10E		/* output file >64kB */
#define EXIT_MAKEROM_OPENLDR	0x10F		/* unable to open loader */
#define EXIT_MAKEROM_PKTFND	0x110		/* no packet drivers found */
#define EXIT_MAKEROM_KERNFND	0x111		/* no kernel files found */
#define EXIT_MAKEROM_ROMREAD	0x112		/* unable to read rom image */
#define EXIT_MAKEROM_ROMEOF	0x113		/* unexpected end of rom */
#define EXIT_MAKEROM_MISORDER	0x114		/* image chunks misordered */
#define EXIT_MAKEROM_PROGLSIZE	0x115		/* FlashCard prog too large */
#define EXIT_MAKEROM_INVEXE	0x116		/* Invalid EXE file header */

#define EXIT_LINUX_MISORDER	0x200		/* image chunks misordered */
#define EXIT_LINUX_KERNEOF	0x201		/* unexpected end of kernel */
#define EXIT_LINUX_INVKERN	0x202		/* invalid kernel image */
#define EXIT_LINUX_INVSETUP	0x203		/* invalid kernel setup */
#define EXIT_LINUX_KERNSIZE	0x204		/* kernel too large */
#define EXIT_LINUX_CMDLSIZE	0x205		/* command line size */
#define EXIT_LINUX_RDLOC	0x206		/* invalid ramdisk location */
#define EXIT_LINUX_NORD		0x207		/* no ramdisk specified */
#define EXIT_LINUX_KERNOPEN	0x208		/* unable to open kernel file */
#define EXIT_LINUX_IMGCREATE	0x209		/* unable to create image */
#define EXIT_LINUX_RDOPEN	0x20A		/* unable to open ramdisk */
#define EXIT_LINUX_BOOTLSIZE	0x20B		/* invalid boot loader size */

#define EXIT_DOS_MISORDER	0x300		/* image chunks misordered */
#define EXIT_DOS_RDREAD		0x301		/* error reading ramdisk */
#define EXIT_DOS_RDEOF		0x302		/* unexpected end of ramdisk */
#define EXIT_DOS_FATCMP		0x303		/* FAT copies do not match */
#define EXIT_DOS_NOBOOT		0x304		/* ramdisk not bootable */
#define EXIT_DOS_NODOS		0x305		/* ramdisk not DOS image */
#define EXIT_DOS_INVFS		0x306		/* invalid DOS filesystem */
#define EXIT_DOS_SECTSIZE	0x307		/* invalid sector size */
#define EXIT_DOS_HIDDEN		0x308		/* ramdisk has hidden sectors */
#define EXIT_DOS_FATNUM		0x309		/* invalid FAT number */
#define EXIT_DOS_RESVDSECT	0x30A		/* invalid reserved sectors */
#define EXIT_DOS_DOUBLESIDE	0x30B		/* ramdisk not double sided */
#define EXIT_DOS_RDSIZE		0x30C		/* invalid ramdisk size */
#define EXIT_DOS_IMGCREATE	0x30D		/* unable to create image */
#define EXIT_DOS_BOOTLSIZE	0x30E		/* invalid boot loader size */
#define EXIT_DOS_DOUBLEFILE	0x30F		/* two files with same name */
#define EXIT_DOS_MSDOSSYS	0x310		/* msdos.sys is missing */
#define EXIT_DOS_IOSYS		0x311		/* io.sys is missing */
#define EXIT_DOS_RDSPACE	0x312		/* not enough ramdisk space */
#define EXIT_DOS_RDSTAT		0x313		/* unable to stat ramdisk */
#define EXIT_DOS_RDOPEN		0x314		/* unable to open ramdisk */
#define EXIT_DOS_INVRD		0x315		/* ramdisk no file or dir */
#define EXIT_DOS_BOOTSECT	0x316		/* invalid DOS boot sector */

#define EXIT_MGL_MISORDER	0x400		/* image chunks misordered */
#define EXIT_MGL_CODESIZE	0x401		/* code size too large */
#define EXIT_MGL_CONSTSIZE	0x402		/* const data size too large */
#define EXIT_MGL_RELOCOVRFLOW	0x403		/* overflow of reloc buffer */
#define EXIT_MGL_DEBUGOVRFLOW	0x404		/* overflow of debug buffer */
#define EXIT_MGL_COMPERRS	0x405		/* compile errors */
#define EXIT_MGL_NOSTART	0x406		/* no start screen defined */
#define EXIT_MGL_PROGOPEN	0x407		/* unable to open prog file */
#define EXIT_MGL_IMGCREATE	0x408		/* error creating output file */

