!**************************************************************************
!*
!* Boot-ROM-Code to load an operating system across a TCP/IP network.
!*
!* Module:  memory.S
!* Purpose: Allocate and free memory
!* Entries: _malloc, _free, _memavail
!*
!**************************************************************************
!*
!* Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
!*
!*  This program is free software; you can redistribute it and/or modify
!*  it under the terms of the GNU General Public License as published by
!*  the Free Software Foundation; either version 2 of the License, or
!*  any later version.
!*
!*  This program is distributed in the hope that it will be useful,
!*  but WITHOUT ANY WARRANTY; without even the implied warranty of
!*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!*  GNU General Public License for more details.
!*
!*  You should have received a copy of the GNU General Public License
!*  along with this program; if not, write to the Free Software
!*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
!*


!
!**************************************************************************
!
! Include assembler macros:
!
#include <macros.inc>
#include <memory.inc>
#include "./libpriv.inc"


!
!**************************************************************************
!
! Start code segment.
!
	.text

	public	_malloc			! define entry points
	public	_free
	public	_memavail


!
!**************************************************************************
!
! Allocate memory.
! Input:  1. arg  -  number of bytes to allocate
! Output: pointer to memory block, or 0 if error
!
_malloc:

	penter				! setup standard stack frame
	getcarg	(bx,0)			! get number of bytes to allocate
	shift	(shr,bx,4)		! convert it into paragraph number
	inc	bx
	mov	ah,#$48
	int	$21			! allocate memory using DOS
	jc	alloc8

	mov	bx,ds
	sub	ax,bx			! convert segment address into offset
	cmp	ax,#$0FFF		! in data segment
	ja	alloc8			! should not be too far away
	shift	(shl,ax,4)		! convert segment offset into byte
	jmp	alloc9			! offset

alloc8:	xor	ax,ax			! return with error
alloc9:	pleave
	ret


!
!**************************************************************************
!
! Free a memory block.
! Input:  1. arg  -  pointer to memory block
! Output: none
!
_free:

	penter				! setup standard stack frame
	getcarg	(bx,0)			! get pointer to memory block
	shift	(shr,bx,4)		! convert byte offset into
	mov	ax,ds			! paragraph offset
	add	ax,bx			! compute segment of memory block

	push	es
	mov	es,ax
	mov	ah,#$49			! free memory block using DOS
	int	$21
	pop	es
free9:	pleave
	ret


!
!**************************************************************************
!
! Determine amount of free memory in kB.
! Input:  none
! Output: memory size
!
_memavail:

	mov	ah,#$48
	mov	bx,#$FFFF		! determine amount of free memory
	int	$21			! should always return with carry
	shift	(shr,bx,6)		! convert into kB
	mov	ax,bx
	ret


!
!**************************************************************************
!
	end

