/*
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef s_Animator_h
#define s_Animator_h

/****************************************************************
 *
 * Animator widget
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 animatorBgPixmap    AnimatorBgPixmap	Pixmap		None
 animatorCast	     AnimatorCast			NULL
 animatorNow	     AnimatorNow			0
 animatorDelta	     AnimatorDelta			100
 animatorDocDir	     AnimatorDocDir			NULL
 animatorDuration    AnimatorDuration			1000
 animatorMode	     AnimatorMode			ANI_STOP
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 height		     Height		Dimension	0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	0
 x		     Position		Position	0
 y		     Position		Position	0

*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

#define XtNanimatorCast "animatorCast"
#define XtNanimatorNow "animatorNow"
#define XtNanimatorDelta "animatorDelta"
#define XtNanimatorDuration "animatorDuration"
#define XtNanimatorMode "animatorMode"
#define XtNanimatorBgPixmap "animatorBgPixmap"
#define XtNanimatorDocDir "animatorDocDir"

#define XtCAnimatorCast "AnimatorCast"
#define XtCAnimatorNow "AnimatorNow"
#define XtCAnimatorDelta "AnimatorDelta"
#define XtCAnimatorDuration "AnimatorDuration"
#define XtCAnimatorMode "AnimatorMode"
#define XtCAnimatorBgPixmap "AnimatorBgPixmap"
#define XtCAnimatorDocDir "AnimatorDocDir"

/* declare specific AnimatorWidget class and instance datatypes */

typedef struct s_AnimatorClassRec*	AnimatorWidgetClass;
typedef struct s_AnimatorRec*		AnimatorWidget;

/* declare the class constant */

extern WidgetClass animatorWidgetClass;

/* misc stuff originally in animator.h */

#define ANI_OK 0
#define ANI_ERR 1

#define ANI_NONE 0

#define ANI_STOP 1
#define ANI_NEXT 2
#define ANI_PREVIOUS 3
#define ANI_CONTINUE 4
#define ANI_QUIT 5

#define ANI_LINE 1
#define ANI_RECTANGLE 2
#define ANI_ARC 3
#define ANI_ELLIPSE 4
#define ANI_PIXMAP 5
#define ANI_STRING 6
#define ANI_POINT 7
#define ANI_FILLRECT 8
#define ANI_FILLARC 9
#define ANI_FILLELLIPSE 10

#define ANI_X 1
#define ANI_Y 2
#define ANI_WIDTH 3
#define ANI_HEIGHT 4
#define ANI_VISIBLE 5
#define ANI_COLOR 6
#define ANI_FONT 7
#define ANI_TEXT 8

/* linked list of positions, sizes et al of an object */
typedef struct s_ani_script {
	long time;
	int x, y;	/* position */
	int width, height;
	int visible;
	int color;
	int font;
	char *string;
	struct s_ani_script *next;
} ani_script;

/* linked list of all the objects on the stage */
typedef struct s_ani_object {
	int type;
	char *name;
	ani_script *script;
	struct s_ani_object *next;
} ani_object;

typedef struct s_ani_image {
	char *filename;
	Pixmap pixmap, mask;
	XpmAttributes xa;
	struct s_ani_image *next;
} ani_image;

extern ani_image *name2image(Display *, Window, char *, char *);
extern Pixmap ani_pixmap(Display *, Window, GC,
			ani_object *, char *, unsigned long, char *);

#endif /* s_Animator_h */

