/*
   Siag, Scheme In A Grid
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include "../common/cmalloc.h"
#include <string.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/stat.h>

#include "../siag/types.h"
#include "../siag/calc.h"

extern void init_windows1(int *, char **);
extern void mainloop(void);

#ifdef GUILE
#include <guile/gh.h>
#endif

#ifdef TCL
#include <tcl.h>
#endif

#include "../siod/siod.h"

/* 970430 use this to automatically figure out where we are */
#include "../common/siaghome.h"

#ifndef SIAGHELP
#define SIAGHELP "chimera"
#endif
#ifndef SIAGRC
#define SIAGRC ".siagrc"
#endif

extern void init_position(void);        /* position.c */
extern int init_C_parser(void);         /* ci.c */
extern int init_parser(int, char **);   /* siodi.c */
extern int init_guile_parser();         /* guilei.c */
extern int init_tcl_parser();           /* tcli.c */
extern void init_interpreters();        /* railway.c */

char *siaghome, *siaghelp;
static char *siagrc;

int ok2print = 0;

int siod_interpreter, C_interpreter;

extern char *siag_format;       /* fileio.siag.c */

static void waitforchild(int i)
{
        waitpid(-1, NULL, WNOHANG);
        signal(SIGCHLD, waitforchild);
}

#ifdef TCL
int Tcl_AppInit(Tcl_Interp *interp)
{
        init_tcl_parser(interp);
        mainloop();
        return TCL_OK;  /* it won't, though */
}
#endif

static void malloc_fail_handler()
{
        fprintf(stderr, "Out of memory\n");
TRACEME((f, "malloc_fail_handler: %s", "Out of memory"))

#if 1
        fprintf(stderr, "\t(should save all changed buffers before aborting)\n");
        abort();
#else
        fprintf(stderr, "Trying to bail out...\n");
        /* delete all windows */
        while (w_list) {
                free_window(w_list);
        }
        /* now say a prayer, close your eyes and jump */
        execute("(quit-siag)");
#endif
        exit(1);
}

void realmain(int argc, char **argv)
{
        char b[256], *home;
        struct stat statbuf;
        buffer *buf = NULL;
        char path[1024], siagpath[1024];
        int i;

        if ((siaghome = getenv("SIAGHOME")) == NULL) {
                char env[256];
                sprintf(env, "SIAGHOME=%s", SIAGHOME);
                putenv(env);
                siaghome = SIAGHOME;
        }
        if ((siaghelp = getenv("SIAGHELP")) == NULL) {
                char env[256];
                sprintf(env, "SIAGHELP=%s", SIAGHELP);
                putenv(env);
                siaghelp = SIAGHELP;
        }
        if ((home = getenv("HOME")) == NULL)
                home = ".";
        sprintf(b, "%s/%s", home, SIAGRC);
        siagrc = cstrdup(b);

        init_windows1(&argc, argv);

        siod_interpreter = init_parser(argc, argv);
        C_interpreter = init_C_parser();
#ifdef GUILE
        init_guile_parser();
#endif
        interp_startup();
        init_mathwrap();        /* standard FP library functions */

        buf = new_buffer("noname.siag", "noname.siag");

        init_windows(buf, argc, argv);

        ok2print = 1;

        init_position();
        init_cmds();

        /* find runtime library */
        strncpy(siagpath, siaghome, 1020);
        strncat(siagpath, "/siag", 1020);
        while (sprintf(path, "%s/siag.scm", siagpath),
               stat(path, &statbuf)) {
                char *buttons[] = {"OK", "Cancel"};
                char *formats[] = {"Siag runtime library (siag.scm)", NULL};
                char name[256], fmt[256];
                int n = alert_box(
        "Can\'t find siag.scm. Please locate it in the following dialog",
                        buttons, 2);
                if (n == 1) exit(1);

                getcwd(siagpath, sizeof(siagpath));
                name[0] = '\0';
                fmt[0] = '\0';
                n = select_file(siagpath, name, formats, fmt);
                if (n == 0) exit(1);
        }
        siaghome = siagpath;
        *strrchr(siaghome, '/') = '\0';

        /* must set SIAGHOME like this if SLIBU is undefined */
        sprintf(b, "(define SIAGHOME \"%s\")", siaghome);
        execute(b);
        sprintf(b, "(define SIAGHELP \"%s\")", siaghelp);
        execute(b);

        /* now load runtime library */
        sprintf(b, "(load \"%s/siag/siag.scm\")", siaghome);
        execute(b);

        /* load user customizations, if any */
        if (!stat(siagrc, &statbuf)) {
                sprintf(b, "(load \"%s\")", siagrc);
                execute(b);
        }

        fileio_init();
        for (i = 1; i < argc; i++) {
                if (argv[i][0] != '-') {

                        strncpy(path, argv[i], 1020);
                        buf = new_buffer(buffer_name(argv[i]), path);
                        /* make it less clueless */
                        loadmatrix(path, buf, guess_file_format(path));

                        calc_matrix(buf);
                        buf->change = FALSE;
                        w_list->buf = buf;
                }
        }
        pr_scr_flag = TRUE;

        /* this works, for reasons beyond my comprehension */
TRACEME((f, "main: %s","Print the version"));
        execute("(print-version)");
TRACEME((f, "main: %s","Print the version"));
        execute("(print-version)");
TRACEME((f, "main: %s","activate the first window"));
        activate_window(w_list);

        signal(SIGCHLD, waitforchild);

        /* we now have "valuable" data, so need for a better handler */
        cmalloc_init(malloc_fail_handler);

#ifdef TCL
        Tcl_Main(argc, argv, Tcl_AppInit);
#else
TRACEME((f, "main: %s","start main loop"));
        mainloop();
#endif
}

int main(int argc, char **argv)
{
#ifdef GUILE
        gh_enter(argc, argv, realmain);
#else
        realmain(argc, argv);
#endif
        return 0;
}

