/*
 * Copyright (c) 1994, 1995 Vectaport Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of the copyright holders not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The copyright holders make
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 */

#ifndef framecmds_h
#define framecmds_h

#include <OverlayUnidraw/ovcmds.h>

#include <Unidraw/Commands/command.h>
#include <Unidraw/Commands/datas.h>
#include <Unidraw/Commands/edit.h>
#include <Unidraw/Commands/macro.h>
#include <Unidraw/Commands/struct.h>

class CreateFrameCmd : public Command {
public:
    CreateFrameCmd(ControlInfo*, boolean after = true);
    CreateFrameCmd(Editor* =nil, boolean after = true);
    boolean After() { return _after; }

    virtual void Execute();
    virtual void Unexecute();
    virtual boolean Reversible();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
    virtual Command* Copy();
protected:
    boolean _after;
};

class DeleteFrameData : public VoidData {
public:
    DeleteFrameData(void*, boolean restore_after);
    boolean RestoreAfter() { return _after; }

protected:
    boolean _after;
};

class DeleteFrameCmd : public Command {
public:
    DeleteFrameCmd(ControlInfo*);
    DeleteFrameCmd(Editor* = nil);

    virtual void Execute();
    virtual void Unexecute();
    virtual boolean Reversible();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
    virtual Command* Copy();
};

class MoveFrameCmd : public Command {
public:
    MoveFrameCmd(ControlInfo*, int motion = +1, boolean allowbg = true);
    MoveFrameCmd(Editor* =nil, int motion = +1, boolean allowbg = true);

    virtual void Execute();
    virtual void Unexecute();
    virtual boolean Reversible();
    virtual void Log();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
    virtual Command* Copy();

  boolean AllowBg() { return _allowbg; }
  void AllowBg(boolean abg) { _allowbg = abg; }
protected:
    int _motion, _actual;
  boolean _allowbg;
};

class FrameBeginCmd : public MoveFrameCmd {
public:
    FrameBeginCmd(ControlInfo*);
    FrameBeginCmd(Editor* =nil);

    virtual void Execute();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
    virtual Command* Copy();
};

class FrameEndCmd : public MoveFrameCmd {
public:
    FrameEndCmd(ControlInfo*);
    FrameEndCmd(Editor* =nil);

    virtual void Execute();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
    virtual Command* Copy();
};

class CreateMoveFrameCmd : public MacroCmd {
public:
    CreateMoveFrameCmd(ControlInfo*, boolean after = true);
    CreateMoveFrameCmd(Editor* = nil, boolean after = true);
    boolean After() { return _after; }

    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
    virtual Command* Copy();
protected:
    boolean _after;
};

class CopyMoveFrameCmd : public MacroCmd {
public:
    CopyMoveFrameCmd(ControlInfo*, boolean after = true);
    CopyMoveFrameCmd(Editor* = nil, boolean after = true);

    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
    virtual Command* Copy();
    virtual void Execute();
protected:
    boolean _after;
};

class FrameGroupCmd : public OvGroupCmd {
public:
    FrameGroupCmd(ControlInfo*, OverlayComp* dest = nil);
    FrameGroupCmd(Editor* = nil, OverlayComp* dest = nil);

    virtual void Execute ();
    virtual OverlaysComp* MakeOverlaysComp();

    virtual Command* Copy();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
};


class FrameUngroupCmd : public UngroupCmd {
public:
    FrameUngroupCmd(ControlInfo*);
    FrameUngroupCmd(Editor* = nil);
    virtual ~FrameUngroupCmd();

    virtual void Execute();

    virtual Command* Copy();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
};

class FrameFrontCmd : public FrontCmd {
public:
    FrameFrontCmd(ControlInfo*);
    FrameFrontCmd(Editor* = nil);

    virtual void Execute();

    virtual Command* Copy();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
};

class FrameBackCmd : public BackCmd {
public:
    FrameBackCmd(ControlInfo*);
    FrameBackCmd(Editor* = nil);

    virtual void Execute();

    virtual Command* Copy();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
};
 
class FrameCopyCmd : public CopyCmd {
public:
    FrameCopyCmd(ControlInfo*, Clipboard* = nil);
    FrameCopyCmd(Editor* = nil, Clipboard* = nil);

    virtual void Execute();

    virtual Command* Copy();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
};

class FrameNewViewCmd : public OvNewViewCmd {
public:
    FrameNewViewCmd(ControlInfo*);
    FrameNewViewCmd(Editor* = nil);

    virtual void Execute();

    virtual Command* Copy();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
};

class ShowOtherFrameCmd : public Command {
public:
    ShowOtherFrameCmd(ControlInfo*, int offset = -1);
    ShowOtherFrameCmd(Editor* =nil, int offset = -1);

    virtual void Execute();
    virtual void Unexecute();
    virtual boolean Reversible();
    virtual void Log();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);
    virtual Command* Copy();

protected:
    int _offset;
    int _old_offset;
};

#endif
