/*
 * Copyright (c) 1993 Branko Lankester <branko@hacktic.nl>
 * Copyright (c) 1993, 1994 Rick Sladkey <jrs@world.std.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Paul Kranenburg,
 *      Branko Lankester and Rick Sladkey.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *	syscallent.h,v 2.18 1994/03/12 23:12:16 jrs Exp
 */

	{ 0,	sys_setup,		"setup"		},	/* 0 */
	{ 1,	sys_exit,		"_exit"		},	/* 1 */
	{ 0,	sys_fork,		"fork"		},	/* 2 */
	{ 3,	sys_read,		"read"		},	/* 3 */
	{ 3,	sys_write,		"write"		},	/* 4 */
	{ 3,	sys_open,		"open"		},	/* 5 */
	{ 1,	sys_close,		"close"		},	/* 6 */
	{ 3,	sys_waitpid,		"waitpid"	},	/* 7 */
	{ 2,	sys_creat,		"creat"		},	/* 8 */
	{ 2,	sys_link,		"link"		},	/* 9 */
	{ 1,	sys_unlink,		"unlink"	},	/* 10 */
	{ 3,	sys_execve,		"execve"	},	/* 11 */
	{ 1,	sys_chdir,		"chdir"		},	/* 12 */
	{ 1,	sys_time,		"time"		},	/* 13 */
	{ 3,	sys_mknod,		"mknod"		},	/* 14 */
	{ 2,	sys_chmod,		"chmod"		},	/* 15 */
	{ 3,	sys_chown,		"chown"		},	/* 16 */
	{ 0,	sys_break,		"break"		},	/* 17 */
	{ 2,	sys_oldstat,		"oldstat"	},	/* 18 */
	{ 3,	sys_lseek,		"lseek"		},	/* 19 */
	{ 0,	sys_getpid,		"getpid"	},	/* 20 */
	{ 5,	sys_mount,		"mount"		},	/* 21 */
	{ 1,	sys_umount,		"umount"	},	/* 22 */
	{ 1,	sys_setuid,		"setuid"	},	/* 23 */
	{ 0,	sys_getuid,		"getuid"	},	/* 24 */
	{ 1,	sys_stime,		"stime"		},	/* 25 */
	{ 4,	sys_ptrace,		"ptrace"	},	/* 26 */
	{ 1,	sys_alarm,		"alarm"		},	/* 27 */
	{ 2,	sys_oldfstat,		"oldfstat"	},	/* 28 */
	{ 0,	sys_pause,		"pause"		},	/* 29 */
	{ 2,	sys_utime,		"utime"		},	/* 30 */
	{ 2,	sys_stty,		"stty"		},	/* 31 */
	{ 2,	sys_gtty,		"gtty"		},	/* 32 */
	{ 2,	sys_access,		"access"	},	/* 33 */
	{ 1,	sys_nice,		"nice"		},	/* 34 */
	{ 0,	sys_ftime,		"ftime"		},	/* 35 */
	{ 0,	sys_sync,		"sync"		},	/* 36 */
	{ 2,	sys_kill,		"kill"		},	/* 37 */
	{ 2,	sys_rename,		"rename"	},	/* 38 */
	{ 2,	sys_mkdir,		"mkdir"		},	/* 39 */
	{ 1,	sys_rmdir,		"rmdir"		},	/* 40 */
	{ 1,	sys_dup,		"dup"		},	/* 41 */
	{ 1,	sys_pipe,		"pipe"		},	/* 42 */
	{ 1,	sys_times,		"times"		},	/* 43 */
	{ 0,	sys_prof,		"prof"		},	/* 44 */
	{ 1,	sys_brk,		"brk"		},	/* 45 */
	{ 1,	sys_setgid,		"setgid"	},	/* 46 */
	{ 0,	sys_getgid,		"getgid"	},	/* 47 */
	{ 3,	sys_signal,		"signal"	},	/* 48 */
	{ 0,	sys_geteuid,		"geteuid"	},	/* 49 */
	{ 0,	sys_getegid,		"getegid"	},	/* 50 */
	{ 1,	sys_acct,		"acct"		},	/* 51 */
	{ 0,	sys_phys,		"phys"		},	/* 52 */
	{ 0,	sys_lock,		"lock"		},	/* 53 */
	{ 3,	sys_ioctl,		"ioctl"		},	/* 54 */
	{ 3,	sys_fcntl,		"fcntl"		},	/* 55 */
	{ 0,	sys_mpx,		"mpx"		},	/* 56 */
	{ 2,	sys_setpgid,		"setpgid"	},	/* 57 */
	{ 2,	sys_ulimit,		"ulimit"	},	/* 58 */
	{ 1,	sys_oldolduname,	"oldolduname"	},	/* 59 */
	{ 1,	sys_umask,		"umask"		},	/* 60 */
	{ 1,	sys_chroot,		"chroot"	},	/* 61 */
	{ 2,	sys_ustat,		"ustat"		},	/* 62 */
	{ 2,	sys_dup2,		"dup2"		},	/* 63 */
	{ 0,	sys_getppid,		"getppid"	},	/* 64 */
	{ 0,	sys_getpgrp,		"getpgrp"	},	/* 65 */
	{ 0,	sys_setsid,		"setsid"	},	/* 66 */
	{ 3,	sys_sigaction,		"sigaction"	},	/* 67 */
	{ 0,	sys_siggetmask,		"siggetmask"	},	/* 68 */
	{ 1,	sys_sigsetmask,		"sigsetmask"	},	/* 69 */
	{ 2,	sys_setreuid,		"setreuid"	},	/* 70 */
	{ 2,	sys_setregid,		"setregid"	},	/* 71 */
	{ 3,	sys_sigsuspend,		"sigsuspend"	},	/* 72 */
	{ 1,	sys_sigpending,		"sigpending"	},	/* 73 */
	{ 2,	sys_sethostname,	"sethostname"	},	/* 74 */
	{ 2,	sys_setrlimit,		"setrlimit"	},	/* 75 */
	{ 2,	sys_getrlimit,		"getrlimit"	},	/* 76 */
	{ 2,	sys_getrusage,		"getrusage"	},	/* 77 */
	{ 2,	sys_gettimeofday,	"gettimeofday"	},	/* 78 */
	{ 2,	sys_settimeofday,	"settimeofday"	},	/* 79 */
	{ 2,	sys_getgroups,		"getgroups"	},	/* 80 */
	{ 2,	sys_setgroups,		"setgroups"	},	/* 81 */
	{ 1,	sys_select,		"select"	},	/* 82 */
	{ 2,	sys_symlink,		"symlink"	},	/* 83 */
	{ 2,	sys_oldlstat,		"oldlstat"	},	/* 84 */
	{ 3,	sys_readlink,		"readlink"	},	/* 85 */
	{ 1,	sys_uselib,		"uselib"	},	/* 86 */
	{ 1,	sys_swapon,		"swapon"	},	/* 87 */
	{ 3,	sys_reboot,		"reboot"	},	/* 88 */
	{ 3,	sys_readdir,		"readdir"	},	/* 89 */
	{ 1,	sys_mmap,		"mmap"		},	/* 90 */
	{ 2,	sys_munmap,		"munmap"	},	/* 91 */
	{ 2,	sys_truncate,		"truncate"	},	/* 92 */
	{ 2,	sys_ftruncate,		"ftruncate"	},	/* 93 */
	{ 2,	sys_fchmod,		"fchmod"	},	/* 94 */
	{ 3,	sys_fchown,		"fchown"	},	/* 95 */
	{ 2,	sys_getpriority,	"getpriority"	},	/* 96 */
	{ 3,	sys_setpriority,	"setpriority"	},	/* 97 */
	{ 4,	sys_profil,		"profil"	},	/* 98 */
	{ 2,	sys_statfs,		"statfs"	},	/* 99 */
	{ 2,	sys_fstatfs,		"fstatfs"	},	/* 100 */
	{ 3,	sys_ioperm,		"ioperm"	},	/* 101 */
	{ 2,	sys_socketcall,		"socketcall"	},	/* 102 */
	{ 3,	sys_syslog,		"syslog"	},	/* 103 */
	{ 3,	sys_setitimer,		"setitimer"	},	/* 104 */
	{ 2,	sys_getitimer,		"getitimer"	},	/* 105 */
	{ 2,	sys_stat,		"stat"		},	/* 106 */
	{ 2,	sys_lstat,		"lstat"		},	/* 107 */
	{ 2,	sys_fstat,		"fstat"		},	/* 108 */
	{ 1,	sys_olduname,		"olduname"	},	/* 109 */
	{ 1,	sys_iopl,		"iopl"		},	/* 110 */
	{ 0,	sys_vhangup,		"vhangup"	},	/* 111 */
	{ 0,	sys_idle,		"idle"		},	/* 112 */
	{ 1,	sys_vm86,		"vm86"		},	/* 113 */
	{ 4,	sys_wait4,		"wait4"		},	/* 114 */
	{ 1,	sys_swapoff,		"swapoff"	},	/* 115 */
	{ 1,	sys_sysinfo,		"sysinfo"	},	/* 116 */
	{ 5,	sys_ipc,		"ipc"		},	/* 117 */
	{ 1,	sys_fsync,		"fsync"		},	/* 118 */
	{ 1,	sys_sigreturn,		"sigreturn"	},	/* 119 */
	{ 2,	sys_clone,		"clone"		},	/* 120 */
	{ 2,	sys_setdomainname,	"setdomainname"	},	/* 121 */
	{ 1,	sys_uname,		"uname"		},	/* 122 */
	{ 3,	sys_modify_ldt,		"modify_ldt"	},	/* 123 */
	{ 1,	sys_adjtimex,		"adjtimex"	},	/* 124 */
	{ 3,	sys_mprotect,		"mprotect"	},	/* 125 */
	{ 3,	sys_sigprocmask,	"sigprocmask"	},	/* 126 */
	{ 2,	sys_create_module,	"create_module"	},	/* 127 */
	{ 4,	sys_init_module,	"init_module"	},	/* 128 */
	{ 1,	sys_delete_module,	"delete_module"	},	/* 129 */
	{ 1,	sys_get_kernel_syms,	"get_kernel_syms"},	/* 130 */
	{ 4,	sys_quotactl,		"quotactl"	},	/* 131 */
	{ 1,	sys_getpgid,		"getpgid"	},	/* 132 */
	{ 1,	sys_fchdir,		"fchdir"	},	/* 133 */
	{ 0,	sys_bdflush,		"bdflush"	},	/* 134 */

    {-1,    sys_sysfs,              "sysfs"         },      /* 135 */
    { 1,    sys_personality,        "personality"   },      /* 136 */
    {-1,    sys_afs_syscall,        "afs_syscall"   },      /* 137 */
    { 1,    sys_setfsuid,           "setfsuid"      },      /* 138 */
    { 1,    sys_setfsgid,           "setfsgid"      },      /* 139 */
    { 3,    sys__llseek,            "_llseek"       },      /* 140 */
    { 3,    sys_getdents,           "getdents"      },      /* 141 */
    {-1,    sys__newselect,         "_newselect"    },      /* 142 */
    { 2,    sys_flock,              "flock"         },      /* 143 */
    {-1,    sys_syscall_flock,      "syscall_flock" },      /* 143 */
    { 3,    sys_msync,              "msync"         },      /* 144 */
    { 3,    sys_readv,              "readv"         },      /* 145 */
    {-1,    sys_syscall_readv,      "syscall_"      },      /* 145 */
    { 3,    sys_writev,             "writev"        },      /* 146 */
    {-1,    sys_syscall_writev,     "syscall_writev"},      /* 146 */
    { 1,    sys_getsid,             "getsid"        },      /* 147 */

	{ 5,	printargs,		"SYS_148"	},	/* 148 */
	{ 5,	printargs,		"SYS_149"	},	/* 149 */

	{ 8,	printargs,		"socket_subcall"},	/* 150 */
	{ 3,	sys_socket,		"socket"	},	/* 151 */
	{ 3,	sys_bind,		"bind"		},	/* 152 */
	{ 3,	sys_connect,		"connect"	},	/* 153 */
	{ 2,	sys_listen,		"listen"	},	/* 154 */
	{ 3,	sys_accept,		"accept"	},	/* 155 */
	{ 3,	sys_getsockname,	"getsockname"	},	/* 156 */
	{ 3,	sys_getpeername,	"getpeername"	},	/* 157 */
	{ 4,	sys_socketpair,		"socketpair"	},	/* 158 */
	{ 4,	sys_send,		"send"		},	/* 159 */
	{ 4,	sys_recv,		"recv"		},	/* 160 */
	{ 6,	sys_sendto,		"sendto"	},	/* 161 */
	{ 6,	sys_recvfrom,		"recvfrom"	},	/* 162 */
	{ 2,	sys_shutdown,		"shutdown"	},	/* 163 */
	{ 5,	sys_setsockopt,		"setsockopt"	},	/* 164 */
	{ 5,	sys_getsockopt,		"getsockopt"	},	/* 165 */
	{ 5,	printargs,		"SYS_166"	},	/* 166 */
	{ 5,	printargs,		"SYS_167"	},	/* 167 */
	{ 5,	printargs,		"SYS_168"	},	/* 168 */
	{ 5,	printargs,		"SYS_169"	},	/* 169 */

	{ 4,	printargs,		"ipc_subcall"	},	/* 170 */
	{ 4,	printargs,		"semop"		},	/* 171 */
	{ 4,	sys_semget,		"semget"	},	/* 172 */
	{ 4,	sys_semctl,		"semctl"	},	/* 173 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 174 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 175 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 176 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 177 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 178 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 179 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 180 */
	{ 4,	sys_msgsnd,		"msgsnd"	},	/* 181 */
	{ 4,	sys_msgrcv,		"msgrcv"	},	/* 182 */
	{ 4,	sys_msgget,		"msgget"	},	/* 183 */
	{ 4,	sys_msgctl,		"msgctl"	},	/* 184 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 185 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 186 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 187 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 188 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 189 */
	{ 4,	printargs,		"ipc_subcall"	},	/* 190 */
	{ 4,	sys_shmat,		"shmat"		},	/* 191 */
	{ 4,	sys_shmdt,		"shmdt"		},	/* 192 */
	{ 4,	sys_shmget,		"shmget"	},	/* 193 */
	{ 4,	sys_shmctl,		"shmctl"	},	/* 194 */
	{ 5,	printargs,		"SYS_195"	},	/* 195 */
	{ 5,	printargs,		"SYS_196"	},	/* 196 */
	{ 5,	printargs,		"SYS_197"	},	/* 197 */
	{ 5,	printargs,		"SYS_198"	},	/* 198 */
	{ 5,	printargs,		"SYS_199"	},	/* 199 */
