/*
 *
 *	Routines standard de creation de sockets cote client.
 *
 *	Permet de creer des socket tcp sur un  service donne).
 *
 *      Auteur : Ronan KERYELL (Ecole Normale Superieure  /  Paris)
 *               keryell@ens.fr
 */
static char rcsid[] = "$Id: inet.c,v 1.1 1994/08/30 15:58:39 pierre Exp $";

#ifndef NO_NETWORK

#include <sys/types.h>
#define _TYPE
#include <sys/socket.h>
#include <netinet/in.h>
#if sgi
#include <bsd/netdb.h>
#else
#include <netdb.h>
#endif sgi
#include <stdio.h>

#if defined(SVR4) || defined(hpux)
#define bcopy(src,dest,len) (memcpy(dest,src,len))
#endif
 
#ifndef u_short
#define u_short ushort
#endif u_short

/*
 *
 *	Cree une socket vers un hote donne, sur un service donne,
 *
 *	Ex : sock = c_clientbyname("aneth","courier")
 *
 *	Renvoie comme resultat :
 *		- dans le cas tcp : la socket prete a l'emploie (sur laquelle on
 *							peut faire des read ou des write).
 *
 */

c_clientbyname(host,name)
char *host,*name;
{
	int sock;
	struct sockaddr_in addr;
	struct servent *sv;
	struct hostent *hp;
	/* Recupere l'adresse de l'hote cible */
	if (!(hp = gethostbyname(host))){
		perror("gethostbyname");
		return (-1);
	}
	/* Description du service recherche (essentiellement, le numero de port) */
	if (!(sv = getservbyname(name,"tcp"))){
		perror("getservbyname");
		return(-1);
	}
	/* Et on cree la socket */
	if ((sock = socket(AF_INET, SOCK_STREAM,0)) == -1){
		perror("socket");
		return (-1);
	}
	/* Preparons l'adresse pour le connect */
	/* Le type d'adresse */
	/* la macro htons est un peut bidon : elle est la pour assurer */
	/* la compatibilite avec le vax qui inverse les bits entre le local */
	/* et ethernet .... */
	addr.sin_family = hp->h_addrtype;
	/* Le port (recupere dans le getservbyname) */
	addr.sin_port = sv->s_port;
	/* L'adresse de l'hote cible */
	bcopy(hp->h_addr, (caddr_t)&addr.sin_addr, hp->h_length);

	/* Et zoup : on se connecte */
	if ( connect(sock,(struct sockaddr *)&addr, sizeof(addr)) == -1){
		perror("connect");
		return (-1);
	}
	/* Ok ! : on a une socket en tcp de bon gout */
	return (sock);
}

#endif /* NO_NETWORK */
