/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  load.h
 * Purpose: Definitions for the boot image loader
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Image file header. This header has to have the same size as a TFTP
 * block.
 */
struct imghdr
{
	unsigned long	 ih_magic1;	/* Header magic ID 1		*/
	unsigned long	 ih_flags;	/* Header flags			*/
	void far	*ih_locn;	/* Pointer to this header	*/
	void far	*ih_execute;	/* Execute address		*/
	unsigned char	 ih_dummy[494];	/* Fill up to SEGSIZE		*/
	unsigned short	 ih_magic2;	/* Header magic ID 2		*/
};

#define IH_MAGIC1	0x1b031336L		/* First magic number	*/
#define IH_MAGIC2	0xaa55			/* Second magic number	*/
#define IH_HDRLEN(a)	((unsigned int)((a) & 0x0fL) << 2)
#define IH_VENDLEN(a)	((unsigned int)((a) & 0xf0L) >> 2)



/*
 **************************************************************************
 *
 * Load record header
 */
struct loadrec {
	unsigned long	lr_flags;	/* Flags and record length	*/
	unsigned long	lr_addr;	/* Linear address to put record	*/
	unsigned long	lr_ilen;	/* Image length			*/
	unsigned long	lr_mlen;	/* Memory length		*/
};

#define LR_IS_B0(a)	((a) & 0x01000000L)
#define LR_IS_B1(a)	((a) & 0x02000000L)
#define LR_IS_EOF(a)	((a) & 0x04000000L)	  /* Marks last record	*/
#define LR_HDRLEN(a)	((unsigned int)((a) & 0x0fL) << 2)
#define LR_VENDLEN(a)	((unsigned int)((a) & 0xf0L) >> 2)



/*
 **************************************************************************
 *
 * Pointer to load area for DOS boot block (needed for mode 1):
 */
#define BOOTBLOCK	(MK_FP(0, 0x7c00))



/*
 **************************************************************************
 *
 * Functions in boot image loader module:
 */

/* Get the boot image from the server and execute it */
extern void load(struct bootp *bp);

