/* window.h -- the data structures and function prototypes used by window.c. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifndef _GIT_WINDOW_H
#define _GIT_WINDOW_H


#include <sys/types.h>

#include "stdc.h"


typedef struct
{
    size_t lines, columns;
    size_t x, y;
    size_t cursorx, cursory;
} window_t;


extern window_t *window_init __P((size_t, size_t, size_t, size_t));
extern void      window_end __P((window_t *));
extern void      window_resize __P((window_t *,size_t,size_t,size_t,size_t));
extern size_t    window_write __P((char *, size_t));
extern size_t    window_putch __P((char));
extern void      window_cursormove_notify __P((window_t *, size_t, size_t));
extern void      window_cursormove __P((window_t *, size_t, size_t));


#endif  /* _GIT_WINDOW_H */
