#! /bin/bash
#
# Make the system bootable.

cat << EOF
In order to use the new kernel image you have just installed, you
will need to reboot the machine.  Before you can reboot the machine,
however, you will need to either make a bootable floppy diskette or
re-run LILO.

EOF

echo -n "Do you want to make the system bootable now (y/n)? "

read INPUT

if [ $INPUT = "y" ]
then
  if [ ! -f /etc/lilo.conf -a -x /sbin/lilo ]
  then
	echo "You don't have LILO installed, you'll have to use a floppy."
  else
    echo
    until [ "$input" = "y" -o "$input" = "n" ]
    do
      echo -n "LILO appears to be installed.  Should I run /sbin/lilo (y/n)? "
      read input
      if [ "$input" != "y" -a "$input" != "n" ]
      then
        echo
        echo "Please answer \`y' or \`n'."
        echo
      fi
    done
    if [ $input = "y" ]
    then
      echo
      /sbin/lilo
      echo
      echo "Now you may reboot your system from the hard drive."
      exit 0
    else
      echo
      echo "Okay."
      echo
    fi
  fi

  dd_ok="n" ; dd_quit="n"
  until [ "$dd_ok" = "y" -o "$dd_quit" = "y" ]
  do
    echo -n \
     "Please insert a floppy diskette into your boot drive and press <RETURN>: "
    read input
    echo
    echo "Creating a bootdisk..."
    # Kludge to avoid a bug: the kernel won't read the write-protect switch
	# when a floppy is changed after ioctl FDFLUSH. Reading the floppy forces
	# the switch to be read.
	dd if=/dev/fd0 of=/dev/null bs=1 count=1 2>/dev/null

    dd if=/vmlinuz of=/dev/fd0
    if [ $? -eq 0 ]
    then
      dd_ok="y"
    else
      echo "WARNING: There was a problem creating the boot diskette. Please"
      echo "make sure that you inserted the diskette into the correct drive"
      echo "and that the diskette is not write-protected."
      echo
      echo -n "Would you like to try again (y/n)? "
      read bootdisk
      if [ "$bootdisk" != "y" ]
      then
        dd_quit="y"
      fi
    fi
    rdev /dev/fd0 `rdev | cut -d ' ' -f 1`
	rdev -R /dev/fd0 1
    echo
  done
  if [ "$dd_ok" = "y" ]
  then
    echo "Done."
    echo
    echo "Now you may reboot your system from the floppy diskette."
    exit 0
  else
    echo "There was a problem.  To create a bootdisk from the shell:"
    echo
    echo "   # dd if=/vmlinuz of=/dev/fd0"
    echo
    exit 1
  fi 2> /dev/null
else
  echo
  echo "Okay.  When you want to do this, run \`mkboot'."
  exit 0
fi 2>/dev/null
