<?php
/**
 * Hungarian Language file
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2005  István Pető and Gábor Hrotkó
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * @author István Pető
 * @author Gábor Hrotkó
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: lang.hu.php,v 1.18.2.8 2006/05/03 02:29:24 canajun2eh Exp $
 */
if (preg_match("/lang\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
	print "You cannot access a language file directly.";
	exit;
}


  	 
//-- GENERAL HELP MESSAGES
$pgv_lang["qm"]				= "?";
$pgv_lang["qm_ah"]			= "?";
$pgv_lang["page_help"]			= "Segítség";
$pgv_lang["help_for_this_page"]		= "Segítség ehhez az oldalhoz";
$pgv_lang["help_contents"]		= "A Segítség tartalomjegyzéke";
$pgv_lang["show_context_help"]		= "Környezetérzékeny segítség megjelenítése";
$pgv_lang["hide_context_help"]		= "Környezetérzékeny segítség elrejtése";
$pgv_lang["sorry"]			= "<b>Elnézést kérünk, de ennek az oldalnak a Segítsége még nem készült el.</b>";
$pgv_lang["help_not_exist"]		= "<b>Ennek az oldalnak vagy elemnek még nincsen Segítsége.</b>";
$pgv_lang["var_not_exist"]			= "<span style=font-weight: bold>A nyelvi szöveg nem létezik. Kérem jelentse ezt be mint hiba.</span>";
$pgv_lang["resolution"]			= "Képernyő-felbontás";
$pgv_lang["menu"]			= "Menü";
$pgv_lang["header"]			= "Fejléc";
$pgv_lang["imageview"]          	= "Képnéző";

//-- CONFIG FILE MESSAGES
$pgv_lang["login_head"]                 = "Belépés a PhpGedView felhasználóinak";
$pgv_lang["error_title"]		= "HIBA: A GEDCOM file nem nyitható meg";
$pgv_lang["error_header"] 		= "A <b>#GEDCOM#</b> nevű GEDCOM-állomány a megadott helyen nem érhető el.";
$pgv_lang["error_header_write"] 	= "A <b>#GEDCOM#</b> nevű GEDCOM-állomány nem írható. Kérjük, ellenőrizze a tulajdonságait és jogosultságait.";
$pgv_lang["for_support"]		= "Technikai jellegű segítség:";
$pgv_lang["for_contact"]		= "Genealógiai jellegű segítség:";
$pgv_lang["for_all_contact"]		= "Technikai és genealógiai jellegű segítség";
$pgv_lang["build_title"]		= "Index állományok létrehozása";
$pgv_lang["build_error"]		= "A rendszer új GEDCOM állományt észlelt.";
$pgv_lang["please_wait"]		= "Kérem, várjon, az index állományokat frissíteni kell.";
$pgv_lang["choose_gedcom"]		= "Válasszon egy GEDCOM-adattömböt";
$pgv_lang["username"]			= "Felhasználói név";
$pgv_lang["invalid_username"]		= "A felhaszánlónév érvénytelen karaktereket tartalmaz";
$pgv_lang["lastname"]				= "Vezetéknév";
$pgv_lang["firstname"]				= "Keresztnév";
$pgv_lang["password"]			= "Jelszó";
$pgv_lang["confirm"]			= "Jelszó mégegyszer";
$pgv_lang["user_contact_method"]	= "Kapcsolattartási mód";
$pgv_lang["login"]			= "Belépés";
$pgv_lang["login_aut"]			= "Felhasználó szerkesztése";
$pgv_lang["logout"]			= "Kilépés";
$pgv_lang["admin"]			= "Adminisztráció";
$pgv_lang["logged_in_as"]		= "Bejelentkezve mint";
$pgv_lang["my_pedigree"]		= "Családfám";
$pgv_lang["my_indi"]			= "Saját Személyes Adataim";
$pgv_lang["no"]				= "Nem";
$pgv_lang["yes"]			= "Igen";
$pgv_lang["add_gedcom"]			= "Új GEDCOM-állomány hozzáadása";
$pgv_lang["change_theme"]               = "Asztaltéma-váltás";
$pgv_lang["gedcom_downloadable"]        = "Ez a GEDCOM-állomány letölthető az interneten kerszetül.<br/>Kérjük, tekintse át a <a href=\"readme.txt\"><b>readme.txt</b></a> SECURITY (BIZTONSÁG) fejezetét a probléma megszüntetéséhez.";

//-- INDEX (PEDIGREE_TREE) FILE MESSAGES
$pgv_lang["index_header"]		= "Ősfa";
$pgv_lang["gen_ped_chart"]		= "ősei #PEDIGREE_GENERATIONS# generációra visszamenőleg";
$pgv_lang["generations"]		= "Generációk száma";
$pgv_lang["view"]			= "Mutat";
$pgv_lang["fam_spouse"]			= "Családtagok házastárssal";
$pgv_lang["root_person"]		= "Kezdő személy azonosítója";
$pgv_lang["hide_details"]		= "Részletek elrejtése";
$pgv_lang["show_details"]		= "Részletek mutatása";
$pgv_lang["person_links"]		= "Hivatkozások ennek a személynek grafikonjaira, a családjára és közeli hozzátartozóira. Klikkeljen erre az ikonra ahhoz, hogy az oldal ezzel a személlyel kezdődjön.";
$pgv_lang["zoom_box"]			= "Doboz kicsinyítése/nagyítása.";
$pgv_lang["orientation"]			= "Orientáció";
$pgv_lang["portrait"]			= "Álló";
$pgv_lang["landscape"]			= "Fekvő";
$pgv_lang["start_at_parents"]		= "Kezdjük a szülőknél";
$pgv_lang["charts"]			= "Grafikonok";
$pgv_lang["lists"]			= "Listák";
$pgv_lang["welcome_page"]		= "Nyitóoldal";
$pgv_lang["max_generation"]		= "A családfa generációk maximális száma #PEDIGREE_GENERATIONS#.";
$pgv_lang["min_generation"]		= "A családfa generációk minimális száma 3.";
$pgv_lang["box_width"]			= "Dobozszélesség";

//-- FUNCTIONS FILE MESSAGES
$pgv_lang["unable_to_find_family"]	= "Nem található ilyen azonosítójú család";
$pgv_lang["unable_to_find_indi"]	= "Nem található ilyen azonosítójú személy";
$pgv_lang["unable_to_find_record"]	= "Nem található ilyen azonosítójú rekord";
$pgv_lang["unable_to_find_source"]	= "Nem található ilyen azonosítójú forrás";
$pgv_lang["unable_to_find_repo"]	= "Nem található ilyen azonosítójú tároló";
$pgv_lang["repo_name"]			= "Nyilvántartó szervezet:";
$pgv_lang["address"]			= "Cím:";
$pgv_lang["phone"]			= "Telefon:";
$pgv_lang["source_name"]		= "A forrás neve:";
$pgv_lang["title"]			= "Cím:";
$pgv_lang["author"]			= "Szerző:";
$pgv_lang["publication"]		= "Publikáció:";
$pgv_lang["call_number"]		= "Hívószám:";
$pgv_lang["living"]			= "Életben van";
$pgv_lang["private"]			= "Bizalmas";
$pgv_lang["birth"]			= "Született:";
$pgv_lang["death"]			= "Elhunyt:";
$pgv_lang["descend_chart"]		= "Leszármazottak";
$pgv_lang["individual_list"]		= "Személyek listája";
$pgv_lang["family_list"]		= "Családok listája";
$pgv_lang["source_list"]		= "Forráslista";
$pgv_lang["place_list"]			= "Helyszínek hierarchiája";
$pgv_lang["place_list_aft"]             = "Helyszínek hierarchiája után";
$pgv_lang["media_list"]			= "Multimédia lista";
$pgv_lang["search"]			= "Keresés";
$pgv_lang["clippings_cart"]		= "Családfa Metszési Kosara";
$pgv_lang["print_preview"]		= "Nyomtatható változat";
$pgv_lang["cancel_preview"]		= "Vissza a normál nézethez";
$pgv_lang["change_lang"]		= "Nyelvválasztás";
$pgv_lang["print"]			= "Nyomtatás";
$pgv_lang["total_queries"]		= "Összes adatbázis-lekérdezés: ";
$pgv_lang["total_privacy_checks"]       = "Összes diszkréciós szabály: ";
$pgv_lang["back"]			= "Vissza";
$pgv_lang["privacy_list_indi_error"]	= "Diszkréciós beállítások miatt, egy vagy több személy rejtve marad.";
$pgv_lang["privacy_list_fam_error"]	= "Diszkréciós beállítások miatt, egy vagy több család rejtve marad.";

//-- INDIVUDUAL FILE MESSAGES
$pgv_lang["aka"]			= "Úgyis ismert mint";
$pgv_lang["male"]			= "Férfi";
$pgv_lang["female"]			= "Nő";
$pgv_lang["temple"]			= "UNSZ templom";
$pgv_lang["temple_code"]		= "UNSZ templom kódja:";
$pgv_lang["status"]			= "Státusz";
$pgv_lang["source"]			= "Forrás:";
$pgv_lang["citation"]			= "Hivatkozás:";
$pgv_lang["text"]			= "Forrás Szöveg: ";
$pgv_lang["note"]			= "Megjegyzés:";
$pgv_lang["NN"]				= "(ismeretlen)";
$pgv_lang["PN"]				= "(ismeretlen)";
$pgv_lang["unrecognized_code"]		= "Ismeretlen GEDCOM-kód";
$pgv_lang["unrecognized_code_msg"]	= "Ez egy programhiba, és szeretnénk kijavítani. Kérjük jelezze felénk a hibát:";
$pgv_lang["indi_info"]			= "Személyes adatok";
$pgv_lang["pedigree_chart"]		= "Ősfa";
$pgv_lang["individual"]				= "Személy";
$pgv_lang["family"]			= "Család";
$pgv_lang["family_with"]		= "Család (valakivel)";
$pgv_lang["as_spouse"]			= "Család a házastárssal";
$pgv_lang["as_child"]			= "Család a szülökkel";
$pgv_lang["view_gedcom"]		= "A GEDCOM-rekord megtekintése";
$pgv_lang["add_to_cart"]		= "Hozzáadás a Metszési Kosárhoz";
$pgv_lang["still_living_error"]		= "A személy jelenleg is életben van, illetve nincs hozzárendelt születési vagy halálozási adat.  Az élő személyek adatai nem nyilvánosak.<br/>További információt a kővetkező címen kérhet:";
$pgv_lang["privacy_error"]	    	= "A szemlély adatai bizalmas jellegűek.<br/>";
$pgv_lang["more_information"]		= "További információt itt kérhet:";
$pgv_lang["name"]			= "Név:";
$pgv_lang["given_name"]			= "Keresztnév:";
$pgv_lang["surname"]			= "Vezetéknév:";
$pgv_lang["suffix"]			= "Utótag:";
$pgv_lang["object_note"]		= "Megjegyzés:";
$pgv_lang["sex"]			= "Nem";
$pgv_lang["personal_facts"]		= "Személyes adatok";
$pgv_lang["type"]			= "Típus";
$pgv_lang["date"]			= "Dátum";
$pgv_lang["place_description"]		= "Hely / Leírás";
$pgv_lang["parents"] 			= "Szülők:";
$pgv_lang["siblings"] 			= "Testvér";
$pgv_lang["father"] 			= "Apa";
$pgv_lang["mother"] 			= "Anya";
$pgv_lang["parent"] 				= "Szülő";
$pgv_lang["relatives"]			= "Közeli családtagok";
$pgv_lang["relatives_events"]		= "Közeli családtagok eseményei";
$pgv_lang["child"]			= "Gyermek";
$pgv_lang["spouse"]			= "Házastárs";
$pgv_lang["surnames"]			= "Vezetéknevek";
$pgv_lang["adopted"]			= "Örökbefogadott";
$pgv_lang["foster"]			= "Nevelő";
$pgv_lang["sealing"]			= "Befogadás";
$pgv_lang["infant"]					= "Csecsemő";
$pgv_lang["link_as_husband"]		= "Ezt a személyt hozzákapcsolni egy létezö családhoz mint férj";
$pgv_lang["link_as_wife"]			= "Ezt a személyt hozzákapcsolni egy létezö családhoz mint feleség";
$pgv_lang["link_as_child"]			= "Ezt a személyt hozzákapcsolni egy létezö családhoz mint gyermek";
$pgv_lang["deceased"]				= "Elhúnyt";
$pgv_lang["stillborn"]				= "Halva született";
$pgv_lang["disproved"]				= "Nem elfogadott";
$pgv_lang["challenged"]				= "Rokkant";
$pgv_lang["no_tab1"]                    = "Ennek a személynek nincsen Tényei.";
$pgv_lang["no_tab2"]                    = "Ennek a személynek nincs Megjegyzései.";
$pgv_lang["no_tab3"]                    = "Ennek a személynek nincs Forrás-hivatkozásai.";
$pgv_lang["no_tab4"]                    = "Ennek a személynek nincs Multimédia-elemei.";
$pgv_lang["no_tab5"]                    = "Ennek a személynek nincs közeli rokonai.";
$pgv_lang["no_tab6"]				= "Ennek a személynek nincs Kutatási naplója.";

//-- FAMILY FILE MESSAGES
$pgv_lang["family_info"]		= "Család információ";
$pgv_lang["family_group_info"]		= "Információk erről a családról";
$pgv_lang["husband"]			= "Férj";
$pgv_lang["wife"]			= "Feleség";
$pgv_lang["marriage"]			= "Házasság:";
$pgv_lang["lds_sealing"]		= "UNSZ befogadás:";
$pgv_lang["marriage_license"]		= "Házassági anyakönyvi kivonat:";
$pgv_lang["media_object"]		= "Multimédia-elem:";
$pgv_lang["children"]			= "Gyerekek";
$pgv_lang["no_children"]		= "Nincsenek gyerekek rögzítve";
$pgv_lang["childless_family"]		= "Gyermektelen család";
$pgv_lang["number_children"]		= "Gyermekek száma: ";
$pgv_lang["parents_timeline"]		= "A házaspár mutatása a Kronológiában";

//-- CLIPPINGS FILE MESSAGES
$pgv_lang["clip_cart"]			= "Metszési kosár";
$pgv_lang["clip_explaination"]	= "A Családfa-ágak kosara lehetővé teszi, hogy a családfáról egyes ágakat lemetszen, és egy külőnálló GEDCOM állományba összekötve letöltse azt.<br/><br/>";
$pgv_lang["item_with_id"]		= "Elem ezzel az id-vel";
$pgv_lang["error_already"]		= "már szerepel a lemetszett ágakat tartalmazó kosárban.";
$pgv_lang["which_links"]		= "Melyik ágat szeretné ebből a családból szintén hozzáadni?";
$pgv_lang["just_family"]		= "Csak ennek a családnak a rekordját adjuk hozzá.";
$pgv_lang["parents_and_family"]		= "Szülők hozzáadása ezzel a családrekorddal.";
$pgv_lang["parents_and_child"]		= "Szülők és gyerekek hozzáadása ezzel a családrekorddal.";
$pgv_lang["parents_desc"]		= "Szülők, és az összes leszármazottak hozzáadása ezzel a családrekorddal.";
$pgv_lang["continue"]			= "Hozzáadás folytatása";
$pgv_lang["which_p_links"]		= "Melyik ágat szeretné ettől a személytől szintén hozzáadni?";
$pgv_lang["just_person"]		= "Csak ennek a személynek a hozzáadása.";
$pgv_lang["person_parents_sibs"]	= "Ennek a személynek, a szüleinek és a testvéreinek a hozzáadása.";
$pgv_lang["person_ancestors"]		= "Ennek a személynek és az egyenes ági felmenőinek a hozzáadása.";
$pgv_lang["person_ancestor_fams"]	= "Ennek a személnyek, az egyenes ágbi felmenőinek és azok családjainak hozzáadása.";
$pgv_lang["person_spouse"]		= "Ennek a személynek, a házastársának és a gyerekeinek a hozzáadása.";
$pgv_lang["person_desc"]		= "Ennek a személynek, a házastársának és az összes leszármazottjának a hozzáadása.";
$pgv_lang["unable_to_open"]		= "Nem sikerült írásra megnyitni a metszéshez használt mappát";
$pgv_lang["person_living"]		= "A személy jelenleg is életben van, így a személyes adatok nem férhetők hozzá.";
$pgv_lang["person_private"]		= "Ennek a személynek az adatai bizalmasak. A személyes adatok így nem lesznek csatolva.";
$pgv_lang["family_private"]		= "Ennek a családnak a további információ nem nyilvánosak. Ezek a családi részletek nem lesznek csatolva.";
$pgv_lang["download"]			= "Kattintson jobb-egérgombbal (control+kattintás Machintoson) az alábbi hivatkozáson, és válassza a &quot;Mentés másként&quot; menüpontot az állományok letöltéséhez.";
$pgv_lang["media_files"]		= "Ebben a GEDCOM-állományban az alábbi médiahivatkozások vannak";
$pgv_lang["cart_is_empty"]		= "Az Ön Metsző kosara üres.";
$pgv_lang["id"]				= "Azonosító";
$pgv_lang["name_description"]		= "Név / Leírás";
$pgv_lang["remove"]			= "Eltávolítás";
$pgv_lang["empty_cart"]			= "Üres kosár";
$pgv_lang["download_now"]		= "Letöltés";
$pgv_lang["indi_downloaded_from"]	= "Ez a személy innen lett letöltve:";
$pgv_lang["family_downloaded_from"]	= "Ez a család innen lett letöltve:";
$pgv_lang["source_downloaded_from"]	= "Ez a forrás innen lett letöltve:";

//-- PLACELIST FILE MESSAGES
$pgv_lang["connections"]		= "Helyszín-kapcsolatot találtunk";
$pgv_lang["top_level"]			= "Felső szint";
$pgv_lang["form"]			= "A helyek az alábbiak alapján rangsoroltak:";
$pgv_lang["default_form"]		= "város, megye, állam/tartomány, ország";
$pgv_lang["default_form_info"]		= "(Alapértelmezett)";
$pgv_lang["gedcom_form_info"]		= "(GEDCOM)";
$pgv_lang["unknown"]			= "ismeretlen";
$pgv_lang["individuals"]		= "Személyek";
$pgv_lang["view_records_in_place"]      = "Ehhez a helyhez kötődő rekordok";
$pgv_lang["place_list2"]                = "Helyszín-lista";
$pgv_lang["show_place_hierarchy"]       = "A helyszínek hierarchiában";
$pgv_lang["show_place_list"]            = "Az összes helyszín egy listában";
$pgv_lang["total_unic_places"]          = "Helyszínek száma";
	 
//-- MEDIALIST FILE MESSAGES
$pgv_lang["multi_title"]		= "Multimédia elemek listája";
$pgv_lang["media_found"]		= "média elem";
$pgv_lang["view_person"]		= "Személy megjelenítése";
$pgv_lang["view_family"]		= "Család megjelenítése";
$pgv_lang["view_source"]		= "Forrás megjelenítése";
$pgv_lang["view_object"]			= "Elem megjelenítése";
$pgv_lang["prev"]			= "&lt; Előző";
$pgv_lang["next"]			= "Következő &gt;";
$pgv_lang["file_not_found"]		= "Az állomány nem található.";
$pgv_lang["medialist_show"]             = "Mutat";
$pgv_lang["per_page"]                   = "/oldal";
$pgv_lang["remove_links"]			= "Kapcsolatok törlés";
$pgv_lang["confirm_remove_links"]	= "Biztosan kivánja ennek az elemnek az összes kapcsolatait törölni?";
$pgv_lang["confirm_delete_file"]	= "Biztosan törölni kivánja ezt az állományt?";
$pgv_lang["gen_thumb"]				= "Elönézet készítés";
$pgv_lang["manage_media"]			= "Média Kezelés";
$pgv_lang["no_thumb_dir"]			= " az elönézet mappa nem létezik és nem lehetett létrehozni.";
$pgv_lang["media_file_size"]		= "Média nagyság";
$pgv_lang["image_size"]				= "Kép méretei";
$pgv_lang["media_format"]			= "Média Formátum";
$pgv_lang["image_format"]			= "Kép Formátum";
$pgv_lang["show_thumbnail"]			= "Elönézetek feltüntetése";
$pgv_lang["delete_dir_success"]		= "Média és elönézet mappák sikeresen törölve.";
$pgv_lang["thumbs_deleted"]			= "Elönézet mappa sikeresen törölve.";
$pgv_lang["thumbs_not_deleted"]		= "Elönézet mappa nem lett törölve.";
$pgv_lang["add_directory"]			= "Mappa hozzáadás";
$pgv_lang["current_dir"]			= "Aktuálís mappa";
$pgv_lang["media_deleted"]			= "A média mappa sikeresen törölve.";
$pgv_lang["media_not_deleted"]		= "A media mappa nem lett törölve.";
$pgv_lang["directory_not_exist"]	= "A mappa nem létezik.";
$pgv_lang["directory_not_empty"]	= "A mappa nem üres.";
$pgv_lang["delete_file"]			= "Állomány törlése";
$pgv_lang["remove_object"]			= "Elem törlés";
$pgv_lang["confirm_remove_object"]	= "Biztosan kivánja ennek az elemnek a törlését az adatbázisból?";
$pgv_lang["delete_directory"]		= "Mappa törlés";

//-- SEARCH FILE MESSAGES
$pgv_lang["search_gedcom"]		= "Keresés a GEDCOM állományban";
$pgv_lang["enter_terms"]		= "Keresőkifejezés megadása:";
$pgv_lang["soundex_search"]		= "Hasonló nevek keresése:";
$pgv_lang["sources"]			= "Források";
$pgv_lang["firstname_search"]		= "Keresztnév";
$pgv_lang["lastname_search"]		= "Vezetéknév";
$pgv_lang["search_place"]		= "Helyszín";
$pgv_lang["search_year"]		= "Év";
$pgv_lang["no_results"]			= "Nincs találat";
$pgv_lang["search_soundex"]			= "Hangzási keresés";
$pgv_lang["search_soundextype"]		= "Hangzási tipus:";
$pgv_lang["search_more_chars"]      = "Több mint egy betüt adjon meg";
$pgv_lang["search_general"]			= "Általános keresés";
$pgv_lang["search_type"]			= "Keresési tipus";
$pgv_lang["search_geds"]			= "Amelyik GEDCOM-okban keress";
$pgv_lang["search_asso_label"]		= "Kapcsolatok";
$pgv_lang["associate"]				= "kapcsolat";
$pgv_lang["search_tagfoff"]			= "Igen";
$pgv_lang["search_tagfon"]			= "Kizárása a nem geneologiai adatoknak";
$pgv_lang["paste_rid_into_field"]	= "Ragassza be ennek a Szervezet azonosítószámát az ön szerkesztési mezöjébe, hogy ez a Szervezet legyen a referencia";
$pgv_lang["confirm_delete_repo"]	= "Biztos ki akarja törölni ezt a Szervezetet az adatbázisból?";
$pgv_lang["new_repo_created"]		= "Új Szervezet alkotva";
$pgv_lang["create_repository"]		= "Új Szervezet";
$pgv_lang["other_repo_records"]		= "Adatok amik ehhez a Szervezethez kapcsolodnak:";
$pgv_lang["delete_repo"]			= "Szervezet Törlése";
$pgv_lang["repo_info"]				= "Szervezet Információ";
$pgv_lang["total_repositories"]		= "Szervezetek";
$pgv_lang["find_repository"]		= "Szervezet Keresés";
$pgv_lang["repos_found"]			= "Talált Szervezetek";
$pgv_lang["repo_list"]				= "Szervezet Lista";
$pgv_lang["find_source"]			= "Találj Forrást";
$pgv_lang["search_tagfilter"]		= "Szűrő nélkűl";
$pgv_lang["search_prtall"]			= "Az összes név";
$pgv_lang["search_prthit"]			= "Talált nevek";
$pgv_lang["search_prtnames"]		= "Személyek<br/>neveit kiírni:";
$pgv_lang["search_options"]			= "Keresési Opció";
$pgv_lang["search_sources"]			= "Források";
$pgv_lang["search_indis"]			= "Személyek";
$pgv_lang["search_fams"]			= "Családok";
$pgv_lang["search_inrecs"]			= "Keress";
$pgv_lang["search_russell"]			= "Russell";
$pgv_lang["search_DM"]				= "Daitch-Mokotoff";

//-- SOURCELIST FILE MESSAGES
$pgv_lang["sources_found"]		= "forrást találtunk";
$pgv_lang["titles_found"]               = "cím";

//-- SOURCE FILE MESSAGES
$pgv_lang["source_info"]		= "Forrás információ";
$pgv_lang["other_records"]		= "Erre a forrásra hivatkozó rekordok:";
$pgv_lang["people"]			= "Személyek";
$pgv_lang["families"]			= "Családok";
$pgv_lang["total_sources"]		= "Források száma";

//-- BUILDINDEX FILE MESSAGES
$pgv_lang["building_indi"]		= "Személy- és család-index állományok létrehozása";
$pgv_lang["building_index"]		= "Indexlisták létrehozása";
$pgv_lang["invalid_gedformat"]  	= "Érvénytelen GEDCOM 5.5 formátum";
$pgv_lang["importing_records"]		= "A rekordok importálása az adatbázisba.";
$pgv_lang["detected_change"]		= "A PhpGedView változást észlelt a <b>#GEDCOM#</b> GEDCOM-állományban. Az index állományokat frissíteni kell.";
$pgv_lang["please_be_patient"]		= "KÉRJÜK, LEGYEN TÜRELEMMEL";
$pgv_lang["reading_file"]		= "GEDCOM állomány beolvasása";
$pgv_lang["flushing"]			= "Tartalom frissítése";
$pgv_lang["found_record"]		= "Rekordot találtunk";
$pgv_lang["exec_time"]			= "Végrehajtási idő:";
$pgv_lang["time_limit"]				= "Időhatár:";
$pgv_lang["unable_to_create_index"]	= "Az index állomány nem hozható létre. Bizonyosodjon meg arról, hogy a megfelelő írásjogok be vannak állítva a PhpGedView könyvtárra. A jogokat vissza lehet állítani, miután az index-állomány kiírásra került.";
$pgv_lang["indi_complete"]		= "A személy-index állomány frissítése elkészült.";
$pgv_lang["family_complete"]		= "A család-index állomány frissítése elkészült.";
$pgv_lang["source_complete"]		= "A forrás-index állomány frissítése elkészült.";
$pgv_lang["tables_exist"]		= "A PhpGedView-táblák már léteznek az adatbázisban";
$pgv_lang["you_may"]			= "Választhat:";
$pgv_lang["drop_tables"]		= "Jelenlegi táblák törlése";
$pgv_lang["import_multiple"]		= "Több GEDCOM-állomány importálása és felhasználása";
$pgv_lang["explain_options"]		= "Ha a táblák törlését választja, akkor az <u>összes</u> adat a jelenlegi GEDCOM-állománnyal lesz lecserélve.<br/><br/>Ha azt választja, hogy több GEDCOM-állománnyal dolgozzunk, akkor az nevű ugyanolyan állományokból származó rekordok törlésre kerülnek. Ez lehetőséget ad több GEDCOM-adat ugyanabban a táblában való tárolására, és a köztük való könnyű átváltásra.<br/><br/><b>Megjegyzésre szórúl hogy a tartományok neve kis és nagy betükkel különbözhet.</b> Ez azt jelenti hogy a <b>Test.GED</b> <u>nem</u> ugyan az mint a <b>test.ged</b>.";
$pgv_lang["path_to_gedcom"]		= "Adja meg az útvonalat a GEDCOM-állományhoz:";
$pgv_lang["changes_present"]		= "Az aktuális GEDCOM -nak vannak függőben változtatásai. Ha folytatja az importálást akkor ezek a függőben levő változtatások azonnal bekerűlnek az adatbázisba. Meg kellene tekintenie a függőben levő változtatásokat még mielött folytatná az importálást.";
$pgv_lang["dataset_exists"]		= "Ezzel a névvel már van adatbázisba importált GEDCOM.";
$pgv_lang["empty_dataset"]		= "Ki szeretné törölni a régi adatokat és kicserélni ezzel az új adatokkal?";
$pgv_lang["updating_is_dead"]		= "\"Elhunyt\" státusz frissités az INDI -nek";
$pgv_lang["index_complete"]		= "Az indexelés elkészült";
$pgv_lang["click_here_to_go_to_pedigree_tree"] = "Kattintson ide, hogy megtekintse az ősfát.";
$pgv_lang["import_complete"]		="Az importálás elkészült";
$pgv_lang["updating_family_names"]	= "Vezetéknevek frissitése a FAM -nak ";
$pgv_lang["run_tools"]			= "Az importálás előtt kívánja futtatni a következő eszközök valamelyikét?";
$pgv_lang["addmedia"]			= "Média hozzáadása";
$pgv_lang["dateconvert"]		= "Dátumkonverzió";
$pgv_lang["xreftorin"]			= "XREF ID-k konvertálása RIN számokká";
$pgv_lang["tools_readme"]		= "További információért tekintse meg az eszközök szekcióban lévő #README.TXT# állományt.";
$pgv_lang["sec"]			= "mp.";
$pgv_lang["bytes_read"]			= "Byte beolvasva:";
$pgv_lang["created_indis"]		= "A <i>Személyek</i> táblát sikeresen létrehoztuk.";
$pgv_lang["created_indis_fail"] 	= "A <i>Személyek</i> táblát nem sikerült létrehozni.";
$pgv_lang["created_fams"]		= "A <i>Családok</i> táblát sikeresen létrehoztuk.";
$pgv_lang["created_fams_fail"]  	= "A <i>Családok</i> táblát nem sikerült létrehozni.";
$pgv_lang["created_sources"]		= "A <i>Források</i> táblát sikeresen létrehoztuk.";
$pgv_lang["created_sources_fail"]       = "A <i>Források</i> táblát nem sikerült létrehozni.";
$pgv_lang["created_other"]		= "Az <i>Egyebek</i> táblát sikeresen létrehoztuk.";
$pgv_lang["created_media_mapping_fail"]	= "A <i>Média címezés</i> táblát nem sikerült létrehozni.";
$pgv_lang["created_media_fail"]	= "A <i>Média</i> táblát nem sikerült létrehozni.";
$pgv_lang["created_placelinks_fail"]	= "A <i>Helyszinek Link</i> táblát nem sikerült létrehozni.";
$pgv_lang["created_placelinks"] 	= "A <i>Helyszinek Link</i> táblát sikeresen létrehoztuk.";
$pgv_lang["created_other_fail"] 	= "Az <i>Egyebek</i> táblát nem sikerült létrehozni.";
$pgv_lang["created_places"]		= "A <i>Helyszínek</i> táblát sikeresen létrehoztuk.";
$pgv_lang["created_places_fail"]        = "A <i>Helyszínek</i> táblát nem sikerült létrehozni.";
$pgv_lang["import_progress"]    	= "Az importálás folyamatban...";

//-- INDIVIDUAL AND FAMILYLIST FILE MESSAGES
$pgv_lang["total_fams"]			= "Családok száma";
$pgv_lang["total_indis"]		= "Személyek száma";
$pgv_lang["starts_with"]		= "Kezdete:";
$pgv_lang["person_list"]		= "Személyek listája:";
$pgv_lang["paste_person"]		= "Személy beillesztése";
$pgv_lang["notes_sources_media"]	= "Megjegyzések, források, média";
$pgv_lang["notes"]			= "Megjegyzések";
$pgv_lang["ssourcess"]			= "Források";
$pgv_lang["media"]			= "Média";
$pgv_lang["name_contains"]		= "Név tartalmazza:";
$pgv_lang["filter"]			= "Szűrő";
$pgv_lang["find_individual"]		= "Személy azonosítójára keresés";
$pgv_lang["find_familyid"]              = "Család azonosítójára keresés";
$pgv_lang["find_sourceid"]		= "Forrás azonosítójának keresése";
$pgv_lang["magnify"]				= "Nagyít";
$pgv_lang["find_specialchar"]		= "Speciális karakter keresése";
$pgv_lang["skip_surnames"]		= "Teljes nevek listája";
$pgv_lang["show_surnames"]		= "Vezetéknevek listája";
$pgv_lang["all"]			= "Mind";
$pgv_lang["hidden"]			= "Rejtett";
$pgv_lang["confidential"]		= "Bizalmas";
$pgv_lang["alpha_index"]				= "Ábécés index";
$pgv_lang["firstname_alpha_index"] 	= "Keresztnév ábécés indexe";
$pgv_lang["name_list"] 				= "Név lista";

//-- TIMELINE FILE MESSAGES
$pgv_lang["age"]			= "életkor:";
$pgv_lang["year1"]					= "év";
$pgv_lang["month1"]					= "hónap";
$pgv_lang["day1"]					= "nap";
$pgv_lang["years"]					= "évek";
$pgv_lang["months"]					= "hónapok";
$pgv_lang["days"]					= "napok";
$pgv_lang["timeline_title"]		= "PhpGedView kronológia";
$pgv_lang["timeline_chart"]		= "Kronológia";
$pgv_lang["remove_person"]		= "Személy visszavonása";
$pgv_lang["show_age"]			= "életkor jelző";
$pgv_lang["add_another"]		= "Új személy hozzáadása:<br/>Személyi azonosító:";
$pgv_lang["find_id"]			= "Azonosító";
$pgv_lang["show"]			= "Mutat";
$pgv_lang["year"]			= "Év:";
$pgv_lang["timeline_instructions"]	= "Az elterjedtebb böngészők támogatják a szövegdobozok grafikonon belüli mozgatását.";
$pgv_lang["zoom_in"]			= "Nagyítás";
$pgv_lang["zoom_out"]			= "Kicsinyítés";

//-- MONTH NAMES
$pgv_lang["jan"]			= "január";
$pgv_lang["feb"]			= "február";
$pgv_lang["mar"]			= "március";
$pgv_lang["apr"]			= "április";
$pgv_lang["may"]			= "május";
$pgv_lang["jun"]			= "június";
$pgv_lang["jul"]			= "július";
$pgv_lang["aug"]			= "augusztus";
$pgv_lang["sep"]			= "szeptember";
$pgv_lang["oct"]			= "október";
$pgv_lang["nov"]			= "november";
$pgv_lang["dec"]			= "december";
$pgv_lang["abt"]			= "körül";
$pgv_lang["aft"]			= "után";
$pgv_lang["and"]			= "és";
$pgv_lang["bef"]			= "előtt";
$pgv_lang["bet"]			= "között";
$pgv_lang["cal"]			= "számított";
$pgv_lang["est"]			= "becsült";
$pgv_lang["from"]			= "kezdettel";
$pgv_lang["int"]			= "sértetlenség";
$pgv_lang["to"]				= "bezárólag";
$pgv_lang["cir"]			= "körülbelül";
$pgv_lang["apx"]			= "megközelítőleg";

//-- Admin File Messages
$pgv_lang["select_an_option"]		= "Válasszon az alábbi lehetőségek közül:";
$pgv_lang["readme_documentation"]	= "OLVASSEL Dokumentáció";
$pgv_lang["view_readme"]			= "readme.txt állomány tekintése";
$pgv_lang["configuration"]		= "Beállítások";
$pgv_lang["rebuild_indexes"]		= "Indexek újraépítése";
$pgv_lang["user_admin"]			= "Felhasználókezelés";
$pgv_lang["user_created"]		= "A felhasználót sikeresen hozzáadtuk.";
$pgv_lang["user_create_error"]		= "Nem sikerült a felhasználót hozzáadni. Kérjük lépjen vissza, és próbálja meg újra.";
$pgv_lang["password_mismatch"]		= "A jelszavak nem egyeznek";
$pgv_lang["enter_username"]		= "Adja meg a felhasználónevet";
$pgv_lang["enter_fullname"]		= "Adja meg a teljes nevét";
$pgv_lang["enter_password"]		= "Adja meg a jelszavát";
$pgv_lang["confirm_password"]		= "Ismételje meg a jelszót";
$pgv_lang["comment_exp"]			= "Adminisztrátor figyelmeztetés ezen a dátumon";
$pgv_lang["comment"]				= "Adminisztrátor megjegyzése a felhasználóról";
$pgv_lang["update_user"]		= "Felhasználói jogosultság frissítése";
$pgv_lang["update_myaccount"]		= "A felhasználói adataim frissítése";
$pgv_lang["save"]			= "Mentés";
$pgv_lang["delete"]			= "Töröl";
$pgv_lang["edit"]			= "Szerkeszt";
$pgv_lang["full_name"]			= "Teljes név";
$pgv_lang["visibleonline"]              = "Bejelentkezés után látható";
$pgv_lang["editaccount"]		= "A felhasználó szerkesztheti a saját felhasználói adatait";
$pgv_lang["admin_gedcom"]               = "GEDCOM-adminisztráció";
$pgv_lang["confirm_user_delete"]	= "Valóban törölni kívánja ezt a felhasználót?";
$pgv_lang["create_user"]		= "Felhasználó létrehozása";
$pgv_lang["no_login"]			= "Nem sikerült azonosítani a felhasználót.";
$pgv_lang["import_gedcom"]		= "GEDCOM-állomány importálása";
$pgv_lang["duplicate_username"]		= "Ezzel a névvel már létezik felhasználó. Kérem, lépjen vissza és válasszon másik felhasználónevet!";
$pgv_lang["gedcomid"]			= "A felhasználó azonosítója a GEDCOM-ban";
$pgv_lang["enter_gedcomid"]		= "Egy GEDCOM azonosítót meg kell adnia.";
$pgv_lang["user_info"]			= "Felhasználói adataim";
$pgv_lang["rootid"]			= "A családfa-grafikon kezdő személye";
$pgv_lang["download_gedcom"]		= "GEDCOM-állomány letöltése";
$pgv_lang["upload_gedcom_help"]		= "Válasszon egy GEDCOM vagy ZIP állományt az ön számitógépéről amit fel szeretne tőlteni a szerverre. Az állomány a <b>#INDEX_DIRECTORY#</b> mappába lesz feltőltve.<br/><br/>Ha egy ZIP állományt tőlt fel akkor abban csak egy GEDCOM lehet és az a GEDCOM lesz autómatikusan használva a következő lépésekben.<br/><br/>";
$pgv_lang["upload_media_help"]		= "~#pgv_lang[upload_media]#~<br/><br/>Válasszon álományokat a számítógépéről amit a szerverre fel akar tölteni. Minden álomány a <b>#MEDIA_DIRECTORY#</b> mappába lesz feltöltve vagy az alatta levö mappába.<br/><br/>Az ön által választott mappa név a #MEDIA_DIRECTORY# -hoz lesz kapcsolva. Például, #MEDIA_DIRECTORY#csaladom. Ha az elönézet mappa nem létezik akkor létre lesz hozva.";
$pgv_lang["upload_gedcom"]		= "GEDCOM-állomány feltöltése";
$pgv_lang["add_new_gedcom"]		= "Új GEDCOM-állomány létrehozása";
$pgv_lang["gedcom_file"]		= "GEDCOM-állomány:";
$pgv_lang["enter_filename"]		= "Meg kell adnia egy GEDCOM-állomány nevét.";
$pgv_lang["file_not_exists"]    	= "Ezen a néven nem létezik GEDCOM-állomány";
$pgv_lang["choose_priv"]			= "Válasszon bizalmassági fokot:";
$pgv_lang["apply_privacy"]			= "Alkalmazás a bizalmas beállításoknak?";
$pgv_lang["file_not_present"]		= "Az állomány nem létezik.";
$pgv_lang["gedadmin"]				= "GEDCOM Adminisztrátor";
$pgv_lang["user"]					= "Autentikus felhasználó";
$pgv_lang["file_exists"]		= "Ezzen a néven már létezik egy GEDCOM-állomány. Kérem válasszon egy másikat, vagy törölje a régit.";
$pgv_lang["new_gedcom_title"]		= "Családfa ebből az állományból: [#GEDCOMFILE#]";
$pgv_lang["upload_error"]		= "Hiba történt az Ön GEDCOM-állományának feltöltése közben.";
$pgv_lang["add_gedcom_instructions"]	= "Adjon meg egy ehhez az új GEDCOM-hoz. Az új GEDCOM-állományt az Index könyvtárban fogjuk elhelyezni:#INDEX_DIRECTORY#";
$pgv_lang["file_success"]		= "Az állomány feltöltése sikeresen befejeződött";
$pgv_lang["file_too_big"]		= "A feltölteni kívánt állomány elérte a maximális méretet";
$pgv_lang["file_partial"]		= "Az állomány csak részben töltődött fel, kérem próbálja meg újra";
$pgv_lang["file_missing"]		= "Nem érkezett feltöltött állomány. Töltse fel újból.";
$pgv_lang["manage_gedcoms"]		= "GEDCOM-kezelés és diszkréciós beállítások";
$pgv_lang["siteadmin"]				= "Site adminisztrátor";
$pgv_lang["visitor"]				= "Látogató";
$pgv_lang["research_assistant"]		= "Kutatási Segéd";
$pgv_lang["administration"]		= "Adminisztráció";
$pgv_lang["ansi_to_utf8"]		= "Át szeretné konvertálni ezt a GEDCOM-ot ANSI-ból UTF-8-ba?";
$pgv_lang["link_media_records"]		= "Média hozzákapcsolása";
$pgv_lang["manage_media_files"]		= "Média elemek kezelése";
$pgv_lang["add_media_records"]		= "Média adatok hozzáadása";
$pgv_lang["utf8_to_ansi"]		= "Át szeretné konvertálni ezt a GEDCOM-ot UTF-8-ról ANSI (ISO-8859-1)-ra?";
$pgv_lang["user_manual"]		= "PhpGedView felhasználói kézikönyv";
$pgv_lang["upgrade"]			= "A PhpGedView frissítése";
$pgv_lang["view_logs"]			= "Napló-állományok megtekintése";
$pgv_lang["logfile_content"]    	= "A napló-állomány tartalma";
$pgv_lang["cousin-in-law"]			= "Unokatestvér házasságból";
$pgv_lang["malecousin"]				= "Fiu unokatestvér";
$pgv_lang["femalecousin"]			= "Lány unokatestvér";
$pgv_lang["firstcousin"]			= "Elsö unoka testvér";
$pgv_lang["step1"]			= "1. lépés a 4-ből:";
$pgv_lang["step2"]			= "2. lépés a 4-ből:";
$pgv_lang["step3"]			= "3. lépés a 4-ből:";
$pgv_lang["step4"]			= "4. lépés a 4-ből:";
$pgv_lang["validate_gedcom"]		= "GEDCOM érvényességének ellenőrzése";
$pgv_lang["img_admin_settings"]		= "A képeszekesztés beállításai";
$pgv_lang["download_note"]              = "Megjegyzés: A nagyméretű GEDCOM-állományok letöltés előtti feldolgozása hosszú időt vehet igénybe. Ha PHP előre definiált futási ideje letelik a letöltés befejezése előtt, akkor Ön egy nem teljes állomnyt kaphat.<br/><br/>A helyes letöltést ellenőrizheti az állomány végén található értékkel: <b>0&nbsp;TRLR</b>. GEDCOM álományok sima írott szöveggel vannak írva igy bármilyen szövegolvasó szofverrel kitudja nyitni, de biztos legyen benne hogy <u>ne</u> spórolja meg a GEDCOM álományt az ellenörzés után.<br/><br/>Általánosságban a letöltés kb. annyi ideig tart, mint az adott GEDCOM-állomány importálása.";
$pgv_lang["pgv_registry"]               = "Oldalak, melyek szintén PhpGedView-t használnak";
$pgv_lang["verify_upload_instructions"] = "Ha Ön a folytatás mellet dönt, a korábbi GEDCOM-állományt az Ön által feltöltöttre fogjuk lecserélni és az importálási folyamat újrakezdődik. Ha a megszakítást választja, a korábbi GEDCOM-állomány érintetlen marad.";
$pgv_lang["cancel_upload"]		= "Feltöltés megszakítása";
	 
//-- Relationship chart messages
$pgv_lang["relationship_chart"]		= "Rokonsági fok";
$pgv_lang["person1"]			= "1. személy";
$pgv_lang["person2"]			= "2. személy";
$pgv_lang["granddaughter"]			= "Unoka, lány";
$pgv_lang["grandson"]				= "Unoka, fiú";
$pgv_lang["uncle"]				= "Nagybácsi";
$pgv_lang["aunt"]					= "Nagynéni";
$pgv_lang["sister-in-law"]			= "Sógórnő";
$pgv_lang["brother-in-law"]		= "Sógór";
$pgv_lang["grandchild"]				= "Unoka";
$pgv_lang["daughter-in-law"]		= "Meny";
$pgv_lang["son-in-law"]				= "Vej";
$pgv_lang["no_link_found"]		= "A két személy között nem lelhető fel rokoni kapcsolat.";
$pgv_lang["sibling"]			= "Testvér";
$pgv_lang["follow_spouse"]		= "Házastárson keresztüli rokonság ellenőrzése.";
$pgv_lang["timeout_error"]		= "A program túllépte az időkorlátot, mielőtt rokonsági kapcsolatot talált volna.";
$pgv_lang["son"]			= "Fiúgyermek";
$pgv_lang["daughter"]			= "Lánygyermek";
$pgv_lang["brother"]			= "Fiútestvér";
$pgv_lang["sister"]			= "Lánytestvér";
$pgv_lang["relationship_to_me"]		= "Rokonsági kapcsolat hozzám";
$pgv_lang["rela_wife"]				= "Rokonsági kapcsolat a feleséghez";
$pgv_lang["rela_husb"]				= "Rokonsági kapcsolat a férjhez";
$pgv_lang["next_path"]			= "Alternatív útvonal";
$pgv_lang["show_path"]			= "Útvonal";
$pgv_lang["line_up_generations"]        = "Azonos generációk igazítása";
$pgv_lang["oldest_top"]             	= "Legidősebbet felülre";

//-- GEDCOM edit utility
$pgv_lang["check_delete"]		= "Valóban törli ezt a GEDCOM-adatot?";
$pgv_lang["access_denied"]		= "<b>Hozzáférés megtagadva</b><br/>Megfelelő jogosultság hiányában nem tekintheti meg ezt a forrást.";
$pgv_lang["gedrec_deleted"]		= "A GEDCOM-bejegyzést sikeresen töröltük";
$pgv_lang["gedcom_deleted"]		= "GEDCOM [#GED#] sikeresen törölve lett.";
$pgv_lang["changes_exist"]		= "A jelenlegi GEDCOM megváltozott.";
$pgv_lang["accept_changes"]		= "Változások elfogadása / elvetése";
$pgv_lang["show_changes"]		= "A rekordot módosították. A változások megtekintéséhez kattintson ide.";
$pgv_lang["hide_changes"]               = "A változások elrejtéséhez kattintson ide.";
$pgv_lang["review_changes"]		= "A GEDCOM-változások áttekintése";
$pgv_lang["undo_successful"]		= "Sikeres visszavonás";
$pgv_lang["undo"]			= "Visszavonás";
$pgv_lang["view_change_diff"]		= "Változások megtekintése";
$pgv_lang["changes_occurred"]		= "A következő változások történtek ezen a személyen:";
$pgv_lang["find_place"]			= "Hely keresése";
$pgv_lang["refresh"]				= "Frissítés";
$pgv_lang["close_window"]		= "Ablak bezárás";
$pgv_lang["close_window_without_refresh"] = "Az ablak frissítése nélkül bezár";
$pgv_lang["place_contains"]		= "Hely tartalmazza:";
$pgv_lang["accept_gedcom"]		= "Ön minden egyes változás megtartásáról vagy elvetéséről dönthet.<br/><br/>A változások egyszerre való elfogadásához kattintson a lenti <b>\"Mindet elfogad\"</b> hivatkozásra.<br/>További információért<br/>kattintson a <b>\"Eltérések\"</b> hivatkozásra, így megtekintheti a régi és az új változat közötti különbséget,<br/>vagy kattintson a <b>\"GEDCOM-rekord\"</b> hivatkozásra, hogy GEDCOM-formátumban nézhesse át az újabb állapotot.";
$pgv_lang["ged_import"]			= "Importálás";
$pgv_lang["now_import"]			= "A GEDCOM-rekordok importálásához kattintson az alábbi 'importálás' hivatkozásra.";
$pgv_lang["add_fact"]			= "Új esemény hozzáadása";
$pgv_lang["add"]			= "Hozzáadás";
$pgv_lang["custom_event"]		= "Egyéni esemény";
$pgv_lang["update_successful"]		= "A frissítés sikeresen megtörtént";
$pgv_lang["add_child"]			= "Gyermek hozzáadása";
$pgv_lang["add_child_to_family"]	= "Gyermek hozzáadása a családhoz";
$pgv_lang["add_sibling"]		= "Testvér hozzáadása";
$pgv_lang["add_son_daughter"]		= "Gyermek hozzáadása";
$pgv_lang["must_provide"]		= "Meg kell adnia egy ";
$pgv_lang["delete_person"]		= "A személy törlése";
$pgv_lang["confirm_delete_person"]	= "Biztosan törölni szeretné ezt a személyt a GEDCOM-állományból?";
$pgv_lang["find_media"]			= "Média keresése";
$pgv_lang["set_link"]			= "Kapcsolat létrehozása";
$pgv_lang["add_source_lbl"]		= "Forrás idézés hozzáadása";
$pgv_lang["add_source"]			= "Új forrás idézés hozzáadása";
$pgv_lang["add_note_lbl"]		= "Jegyzet hozzáadása";
$pgv_lang["add_note"]			= "Új megjegyzés hozzáfűzése";
$pgv_lang["add_media_lbl"]		= "Média hozzáadása";
$pgv_lang["add_media"]			= "Új média-elem hozzáadása";
$pgv_lang["delete_source"]		= "Forrás törlése";
$pgv_lang["confirm_delete_source"]	= "Biztosan törölni szeretné ezt a forrást a GEDCOM-állományból?";
$pgv_lang["add_husb"]			= "Férj hozzáadása";
$pgv_lang["add_husb_to_family"]		= "Férj hozzáadása a családhoz";
$pgv_lang["add_wife"]			= "Feleség hozzáadása";
$pgv_lang["add_wife_to_family"]		= "Feleség hozzáadása a családhoz";
$pgv_lang["find_family"]		= "Család keresése";
$pgv_lang["find_fam_list"]              = "Család-lista keresése";
$pgv_lang["add_new_wife"]		= "Új feleség hozzáadása";
$pgv_lang["add_new_husb"]		= "Új férj hozzáadása";
$pgv_lang["edit_name"]			= "Név szerkesztése";
$pgv_lang["delete_name"]		= "Név törlése";
$pgv_lang["replace"]			= "Rekord cserélése";
$pgv_lang["append"]			= "Rekord hozzáfűzése";
$pgv_lang["add_father"]			= "Apa hozzáadása";
$pgv_lang["add_mother"]			= "Anya hozzáadása";
$pgv_lang["add_obje"]			= "Új multimédia-elem hozzáadása";
$pgv_lang["no_changes"]                 = "Jelenleg nincs olyan változás, melyet ellenőrizni kellene.";
$pgv_lang["accept"]  		        = "Elfogad";
$pgv_lang["accept_all"]                 = "Mindent elfogad";
$pgv_lang["accept_successful"]  	= "A változásokat sikeresen mentettük az adatbázisba.";
$pgv_lang["edit_raw"]                   = "A nyers GEDCOM-rekord szerkesztése";
$pgv_lang["select_date"]                = "Dátumválasztás";
$pgv_lang["create_source"]              = "Új forrás létrehozása";
$pgv_lang["new_source_created"] 	= "Az új forrást sikeresen létrehoztuk.";
$pgv_lang["paste_id_into_field"]	= "Illessze be a következő azonosítót a szerekesztett mezőkbe, hogy hivatkozhasson erre a forrásra.";
$pgv_lang["add_name"]                   = "Új név hozzáadása";
$pgv_lang["privacy_not_granted"]        = "Önnek ehhez nincs jogosultsága: ";
$pgv_lang["user_cannot_edit"]           = "Ez a felhasználó nem szerkesztheti ezt a GEDCOM-állományt.";
$pgv_lang["gedcom_editing_disabled"]    = "A rendszer adminisztrátora nem engedélyezi ennek a GEDCOM-nak a szerkesztését.";
$pgv_lang["privacy_prevented_editing"]  = "A diszkréciós beállítások alapján Ön nem szerkesztheti ezt a rekordot.";
$pgv_lang["bdm"]					= "Születések, Halálozások, Házasságok";
$pgv_lang["ged_noshow"]				= "Ezt az oldalt az internetcím adminisztratörje lekapcsolta.";
$pgv_lang["edit_sex"]				= "Nem szerkesztése";
$pgv_lang["add_asso"]				= "Új kapcsolat hozzáadás";
	 
//-- calendar.php messages
$pgv_lang["on_this_day"]		= "Ezen a napon az Ön múltjában...";
$pgv_lang["in_this_month"]		= "Ebben a hónapban az Ön múltjában ...";
$pgv_lang["in_this_year"]               = "Ebben az évben az Ön múltjában...";
$pgv_lang["year_anniversary"]		= "#year_var# éves évforduló";
$pgv_lang["today"]			= "Ma";
$pgv_lang["day"]			= "Nap:";
$pgv_lang["month"]			= "Hónap";
$pgv_lang["showcal"]			= "Szűrés a megmutatott eseményekre:";
$pgv_lang["anniversary_calendar"]	= "Évfordulók";
$pgv_lang["sunday"]			= "Vasárnap";
$pgv_lang["monday"]			= "Hétfő";
$pgv_lang["tuesday"]			= "Kedd";
$pgv_lang["wednesday"]			= "Szerda";
$pgv_lang["thursday"]			= "Csütörtök";
$pgv_lang["friday"]			= "Péntek";
$pgv_lang["saturday"]			= "Szombat";
$pgv_lang["viewday"]			= "Adott napon";
$pgv_lang["viewmonth"]			= "Adott hónapban";
$pgv_lang["viewyear"]                   = "Adott évben";
$pgv_lang["all_people"]			= "Az összes személy";
$pgv_lang["living_only"]		= "Élő személyek";
$pgv_lang["recent_events"]		= "Az utóbbi évekből (&lt; 100 év)";
$pgv_lang["day_not_set"]                = "A nap nincs megadva";
$pgv_lang["year_error"]			= "Az 1970-es éveknél régebbi dátumok nem támogatottak.";

//-- upload media messages
$pgv_lang["upload_media"]		= "Média állomány feltöltése";
$pgv_lang["folder"]		 			= "Mappa a szerveren";
$pgv_lang["media_file"]			= "Média állomány";
$pgv_lang["thumbnail"]			= "Előnézet";
$pgv_lang["upload_successful"]		= "A feltöltés sikeres volt.";
$pgv_lang["record_not_removed"]		= "Adat #xref# nem sikerült törölni a GEDCOM -ból.";
$pgv_lang["record_not_added"]		= "Adat #xref# nem lehetett hozáadni a GEDCOM -hoz.";
$pgv_lang["record_added"]			= "Adat #xref# sikeresen hozáadva a GEDCOM -ból.";
$pgv_lang["record_removed"]			= "Adat #xref# sikeresen törölve a GEDCOM -ból.";
$pgv_lang["record_removed"]			= "Adat #xref# sikeresen törölve a DEGCOM -ból.";
$pgv_lang["record_not_updated"]		= "Adat #pid# nem sikerült frissiteni.";
$pgv_lang["record_updated"]			= "Adat #pid# sikeresen frissitve.";
$pgv_lang["media_record_not_deleted"]	= "Média adat #xref# és a linkje nem lett törölve az adatbázisból.";
$pgv_lang["media_record_deleted"]	= "Média adat #xref# és a linkje sikeresen törölve az adatbázisból.";
$pgv_lang["thumbnail_not_deleted"]	= "Elönézet állományt nem lehetett kitörölni.";
$pgv_lang["thumbnail_deleted"]		= "Elönézet állomány sikeresen törölve.";
$pgv_lang["media_file_not_renamed"]	= "Média állományt nem lehetett átrakni vagy átnevezni.";
$pgv_lang["media_file_not_moved"]	= "Média állományt nem lehetett átrakni.";
$pgv_lang["media_file_not_deleted"]	= "Média állományt nem lehetett kitörölni.";
$pgv_lang["media_file_deleted"]		= "Média állomány sikeresen törölve.";

//-- user self registration module
//$pgv_lang["no_pw_or_account"]		= "Ha még nincs felhasználóneve, vagy elfelejtette a jelszavát, csak kattintson a <b>Bejelentkezés</b> gombra";
$pgv_lang["lost_password"]		= "Elvesztette a jelszavát?";
$pgv_lang["mandatory"] 			= "A * -gal jelöt mezők, kötelezök.";
$pgv_lang["requestpassword"]		= "Új jelszó kérése";
$pgv_lang["no_account_yet"]		= "Még nem regisztrálta magát?";
$pgv_lang["requestaccount"]		= "Regisztráció kérése";
$pgv_lang["emailadress"]		= "E-mail cím";
$pgv_lang["mail01_line01"]		= "Kedves #user_fullname#!";
$pgv_lang["mail01_line02"]		= "Az ön email címével ( #user_email# ) belépést kezdeméyneztek ( #SERVER_NAME# ).";
$pgv_lang["mail01_line03"]		= "A következő adatokat használtuk.";
$pgv_lang["mail01_line04"]		= "Kérem kattintson a következő linkre, és töltse ki a kért adatokat, hogy ellenőrizni tudjuk az adatait és az email címét.";
$pgv_lang["mail01_line05"]		= "Ha nem Ön kérte ezt az adatot, akkor nyugodtan törölheti ezt az üzenetet.";
$pgv_lang["mail01_line06"]		= "Nem fog kapni több levelet a rendszertől, mivel a felhasználói azonosítója 7 napon belül további figyelmeztetés nélkül törlésre kerül.";
$pgv_lang["mail02_line04a"]			= "Ön kapni fog egy email-t amint a jövendö felhasználó ellenörizte magát. Csak az ellenörzés után tud a felhasználó bejelentkezni az ön beavatkozása nélkül.";
$pgv_lang["mail01_subject"]		= "Az Ön regisztrációja a(z) #SERVER_NAME# szerveren";
$pgv_lang["mail02_line01"]		= "Kedves Adminisztrátor!";
$pgv_lang["mail02_line02"]		= "Egy felhasználó új azonosítót készített a(z) ( #SERVER_NAME# ) szerveren.";
$pgv_lang["pls_note06a"] 			= "Mi most küldeni fogunk egy ellenörzö email -t erre a címre ( #user_email# ). Önnek meg kell erösítenie a számla kérését az ellenörzö email alapján. Ha ön nem erösíti meg a számla kérését akkor automatikusan 7 nap után elutasításra kerül a kérelme. Önnek egy uj kérelmet kell írnia.<br/><br/>Miután követte az instrukciókat az ellenörzö email-ben, utána tud csak bejelentkezni. Ahoz hogy bejelentkezzen tudnia kell a felhasználónevét és a jelszavát.<br/><br/>";
$pgv_lang["mail02_line03"]		= "A felhasználó kapott egy emailt a fontosabb adatokkal, ahhoz hogy ellenőrizni tudja az azonosítóját.";
$pgv_lang["mail02_line04"]		= "Amint a felhasználó elvégezte ezt az ellenőrzést, emailben kap értesítést, így jogot adhat a felhasználónak a bejelentkezéshez.";
$pgv_lang["mail02_subject"]		= "Új regisztráció a(z) #SERVER_NAME# szerveren";
$pgv_lang["hashcode"]			= "Ellenőrző kód:";
$pgv_lang["thankyou"]			= "Kedves #user_fullname#!<br/>Köszönjük a regisztrációt";
$pgv_lang["pls_note06"]			= "Kapni fog egy ellenőrző emailt erre a címre ( #user_email# ). Ezt a levelet használja az azonosítója aktiválásához; ha hét napon belül nem sikerül az aktiváció, áthelyezésre kerül az azonosítója (akkor újra megkísérelheti a regisztációt).<br/><br/>Ahhoz hogy bejelentkezzen az oldalara, tudnia kell az azonosítóját, és a jelszavát.";
$pgv_lang["registernew"]		= "Új azonosító visszaigazolása";
$pgv_lang["mail03_line03a"]			= "Nem kell mást csinálnia, a felhasználó most már be tud jelentkezni.";
$pgv_lang["user_verify"]		= "Felhasználó ellenőrzése";
$pgv_lang["send"]			= "Elküld";
$pgv_lang["pls_note10a"]			= "Most már be tud jelentkezni a felhasználó nevével és a kódjával.";
$pgv_lang["pls_note07"]			= "~#pgv_lang[user_verify]#~<br/><br/>Kérem írja be a felhasználónevét, a jelszavát és az emailben az ellenőrzéshez kapott aktiváló kódot.";
$pgv_lang["pls_note08"]			= "A #user_name# felhasználó adatait leellenőriztük.";
$pgv_lang["mail03_line01"]		= "Kedves Adminisztrátor!";
$pgv_lang["mail03_line02"]		= "#newuser[username]# ( #newuser[fullname]# ) ellenőrizte a regisztációs adatait.";
$pgv_lang["mail03_line03"]		= "Kérem, kattintson a lenti hivatkozásra, jelentkezzen be, és adjon a felhasználónak jogot a bejelntkezéshez.";
$pgv_lang["mail03_subject"]		= "Új ellenőrzés a(z) #SERVER_NAME# szerveren";
$pgv_lang["pls_note09"]			= "Önt regisztrált felhasználóként azonosítottuk.";
$pgv_lang["pls_note10"]			= "Az adminisztrátort értesítettük. Amint ő megadja az engedélyt a bejelentkezéshez, be tud majd jelentkezni a felhasználónevével és jelszavával.";
$pgv_lang["data_incorrect"]		= "Hibás adat!<br/>Kérem próbálja újra!";
$pgv_lang["user_not_found"]		= "Nem lehetett ellenőrizni a megadott információt. Kérem lépjen vissza, és próbálja meg újra.";
$pgv_lang["lost_pw_reset"]		= "Elvesztettem a jelszavamat";
$pgv_lang["pls_note11"]			= "Ahhoz hogy a jelszavát megváltoztassa, adja meg a felhasználónevet és az email címét. <br/><br/>Emailben küldünk egy speciális URL-t, amely egy igazolást tartalmaz. Meglátogatva azt az internetcímet, megváltoztathatja a jelszavát majd bejelentkezhet az oldalra. Biztonsági okokból, azt a címet ne adja meg másnak, még az oldal adminisztrátorának (ezt nem is kérjük).<br/><br/>Amennyiben segítségre van szüksége, lépjen kapcsolatba az oldal adminisztrátorával.";
$pgv_lang["enter_email"]		= "Adjon meg egy e-mail címet";
$pgv_lang["mail04_line01"]		= "Kedves #user_fullname# ...";
$pgv_lang["mail04_line02"]		= "Az Ön felhasználónevéhez új jelszót igényeltek!";
$pgv_lang["mail04_line03"]		= "Ajánlások:";
$pgv_lang["mail04_line04"]		= "Kattintson az alábbi hivatkozásra, jelentkezzen be az új jelszóval majd változtassa meg ahhoz hogy az adatai biztonságban maradjanak.";
$pgv_lang["mail04_line05"]			= "Miután be jelentkezett, válassza a '#pgv_lang[myuserdata]#' linket a '#pgv_lang[mygedview]#' menű alatt és tőltse ki a jelszó mezőket hogy megváltoztassa a jelszavát.";
$pgv_lang["mail04_subject"]		= "Adat kérése a(z) #SERVER_NAME# szerveren";
$pgv_lang["pwreqinfo"]			= "Tisztelt Felhasználó!<br/><br/>Egy emailt küldtünk a (#user[email]#) címre, amiben benne van az új jelszó.<br/><br/>Kérjük, nézze meg a levelesládáját, mert ez a levél perceken belül megérkezhet.<br/><br/>Javaslat:<br/><br/>Miután megkapta az új jelszavát emailben, jelentkezzen be az új jelszóval majd változtassa meg ahhoz hogy az adatai biztonságban maradjanak.";
$pgv_lang["editowndata"]		= "Felhasználói adataim";
$pgv_lang["savedata"]			= "A megváltozott adatok mentése";
$pgv_lang["datachanged"]		= "A felhasználó adata megváltozott!";
$pgv_lang["datachanged_name"]		= "Most már bejelentkezhet az új felhasználónevével.";
$pgv_lang["myuserdata"]			= "Felhasználói adataim";
$pgv_lang["verified"]			= "A felhasználó megerősítette jelentkezését";
$pgv_lang["verified_by_admin"]		= "A felhasználót elfogadta az adminisztrátor";
$pgv_lang["user_theme"]			= "Az én témám";
$pgv_lang["mgv"]			= "MyGedView";
$pgv_lang["mygedview"]			= "MyGedView Portál";
$pgv_lang["passwordlength"]		= "A jelszónak legalább 6 karakterből kell állnia.";
$pgv_lang["admin_approved"]		= "Elfogadtuk az azonosítóját a(z) #SERVER_NAME# szerveren";
$pgv_lang["you_may_login"]		= " az adminisztrátor által. Bejelentkezhet a PhpGedView oldalra a lenti hivatkozásra kattintva:";
$pgv_lang["welcome_text_auth_mode_1"]   = "<center><b>Üdvözöljük ezen a Családfakutató-Honlapon!</b></center><br/>A honlapot minden olyan felhasználó látogathatja, akinek van hozzáférési jogosultsága.<br/><br/>Amennyiben Önnek már rendelkezik felhasználói jogosultsággal, bejelentkezhet az oldara. Ha még nem, a megfelelő hivatkozásra kattintva kezdeményezheti annak megszerzését.<br/><br/>Miután megerősítette jelentkezését, a honalp adminisztrátora fogadja el, vagy utasítja el az Ön igényét.A pozitív döntésről email-ben kap értesítést.";
$pgv_lang["welcome_text_auth_mode_2"]   = "<center><b>Üdvözöljük ezen a Családfakutató-Honlapon</b><center><br/>A honlaphoz kizárólag a <u>bejelentkezett</u> felhasználók férhetnek hozzá.<br/><br/>Amennyiben Önnek már rendelkezik felhasználói jogosultsággal, bejelentkezhet az oldara. Ha még nem, a megfelelő hivatkozásra kattintva kezdeményezheti annak megszerzését.<br/><br/>Miután megerősítette jelentkezését, a honalp adminisztrátora fogadja el, vagy utasítja el az Ön igényét. A pozitív döntésről email-ben kap értesítést.";
$pgv_lang["welcome_text_auth_mode_3"]   = "<center><b>Üdvözöljük ezen a Családfakutató-Honlapon</b></center><br/>A honlaphoz <u>kizárókag családtagok</u> férhetnek hozzá.<br/><br/>Amennyiben Önnek már rendelkezik felhasználói jogosultsággal, bejelentkezhet az oldara. Ha még nem, a megfelelő hivatkozásra kattintva kezdeményezheti annak megszerzését.<br/><br/>Miután megerősítette jelentkezését, a honalp adminisztrátora fogadja el, vagy utasítja el az Ön igényét. A pozitív döntésről email-ben kap értesítést.";
$pgv_lang["welcome_text_cust_head"]	= "<center><b>Üdvözöljük ezen a Családfakutató-Honlapon</b></center><br/>A honlapot érvényes felhasználói névvel és jelszóval rendelkező felhasználók látogathatják.<br/>";
	 
//-- mygedview page
$pgv_lang["welcome"]			= "Üdvözöljük";
$pgv_lang["upcoming_events"]		= "Következő események";
$pgv_lang["no_events_privacy"]		= "Történik esemény az elkövetkezö #pgv_lang[global_num1]# napon, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["none_today_privacy"]		= "Történnek események ma, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["more_today_privacy"]		= "<br/>Több esemény történik ma, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["none_today_privacy"]		= "Történnek események ma, de bizalmas korlátozás miatt nem mutetható.";
$pgv_lang["none_today_all"]			= "A mai napon nincs esemény.";
$pgv_lang["none_today_living"]		= "A mai napon nincs esemény az élők között.";
$pgv_lang["more_events_privacy1"]	= "<br/>Több esemény történik holnap, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["more_events_privacy"]	= "<br/>Több esemény történik az elkövetkezendö #pgv_lang[global_num1]# napon, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["no_events_privacy1"]		= "Történik esemény holnap, de bizalmas korlátozás miatt nem mutatható.";
$pgv_lang["no_events_all1"]			= "Semmi esemény nincs holnap.";
$pgv_lang["no_events_all"]			= "Semmi esemény nincs a következő #pgv_lang[global_num1]# napon.";
$pgv_lang["no_events_living1"]		= "Semmi esemény nincs honap az élők között.";
$pgv_lang["no_events_living"]		= "Semmi esemény nincs az élök között a következő #pgv_lang[global_num1]# napon.";
$pgv_lang["basic_or_all"]			= "Csak a Születés, Halálozás és a Házasságot mutasd?";
$pgv_lang["living_or_all"]			= "Csak az élők eseményeit mutasd?";
$pgv_lang["chat"]			= "Csevegés";
$pgv_lang["no_login_users"]			= "0 bejelentkezett és 0 névtelen felhasználó";
$pgv_lang["login_users"]			= "#pgv_lang[global_num1]# bejelentkezett felhasználó";
$pgv_lang["login_user"]				= "1 bejelentkezett felhasználó";
$pgv_lang["anon_users"]				= "#pgv_lang[global_num1]# névtelen bejelentkezett felhasználó";
$pgv_lang["anon_user"]				= "1 névtelen bejelentkezett felhasználó";
$pgv_lang["users_logged_in"]		= "Bejelentkezett felhasználók";
$pgv_lang["message"]			= "Üzenet elküldése";
$pgv_lang["my_messages"]		= "Üzeneteim";
$pgv_lang["date_created"]		= "Adat elküldve:";
$pgv_lang["message_from"]		= "E-mail cím:";
$pgv_lang["message_from_name"]		= "Az Ön neve:";
$pgv_lang["message_to"]			= "Címzett:";
$pgv_lang["message_subject"]		= "Tárgy:";
$pgv_lang["message_body"]		= "Szövegtörzs:";
$pgv_lang["no_to_user"]			= "Nincs megadva címzett. Nem lehet folytatni.";
$pgv_lang["provide_email"]		= "Kérem adja meg az e-mail címét, hogy üzenetére válaszolhassunk. E-mail címét kizárólag ebből a célból fogjuk felhasználni.";
$pgv_lang["reply"]			= "Válasz";
$pgv_lang["message_deleted"]		= "Üzenet törölve";
$pgv_lang["message_sent"]		= "Üzenet elküldve";
$pgv_lang["reset"]			= "Visszaállít";
$pgv_lang["site_default"]		= "Alapértelmezett";
$pgv_lang["mygedview_desc"]		= "Az Ön MyGedView oldalán kiválaszhatja az Önnek kedves személyeket, figyelheti az elkövetkezendő eseményeket, és kapcsolatba léphet más felhasználókkal.";
$pgv_lang["no_messages"]		= "Nincs új üzenete.";
$pgv_lang["clicking_ok"]		= "Kattintson az OK-ra, és egy új ablakban léphet kapcsolatba a #user[fullname]# személlyel";
$pgv_lang["my_favorites"]		= "Kedvenceim";
$pgv_lang["no_favorites"]		= "Önnek nincsenek kijelölt Kedvencei.<br/><br/>Ha egy személyt, családot vagy forrást fel kíván venni Kedvencek közé, keresse meg és kattintson a <b>#pgv_lang[add_favorite]#</b> hivatkozásra, vagy használja az alábbi beviteli mezőt az azonosító alapján történő felvételhez. Azonosító szám helyett be irhat egy URL -t és egy címet.";
$pgv_lang["add_to_my_favorites"]	= "Hozzáadás a Kedvencekhez";
$pgv_lang["gedcom_favorites"]		= "Kedvencek ebből a GEDCOM-ból";
$pgv_lang["no_gedcom_favorites"]	= "Nincs kiválasztott kedvenc. Az adminisztrátor adhat olyan kedvenceket, amelyek induláskor megjelennek.";
$pgv_lang["confirm_fav_remove"]		= "Biztosan el kívánja távolítani ezt az elemet a Kedvencek közül?";
$pgv_lang["invalid_email"]		= "Írjon be egy érvényes e-mail címet!";
$pgv_lang["enter_subject"]		= "Írja be az üzenet tárgyát!";
$pgv_lang["enter_body"]			= "Írja be az üzenet szövegét!";
$pgv_lang["confirm_message_delete"]	= "Biztosan töröljük ezt az üzenetet?";
$pgv_lang["message_email1"]		= "Ön a következő üzenetet kapta a következő címről:";
$pgv_lang["message_email2"]		= "A következő üzenetet küldte el egy PhpGedView-felhasználónak:";
$pgv_lang["message_email3"]		= "A következő üzenetet küldte el a PhpGedView-adminisztrátorának:";
$pgv_lang["viewing_url"]		= "Az üzenetet az alábbi linkre kattintva küldheti el";
$pgv_lang["messaging2_help"]		= "Az üzenet elküldésekor kapni fog egy másolatot e-mailben, az Ön által megadott e-mail címre";
$pgv_lang["random_picture"]		= "Meglepetés-kép";
$pgv_lang["message_instructions"]	= "<b>Figyelem:</b> Az élő személyek személyes adatait csak a család hozzátartozói és a közeli barátok láthatják. Mielőtt bármilyen személyes adatot megkaphatna, megkérjük hogy ellenőrizze a rokonságát. Lehetséges, hogy elhunyt személyek adatai sem hozzáférhetőek. Ebben az esetben, lehetséges hogy nincs elég információ arról hogy életben vannak-e még, vagy nincs elég egyéb információ róluk.<br/><br/>Mielőtt kérdezne, győződjön meg arról, hogy a megfelelő személyről van szó. Ellenőrizze le a dátumokat, helyeket és a közeli hozzátartozókat. Ha leszármazási adatokkal szolgál, kérem adja meg adja meg az információk forrását is.<br/><br/>";
$pgv_lang["sending_to"]			= "Ezt az üzenetet a(z) #TO_USER# felhasználónak küldjük.";
$pgv_lang["preferred_lang"]	 	= "A felhasználó #USERLANG# nyelven szeretné a rendszert használni";
$pgv_lang["gedcom_created_using"]	= "A GEDCOM-ot létrehozó szoftver: <b>#SOFTWARE# #CREATED_VERSION#</b>";
$pgv_lang["gedcom_created_on"]		= "A GEDCOM létrehozásának dátuma: <b>#CREATED_DATE#</b>";
$pgv_lang["gedcom_created_on2"] 	= " (frissítés dátuma: <b>#CREATED_DATE#</b>)";
$pgv_lang["gedcom_stats"]		= "GEDCOM-statisztika:";
$pgv_lang["stat_individuals"]		= "Személyek";
$pgv_lang["stat_families"]		= "Családok";
$pgv_lang["stat_sources"]		= "Források";
$pgv_lang["stat_other"]			= "Egyéb adatok";
$pgv_lang["stat_latest_birth"] 	= "Legutólsó születési év";
$pgv_lang["stat_earliest_birth"] 	= "Legrégibb születési év";
$pgv_lang["customize_page"]		= "Állítsa be az Ön személyes oldalát";
$pgv_lang["customize_gedcom_page"]	= "Állítsa be ezt a GEDCOM-oldalt";
$pgv_lang["upcoming_events_block"]	= "Elkövetkező események";
$pgv_lang["upcoming_events_descr"]	= "Az Elkövetkező események blokk az aktív GEDCOM-ból olyan eseményeket mutat, amelyek a következő 30 napban lesznek aktuálisak. A felhasználó oldalán ez a rész csak élő személyeket mutathat. A GEDCOM-oldalon minden személyt felsorol.";
$pgv_lang["todays_events_block"]	= "A mai napon... blokk";
$pgv_lang["todays_events_descr"]	= "A mai napon az Ön múltjában ... blokk, az aktív GEDCOM-ból olyan eseményeket mutat, amelyeknek a mai napon történetek. Ha nincs ilyen esemény, akkor ez a rész üres marad. A felhasználó oldalán, ez a rész csak élő személyeket mutathat. A GEDCOM-oldalon minden személyt felsorol.";
$pgv_lang["logged_in_users_block"]	= "Bejelentkezett felhasználók blokk";
$pgv_lang["logged_in_users_descr"]	= "A bejelentkezett felhasználók blokk az éppen bejelentkezett felhasználókat mutatja.";
$pgv_lang["user_messages_block"]	= "Felhasználói üzenetek blokk";
$pgv_lang["user_messages_descr"]	= "A Felhasználói üzenetek blokk az aktív felhasználónak elküldött üzenetek listáját tartalmazza.";
$pgv_lang["random_media_events"]	= "Események";
$pgv_lang["random_media_persons"]	= "Személyek";
$pgv_lang["user_favorites_block"]	= "Felhasználói kedvencek blokk";
$pgv_lang["user_favorites_descr"]	= "A Felhasználói kedvencek blokk a kedvenc személyek listáját tartalmazza, hogy így könnyebben megtalálhassák őket.";
$pgv_lang["welcome_block"]		= "Felhasználó üdvözlő blokk";
$pgv_lang["welcome_descr"]		= "A Felhasználó üdvözlő blokk a jelenlegi időt és dátumot tünteti fel, a hivatkozást ahol módosíthatják a felhasználói beállításaikat vagy a saját családfájukra ugorhatnak, és a hivatkozást, ahol személyes oldalukat állíthatják be.";
$pgv_lang["random_media_block"]		= "Véletlen média blokk";
$pgv_lang["random_media_descr"]		= "A Véletlen média blokk véletlenszerűen választ ki egy képet vagy egyéb médiát a jelenlegi GEDCOM-ból, és megjeleníti azt a felhasználónak.";
$pgv_lang["gedcom_block"]		= "GEDCOM Üdvözlő blokk";
$pgv_lang["gedcom_descr"]		= "A GEDCOM Üdvözlő blokk hasonlóan működik mint a Felhasználó üdvözlő blokk, azaz üdvözli a látogatót, az aktív GEDCOM címét, az időt és a dátumot jeleníti meg..";
$pgv_lang["gedcom_favorites_block"]	= "GEDCOM Kedvencek blokk";
$pgv_lang["gedcom_favorites_descr"]	= "A GEDCOM Kedvencek blokkba az adminisztrátor választhatja be a kedvenc személyeket, így a látogatók könnyebben megtalálhatják őket. Ezzel a módszerrel kiemelhetők a fontosabb személyek a család történetéből.";
$pgv_lang["gedcom_stats_block"]		= "GEDCOM Statisztika blokk";
$pgv_lang["gedcom_stats_descr"]		= "A GEDCOM Statisztika blokk alapvető dolgokat mutat a jelenlegi GEDCOM-ból, mint a létrehozás dátuma, és hány személy található benne.";
$pgv_lang["gedcom_stats_show_surnames"]	= "Leggyakoribb vezetéknevek mutatása?";
$pgv_lang["portal_config_intructions"]	= "~#pgv_lang[customize_page]#<br/>#pgv_lang[customize_gedcom_page]#~<br/><br/>Ezen az oldalon beállíthatja a MyGedView Portálon megjelenő blokkok helyét, úgy hogy tetszőleges helyre helyezi a megfelelő blokkot. <br/><br/>Az oldal két fő részre van osztva, a <b>Központi</b> részre, és a <b>Jobb</b> oldalra. A központi rész nagyobb, és a \$pgv_lang[mgv] cím alatt jelenik meg. A <b>Jobb</b> oldal a cím jobb oldalánál kezdődik, és az oldal jobb oldalán halad lefelé.<br/><br/>Mindegyik résznek megvannak saját blokkjai, amelyeknek a sorrendjét meg lehet változtatni, valamint blokkokat lehet beszúrni és kivenni.<br/><br/>Amikor az egyik blokk üres, a maradék blokk felveszi az egész szélességet az oldalon.<br/><br/>";
$pgv_lang["login_block"]		= "Bejelentkező blokk";
$pgv_lang["login_descr"]		= "A bejelentkező blokk felhasználónév és jelszó bevitelt tesz lehetővé a bejelentkezéshez.";
$pgv_lang["theme_select_block"]         = "Asztaltéma-választó blokk";
$pgv_lang["theme_select_descr"]         = "Az asztaltéma-választó blokk megmutatja az asztaltéma-választó felületet akkor is, ha a váltás nincs engedélyezve.";
$pgv_lang["block_top10_title"]          = "Leggyakoribb vezetéknevek";
$pgv_lang["block_top10"]                = "Top 10 vezetéknév blokk";
$pgv_lang["block_top10_descr"]          = "Ez a blokk egy táblázatban megmutatja az adatbázisban lévő 10 leggyakoribb keresztnevet.";
$pgv_lang["gedcom_news_block"]		= "GEDCOM hírblokk";
$pgv_lang["gedcom_news_descr"]		= "A GEDCOM hírblokk az adminisztrátor által bevitt híreket mutatja.<br/><br/>A Hírek szolgálhat például a GEDCOM-állomány frissítésének, vagy családok újraegyesítésének bejelentésére vagy gyermek születésére.";
$pgv_lang["user_news_block"]		= "Felhasználói hírlap blokk";
$pgv_lang["user_news_descr"]		= "A felhasználók hírlapjához saját feljegyzések készíthetőek.";
$pgv_lang["my_journal"]			= "Az én hírlapom";
$pgv_lang["no_journal"]			= "Ön még nem hozott létre hírlap-bejegyzést.";
$pgv_lang["confirm_journal_delete"]	= "Biztosan törli ezt a hírlap-bejegyzést?";
$pgv_lang["add_journal"]		= "Új hírlap-bejegyzés hozzáadása";
$pgv_lang["gedcom_news"]		= "Hírek";
$pgv_lang["confirm_news_delete"]	= "Biztosan törli ezt a hír bejegyzést?";
$pgv_lang["add_news"]			= "Hír hozzáadása";
$pgv_lang["no_news"]			= "Nem érkezett új hír.";
$pgv_lang["edit_news"]			= "Hírlap vagy hír hozzáadás/szerkesztése";
$pgv_lang["enter_title"]		= "Adjon meg egy címet.";
$pgv_lang["enter_text"]			= "Kérem írja be a közölni kívánt információt ehhez a hírhez vagy hírlap-bejegyzéshez.";
$pgv_lang["news_saved"]			= "A Hír/Hírlap-bejegyzést sikeresen mentettük.";
$pgv_lang["article_text"]		= "Szövegbevitel:";
$pgv_lang["main_section"]		= "Központi szekció blokkjai";
$pgv_lang["right_section"]		= "Jobb oldali blokkok";
$pgv_lang["available_blocks"]		= "Rendelkezésre álló Blokkok";
$pgv_lang["move_up"]			= "Felfelé";
$pgv_lang["move_down"]			= "Lefelé";
$pgv_lang["move_right"]			= "Jobbra";
$pgv_lang["move_left"]			= "Balra";
$pgv_lang["broadcast_all"]		= "Üzenet az összes felhasználónak";

$pgv_lang["hit_count"]			= "Számláló:";
$pgv_lang["phpgedview_message"]		= "PhpGedView üzenet";
$pgv_lang["common_surnames"]		= "Leggyakoribb vezetéknevek:";
$pgv_lang["default_news_title"]		= "Üdvözöljük az Ön Családfájánál.";
$pgv_lang["default_news_text"]		= "Ezen az oldalon a családfa-információk közlését a <a href=\"http://www.phpgedview.net/\" target=\"_blank\">PhpGedView #VERSION#</a> programmal tettük lehetővé. Az oldal áttekintést ad ehhez a programhoz.<br/><br/>Ahhoz hogy megkezdhesse a munkát az adatokkal, válassza az egyik grafikont a Grafikonok menüből, menjen a személyek listájához, vagy keressen a nevek és a helyek közt.<br/><br/>Ha nehézségei támadnak az oldal használata közben, kattintson a segítség menüre, és ott magyarázatot kaphat annak az oldalnak a használatához.<br/><br/>Köszönjük hogy meglátogatta ezt az oldalt.";
$pgv_lang["reset_default_blocks"]	= "Az alapértelmezett blokkok visszaállítása";
$pgv_lang["recent_changes"]             = "Aktuális változások";
$pgv_lang["recent_changes_block"]       = "Aktuális változások blokk";
$pgv_lang["hide_block_warn"]		= "Amikor elrejt egy üres blokkot, akkor nem lehet megváltoztatni a konfigurációját amig a blokk megint látható nem lesz mert már nem lesz üres.";
$pgv_lang["show_empty_block"]		= "Rejtve legyen ez a Blokk amikor üres?";
$pgv_lang["block_not_configure"]	=	"Ezt a Blokkot nem lehet beállitani.";
$pgv_lang["recent_changes_some"]	= "<b>Változás törént az elmúlt #pgv_lang[global_num1]# napban.</b><br/>";
$pgv_lang["recent_changes_none"]	= "<b>Nem történt semmi változás az elmúlt #pgv_lang[global_num1]# napban.</b><br/>";
$pgv_lang["recent_changes_descr"]       = "Az Aktuális változások blokkjában találhat minden olyan, a GEDCOM-állományt érintő változást, mely az elmúlt hónapban történt. Ez a blokk segíti Önt a változások naprakész követésében. A változások felismerése a CHAN elem alapján történik.";
$pgv_lang["delete_selected_messages"]   = "Kiválasztott üzenetek törlése";
$pgv_lang["use_blocks_for_default"]     = "Legyen ez a blokkbeállítás az alapértelmezett minden felhasználónak?";

//-- upgrade.php messages
$pgv_lang["options"]			= "Lehetőségek:";
$pgv_lang["inc_languages"]		= "Nyelvi állományok";
$pgv_lang["config_update_ok"]		= "A konfigurációs állományt sikeresen frissítettük.";
$pgv_lang["server_file"]				= "Az állomány neve a szerveren";
$pgv_lang["server_file_advice"]			= "Ne változtassa meg hogy, az eredeti neve az állománynak megmaradjon.";
$pgv_lang["server_folder"]				= "Mappa neve a szerveren";
$pgv_lang["page_size"]					= "Óldal méret";
$pgv_lang["wiki_main_page"]				= "Wiki start oldala";
$pgv_lang["basic_search"]			= "keres";
$pgv_lang["birthdate_search"]		= "Születési dátum: ";
$pgv_lang["deathplace_search"]		= "Halálozás helye: ";
$pgv_lang["label_gedcom_id2"]       = "Adatbázis azonosítószáma:";
$pgv_lang["lbl_type_server"]        = "Írjon be egy új weboldalt.";
$pgv_lang["change"]					= "Változtat";
$pgv_lang["change_family_instr"]	= "Használja ezt az oldalt hogy változtasson vagy törőljön családtagokat.<br/><br/>Minden családtagnál használhatja a Változtat linket hogy válasszon egy másik személyt a helyében. Az Eltávolit linket használhatja hogy a személyt eltávolitsa a családból.<br/><br/>Miután készen van a változtatásokkal, nyomja meg a Mentés gombot, hogy elmentse a változtatásokat.<br/>";
$pgv_lang["lbl_server_list"]        = "Használjon egy bejegyzett weboldalt.";
$pgv_lang["error_same"]             = "Ugyanazt az weboldalt választotta.";
$pgv_lang["error_remote"]           = "Egy Külső weboldalt választott.";
$pgv_lang["label_add_remote_link"]  = "Link hozzáadás";
$pgv_lang["label_remove_ip"]		= "IP cím letíltása (Pl: 198.128.*.*): ";
$pgv_lang["last_email_sent"]		= "Az utolsó emlékeztető email el lett kűldve ";
$pgv_lang["autocomplete"]			= "Autókiegészítés";
$pgv_lang["html_block_name"]		= "HTML";
$pgv_lang["htmlplus_block_name"]	= "Fejlettebb HTML";
$pgv_lang["htmlplus_block_content"] = "Tartalomjegyzék";
$pgv_lang["config_block"]			= "Beállítás";
$pgv_lang["child-family"]			= "Szülők és testvérek";
$pgv_lang["total_not_born"]			= "Még meg nem születettek";
$pgv_lang["common_upload_errors"]	= "Ez a hiba valószinüleg azért van mert lehet hogy a feltöltött állomány meghaladta a maximumot. Az PHP alap feltöltése 2MB. Kapcsolatba léphet a Segítség csoportal hogy, megnöveljék az apalot a php.ini állományban, vagy feltölthetö legyen FTP-n keresztül. Használja a <a href=\"uploadgedcom.php?action=add_form\"><b>GEDCOM hozzáadás</b></a> oldalt, hogy hozáadjon egy GEDCOM állományt amit feltöltött FTP-n keresztül.";
$pgv_lang["indis_with_surname"]		= "Személyek #surname# vezetéknévvel";
$pgv_lang["marr_name_import_instr"]	= "Kattintson a lenti gombra csak akkor ha azt akarja hogy a PhpGedView kiszámolja a nök házasult nevüket ebben a GEDCOM-ban. Ez lehetövé teszi hogy keressen nöket a férjük vezetéknevével. <i>Megjegyzés: Házasult nevek csak akkor tünnek fel a listákban ha a GEDCOM konfigurációjában ezt az opciót megengedi. <b>Kiszámolni a házasult neveket, csak egy lehetöség.</b></i>";
$pgv_lang["review_changes_descr"]	= "A Változások Függőben Blokkja listában sorolja fel a felhasználoknak Szerkesztési engedélyel hogy változás történt online amit meg kell tekinteni és elfogadni. Ezek a változások függöben vannak amig elfogadják vagy elutasitják öket.<br/><br/>Ha ez a Blokk be van kapcsolva, akkor felhasználok elfogadási engedélyel, kapnak egy emailt naponta egyszer hogy változás történt amit meg kell tekinteni.";
$pgv_lang["user_default_tab"]		= "Mutassa ezt az oldalt mint alap oldal a Személyek Információs oldalán";
$pgv_lang["number_sign"]			= "#";
$pgv_lang["privacy"]				= "Diszkréció";
$pgv_lang["locked"]					= "Ne változtasd meg";
$pgv_lang["edit_indi"] 				= "Személy szerkesztése";
$pgv_lang["indis_charts"]			= "Személy Opció";
$pgv_lang["cut"]					= "Kivág";
$pgv_lang["copy"]					= "Másól";
$pgv_lang["reorder_children"]		= "Gyerekek új sórrendje";
$pgv_lang["sort_by_birth"]			= "Sórrend születési dátum szerint";
$pgv_lang["fams_charts"]			= "Család Opció";
$pgv_lang["edit_fam"]				= "Család szerkesztése";
$pgv_lang["max_upload_size"]		= "Maximum feltöltési nagyság: ";
$pgv_lang["stepbrother"]			= "Mostoha fiútestvér";
$pgv_lang["stepsister"]				= "Mostoha lánytestvér";
$pgv_lang["stepmom"]				= "Mostoha anya";
$pgv_lang["stepdad"]				= "Mostoha apa";
$pgv_lang["stepfamily"]				= "Mostoha család";
$pgv_lang["top10_pageviews_block"]		= "Leggyakoribban nézet elemek";
$pgv_lang["top10_pageviews"]		= "Leggyakoribban nézet elemek";
$pgv_lang["top10_pageviews_descr"]	= "Ez a Blokk feltünteti a 10 leggyakoribban megtekintetet adatot. Ennek a Blokknak kell hogy a Számláló be legyen kapcsolva a GEDCOM konfigurációjánál.";
$pgv_lang["add_new_chil"] = "Új gyermek hozzáadása";
$pgv_lang["update_address"] = "Cím Frissités";
$pgv_lang["select_fact"] = "Válasszon egy tényt...";
$pgv_lang["photo_replace"] = "Ki akar cserélni egy régi képet ezzel a képpel?";
$pgv_lang["update_photo"] = "Kép Frissités";
$pgv_lang["update_fact_restricted"] = "Ennek a ténynek a frissitése korlátozott:";
$pgv_lang["update_fact"] = "Tény Frissités";
$pgv_lang["update_name"] = "Név Frissités";
$pgv_lang["quick_update_instructions"] = "Ezen az oldalon Gyors Frissitést lehet alkotni egy személynek az adatában. Elég ha csak az új adatot ir be vagy megváltoztatja a jelenlegi adatot. Miután kész van, egy adminisztrátornak meg kell tekintenie és elfogadnia mielött a felhasználok meg tudják tekinteni a vátozásokat.";
$pgv_lang["quick_update_title"] = "Gyors Frissités";
$pgv_lang["show_spouses"]		= "Házastársak feltüntetése";
$pgv_lang["review_changes_body"]	= "Online változások történtek a geneologiai adatbázisban. Ezeket a változásokat meg kell tekinteni és elfogadni hogy a többi felhasználó is megtekinthesse. Kérem, használja a lenti URL címet hogy abba a PhpGedView weboldalra menjen és bejelentkezzen hogy megnézze a változásokat.";
$pgv_lang["review_changes_subject"]	= "PhpGedView - Változások Megtekintése";
$pgv_lang["review_changes_email_freq"]	= "Ismételt emlékeztetö email (napok)";
$pgv_lang["review_changes_email"]	= "Emlékeztetö email küldése?";
$pgv_lang["review_changes_block"]	= "Változások Függőben";
$pgv_lang["top10_pageviews_msg"]	= "A számlálót be kell kapcsolni a GEDCOM konfigurációjában hogy ez a Blokk müködjön.";
$pgv_lang["top10_pageviews_nohits"]	= "Jelenleg nincs találat.";
$pgv_lang["total_names"]			= "Nevek száma";
$pgv_lang["calc_marr_names"]		= "Házasult nevek kiszámolása";
$pgv_lang["import_marr_names"]		= "Házasult név importálása";
$pgv_lang["first_letter_fname"]		= "Válasszon egy betüt amivel személyek keresztneve kezdödik.";
$pgv_lang["reorder_families"]		= "Családok sórrendje";
$pgv_lang["sort_by_marriage"]		= "Sórrend házassági dátum szerint";
$pgv_lang["other"]					= "Egyéb";
$pgv_lang["children_timeline"]		= "Gyerek feltüntetése kronologiai grafikonon";
$pgv_lang["family_timeline"]		= "Család feltüntetése kronologiai grafikonon";
$pgv_lang["halfsister"]				= "Fél leánytestvér";
$pgv_lang["halfbrother"]			= "Fél fiútestvér";
$pgv_lang["halfsibling"]			= "Féltestvér";
$pgv_lang["fathers_family_with"]	= "Apa családja mással";
$pgv_lang["mothers_family_with"]	= "Anya családja mással";
$pgv_lang["total_memory_usage"]		= "Felhasznált Memória:";
$pgv_lang["importing_places"]		= "Helyszinek adatai importálása";
$pgv_lang["continue_import"]		= "Importálás folytatása";
$pgv_lang["genealogy_contact"]		= "Geneologiai kapcsolat";
$pgv_lang["support_contact"]		= "Teknikai segitséghez kapcsolat";
$pgv_lang["fams_with_surname"]		= "Családok #surname# vezetéknévvel";
$pgv_lang["add_unlinked_source"]	= "Kapcsolat nélküli forrás hozzáadása";
$pgv_lang["add_unlinked_person"]	= "Kapcsolat nélküli személy hozzáadása";
$pgv_lang["remember_me"]			= "Emlékezzél rám erröl a számitógépröl?";
$pgv_lang["cookie_login_help"]		= "Ez az weboldal emlékszik önre egy elöző bejelentkezésből. Jelenleg megengedett a hozzáférés magán információkhoz és más felhasználói tulajdonságokhoz, de ahhoz hogy szerkeszteni vagy adminisztrálni lehet a weboldalt ahhoz be kell jelentkezni megint biztonsági indokok miatt.";
$pgv_lang["download_zipped"]		= "GEDCOM letöltése mint ZIP-állomány?";
$pgv_lang["remove_custom_tags"]		= "Eltávolítani a hozzá adott PGV toldalékokat? (pl._PGVU,_THUM)";
$pgv_lang["total_dead"]				= "Elúnytak száma";
$pgv_lang["total_living"]			= "Élők száma";
$pgv_lang["relatives_report"]		= "Rokonok Jelentés";
$pgv_lang["choose_relatives"]		= "Válasszon rokonokat";
$pgv_lang["descendants"]			= "Leszármazottak";
$pgv_lang["ancestors"]				= "Ösök egyenes vonalon és a családjuk";
$pgv_lang["direct-ancestors"]		= "Ösök egyenes vonalon";
$pgv_lang["spouse-family"]			= "Házastárs és gyerekek";
$pgv_lang["none"]					= "Semmi";
$pgv_lang["comments"]				= "Kommentárok";
$pgv_lang["enter_comments"]			= "Kérem, irja be a kapcsolatát az adathoz a Kommentár mezőbe.";
$pgv_lang["pls_note12"]				= "Kérem, használja ezt a mezőt hogy itt összefoglalja hogy miért kér egy számlát ehhez a weboldalhoz és hogyan kapcsolodik a geneologiai adatokhoz.";
$pgv_lang["after"]					= "utána";
$pgv_lang["before"]					= "elötte";
$pgv_lang["before_or_after"]		= "Helyezze a számlálót a név elé vagy mögé?";
$pgv_lang["days_to_show"]			= "Napok száma feltüntetése";
$pgv_lang["num_to_show"]			= "Elemek száma feltüntetése";
$pgv_lang["html_block_sample_part2"]	= "megváltoztassa amit ide kiírt.</p>";
$pgv_lang["html_block_sample_part1"]	= "<p class=\"blockhc\"><b>Irja ide a címet</b></p><br/><p>Kattintson a Konfiguráció gombra";
$pgv_lang["html_block_descr"]		= "Ez egy egyszerű HTML Blokk amit az oldalra lehet tenni hogy, bármilyen saját üzenetet hozáadhasson.";
$pgv_lang["view_changelog"]			= "changelog.txt megtekintése";
$pgv_lang["changelog"]				= "Verzió #VERSION# változások";
$pgv_lang["importing_dates"]		= "Dátum adatok importálása";
$pgv_lang["index_edit_advice"]		= "Jelöljön ki egy Blokkot és kattintson az egyik nyílra hogy, áthelyezze a kijelölt Blokkot a megadott irányba.";
$pgv_lang["undo_all"]				= "Minden Változtatás Visszavonása";
$pgv_lang["undo_all_confirm"]		= "Biztosan vissza von minden változtatást ebben a GEDCOM -ban?";
$pgv_lang["address_list"]			= "Cím Lista";
$pgv_lang["filter_address"]			= "Címek mutatása ami ezt tartalmaz:";
$pgv_lang["address_labels"]			= "Cím Etikettek";
$pgv_lang["link_new_wife"]			= "Hozzáadni egy feleséget egy bejegyzett személyből választva";
$pgv_lang["link_new_husb"]			= "Hozzáadni egy férjet egy bejegyzett személyből választva";
$pgv_lang["remove_child"]			= "Ezt a gyereket eltávolítani ebből a családból";
$pgv_lang["confirm_remove"]			= "Biztosan el akarja távolitani ezt a személyt ebből a családból?";
$pgv_lang["label_diff_server"]      = "Másik weboldal";
$pgv_lang["label_same_server"]      = "Azonos weboldal";
$pgv_lang["title_remote_link"]      = "Külső link hozzáadás";
$pgv_lang["current_person"]         = "Aktuálissal azonos";
$pgv_lang["link_remote"]            = "Kapcsolj egy külső szeményt";
$pgv_lang["indi_is_remote"]			= "Az információ ennek a személynek egy külső weboldalról lett ide kapcsolva.";
$pgv_lang["next_email_sent"]		= "A következő emlékeztető email el lesz küldve";
$pgv_lang["import_time_exceeded"]	= "A maximun futtatási idő lejárt. Kattintson a Folytatás gombra hogy, folytassa a GEDCOM állomány importálását.";
$pgv_lang["add_fav_enter_id"]		= "Irjon be egy Személy, Család vagy Forrás azonosítóját";
$pgv_lang["add_fav_or_enter_url"]	= "VAGY<br/>\nIrjon be egy URL-t és egy címet";
$pgv_lang["add_fav_enter_note"]		= "Beírhat egy tetszőleges jegyzetet erről a kedvencről";
$pgv_lang["url"]					= "URL";
$pgv_lang["add_favorite"]			= "Új kedvenc hozzáadása";
$pgv_lang["delete_family"]			= "Család törlése";
$pgv_lang["change_family_members"]	= "Családtagok változtatása";
$pgv_lang["delete_family_confirm"]	= "A család tőrlése minden személyi ősszefüggést egymáshoz kitöröl de a személyek megmaradnak. Biztos benne hogy, ki akarja törölni ezt a családot?";
$pgv_lang["cancel"]					= "Mégse";
$pgv_lang["cookie_help"]			= "Ez az weboldal cookie-kat használ hogy, ellenőrizze a belépési státuszt.<br/><br/>A cookie elfogadását a böngészöben lehet beállitani. Ezt be kell állitani még mielött bejelentkezik. Az ön böngészöjében a Segitség-nél találhat információt hogy ezt hogy lehet beállitani.";
$pgv_lang["stat_users"]				= "Felhasználók száma";
$pgv_lang["no_family_facts"]		= "Nincs tény jegyezve ennek a családnak.";
$pgv_lang["saturday_1st"]				= "Szo";
$pgv_lang["user_auto_accept"]		= "Ennek a használónak a változtatásai automatikusan elfogadható";
$pgv_lang["familybook_chart"]		= "Családi Kőnyv Grafikon";
$pgv_lang["source_menu"]			= "Forrás Opció";
$pgv_lang["edit_source"]			= "Forrás szerkesztése";
$pgv_lang["cancel"]					= "Mégse";
$pgv_lang["friday_1st"]					= "P";
$pgv_lang["thursday_1st"]				= "Cs";
$pgv_lang["wednesday_1st"]				= "Sze";
$pgv_lang["tuesday_1st"]				= "K";
$pgv_lang["monday_1st"]					= "H";
$pgv_lang["sunday_1st"]					= "V";
$pgv_lang["stat_surnames"]			= "Vezetéknevek száma";
$pgv_lang["stat_events"]			= "Események száma";
$pgv_lang["stat_average_children"]	= "Gyermekek száma átlagosan családonként";
$pgv_lang["stat_most_children"]		= "Legnagyobb gyermekes család";
$pgv_lang["stat_longest_life"]		= "Legidősebb személy";
$pgv_lang["stat_avg_age_at_death"]	= "Átlagos életkor";
$pgv_lang["ex-husband"] = "Volt férj";
$pgv_lang["noemail"] 				= "Címek email nélkül";
$pgv_lang["onlyemail"] 				= "Csak emailes címek";
$pgv_lang["stats_to_show"]			= "Válassza azokat a statisztikákat amit ez a Blokk mutasson";
$pgv_lang["broadcast_never_logged_in"]	= "Külgy üzenet azoknak a felhasználóknak akik még soha nem jelentkeztek be";
$pgv_lang["broadcast_not_logged_6mo"]	= "Külgy üzenet azoknak a felhasználóknak akik 6 hónapja nem jelentkeztek be";
$pgv_lang["ex-wife"] = "Volt feleség";
$pgv_lang["ex-spouse"] = "Volt házastárs";
$pgv_lang["label_remote_id"]        = "Külső személy azonosítószáma";
$pgv_lang["label_site_url2"]        = "Weboldal URL:";
$pgv_lang["label_site_url"]         = "Weboldal URL:";
$pgv_lang["label_site"]             = "Weboldal";
$pgv_lang["label_location"]         = "Weboldal Helye";
$pgv_lang["label_families"]         = "Családok";
$pgv_lang["label_individuals"]      = "Személyek";
$pgv_lang["label_add_server"]       = "Hozzáad";
$pgv_lang["label_delete"]           = "Töröl";
$pgv_lang["label_password_id2"]		= "Jelszó: ";
$pgv_lang["error_ban_server"]       = "Érvénytelen IP cím.";
$pgv_lang["label_password_id"]		= "Jelszó";
$pgv_lang["label_username_id2"]		= "Felhasználónév: ";
$pgv_lang["label_username_id"]		= "Felhasználónév";
$pgv_lang["label_gedcom_id"]        = "Adatbázis azonosítószáma";
$pgv_lang["label_rel_to_current"]   = "Kapcsolat az aktuális személyhez";
$pgv_lang["label_merge_options"]    = "Egybeolvaszt Opció";
$pgv_lang["label_local_id"]         = "Személy azonosítószáma";
$pgv_lang["label_remote_id"]        = "Külső személy azonosítószáma";
$pgv_lang["label_site_url"]         = "Weboldal URL:";
$pgv_lang["thumb_genned"]			= "Elönézet #thumbnail# autómatikusan generálva.";
$pgv_lang["no_upload"]				= "Média álományok feltöltése nem megengedett mert multi-média elemek használata nem megengedett vagy mert a média mappa nem irható.";
$pgv_lang["auto_thumbnail"]			= "Automatikus elönézet";
$pgv_lang["generate_thumbnail"]		= "Automatikus elönézet generálása:";
$pgv_lang["thumbgen_error"]			= "Elönézet #thumbnail# nem lehetett automatikusan generálni.";
$pgv_lang["upload_file"]			= "Állomány feltöltése az ön számitógépéből.";
$pgv_lang["media_folder_corrupt"]	= "A média mappa hibás.";
$pgv_lang["move_file_success"]		= "Média és elönézet állomány sikeresen átrakva.";
$pgv_lang["media_thumb_exists"]		= "A Média elönézet már létezik.";
$pgv_lang["media_exists"]			= "A Mádia állomány már létezik.";
$pgv_lang["invalid_id"]				= "Az azonositó nem létezik ebben a GEDCOM állományban.";
$pgv_lang["media_id"]				= "Média azonosító";
$pgv_lang["to_source"]				= "Forrázhoz";
$pgv_lang["to_family"]				= "Családhoz";
$pgv_lang["to_person"]				= "Személyhez";
$pgv_lang["link_media"]				= "Média kapcsolás";
$pgv_lang["illegal_chars"]			= "Érvénytelen karakterek a névben.";
$pgv_lang["security_not_exist"]		= "Biztonsági Figyelmeztetés: Nem lehetett az <b><i>index.php</i></b> állományt létrehozni itt ";
$pgv_lang["security_no_create"]		= "Biztonsági Figyelmeztetés: Az állomány <b><i>index.php</i></b>, nem létezik itt";
$pgv_lang["folder_no_create"]		= "A mappát nem sikerült létrehozni";
$pgv_lang["label_site"]             = "Weboldal";
$pgv_lang["label_location"]         = "Weboldal Helye";
$pgv_lang["label_ask_first"]        = "Elöbb engem kérdezz";
$pgv_lang["label_accept_changes"]   = "Az Összes változás elfogadása";
$pgv_lang["invalid_search_multisite_input_gender"] = "Keressen újra de több információval mint csak a nem";
$pgv_lang["invalid_search_multisite_input"] = "Írja be valameiket: Név, Születési dátum, Születés helye, Halálozási dátum, Halálozás helye, és Nem ";
$pgv_lang["site_list"]				= "Weboldal: ";
$pgv_lang["gender_search"]			= "Neme: ";
$pgv_lang["label_diff_server"]      = "Másik weboldal";
$pgv_lang["label_same_server"]      = "Azonos weboldal";
$pgv_lang["title_remote_link"]      = "Külső link hozzáadás";
$pgv_lang["current_person"]         = "Aktuálissal azonos";
$pgv_lang["link_remote"]            = "Kapcsolj egy külső szeményt";
$pgv_lang["indi_is_remote"]			= "Az információ ennek a személynek egy külső weboldalról lett ide kapcsolva.";
$pgv_lang["deathdate_search"]		= "Halálozási dátum: ";
$pgv_lang["birthplace_search"]		= "Születési hely: ";
$pgv_lang["name_search"]			= "Név: ";
$pgv_lang["folder_created"]		= "Könyvtár létrehozása";
$pgv_lang["upload"]					= "Feltöltés";
$pgv_lang["admin_geds"]				= "Adat és GEDCOM adminisztráció";

//-- validate GEDCOM
$pgv_lang["performing_validation"]	= "GEDCOM ellenőrzés kezdődik, válassza ki a kívánt lehetőségeket, majd kattintson a 'Tisztítás' gombra.";
$pgv_lang["changed_mac"]		= "Macintosh sortöréseket találtunk. A megváltoztatott sorok csak Új sor karakterrel végződnek, nem pedig Új sor és Lapdobással.";
$pgv_lang["changed_places"]		= "Hibákat találtunk egyes helységek kódolásában. Ezeket átalakítottuk, hogy a GEDCOM 5.5 szabványnak megfeleljenek. Egy példa a jelenlegi GEDCOM-ból:";
$pgv_lang["invalid_dates"]		= "Hibás dátumformátumokat találtam, a tisztítás után ezek a következő formátumra cseréljük: Év Hónap Nap (pl. 2004. január 1.).";
$pgv_lang["valid_gedcom"]		= "Érvényes GEDCOM-ot észleltem. Nincs szükség tisztításra.";
$pgv_lang["media_not_linked"]		= "Ez a Média nincsen semmi GEDCOM adathoz hozzákapcsolva.";
$pgv_lang["media_linked"]			= "Ez a média ehhez van hozzákapcsolva:";
$pgv_lang["optional_tools"]		= "Az importálás előtt választhatja a következő eszközöket.";
$pgv_lang["optional"]			= "Egyéb eszközök";
$pgv_lang["day_before_month"]		= "Nap a hónap előtt (NN HH ÉÉÉÉ)";
$pgv_lang["month_before_day"]		= "Hónap a nap előtt (HH NN ÉÉÉÉ)";
$pgv_lang["do_not_change"]		= "Ne legyen változás";
$pgv_lang["change_id"]			= "A személyes ID megváltoztatása erre:";
$pgv_lang["example_place"]			= "Hibás helyszín a GEDCOM-állományból:";
$pgv_lang["example_date"]		= "Hibás dátum a GEDCOM-állományból:";
$pgv_lang["add_media_tool"]		= "Média hozzáadása eszköz";
$pgv_lang["admin_site"]				= "Site adminisztráció";
$pgv_lang["admin_info"]				= "Információs";
$pgv_lang["phpinfo"]				= "PHP információ";
$pgv_lang["launch_media_tool"]		= "Kattintson ide a 'Média hozzáadása' eszköz elindításához.";
$pgv_lang["add_media_descr"]		= "Ez az eszköz média bejegyzéseket ad a jelenlegi GEDCOM-hoz. Zárja be ezt az ablakot, amikor készen van a médiák hozzáadásával.";
$pgv_lang["highlighted"]		= "Kijelölt kép";
$pgv_lang["extension"]			= "Kiterjesztés";
$pgv_lang["order"]			= "Rendezés";
$pgv_lang["inject_media_tool"]		= "Média hozzáadás a GEDCOM állományba";
$pgv_lang["add_media_button"]		= "Média-elem hozzáadása";
$pgv_lang["media_table_created"]	= "A <i>média</i> tábla frissítése sikeresen befejeződött.";
$pgv_lang["click_to_add_media"]		= "Kattintson ide, ha a #GEDCOM# GEDCOM-hoz hozzá kívánja adni a listában szereplő média-elemeket";
$pgv_lang["adds_completed"]		= "A médiát sikeresen hozzáadtuk a GEDCOM-állományhoz.";
$pgv_lang["ansi_encoding_detected"]	= "ANSI kódolást találtunk. A program akkor működik a legmegfelelőbben, ha az állományok kódolása UTF-8.";
$pgv_lang["invalid_header"]             = "A GEDCOM-állomány fejléce <b>(0 HEAD)</b> előtti sorokat találtunk.  Ezeket a tisztítás során el fogjuk távolítani.";
$pgv_lang["macfile_detected"]   	= "Macintosh-állományt találtunk. A tisztítás során ezt DOS-állománnyá fogjuk konvertálni.";
$pgv_lang["place_cleanup_detected"]     = "Érvénytelen helyszín-kódolást találtunk, melyeket javítani lenne szükséges. Az észlelt érvénytelen helyszínt a következő minta mutatja be: ";
$pgv_lang["cleanup_places"]             = "Helyszínek tisztítása";
$pgv_lang["import_options"]		= "Import Lehetöségek";
$pgv_lang["import_statistics"]	= "Statisztika Importálás";
$pgv_lang["verify_gedcom_help"]	= "Itt változtatni tud hogy folytassa a feltöltést és importálást a GEDCOM -nak vagy megállítja a feltöltést és az importálást.";
$pgv_lang["verify_gedcom"]		= "GEDCOM ellenörzése";
$pgv_lang["import_options_help"] 	= "Használhat más opciókat amikor importálja a GEDCOM -ot.";
$pgv_lang["empty_lines_detected"]       = "Empty lines were detected in your GEDCOM file.  On cleanup, these empty lines will be removed.";
	 
//-- hourglass chart
$pgv_lang["hourglass_chart"]			= "Homokóra diagram";

//-- report engine
$pgv_lang["choose_report"]              = "Válasszon ki egy jelentést";
$pgv_lang["enter_report_values"]        = "Adjon meg értékeket a jelentéshez";
$pgv_lang["selected_report"]            = "Kiválasztott jelentés";
$pgv_lang["run_report"]                 = "Jelentés megtekintése";
$pgv_lang["select_report"]              = "Jelentés kiválasztása";
$pgv_lang["download_report"]			= "Jelentés letöltése";
$pgv_lang["reports"]                    = "Jelentések";
$pgv_lang["pdf_reports"]                = "PDF jelentések";
$pgv_lang["html_reports"]               = "HTML jelentések";
$pgv_lang["ahnentafel_generation"]		= "Generáció ";
$pgv_lang["ahnentafel_buried_f"]		= "eltemetve";
$pgv_lang["ahnentafel_buried_m"]		= "eltemetve";
$pgv_lang["of"] 						= "/";
$pgv_lang["ahnentafel_died_f"]			= "elhúnyt";
$pgv_lang["ahnentafel_died_m"]			= "elhúnyt";
$pgv_lang["ahnentafel_married_f"]		= "házasodott";
$pgv_lang["ahnentafel_married_m"]		= "házasodott";
$pgv_lang["ahnentafel_christened_f"]	= "keresztelkedett";
$pgv_lang["ahnentafel_christened_m"]	= "keresztelkedett";
$pgv_lang["ahnentafel_born_f"]			= "született";
$pgv_lang["ahnentafel_born_m"]			= "született";
$pgv_lang["ahnentafel_pronoun_f"]		= "Ő ";
$pgv_lang["ahnentafel_pronoun_m"]		= "Ő ";
$pgv_lang["family_group_report"]        = "Csoportos jelentés a családokról";
$pgv_lang["page"]                       = "Oldal";
$pgv_lang["enter_famid"]                = "A család azonosítója";
$pgv_lang["show_sources"]               = "Feltüntessük a forrásokat?";
$pgv_lang["show_notes"]                 = "Feltüntessük a megjegyzéseket?";
$pgv_lang["show_basic"]                 = "Nyomtassuk az alapvető eseményeket, ha azok üresek?";
$pgv_lang["show_photos"]				= "Megmutassuk a fényképeket?";
$pgv_lang["individual_report"]			= "Személyes jelentés";
$pgv_lang["enter_pid"]					= "A személy azonosítója";
$pgv_lang["individual_list_report"]		= "Személyes lista";
$pgv_lang["generated_by"]               = "Létrehozta:";
$pgv_lang["list_children"]              = "Gyermekek listázása születésük szerint.";
$pgv_lang["birth_report"]               = "Születési dátum és hely jelentés";
$pgv_lang["birthplace"]                 = "Születési hely tartalmazza";
$pgv_lang["birthdate1"]                 = "Születési idő-intervallum kezdete";
$pgv_lang["birthdate2"]                 = "Születési idő-intervallum vége";
$pgv_lang["sort_by"]                    = "rendezési elv:";
	 
$pgv_lang["cleanup"]					= "Tisztítás";
$pgv_lang["skip_cleanup"]				= "Tisztítás megszakítása";

 //-- CONFIGURE (extra) messages for programs patriarch, slklist and statistics
$pgv_lang["dynasty_list"]               = "Családok áttekintése";
$pgv_lang["make_slklist"]               = "Excel (.slk) lista létrehozása";
$pgv_lang["excel_list"]                 = "Output in EXCEL (slk) format on the following files (first use patriarchlist):";
$pgv_lang["excel_tab"]                  = "tabblad:";
$pgv_lang["excel_create"]               = " átmásolásra kerül ebben az állományba:";
$pgv_lang["patriarch_list"]             = "Patriarch lista";
$pgv_lang["slk_list"]                   = "Excel .slk lista";
$pgv_lang["statistics"]                 = "Statisztika:";

//-- Merge Records
$pgv_lang["merge_records"]              = "Rekordok összefűzése";
$pgv_lang["merge_same"]                 = "A kiválasztott rekordok típusa nem egyezik meg, így azok nem fűzhetők össze.";
$pgv_lang["merge_step1"]                = "Összefűzés -  1. lépés a 3-ból";
$pgv_lang["merge_step2"]                = "Összefűzés -  2. lépés a 3-ból";
$pgv_lang["merge_step3"]                = "Összefűzés -  3. lépés a 3-ból";
$pgv_lang["select_gedcom_records"]      = "Válassza ki a 2 összefűzendő GEDCOM-rekordot! A rekordok típusának meg kell egyezni.";
$pgv_lang["merge_to"]                   = "Célrekord azonosítója:";
$pgv_lang["merge_from"]                 = "Forrásrekord azonosítója:";
$pgv_lang["merge_facts_same"]   	= "A következő események a két rekordban megegyeznek és automatikusan összefűzésre kerülnek.";
$pgv_lang["no_matches_found"]   	= "Nem találtunk egyező eseményeket.";
$pgv_lang["unmatching_facts"]   	= "A következő események nem egyeznek meg. Kérjük jelölje ki, hogy melyik információt tartsuk meg.";
$pgv_lang["record"]                     = "rekord";
$pgv_lang["adding"]                     = "Hozzáadás";
$pgv_lang["updating_linked"]    	= "Összekapcsolt rekordok frissítése";
$pgv_lang["merge_more"]                 = "További rekordok összefűzése";
$pgv_lang["same_ids"]                   = "Ön ugyanazt az azonosítót adta meg mindkétszer. Egy rekord nem fűzhető össze saját magával.";

//-- ANCESTRY FILE MESSAGES
$pgv_lang["ancestry_chart"]             = "Könyv az ősfáról";
$pgv_lang["gen_ancestry_chart"]         = "#PEDIGREE_GENERATIONS# generációs könyv az ősfáról";
$pgv_lang["chart_style"]                = "A grafikon stylusa";
$pgv_lang["chart_list"]			= "Lista";
$pgv_lang["chart_booklet"]   	= "Füzet";
$pgv_lang["show_cousins"]			= "Unokatestvérek feltüntetése";

// 1st generation
$pgv_lang["sosa_2"]               	= "Apa";
$pgv_lang["sosa_3"]               	= "Anya";
// 2nd generation
$pgv_lang["sosa_4"]               	= "Nagyapa";
$pgv_lang["sosa_5"]               	= "Nagyanya";
$pgv_lang["sosa_6"]               	= "Nagyapa";
$pgv_lang["sosa_7"]               	= "Nagyanya";
// 3rd generation
$pgv_lang["sosa_8"]               	= "Dédapa";
$pgv_lang["sosa_9"]               	= "Dédanya";
$pgv_lang["sosa_10"]               	= "Dédapa";
$pgv_lang["sosa_11"]               	= "Dédanya";
$pgv_lang["sosa_12"]               	= "Dédapa";
$pgv_lang["sosa_13"]               	= "Dédanya";
$pgv_lang["sosa_14"]              	= "Dédapa";
$pgv_lang["sosa_15"]               	= "Dédanya";
// 4th generation
$pgv_lang["sosa_16"]               	= "Ükapa";
$pgv_lang["sosa_17"]               	= "Ükanya";
$pgv_lang["sosa_18"]               	= "Ükapa";
$pgv_lang["sosa_19"]               	= "Ükanya";
$pgv_lang["sosa_20"]               	= "Ükapa";
$pgv_lang["sosa_21"]               	= "Ükanya";
$pgv_lang["sosa_22"]               	= "Ükapa";
$pgv_lang["sosa_23"]               	= "Ükanya";
$pgv_lang["sosa_24"]               	= "Ükapa";
$pgv_lang["sosa_25"]               	= "Ükanya";
$pgv_lang["sosa_26"]               	= "Ükapa";
$pgv_lang["sosa_27"]               	= "Ükanya";
$pgv_lang["sosa_28"]               	= "Ükapa";
$pgv_lang["sosa_29"]               	= "Ükanya";
$pgv_lang["sosa_30"]               	= "Ükapa";
$pgv_lang["sosa_31"]               	= "Ükanya";
// 5th generation
$pgv_lang["sosa_32"]               	= "Szépapa";
$pgv_lang["sosa_33"]               	= "Szépanya";
$pgv_lang["sosa_34"]               	= "Szépapa";
$pgv_lang["sosa_35"]               	= "Szépanya";
$pgv_lang["sosa_36"]               	= "Szépapa";
$pgv_lang["sosa_37"]               	= "Szépanya";
$pgv_lang["sosa_38"]               	= "Szépapa";
$pgv_lang["sosa_39"]               	= "Szépanya";
$pgv_lang["sosa_40"]               	= "Szépapa";
$pgv_lang["sosa_41"]               	= "Szépanya";
$pgv_lang["sosa_42"]               	= "Szépapa";
$pgv_lang["sosa_43"]               	= "Szépanya";
$pgv_lang["sosa_44"]               	= "Szépapa";
$pgv_lang["sosa_45"]               	= "Szépanya";
$pgv_lang["sosa_46"]               	= "Szépapa";
$pgv_lang["sosa_47"]               	= "Szépanya";
$pgv_lang["sosa_48"]               	= "Szépapa";
$pgv_lang["sosa_49"]               	= "Szépanya";
$pgv_lang["sosa_50"]               	= "Szépapa";
$pgv_lang["sosa_51"]               	= "Szépanya";
$pgv_lang["sosa_52"]               	= "Szépapa";
$pgv_lang["sosa_53"]               	= "Szépanya";
$pgv_lang["sosa_54"]               	= "Szépapa";
$pgv_lang["sosa_55"]               	= "Szépanya";
$pgv_lang["sosa_56"]               	= "Szépapa";
$pgv_lang["sosa_57"]               	= "Szépanya";
$pgv_lang["sosa_58"]               	= "Szépapa";
$pgv_lang["sosa_59"]               	= "Szépanya";
$pgv_lang["sosa_60"]               	= "Szépapa";
$pgv_lang["sosa_61"]               	= "Szépanya";
$pgv_lang["sosa_62"]               	= "Szépapa";
$pgv_lang["sosa_63"]               	= "Szépanya";

//-- FAN CHART
$pgv_lang["fan_chart"]        		= "Családi kör";
$pgv_lang["gen_fan_chart"]    		= "#PEDIGREE_GENERATIONS# genrációs családi kör";
$pgv_lang["fan_width"]        		= "A kör szélessége";
$pgv_lang["gd_library"]       		= "PHP-szerver beállítási hiba: a GDlib 2.x szükséges a képi funkciók használatához.";
$pgv_lang["gd_freetype"]                = "PHP-szerver beállítási hiba: a FreeType library szükséges a TrueType betűkészletek használatához.";
$pgv_lang["gd_helplink"]                = "http://www.php.net/gd";
$pgv_lang["fontfile_error"]   		= "A betűkészlet nem található a PHP szerveren";
$pgv_lang["fanchart_IE"]			= "Ezt a Családikör képet nem lehet kiírni az ön bönzészöjében. Kattintson a jobb egér gombra, sporolja meg és írja ki.";

//-- RSS Feed
$pgv_lang["rss_descr"]          	= "Újdonságok a #GEDCOM_TITLE# oldalról";
$pgv_lang["rss_logo_descr"]     	= "A hírforrást a PhpGedView táplálja";
$pgv_lang["no_feed"]				= "RSS hírforrás nem ál rendelkezésre erről a PhpGedView weboldalról";
$pgv_lang["no_feed_title"]			= "Hírforrás nem ál rendelkezésre";
$pgv_lang["rss_feeds"]				= "RSS hírforrás";
$pgv_lang["twin"] = "Iker";
$pgv_lang["witness"] = "Tanú";
$pgv_lang["twin_sister"] = "Ikertestvér, lány";
$pgv_lang["twin_brother"] = "Ikertestvér, fiú";
$pgv_lang["servant"] = "Szolga";
$pgv_lang["seller"] = "Eladó";
$pgv_lang["rabbi"] = "Zsidó pap";
$pgv_lang["priest"] = "Pap";
$pgv_lang["nurse"] = "Nővér";
$pgv_lang["lodger"] = "Albérlő";
$pgv_lang["informant"] = "Tudósító";
$pgv_lang["godparent"] = "Keresztszülő";
$pgv_lang["godmother"] = "Keresztanya";
$pgv_lang["godfather"] = "Keresztapa";
$pgv_lang["friend"] = "Barát";
$pgv_lang["buyer"] = "Vásárló";

//-- statistics utility
$pgv_lang["statutci"]                   = "nem tudtuk létrehozni az indexet";
$pgv_lang["statnnames"]                	= "nevek száma    =";
$pgv_lang["statvars"]			 = "Töltse ki az adatokat az ábrának";
$pgv_lang["statnfam"]                  	= "családok száma =";
$pgv_lang["statnmale"]                 	= "férfiak száma  =";
$pgv_lang["stat_10_none"]		 = "senki";
$pgv_lang["stat_16_mmb"]		= "Hónapok száma a házasság és az elsö gyermek között.";
$pgv_lang["stat_21_nok"]			 = "gyermekek száma.";
$pgv_lang["stat_14_mb1"]		= "Az első gyermek születési honapja a kapcsolatban";
$pgv_lang["stat_15_mm1"]		= "Az elsö házasságkötés hónapja";
$pgv_lang["stat_13_mm"]			 = "Házasságkötési hónap";
$pgv_lang["stat_12_md"]			 = "Elhalálozási hónap";
$pgv_lang["stat_11_mb"]			 = "Születési hónap";
$pgv_lang["statsubmit"]			 = "az ábra feltüntetése";
$pgv_lang["statreset"]			 = "alapállás";
$pgv_lang["statar_zgp"]			 = "periodusok vonal (z-tengely):";
$pgv_lang["statar_xga"]			 = "számok vonal (x-tengely):";
$pgv_lang["statar_xgm"]			 = "hónap vonal (x-tengely):";
$pgv_lang["statar_xgl"]			 = "év vonal (x-tengely):";
$pgv_lang["statar_xgp"]			 = "periodus vonal (x-tengely):";
$pgv_lang["statmess1"]			 = "<b>Csak töltse ki a sorokat az elözö beállíásokból az x- vagy az y-tengelyen</b>";
$pgv_lang["stat_301_mf"]			 = "férfi/nő";
$pgv_lang["stat_300_none"]		= "semmi";
$pgv_lang["stat_202_perc"]			 = "százalék";
$pgv_lang["stat_201_num"]			 = "számok";
$pgv_lang["stat_200_none"]			 = "összes (vagy üres)";
$pgv_lang["statnfemale"]               	= "nők száma      =";
$pgv_lang["statlxa"]                    = "az x-tengely mentén:";
$pgv_lang["statlya"]                    = "az y-tengely mentén:";
$pgv_lang["statlza"]                    = "a z-tengely mentén:";
  	 
//-- statisticsplot utility
$pgv_lang["stpl"]                        = "...";
$pgv_lang["stplGDno"]			 = "Graphics Display Library nincsen a PHP 4 -ben. Kérem, lépjen kapcsolatba az ön rendszer adminisztátorával.";
$pgv_lang["stpljpgraphno"]		= "JPgraph modulok nem elérhetők a <i>phpgedview/jpgraph/</i> mappában. Kérem, hozza le innen: http://www.aditus.nu/jpgraph/jpdownload.php<br/> <h3>Elöször telepítse be a JPgraph -ot a <i>phpgedview/jpgraph/</i> mappába</h3><br/>";
$pgv_lang["stpltype"]			 = "tipus:";
$pgv_lang["stplinfo"]			 = "ábrázolási információ:";
$pgv_lang["stplgzas"]			 = "z-tengely határai:";
$pgv_lang["stplmf"]                     = " / személy";
$pgv_lang["stplipot"]                   = " / időszak";
$pgv_lang["stplmonth"]                  = "hónap";
$pgv_lang["click_here"]				= "Kattintson ide hogy folytassa";
$pgv_lang["click_here_help"]		= "~#pgv_lang[click_here]#~<br/><br/>Kattintson erre a gombra hogy megsporólja a változtatásokat.<br/><br/>Vissza fog kerülni a #pgv_lang[welcome]# vagy a #pgv_lang[mygedview]# oldalra, de a változtatásai lehet hogy még men mutatkoznak. Lehet hogy az oldalt frissitenie kell mielött rendesen az összes változtatás felmutatkozik.";
$pgv_lang["block_summaries"]		= "~#pgv_lang[block_desc]#~<br/><br/>Egy rövid leírás minden egyes blokkról amit a #pgv_lang[welcome]# vagy a #pgv_lang[mygedview]# oldalra tud tenni.<br/><table border='1' align='center'><tr><td class='list_value'><b>#pgv_lang[name]#</b></td><td class='list_value'><b>#pgv_lang[description]#</b></td></tr>#pgv_lang[block_summary_table]#</table><br/><br/>";
$pgv_lang["display_all"]			= "Mutass mindent";
$pgv_lang["source_contains"]		= "A Forrás tartalma:";
$pgv_lang["repo_contains"]			= "A Szervezet tartalma:";
$pgv_lang["media_contains"]			= "A Média tartalma:";
$pgv_lang["total_places"]			= "Talált helyek";
$pgv_lang["block_desc"]				= "Leírás Blokk";
$pgv_lang["description"]			= "Leírás";
$pgv_lang["definitions"]			= "Definicíók";
$pgv_lang["maybe"]					= "Talán ";
$pgv_lang["dead"]					= "Elhúnyt ";
$pgv_lang["dead"]					= "Elhúnyt";
$pgv_lang["alive"]					= "Él ";
$pgv_lang["is_alive_in"]			= "Él #YEAR# évében";
$pgv_lang["add_faq_header"] = "FAQ fejléc";
$pgv_lang["position_item"] = "Elem poziciója";
$pgv_lang["faq_list"] = "FAQ lista";
$pgv_lang["hs_title"] 			= "Keresési Segitség";
$pgv_lang["confirm_faq_delete"] = "Biztos benne hogy ezt az GYIK-ot ki akarja törölni?";
$pgv_lang["preview"] =  "Elönézet";
$pgv_lang["no_id"] = "Semmi GYIK azonosító nem lett megadva!";
$pgv_lang["no_faq_items"] = "Az FAQ lista üres.";
$pgv_lang["add_faq_order"] = "FAQ pozitció";
$pgv_lang["add_faq_body"] = "FAQ szövegtörzs";
$pgv_lang["alive_in_year"]			= "Élő az Évben";
$pgv_lang["stplnumbers"]                = "numbers";
$pgv_lang["stplage"]                    = "kor";
$pgv_lang["stplperc"]                   = "százalák";
$pgv_lang["hs_searchin"]		= "Keresd ebben";
$pgv_lang["hs_keyword"] 		= "Keresd";
$pgv_lang["block_summary_table"]	= "&nbsp;";
$pgv_lang["accesskey_family_gedcom"]	= "G";
$pgv_lang["hs_searchuser"]		= "Használói segitség";
$pgv_lang["hs_results"] 		= "Talált eredmény:";
$pgv_lang["hs_close"] 			= "Ablak bezárás";
$pgv_lang["hs_search"] 			= "Keres";
$pgv_lang["accesskey_family_timeline"]	= "T";
$pgv_lang["accesskey_family_children_timeline"]	= "D";
$pgv_lang["accesskey_family_parents_timeline"]	= "P";
$pgv_lang["accesskey_individual_gedcom"]	= "G";
$pgv_lang["accesskey_individual_relation_to_me"]	= "M";
$pgv_lang["accesskey_individual_timeline"]	= "T";
$pgv_lang["accesskey_individual_descendancy"]	= "D";
$pgv_lang["accesskey_individual_pedigree"]	= "P";
$pgv_lang["accesskey_individual_research_log"]	= "L";
$pgv_lang["accesskey_individual_media"]	= "A";
$pgv_lang["accesskey_individual_sources"]	= "O";
$pgv_lang["accesskey_individual_notes"]	= "N";
$pgv_lang["accesskey_individual_relatives"]	= "R";
$pgv_lang["accesskey_individual_details"]	= "I";
$pgv_lang["accesskey_contact"]	= "4";
$pgv_lang["accesskey_help_current_page"]	= "3";
$pgv_lang["accesskey_help_content"]	= "2";
$pgv_lang["accesskey_home_page"]	= "1";
$pgv_lang["accesskey_viewing_advice_desc"]	= "Nézeti tanács";
$pgv_lang["accesskey_viewing_advice"]	= "0";
$pgv_lang["accesskey_skip_to_content_desc"]	= "Ugás a Tartalomjegyzékhez";
$pgv_lang["accesskey_search"]	= "S";
$pgv_lang["accesskey_skip_to_content"]	= "C";
$pgv_lang["accesskeys"]				= "HotKey";
$pgv_lang["hs_searchconfig"]	= "Adminisztrátori Segitség";
$pgv_lang["hs_searchhow"]		= "Keresési tipus";
$pgv_lang["hs_searchall"]		= "Minden szó";
$pgv_lang["hs_searchany"]		= "Bármilyen szó";
$pgv_lang["hs_searchsentence"]	= "Pontos frázis";
$pgv_lang["hs_intruehelp"]		= "Csak Segítségi szöveg";
$pgv_lang["hs_inallhelp"]		= "Minden szöveg";
$pgv_lang["media_import"] = "Média importálás és konvertálás";
$pgv_lang["confirm_folder_delete"] = "Biztos benne hogy, ezt a mappát ki akarja törölni?";
$pgv_lang["account_information"] = "Felhasználói adat információ";
$pgv_lang["choose"] = "Válasszon: ";
$pgv_lang["TYPE__audio"] = "Hangfelvétel";
$pgv_lang["TYPE__book"] = "Könyv";
$pgv_lang["TYPE__document"] = "Dokument";
$pgv_lang["TYPE__film"] = "Mikrófilm";
$pgv_lang["TYPE__magazine"] = "Magazin";
$pgv_lang["TYPE__map"] = "Térkép";
$pgv_lang["TYPE__newspaper"] = "Újság";
$pgv_lang["TYPE__photo"] = "Foto";
$pgv_lang["TYPE__tombstone"] = "Sírkő";
$pgv_lang["TYPE__video"] = "Video";
	 
if (file_exists("languages/lang.hu.extra.php")) require "languages/lang.hu.extra.php";
?>
