/* This file is Copyright 1993 by Clifford A. Adams */
/* shfile.c
 *
 * help scan mode file code
 */

/* trim the list */
#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "intrp.h"
#include "shelp.h"
#include "shdata.h"
#include "shmisc.h"
#include "term.h"
#include "util.h"
#include "INTERN.h"
#include "shfile.h"

/* returns TRUE on success, FALSE otherwise */
bool
sh_use_file(fname,title)
char *fname;		/* file name */
char *title;		/* for top bar */
{
    static char lbuf[1024];
    FILE *fp;
    char *s,*p = Nullch;
    int i;

    if (strEQ(fname,"/NONE/"))
	return(TRUE);
    s = fname;
    if (*s == ':') {	/* relative to last file's directory */
	if (sh_num_contexts==0) {
	    /* really shouldn't happen */
	    printf("\nsh_use_file: top level filename error\n") FLUSH;
	    return(FALSE);
	}
	for (i=sh_num_contexts-1;i>=0;i--)
	    if ((p=sh_contexts[i].filename))	/* EQUALS */
		break;
	if (i<0) {	/* no file found */
	    printf("\nsh_use_file internal error: current not found\n") FLUSH;
	    /* consider doing an assertion? something is really wrong */
	    return(FALSE);
	}
	strcpy(lbuf,p);
	p = rindex(lbuf,'/');
	if (!p) {
	    printf("\nsh_use_file: current has no slash\n") FLUSH;
	    return(FALSE);
	}
	p++;					/* point to after slash */
	strcpy(p,s+1);
	s = lbuf;
    }
/*    printf("\nAttempting to open file %s\n",s) FLUSH; /* */
    fp = fopen(filexp(s),"r");
    if (!fp)
	return(FALSE);		/* unsuccessful */
    (void)sh_new_context();
    sh_contexts[sh_num_contexts-1].title = savestr(title);
    sh_contexts[sh_num_contexts-1].filename = savestr(s);

/* Later considerations:
 * 1. Long lines
 * 2. Backslash continuations
 */
    while ((s = fgets(lbuf,1020,fp))) {		/* EQUALS */
	if (!s)		/* end of file */
	    break;
	sh_do_line(s);
    }
    fclose(fp);
    return(TRUE);
}

/* if non-NULL, is the description (printing name) of the entry */
static char *sh_line_desc;

void
sh_do_line(line)
char *line;
{
    char *s;
    char *p;
    long e;		/* entry index */

    s = line;

    if (s[strlen(s)-1] == '\n')
	s[strlen(s)-1] = '\0';		/* delete newline */
    while ((*s == ' ') || (*s == '\t'))
	s++;		/* delete whitespace */

    if (sh_line_desc) {
	free(sh_line_desc);
	sh_line_desc = (char*)NULL;
    }
    if (*s == '"') {	/* description name */
	/* try handling backslashes later?  Perhaps other special cases? */
	s++;
	for (p=s;*p && *p != '"';p++)
	    ;	/* EMPTY */
	if (!*p) {
	    printf("help scan: unfinished quote.  Line was:\n%s\n",
		   line) FLUSH;
	    return;
	}
	*p = '\0';
	sh_line_desc = savestr(s);
	*p = '"';
	++p;
	s = p;
    }
    while ((*s == ' ') || (*s == '\t'))
	s++;		/* delete whitespace */
    switch (*s) {
	case '#':	/* comment */
	    break;
	case ':':	/* relative to sh_root */
	case '~':
	case '/':
	    /* description defaults to name */
	    if (sh_line_desc)
		e = sh_add_ent(2,sh_line_desc);
	    else
		e = sh_add_ent(2,s);
	    sh_ents[e].file = savestr(s);
	    break;
	default:
	    /* help file */
	    if (sh_line_desc) {
		e = sh_add_ent(1,sh_line_desc);
		sh_ents[e].file = savestr(s);
		break;
	    }
	    break;
    }
}

/* edits the current file */
void
sh_edit_file(fname,current)
char *fname;
bool_int current;	/* if true, edit from current directory */
{
    char *s,*p = Nullch;
    int i;
    char lbuf[LBUFLEN];	/* hold the filename */
    char wherebuf[LBUFLEN];	/* where were we? */

    if (!fname || !*fname)
	return;		/* empty, do nothing (error later?) */
    
    /* section copied from use_file */
    if (strEQ(fname,"/NONE/"))
	return;
    s = fname;
    if (current || (*s == ':')) {	/* relative to last directory */
	if (sh_num_contexts==0) {
	    /* really shouldn't happen */
/*	    printf("\nsh_edit_file: top level filename error\n") FLUSH; /**/
	    return;
	}
	for (i=sh_num_contexts-1;i>=0;i--)
	    if ((p=sh_contexts[i].filename))	/* EQUALS */
		break;
	if (i<0) {	/* no file found */
	    printf("\nsh_edit_file internal error: current not found\n") FLUSH;
	    /* consider doing an assertion? something is really wrong */
	    return;
	}
	strcpy(lbuf,p);
	p = rindex(lbuf,'/');
	if (!p) {
/*	    printf("\nsh_use_file: current has no slash\n") FLUSH; /**/
	    return;
	}
	p++;					/* point to after slash */
	if (*s == ':')
	    s++;
	safecpy(p,s,LBUFLEN-4);
	safecpy(lbuf,filexp(lbuf),LBUFLEN-4);
    } else {
	safecpy(lbuf,filexp(fname),LBUFLEN-4);
    }

    sprintf(cmd_buf,"%s %s",
	filexp(getval("VISUAL",getval("EDITOR",defeditor))),lbuf);
    printf("\nEditing help scan topic file %s:\n%s\n",fname,cmd_buf) FLUSH;
    s = rindex(lbuf,'/');
    if (!s)
	return;		/* error, but not critical */
    if (s == lbuf)	/* wow, file in root directory */
	s++;		/* will need the slash */
    *s = '\0';	/* cut off after directory name */
    getwd(wherebuf);	/* find out where we are */
    if (chdir(lbuf)) {
	printf(nocd,lbuf) FLUSH;
	return;
    }
    resetty();			/* make sure tty is friendly */
    doshell(sh,cmd_buf);/* invoke the shell */
    noecho();			/* and make terminal */
    crmode();			/*   unfriendly again */
    if (chdir(wherebuf)) {
	printf(nocd,wherebuf) FLUSH;
    }
}
#endif /* SCAN */
