(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require int.Abs.
Require int.ComputerDivision.
Require option.Option.
Require list.List.
Require list.Mem.
Require map.Map.

(* Why3 assumption *)
Definition unit := unit.

Axiom qtmark : Type.
Parameter qtmark_WhyType : WhyType qtmark.
Existing Instance qtmark_WhyType.

(* Why3 assumption *)
Inductive array (a:Type) :=
  | mk_array : Z -> (map.Map.map Z a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(array a)): (map.Map.map Z a) :=
  match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(array a)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z) (v:a): (array
  a) := (mk_array (length a1) (map.Map.set (elts a1) i v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a} (n:Z) (v:a): (array a) :=
  (mk_array n (map.Map.const v: (map.Map.map Z a))).

Axiom key : Type.
Parameter key_WhyType : WhyType key.
Existing Instance key_WhyType.

Parameter hash: key -> Z.

Axiom hash_nonneg : forall (k:key), (0%Z <= (hash k))%Z.

(* Why3 assumption *)
Definition bucket (k:key) (n:Z): Z := (ZArith.BinInt.Z.rem (hash k) n).

Axiom bucket_bounds : forall (n:Z), (0%Z < n)%Z -> forall (k:key),
  (0%Z <= (bucket k n))%Z /\ ((bucket k n) < n)%Z.

(* Why3 assumption *)
Definition in_data {a:Type} {a_WT:WhyType a} (k:key) (v:a) (d:(array
  (list (key* a)%type))): Prop := (list.Mem.mem (k, v) (get d (bucket k
  (length d)))).

(* Why3 assumption *)
Definition good_data {a:Type} {a_WT:WhyType a} (k:key) (v:a) (m:(map.Map.map
  key (option a))) (d:(array (list (key* a)%type))): Prop := ((map.Map.get m
  k) = (Init.Datatypes.Some v)) <-> (in_data k v d).

(* Why3 assumption *)
Definition good_hash {a:Type} {a_WT:WhyType a} (d:(array (list (key*
  a)%type))) (i:Z): Prop := forall (k:key) (v:a), (list.Mem.mem (k, v) (get d
  i)) -> ((bucket k (length d)) = i).

(* Why3 assumption *)
Inductive t
  (a:Type) :=
  | mk_t : Z -> (array (list (key* a)%type)) -> (map.Map.map key
      (option a)) -> t a.
Axiom t_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (t a).
Existing Instance t_WhyType.
Implicit Arguments mk_t [[a]].

(* Why3 assumption *)
Definition view {a:Type} {a_WT:WhyType a} (v:(t a)): (map.Map.map key
  (option a)) := match v with
  | (mk_t x x1 x2) => x2
  end.

(* Why3 assumption *)
Definition data {a:Type} {a_WT:WhyType a} (v:(t a)): (array (list (key*
  a)%type)) := match v with
  | (mk_t x x1 x2) => x1
  end.

(* Why3 assumption *)
Definition size {a:Type} {a_WT:WhyType a} (v:(t a)): Z :=
  match v with
  | (mk_t x x1 x2) => x
  end.

(* Why3 goal *)
Theorem WP_parameter_remove : forall {a:Type} {a_WT:WhyType a}, forall (h:Z)
  (h1:(map.Map.map Z (list (key* a)%type))) (h2:(map.Map.map key (option a)))
  (k:key), (((0%Z < h)%Z /\ ((forall (i:Z), ((0%Z <= i)%Z /\ (i < h)%Z) ->
  (good_hash (mk_array h h1) i)) /\ forall (k1:key) (v:a), (good_data k1 v h2
  (mk_array h h1)))) /\ (0%Z <= h)%Z) -> let i := (bucket k h) in
  (((0%Z <= i)%Z /\ (i < h)%Z) -> let l := (map.Map.get h1 i) in
  forall (result:(option a)),
  match result with
  | Init.Datatypes.None => forall (v:a), ~ (list.Mem.mem (k, v) l)
  | (Init.Datatypes.Some v) => (list.Mem.mem (k, v) l)
  end -> ((result = Init.Datatypes.None) -> ((map.Map.get h2
  k) = Init.Datatypes.None))).
(* Why3 intros a a_WT h h1 h2 k ((h1,(h2,h3)),h4) i (h5,h6) l result h7 h8. *)
intros a a_WT rho rho1 rho2 k ((h1,(h2,h3)),h4) i (h5,h6) l result h7 h8.
subst i.
subst result.
subst l.
unfold good_data in h3.
generalize (h3 k); clear h3; intro h3.
destruct (Map.get rho2 k); intuition.
generalize (h3 a0); clear h3; intro h3.
generalize (h7 a0); clear h7; intro h7.
intuition.
Qed.

