/*
 * Copyright (C) 1999-2001 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jonathan@daria.co.uk>
 * Modified by Mario Motta <mmotta@guest.net>
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdkinchannel.h"
#include <vdk/forms.h>

VDKInputChannel::VDKInputChannel(VDKForm* obj,int fd, GdkInputCondition c):
        VDKObject(obj->Owner ()), tag(0), fd(fd),
        condition(c)
{
    tag = gdk_input_add(fd, c, VDKInputChannel::HandleIO, this);
    obj->Objects().add(this);
    Parent(obj);
}

VDKInputChannel::~VDKInputChannel()
{
    gdk_input_remove(tag);
}

void VDKInputChannel::HandleIO(gpointer gp, gint source, GdkInputCondition condition)
{
  VDKInputChannel *ip = static_cast<VDKInputChannel*>(gp);
  ip->condition = condition;
  ip->SignalEmit(INPUT_SIGNAL);
  ip->SignalEmit("input_signal");
}

