/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef SPINS_H
#define SPINS_H
#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>
/*!
  \class VDKSpinButton
  \brief Provides a spin button widget
  \par SIGNALS
  \arg \b value_changed_signal received whenever spin value changes.
  \arg \b focus_out_signal received whenever the entry part of spin
  looses focus.
  \par TIP
  If you want connect to "value_changed" using dynamics table you have
  use <gtk> arg set to false.
  \code
  SignalConnect(spinbutton,"value_changed",&MyForm::Handler,false);
  \endcode
  The reason is that "value_changed" is hooked to an internal 
  adjustement object not accessible by user code.
  Setting <gtk> arg of SignalConnect() make vdk to treat signal internally
  overriding gtk+ signal system.
  \par EXAMPLES
  Into ./testvdk/rangewin.cc
*/
class VDKSpinButton: public VDKObject
{
  static void ValueChanged(GtkWidget *wid, gpointer gp);
  static void OnValueChanged(GtkWidget *wid, gpointer gp);
  GtkObject* adj; 
 public:
  //properties
  /*!
    Sets/gets spin value in float format
   */
  VDKReadWriteValueProp<VDKSpinButton,float> ValueAsFloat;
  /*!
    Sets/gets spin value in int format
   */
  VDKReadOnlyValueProp<VDKSpinButton,int>    ValueAsInt;
    /*!
    Sets/gets spin precison
   */
  VDKReadWriteValueProp<VDKSpinButton, int>  Digits;
    /*!
      Sets/gets spin lower bound
    */
  VDKReadWriteValueProp<VDKSpinButton, float>  LowerBound;
    /*!
      Sets/gets spin upper bound
    */
  VDKReadWriteValueProp<VDKSpinButton, float>  UpperBound;
  /*!
    Constructor
    \param owner
    \param defValue initial default value
    \param lower lower bound
    \param upper bound
    \param step_increment
    \param climb_rate
   */
  VDKSpinButton(VDKForm* owner,
	    float defValue,
	    float lower,
	    float upper,
	    float step_increment,
	    float climb_rate);
  /*!
    Destructor
   */
  virtual ~VDKSpinButton();

  void SetDigits(int digits);
  int GetValueAsInt();
  void SetValueAsFloat(float f);
  float GetValueAsFloat();
  void SetLowerBound(float f);
  float GetLowerBound();
  void SetUpperBound(float f);
  float GetUpperBound();
  /*!
    Sets object foreground
    \param   color a VDKRgb object
    \param   state can be one of the gtk+ widget states
  */
  virtual void SetForeground(VDKRgb color,
                               GtkStateType state = GTK_STATE_NORMAL);
  /*!
    Sets object background
    \param   color a VDKRgb object
    \param   state can be one of the gtk+ widget states
  */
  virtual void SetBackground(VDKRgb color,
			     GtkStateType state = GTK_STATE_NORMAL);

#ifdef USE_SIGCPLUSPLUS 
 public:
 /*!
    Extended LS signal system:
    Received when spin value changes
    \param float spin value
  */
  VDKSignal1<void, float> OnSpinValueChanged;
#endif /* USE_SIGCPLUSPLUS */
};
#endif
