-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
package body Dependency_Relation is

   procedure Create_Full_Dependency
     (Node_Pos                 : in LexTokenManager.Token_Position;
      Subprog_Sym              : in Dictionary.Symbol;
      Abstraction              : in Dictionary.Abstractions;
      Import_List, Export_List : in SeqAlgebra.Seq;
      The_Heap                 : in Heap.HeapRecord)
   --# global in     ContextManager.Ops.Unit_Stack;
   --#        in     LexTokenManager.State;
   --#        in out Dictionary.Dict;
   --#        in out SPARK_IO.File_Sys;
   --# derives Dictionary.Dict   from *,
   --#                                Abstraction,
   --#                                ContextManager.Ops.Unit_Stack,
   --#                                Export_List,
   --#                                Import_List,
   --#                                Node_Pos,
   --#                                Subprog_Sym,
   --#                                The_Heap &
   --#         SPARK_IO.File_Sys from *,
   --#                                Abstraction,
   --#                                ContextManager.Ops.Unit_Stack,
   --#                                Dictionary.Dict,
   --#                                Export_List,
   --#                                Import_List,
   --#                                LexTokenManager.State,
   --#                                Node_Pos,
   --#                                Subprog_Sym,
   --#                                The_Heap;
      is separate;

   -----------------------------------------------------------------------

   procedure Check_Derives_Consistency
     (Subprog_Sym : in     Dictionary.Symbol;
      Position    : in     LexTokenManager.Token_Position;
      The_Heap    : in out Heap.HeapRecord)
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Statistics.TableUsage;
   --# derives ErrorHandler.Error_Context,
   --#         SPARK_IO.File_Sys          from CommandLineData.Content,
   --#                                         Dictionary.Dict,
   --#                                         ErrorHandler.Error_Context,
   --#                                         LexTokenManager.State,
   --#                                         Position,
   --#                                         SPARK_IO.File_Sys,
   --#                                         Subprog_Sym,
   --#                                         The_Heap &
   --#         Statistics.TableUsage,
   --#         The_Heap                   from *,
   --#                                         Dictionary.Dict,
   --#                                         Subprog_Sym,
   --#                                         The_Heap;
      is separate;

   --------------------------------------------------------------------------

   procedure Create_Full_Subprog_Dependency
     (Node_Pos    : in     LexTokenManager.Token_Position;
      Subprog_Sym : in     Dictionary.Symbol;
      Abstraction : in     Dictionary.Abstractions;
      The_Heap    : in out Heap.HeapRecord)
      is separate;

   ---------------------------------------------------------------------

   procedure Wf_Dependency_Relation
     (Node         : in     STree.SyntaxNode;
      Scope        : in     Dictionary.Scopes;
      Subprog_Sym  : in     Dictionary.Symbol;
      First_Seen   : in     Boolean;
      Glob_Def_Err : in     Boolean;
      The_Heap     : in out Heap.HeapRecord)
      is separate;

end Dependency_Relation;
