libcxl
======
The coherent accelerator interface is designed to allow the coherent connection
of accelerators (FPGAs and other devices) to a POWER system. Coherent in this
context means that the accelerator and CPUs can both access system memory
directly and with the same effective addresses. IBM refers to this as the
Coherent Accelerator Processor Interface (CAPI). In the Linux world it is
referred to by the name CXL to avoid confusion with the ISDN CAPI subsystem.

The Linux kernel interacts with the device POWER Service Layer (PSL). Userland
interacts with the device Accelerator Function Unit (AFU). See the Linux kernel
source file [Documentation/powerpc/cxl.txt][1] for a detailed description of
the coherent accelerator interface.

The CXL library provides a userland API to coherently attached devices. CXL
devices can be enumerated. Their capabilities can be queried. AFUs can be
opened, attached to the current process, and started. Jobs, described by AFU
specific Work Element Descriptors (WEDs), can be submitted and executed by
AFUs. AFU MMIO space can be mapped into the current process memory, and AFUs
can be configured and controlled via MMIO reads and writes.

[1]: https://git.kernel.org/cgit/linux/kernel/git/torvalds/linux.git/plain/Documentation/powerpc/cxl.txt
