(*
 * ExtLib Testing Suite
 * Copyright (C) 2004, 2007 Janne Hellsten
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version,
 * with the special exception on linking described in file LICENSE.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *)

(* test_unzip_bug1 test case was contributed by Robert Atkey on
   ocaml-lib-devel@lists.sourceforge.net on Nov 26, 2007.  
   Thanks Rob! *)

let test_unzip_bug1 () =
  let test data =
    let input    = IO.input_string data in
    let unzipped = Unzip.inflate input in
    try
      let str      = IO.read_all unzipped in
      assert (str = "XY")
    with Unzip.Error Unzip.Invalid_data -> assert false
  in
  (* this is "XY" compressed by zlib at level 9 *)
  test "\x78\xda\x8b\x88\x04\x00\x01\x0b\x00\xb2";
  (* this is "XY" compressed by zlib at level 0 *)
  test "\x78\x01\x01\x02\x00\xfd\xff\x58\x59\x01\x0b\x00\xb2"

(* Some zlib compressed strings with various compression levels.  See
   extlib-test/util/zlib-test/gen_ml.sh for more info.  This is not
   very exhaustive but is still better than nothing.  The generation
   script should be pretty easy to extend to cover longer strings. *)
let inputs = 
  [("a", "\x78\x01\x4b\x04\x00\x00\x62\x00\x62");
   ("a", "\x78\x5e\x4b\x04\x00\x00\x62\x00\x62");
   ("a", "\x78\x9c\x4b\x04\x00\x00\x62\x00\x62");
   ("a", "\x78\xda\x4b\x04\x00\x00\x62\x00\x62");
   ("b", "\x78\x01\x4b\x02\x00\x00\x63\x00\x63");
   ("b", "\x78\x5e\x4b\x02\x00\x00\x63\x00\x63");
   ("b", "\x78\x9c\x4b\x02\x00\x00\x63\x00\x63");
   ("b", "\x78\xda\x4b\x02\x00\x00\x63\x00\x63");
   ("c", "\x78\x01\x4b\x06\x00\x00\x64\x00\x64");
   ("c", "\x78\x5e\x4b\x06\x00\x00\x64\x00\x64");
   ("c", "\x78\x9c\x4b\x06\x00\x00\x64\x00\x64");
   ("c", "\x78\xda\x4b\x06\x00\x00\x64\x00\x64");
   ("aa", "\x78\x01\x4b\x4c\x04\x00\x01\x25\x00\xc3");
   ("aa", "\x78\x5e\x4b\x4c\x04\x00\x01\x25\x00\xc3");
   ("aa", "\x78\x9c\x4b\x4c\x04\x00\x01\x25\x00\xc3");
   ("aa", "\x78\xda\x4b\x4c\x04\x00\x01\x25\x00\xc3");
   ("aaa", "\x78\x01\x4b\x4c\x4c\x04\x00\x02\x49\x01\x24");
   ("aaa", "\x78\x5e\x4b\x4c\x4c\x04\x00\x02\x49\x01\x24");
   ("aaa", "\x78\x9c\x4b\x4c\x4c\x04\x00\x02\x49\x01\x24");
   ("aaa", "\x78\xda\x4b\x4c\x4c\x04\x00\x02\x49\x01\x24");
   ("aaaa", "\x78\x01\x4b\x4c\x4c\x4c\x04\x00\x03\xce\x01\x85");
   ("aaaa", "\x78\x5e\x4b\x4c\x4c\x4c\x04\x00\x03\xce\x01\x85");
   ("aaaa", "\x78\x9c\x4b\x4c\x4c\x4c\x04\x00\x03\xce\x01\x85");
   ("aaaa", "\x78\xda\x4b\x4c\x4c\x4c\x04\x00\x03\xce\x01\x85");
   ("foobar", "\x78\x01\x4b\xcb\xcf\x4f\x4a\x2c\x02\x00\x08\xab\x02\x7a");
   ("foobar", "\x78\x5e\x4b\xcb\xcf\x4f\x4a\x2c\x02\x00\x08\xab\x02\x7a");
   ("foobar", "\x78\x9c\x4b\xcb\xcf\x4f\x4a\x2c\x02\x00\x08\xab\x02\x7a");
   ("foobar", "\x78\xda\x4b\xcb\xcf\x4f\x4a\x2c\x02\x00\x08\xab\x02\x7a");
   ("012345678", "\x78\x01\x33\x30\x34\x32\x36\x31\x35\x33\xb7\x00\x00\x08\xf1\x01\xd5");
   ("012345678", "\x78\x5e\x33\x30\x34\x32\x36\x31\x35\x33\xb7\x00\x00\x08\xf1\x01\xd5");
   ("012345678", "\x78\x9c\x33\x30\x34\x32\x36\x31\x35\x33\xb7\x00\x00\x08\xf1\x01\xd5");
   ("012345678", "\x78\xda\x33\x30\x34\x32\x36\x31\x35\x33\xb7\x00\x00\x08\xf1\x01\xd5");
   ("00000000", "\x78\x01\x33\x30\x80\x00\x00\x06\xc8\x01\x81");
   ("00000000", "\x78\x5e\x33\x30\x80\x00\x00\x06\xc8\x01\x81");
   ("00000000", "\x78\x9c\x33\x30\x80\x00\x00\x06\xc8\x01\x81");
   ("00000000", "\x78\xda\x33\x30\x80\x00\x00\x06\xc8\x01\x81");
   ("aaaaaaaaaa", "\x78\x01\x4b\x4c\x84\x01\x00\x14\xe1\x03\xcb");
   ("aaaaaaaaaa", "\x78\x5e\x4b\x4c\x84\x01\x00\x14\xe1\x03\xcb");
   ("aaaaaaaaaa", "\x78\x9c\x4b\x4c\x84\x01\x00\x14\xe1\x03\xcb");
   ("aaaaaaaaaa", "\x78\xda\x4b\x4c\x84\x01\x00\x14\xe1\x03\xcb");
   ("-------------------------aaaaaaaaa------------------", "\x78\x01\xd3\xd5\xc5\x01\x12\x61\x00\x53\x1e\x00\x1c\x89\x0a\xf9");
   ("-------------------------aaaaaaaaa------------------", "\x78\x5e\xd3\xd5\xc5\x01\x12\x61\x00\x53\x1e\x00\x1c\x89\x0a\xf9");
   ("-------------------------aaaaaaaaa------------------", "\x78\x5e\xd3\xd5\xc5\x01\x12\x61\x00\x5d\x42\x57\x17\x00\x1c\x89\x0a\xf9");
   ("-------------------------aaaaaaaaa------------------", "\x78\x5e\xd3\xd5\xc5\x01\x12\x61\x00\x53\x0a\x00\x1c\x89\x0a\xf9");
   ("-------------------------aaaaaaaaa------------------", "\x78\x9c\xd3\xd5\xc5\x01\x12\x61\x00\x53\x0a\x00\x1c\x89\x0a\xf9");
   ("-------------------------aaaaaaaaa------------------", "\x78\xda\xd3\xd5\xc5\x01\x12\x61\x00\x53\x0a\x00\x1c\x89\x0a\xf9")]

let test_unzip_gen_inputs () =
  let test orig data =
    let input    = IO.input_string data in
    let unzipped = Unzip.inflate input in
    try
      let str      = IO.read_all unzipped in
      assert (str = orig)
    with Unzip.Error Unzip.Invalid_data -> assert false
  in
  List.iter
    (fun (orig,compressed) ->
       test orig compressed)
    inputs

let () = 
  Util.register "Unzip" [
    "bug1", test_unzip_bug1;
    "gen_inputs", test_unzip_gen_inputs;
  ]
