/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Binding;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.SAXONFunction;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.style.XSLTemplate;
import org.xml.sax.SAXException;

public abstract class XSLGeneralVariable
extends StyleElement {
    protected String variableName = null;
    protected Expression select = null;
    protected boolean global;
    protected Procedure procedure = null;
    protected boolean assignable = false;
    private Name saxonAssignable = Name.reconstruct("saxon", "http://icl.com/saxon", "assignable");

    public boolean isGlobal() throws SAXException {
        return this.getParentNode() instanceof XSLStyleSheet;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public Procedure getOwningProcedure() throws SAXException {
        NodeInfo nodeInfo = this;
        while (true) {
            NodeInfo nodeInfo2;
            if ((nodeInfo2 = (NodeInfo)nodeInfo.getParentNode()) instanceof XSLStyleSheet) {
                if (nodeInfo instanceof XSLTemplate) {
                    return ((XSLTemplate)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof XSLGeneralVariable) {
                    return ((XSLGeneralVariable)nodeInfo).getProcedure();
                }
                if (nodeInfo instanceof SAXONFunction) {
                    return ((SAXONFunction)nodeInfo).getProcedure();
                }
                throw new SAXException("Local variable must be within xsl:template or xsl:variable");
            }
            nodeInfo = nodeInfo2;
        }
    }

    public void preprocess() throws SAXException {
        if (this.global) {
            this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
        }
    }

    public String getVariableName() throws SAXException {
        if (this.variableName == null) {
            String string = this.getAttributeValue("name");
            if (string == null) {
                this.reportAbsence("name");
            }
            this.variableName = new Name(string, this, false).getAbsoluteName();
        }
        return this.variableName;
    }

    public void prepareAttributes() throws SAXException {
        String string;
        String[] stringArray = new String[]{"name", "select"};
        this.allowAttributes(stringArray);
        this.getVariableName();
        String string2 = this.getAttributeValue("select");
        if (string2 != null) {
            this.select = Expression.make(string2, this);
        }
        if ((string = this.getAttributeValue(this.saxonAssignable)) != null && string.equals("yes")) {
            this.assignable = true;
        }
    }

    public void validate() throws SAXException {
        this.global = this.getParentNode() instanceof XSLStyleSheet;
        if (this.global) {
            this.procedure = new Procedure();
        }
        if (this.select != null && this.getFirstChild() != null) {
            throw this.styleError("An " + this.getDisplayName() + " element with a select attribute must be empty");
        }
        if (this.select == null && this.getNumberOfChildren() == 0) {
            this.select = new StringValue("");
        }
    }

    public void checkDuplicateDeclaration() throws SAXException {
        Binding binding = this.getVariableBinding(this.getVariableName());
        if (binding != null) {
            if (this.global) {
                if (((XSLGeneralVariable)((Object)binding)).getPrecedence() == this.getPrecedence()) {
                    throw this.styleError("Duplicate global variable declaration");
                }
            } else if (!binding.isGlobal()) {
                throw this.styleError("Variable is already declared in this template");
            }
        }
    }

    protected Value getSelectValue(Context context) throws SAXException {
        if (this.select == null) {
            FragmentValue fragmentValue = new FragmentValue();
            Controller controller = context.getController();
            OutputDetails outputDetails = new OutputDetails();
            outputDetails.setMethod("saxon:fragment");
            outputDetails.setEmitter(fragmentValue.getEmitter());
            controller.setNewOutputDetails(outputDetails);
            if (this.global && this.procedure.getNumberOfVariables() > 0) {
                Bindery bindery = context.getBindery();
                bindery.openStackFrame(new ParameterSet());
                this.processChildren(context);
                bindery.closeStackFrame();
            } else {
                this.processChildren(context);
            }
            controller.resetOutputDetails();
            fragmentValue.setBaseURI(this.getSystemId());
            return fragmentValue;
        }
        return this.select.evaluate(context);
    }

    public Procedure getProcedure() {
        return this.procedure;
    }
}

