/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.DOMDriver;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.style.LiteralResultElement;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.StyleNodeFactory;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.trax.URIResolver;
import com.icl.saxon.tree.Builder;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.Stripper;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    String href;
    DocumentInfo includedDoc;

    public abstract boolean isImport() throws SAXException;

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"href"};
        this.allowAttributes(stringArray);
        this.href = this.attributeList.getValue("href");
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws SAXException {
    }

    public XSLStyleSheet getIncludedStyleSheet(XSLStyleSheet xSLStyleSheet, int n) throws SAXException {
        Node node;
        XSLStyleSheet xSLStyleSheet2 = (XSLStyleSheet)this.getParentNode();
        DocumentInfo documentInfo = this.getDocumentRoot();
        URIResolver uRIResolver = this.getPreparedStyleSheet().getURIResolver();
        uRIResolver.setURI(this.getSystemId(), this.href);
        InputSource inputSource = uRIResolver.getInputSource();
        XMLReader xMLReader = uRIResolver.getXMLReader();
        if (inputSource == null) {
            node = uRIResolver.getDOMNode();
            if (node == null) {
                throw new SAXException("URI Resolver for stylesheet modules must return either a SAX InputSource or a DOM Node");
            }
            xMLReader = new DOMDriver();
            ((DOMDriver)xMLReader).setStartNode(node);
            inputSource = new InputSource();
            inputSource.setSystemId(uRIResolver.getURI());
        }
        if (xMLReader == null) {
            xMLReader = this.getPreparedStyleSheet().getXMLReader();
        }
        node = xSLStyleSheet2;
        while (node != null) {
            if (inputSource.getSystemId().equals(((ElementImpl)node).getSystemId())) {
                throw this.styleError("A stylesheet cannot " + this.getLocalName() + " itself");
            }
            node = ((XSLStyleSheet)node).getImporter();
        }
        Stripper stripper = new Stripper();
        stripper.setPreserveSpace(new AnyNameTest(), false);
        stripper.setPreserveSpace(new Name("xsl", "http://www.w3.org/1999/XSL/Transform", "text"), true);
        Builder builder = new Builder();
        builder.setStripper(stripper);
        builder.setNodeFactory(new StyleNodeFactory());
        builder.setDiscardCommentsAndPIs(true);
        builder.setXMLReader(xMLReader);
        builder.setLineNumbering(true);
        this.includedDoc = builder.build(inputSource);
        ElementInfo elementInfo = (ElementInfo)((Object)this.includedDoc.getDocumentElement());
        if (elementInfo instanceof LiteralResultElement) {
            ((LiteralResultElement)elementInfo).makeStyleSheet();
            elementInfo = (ElementInfo)((Object)this.includedDoc.getDocumentElement());
        }
        if (!(elementInfo instanceof XSLStyleSheet)) {
            throw this.styleError("Included document " + this.href + " is not a stylesheet");
        }
        XSLStyleSheet xSLStyleSheet3 = (XSLStyleSheet)elementInfo;
        xSLStyleSheet3.setPrecedence(n);
        xSLStyleSheet3.setImporter(xSLStyleSheet);
        xSLStyleSheet3.spliceIncludes();
        return xSLStyleSheet3;
    }

    public void process(Context context) throws SAXException {
    }
}

