/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.CharacterSet;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.OutputDetails;
import java.io.Writer;
import java.util.Vector;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DocumentHandlerProxy
implements Emitter {
    protected DocumentHandler handler;
    protected Writer writer;
    protected CharacterSet characterSet;
    protected OutputDetails outputDetails;
    protected Vector namespaces = new Vector();
    private int depth = 0;

    public void setUnderlyingDocumentHandler(DocumentHandler documentHandler) {
        this.handler = documentHandler;
    }

    public void setWriter(Writer writer) throws SAXException {
    }

    public void setCharacterSet(CharacterSet characterSet) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        if (this.handler != null) {
            this.handler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.handler == null) {
            throw new SAXException("DocumentHandlerProxy.startDocument(): no underlying handler provided");
        }
        this.handler.startDocument();
        this.depth = 0;
    }

    public void endDocument() throws SAXException {
        this.handler.endDocument();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.namespaces.addElement(string);
        this.namespaces.addElement(string2);
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        ++this.depth;
        if (this.depth > 0) {
            int n = 0;
            while (n < this.namespaces.size()) {
                String string = (String)this.namespaces.elementAt(n);
                String string2 = (String)this.namespaces.elementAt(n + 1);
                if (string.equals("")) {
                    attributeCollection.addAttribute(new Name("xmlns"), "NMTOKEN", string2);
                } else {
                    attributeCollection.addAttribute(new Name("xmlns", "NS_URI", string), "NMTOKEN", string2);
                }
                n += 2;
            }
            this.namespaces.removeAllElements();
            this.handler.startElement(name.getDisplayName(), attributeCollection);
        }
    }

    public void endElement(Name name) throws SAXException {
        if (this.depth > 0) {
            this.handler.endElement(name.getDisplayName());
        }
        --this.depth;
        if (this.depth <= 0) {
            this.depth = Integer.MIN_VALUE;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth > 0) {
            this.handler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.depth > 0) {
            this.handler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.handler.processingInstruction(string, string2);
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    public void setEscaping(boolean bl) throws SAXException {
    }

    public void setIndenting(boolean bl) {
    }

    public void setOutputDetails(OutputDetails outputDetails) throws SAXException {
        this.outputDetails = outputDetails;
    }
}

