/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Value;
import java.util.Vector;
import org.xml.sax.SAXException;

public abstract class Function
extends Expression {
    protected Vector arguments = new Vector(4);

    public void addArgument(Expression expression) {
        this.arguments.addElement(expression);
    }

    public abstract String getName();

    public Expression simplify() throws SAXException {
        return this.basicSimplify();
    }

    private Expression basicSimplify() throws SAXException {
        int n = 0;
        while (n < this.arguments.size()) {
            Expression expression = ((Expression)this.arguments.elementAt(n)).simplify();
            this.arguments.setElementAt(expression, n);
            ++n;
        }
        return this;
    }

    public Expression simplifyPureFunction() throws SAXException {
        this.basicSimplify();
        int n = 0;
        while (n < this.arguments.size()) {
            Expression expression = (Expression)this.arguments.elementAt(n);
            if (!(expression instanceof Value)) {
                return this;
            }
            ++n;
        }
        return this.evaluate(null);
    }

    public Value evaluate(Context context) throws SAXException {
        if (this.arguments.size() == 0) {
            return this.eval(this.arguments, context);
        }
        Vector<Value> vector = new Vector<Value>(this.arguments.size());
        int n = 0;
        while (n < this.arguments.size()) {
            Value value = ((Expression)this.arguments.elementAt(n)).evaluate(context);
            vector.addElement(value);
            ++n;
        }
        return this.eval(vector, context);
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public int getDependencies() {
        int n = this.getIntrinsicDependencies();
        int n2 = 0;
        while (n2 < this.arguments.size()) {
            Expression expression = (Expression)this.arguments.elementAt(n2);
            n |= expression.getDependencies();
            ++n2;
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if ((n & this.getDependencies()) != 0) {
            Function function = this.newInstance();
            if (this.arguments.size() > 0) {
                int n2 = 0;
                while (n2 < this.arguments.size()) {
                    Expression expression = (Expression)this.arguments.elementAt(n2);
                    Expression expression2 = expression.reduce(n, context);
                    function.addArgument(expression2);
                    ++n2;
                }
            }
            if ((n & this.getIntrinsicDependencies()) != 0) {
                Expression expression = function.reduceIntrinsic(n, context);
                expression.setStaticContext(this.getStaticContext());
                return expression.simplify();
            }
            function.setStaticContext(this.getStaticContext());
            return function.simplify();
        }
        return this;
    }

    public Function newInstance() throws SAXException {
        Function function;
        try {
            function = (Function)this.getClass().newInstance();
            function.setStaticContext(this.getStaticContext());
        }
        catch (Exception exception) {
            throw new SAXException("Internal failure replicating function instance", exception);
        }
        return function;
    }

    protected Expression reduceIntrinsic(int n, Context context) throws SAXException {
        return this;
    }

    public abstract Value eval(Vector var1, Context var2) throws SAXException;

    public String toString() {
        String string = this.getName() + "(";
        int n = 0;
        while (n < this.arguments.size()) {
            string = string + this.arguments.elementAt(n).toString();
            if (n < this.arguments.size() - 1) {
                string = string + ", ";
            }
            ++n;
        }
        return string + ")";
    }

    protected int checkArgumentCount(int n, int n2) throws SAXException {
        int n3 = this.arguments.size();
        if (n == n2 && n3 != n) {
            throw new SAXException("Function " + this.getName() + " must have " + n + this.pluralArguments(n));
        }
        if (n3 < n) {
            throw new SAXException("Function " + this.getName() + " must have at least " + n + this.pluralArguments(n));
        }
        if (n3 > n2) {
            throw new SAXException("Function " + this.getName() + " must have no more than " + n2 + this.pluralArguments(n2));
        }
        return n3;
    }

    private String pluralArguments(int n) {
        if (n == 1) {
            return " argument";
        }
        return " arguments";
    }
}

