/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.SingletonExpression;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import org.xml.sax.SAXException;

class AttributeReference
extends SingletonExpression {
    private Name name;
    private NodeInfo boundParentNode = null;

    public AttributeReference(Name name) {
        this.name = name;
    }

    public void bindParentNode(NodeInfo nodeInfo) {
        this.boundParentNode = nodeInfo;
    }

    private NodeInfo getParentNode(Context context) {
        if (this.boundParentNode == null) {
            return context.getContextNode();
        }
        return this.boundParentNode;
    }

    public NodeInfo getNode(Context context) throws SAXException {
        NodeInfo nodeInfo = this.getParentNode(context);
        if (nodeInfo instanceof ElementInfo && ((ElementInfo)nodeInfo).getAttributeValue(this.name) != null) {
            return ((ElementInfo)nodeInfo).makeAttributeNode(this.name);
        }
        return null;
    }

    public boolean evaluateAsBoolean(Context context) throws SAXException {
        NodeInfo nodeInfo = this.getParentNode(context);
        if (nodeInfo instanceof ElementInfo) {
            return ((ElementInfo)nodeInfo).getAttributeValue(this.name) != null;
        }
        return false;
    }

    public String evaluateAsString(Context context) throws SAXException {
        NodeInfo nodeInfo = this.getParentNode(context);
        if (nodeInfo instanceof ElementInfo) {
            String string = ((ElementInfo)nodeInfo).getAttributeValue(this.name);
            if (string == null) {
                return "";
            }
            return string;
        }
        return "";
    }

    public String toString() {
        return "@" + this.name.getDisplayName();
    }

    public int getDependencies() {
        if (this.boundParentNode == null) {
            return 8;
        }
        return 0;
    }

    public Expression reduce(int n, Context context) throws SAXException {
        if (this.boundParentNode == null && (n & 8) != 0) {
            AttributeReference attributeReference = new AttributeReference(this.name);
            attributeReference.bindParentNode(context.getContextNode());
            attributeReference.setStaticContext(this.getStaticContext());
            return attributeReference;
        }
        return this;
    }
}

