/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import org.xml.sax.SAXException;

public class DecimalFormatManager {
    private DecimalFormatSymbols defaultDFS;
    private Hashtable formatTable = new Hashtable();

    public DecimalFormatManager() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        DecimalFormatManager.setDefaults(decimalFormatSymbols);
        this.setDefaultDecimalFormat(decimalFormatSymbols);
    }

    public static void setDefaults(DecimalFormatSymbols decimalFormatSymbols) {
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setInfinity("Infinity");
        decimalFormatSymbols.setMinusSign('-');
        decimalFormatSymbols.setNaN("NaN");
        decimalFormatSymbols.setPercent('%');
        decimalFormatSymbols.setPerMill('\u2030');
        decimalFormatSymbols.setZeroDigit('0');
        decimalFormatSymbols.setDigit('#');
        decimalFormatSymbols.setPatternSeparator(';');
    }

    public void setDefaultDecimalFormat(DecimalFormatSymbols decimalFormatSymbols) {
        this.defaultDFS = decimalFormatSymbols;
    }

    public DecimalFormatSymbols getDefaultDecimalFormat() {
        return this.defaultDFS;
    }

    public void setNamedDecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) throws SAXException {
        if (this.formatTable.get(string) != null && !decimalFormatSymbols.equals((DecimalFormatSymbols)this.formatTable.get(string))) {
            throw new SAXException("Duplicate declaration of decimal-format");
        }
        this.formatTable.put(string, decimalFormatSymbols);
    }

    public DecimalFormatSymbols getNamedDecimalFormat(String string) {
        return (DecimalFormatSymbols)this.formatTable.get(string);
    }
}

