#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "GraphicToolbox.h"

@interface NSBrowserColumn : NSObject <NSCoding>
{
@public
  BOOL _isLoaded;
  id _columnScrollView;
  id _columnMatrix;
  NSString *_columnTitle;
}

- (void) setIsLoaded: (BOOL)flag;
- (BOOL) isLoaded;
- (void) setColumnScrollView: (id)aView;
- (id) columnScrollView;
- (void) setColumnMatrix: (id)aMatrix;
- (id) columnMatrix;
- (void) setColumnTitle: (NSString *)aString;
- (NSString *) columnTitle;
@end


@implementation NSBrowserColumn (theme)
/*
- (void) setColumnMatrix: (id)aMatrix
{
  ASSIGN(_columnMatrix, aMatrix);
  [_columnMatrix setBackgroundColor: [NSColor whiteColor]];
  //[_columnMatrix setDrawsBackground: YES];
}
- (id) columnMatrix
{
  [_columnMatrix setBackgroundColor: [NSColor whiteColor]];
  //[_columnMatrix setDrawsBackground: YES];
  return _columnMatrix;
}
*/
@end


@implementation NSBrowser (theme)

- (BOOL) isOpaque { return NO; }

- (void) drawRect: (NSRect)rect
{
  NSRectClip(rect);
  [[_window backgroundColor] set];
  NSRectFill(rect);

  // Load the first column if not already done
  if (!_isLoaded)
    {
      [self loadColumnZero];
    }

  // Draws titles
  if (_isTitled)
    {
      int i;

      for (i = _firstVisibleColumn; i <= _lastVisibleColumn; ++i)
        {
          NSRect titleRect = [self titleFrameOfColumn: i];
          if (NSIntersectsRect (titleRect, rect) == YES)
            {
              [self drawTitleOfColumn: i
                    inRect: titleRect];
            }
        }
    }
  
  // Draws scroller border
  if (_hasHorizontalScroller)
    {
      NSRect scrollerBorderRect = _scrollerRect;
      NSSize bs = _sizeForBorderType (NSBezelBorder);

      scrollerBorderRect.origin.x = 0;
      scrollerBorderRect.origin.y = 0; 
      scrollerBorderRect.size.width += 2 * bs.width - 1;
      scrollerBorderRect.size.height += (2 * bs.height) - 1;
	
      if ((NSIntersectsRect (scrollerBorderRect, rect) == YES) && _window)
        {
		scrollerBorderRect.size.height -= 2;
		scrollerBorderRect.origin.y += 1;
		scrollerBorderRect.size.width -= 2;
		scrollerBorderRect.origin.x += 1;
        	//NSDrawGrayBezel (scrollerBorderRect, rect);
		NSBezierPath* path = [NSBezierPath bezierPath];
		//[path appendBezierPathWithRoundedRectangle: scrollerBorderRect withRadius: 8.0];
		//[[NSColor colorWithCalibratedRed: 0.5 green: 0.5 blue: 0.5 alpha: 1.0] set];
		[path appendBezierPathWithRect: scrollerBorderRect];
		[[NSColor blackColor] set];
		[path setLineWidth: 1.5];
		[path stroke];
        }
    }

/*
  if (!_separatesColumns)
    {
      NSPoint p1,p2;
      NSRect  browserRect;
      int     i, visibleColumns;
      float   hScrollerWidth = _hasHorizontalScroller ? [NSScroller scrollerWidth] : 0;
    
      // Columns borders
      browserRect = NSMakeRect(0, 0, rect.size.width, rect.size.height);
      NSDrawGrayBezel (browserRect, rect);

      [[NSColor blackColor] set];
      visibleColumns = [self numberOfVisibleColumns];
      for (i = 1; i < visibleColumns; i++)
        {
          p1 = NSMakePoint((_columnSize.width * i) + 2 + (i-1),
                           _columnSize.height + hScrollerWidth + 2);
          p2 = NSMakePoint((_columnSize.width * i) + 2 + (i-1),
                           hScrollerWidth + 2);
          [NSBezierPath strokeLineFromPoint: p1 toPoint: p2];
        }

      // Horizontal scroller border
      if (_hasHorizontalScroller)
        {
          p1 = NSMakePoint(2, hScrollerWidth + 2);
          p2 = NSMakePoint(rect.size.width - 2, hScrollerWidth + 2);
          [NSBezierPath strokeLineFromPoint: p1 toPoint: p2];
        }
    }
*/
}

@end
