# Copyright (C) 2001 John W. Small All Rights Reserved
# mailto:jsmall@laser.net  subject:ruby-generic-server
# Freeware

require 'GServer'
require 'timeout'

class HttpEchoServer < GServer

  def serve(io)
    io.puts("HTTP/1.0 200 Echo follows!")
    io.puts("Connection: close")
    io.puts("Content-Type: text/html")
    io.puts
    io.puts("<html><body>")
    io.puts("<H1>HTTP/1.0 200 Echo follows!</H1>")
    begin
      timeout(1) {
        io.each_line { |line|
          line.chomp!
          io.puts("#{line}<br>")
        }
      }
    rescue
    ensure
      io.puts("</body></html>")
    end
  end

  def initialize(port=8080, host = GServer::DEFAULT_HOST,
    maxConnections = 4, stdlog = $stderr,
    audit = true, debug = true)
    super
  end

end

if __FILE__ == $0
  HttpEchoServer.new.start.join
end
