//WinSpec.cpp, Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 R.Lackner
//the entire code of this module is highly specific to Windows!
//
//    This file is part of RLPlot.
//
//    RLPlot is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    RLPlot is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with RLPlot; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
#include <stdio.h>
#include <math.h>
#include "rlplot.h"
#include "WinSpec.h"
#include "rlplot.rc"
#include "TheDialog.h"

extern int dlgtxtheight;

HINSTANCE hInstance;
HWND MainWnd = 0L;
HACCEL accel;
bool isWIN95 = false;
extern tag_Units Units[];
extern GraphObj *CurrGO;			//Selected Graphic Objects
extern Graph *CurrGraph;
extern char *WWWbrowser;
extern char *LoadFile;
extern Default defs;
extern char TmpTxt[];
extern UndoObj Undo;

const char name[] = "RLPLOT1";

static unsigned int cf_rlpgraph = RegisterClipboardFormat("rlp_graph");
static unsigned int cf_rlpobj = RegisterClipboardFormat("rlp_obj");
static unsigned int cf_rlpxml = RegisterClipboardFormat("rlp_xml");

long FAR PASCAL WndProc(HWND, UINT, UINT, LONG);
PrintWin *Printer = 0L;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// I/O File name dialogs
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get a new file name to store data in
char *SaveDataAsName(char *oldname)
{
	static char szFile[500], szFileTitle[256];
	static char szFilter[] = "RLPlot workbook (*.rlw)\0*.rlw\0data files (*.csv)\0*.csv\0tab separated (*tsv)\0"
		"*.tsv\0XML (*.xml)\0*.xml\0";
	OPENFILENAME ofn;

	szFile[0] = '\0';
	if(oldname)strcpy(szFile, oldname);
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = GetFocus();
	ofn.lpstrFilter = szFilter;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	ofn.lpstrInitialDir = defs.currPath;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
	ofn.lpstrTitle = "Save Data As";

	if(GetSaveFileName(&ofn)){
		defs.FileHistory(szFile);
		return szFile;
		}
	else return NULL;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get a new file name to store graph
char *SaveGraphAsName(char *oldname)
{
	static char szFile[500], szFileTitle[256];
	static char szFilter[] = "RLPlot Graph (*.RLP)\0*.rlp\0";
	OPENFILENAME ofn;

	szFile[0] = '\0';
	if(oldname)strcpy(szFile, oldname);
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = GetFocus();
	ofn.lpstrFilter = szFilter;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	ofn.lpstrInitialDir = defs.currPath;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
	ofn.lpstrTitle = "Save Graph As";

	if(GetSaveFileName(&ofn)){
		defs.FileHistory(szFile);
		return szFile;
		}
	else return NULL;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get file name to read graph
char *OpenGraphName(char *oldname)
{
	static char szFile[500], szFileTitle[256];
	static char szFilter[] = "RLPlot Graph (*.RLP)\0*.rlp\0";
	OPENFILENAME ofn;

	szFile[0] = '\0';
	if(oldname)strcpy(szFile, oldname);
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = GetFocus();
	ofn.lpstrFilter = szFilter;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	ofn.lpstrInitialDir = defs.currPath;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrTitle = "Open Graph";

	if(GetOpenFileName(&ofn)){
		defs.FileHistory(szFile);
		return szFile;
		}
	else return NULL;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get a file name to load data
char *OpenDataName(char *oldname)
{
	static char szFile[500], szFileTitle[256];
	static char szFilter[] = "RLPlot workbook (*rlw)\0*.rlw\0data files (*.csv)\0*.csv\0"
		"tab separated file (*.tsv)\0*.tsv\0"
		"RLPlot Graph (*.rlp)\0*.rlp\0all files (*.*)\0*.*\0";
	OPENFILENAME ofn;

	szFile[0] = '\0';
	if(oldname)strcpy(szFile, oldname);
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = GetFocus();
	ofn.lpstrFilter = szFilter;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	ofn.lpstrInitialDir = defs.currPath;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_HIDEREADONLY;
	ofn.lpstrTitle = "Open Data File";

	if(GetOpenFileName(&ofn)){
		defs.FileHistory(szFile);
		return szFile;
		}
	else return NULL;
}


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get a file name to export graph
void OpenExportName(GraphObj *g, char *oldname)
{
	static char szFile[500], szFileTitle[256];
	static char szFilter[] = "Scalable Vector Graphics (*.svg)\0*.svg\0"
		"Encapsulated Post Script (*.eps)\0*.eps\0"
		"MSWindows MetaFile(*.wmf)\0*.wmf\0Tag Image File Format (*.tif)\0*.tif\0";
	OPENFILENAME ofn;
	int i;

	szFile[0] = '\0';
	if(!g) return;
	if(oldname)strcpy(szFile, oldname);
	memset(&ofn, 0, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = GetFocus();
	ofn.lpstrFilter = szFilter;
	ofn.nFilterIndex = 1;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	ofn.lpstrInitialDir = defs.currPath;
	ofn.Flags = OFN_PATHMUSTEXIST | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
	ofn.lpstrTitle = "Export Graph";

	if(g && GetSaveFileName(&ofn)){
		i = strlen(szFile);
		g->Command(CMD_BUSY, 0L, 0L);
		if(0==stricmp(".svg", szFile+i-4)) {
			DoExportSvg(g, szFile, 0L);
			}
		else if(0==stricmp(".wmf", szFile+i-4)) {
			DoExportWmf(g, szFile, 600.0f, 0L);
			}
		else if(0==stricmp(".eps", szFile+i-4)) {
			DoExportEps(g, szFile, 0L);
			}
		else if(0==stricmp(".tif", szFile+i-4)) {
			DoExportTif(g, szFile, 0L);
			}
		else if(0==stricmp(".tiff", szFile+i-5)) {
			DoExportTif(g, szFile, 0L);
			}
		else ErrorBox("Unknown file extension or format");
		g->Command(CMD_MOUSECURSOR, 0L, 0L);
		}
}
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Common alert boxes
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void InfoBox(char *Msg)
{
	MessageBox(0, Msg, "Info", MB_OK | MB_ICONINFORMATION);
}

void ErrorBox(char *Msg)
{
	MessageBox(0, Msg, "ERROR", MB_OK | MB_ICONSTOP);
}

bool YesNoBox(char *Msg)
{
	if(IDYES == MessageBox(0, Msg, "RLPlot", MB_YESNO | MB_ICONQUESTION)) return true;
	return false;
}

void Qt_Box()
{
	MessageBox(0, "No Qt installed\nunder Windows", "Error", MB_OK | MB_ICONQUESTION);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Display blinking text cursor
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
anyOutput *oTxtCur = 0L, *oCopyMark = 0L;
RECT rTxtCur, rCopyMark;
bool bTxtCur = false, bTxtCurIsVis = false;
DWORD cTxtCur = 0x0L;
HWND hwndTxtCur = 0L;
int iTxtCurCount = 0;
POINT ptTxtCurLine[2];
BitMapWin *bmCopyMark = 0L;

void HideTextCursor()
{
	if(oTxtCur) {
		bTxtCur = false;
		oTxtCur->UpdateRect(&rTxtCur, false);
		}
	oTxtCur = 0L;
}

void HideTextCursorObj(anyOutput *out)
{
	if(oTxtCur && oTxtCur == out) HideTextCursor();
}

void ShowTextCursor(anyOutput *out, RECT *disp, DWORD color)
{
	HWND wnd = GetFocus();

	cTxtCur = color;
	HideTextCursor();
	oTxtCur = out;
	iTxtCurCount = -2;
	memcpy(&rTxtCur, disp, sizeof(RECT));
	ptTxtCurLine[0].x = rTxtCur.left;	ptTxtCurLine[0].y = rTxtCur.top;
	ptTxtCurLine[1].x = rTxtCur.right;	ptTxtCurLine[1].y = rTxtCur.bottom;
	rTxtCur.bottom++;		rTxtCur.right++;
	oTxtCur->ShowLine(ptTxtCurLine, 2, cTxtCur);
	bTxtCurIsVis = bTxtCur = true;
}

void HideCopyMark()
{
	if(bmCopyMark && oCopyMark) {
		oCopyMark->UpdateRect(&rCopyMark, false);
		delete bmCopyMark;
		}
	bmCopyMark = 0L;	oCopyMark = 0L;
}

void ShowCopyMark(anyOutput *out, RECT *mrk, int nRec)
{
	int i;

	HideCopyMark();
	if(!out || !mrk || !nRec) return;
	oCopyMark = out;
	rCopyMark.left = mrk[0].left;	rCopyMark.right = mrk[0].right;
	rCopyMark.top = mrk[0].top;		rCopyMark.bottom = mrk[0].bottom;
	for(i = 1; i < nRec; i++) {
		UpdateMinMaxRect(&rCopyMark, mrk[i].left, mrk[i].top);
		UpdateMinMaxRect(&rCopyMark, mrk[i].right, mrk[i].bottom);
		}
	bmCopyMark = new BitMapWin(rCopyMark.right - rCopyMark.left, 
		rCopyMark.bottom - rCopyMark.top, out->hres, out->vres);
}

LineDEF liCopyMark1 = {0.0f, 1.0f, 0x00ffffffL, 0L};
LineDEF liCopyMark2 = {0.0f, 6.0f, 0x0L, 0xf0f0f0f0L};

long FAR PASCAL TimerWndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
	static POINT line[5];
	static int cp_mark = 0;

	switch(message) {
	case WM_TIMER:
		if(bmCopyMark && oCopyMark) {
			bmCopyMark->CopyBitmap(0, 0, oCopyMark, rCopyMark.left, rCopyMark.top, 
				rCopyMark.right - rCopyMark.left, rCopyMark.bottom - rCopyMark.top, false);
			bmCopyMark->SetLine(&liCopyMark1);
			line[0].x = line[1].x = line[4].x = 0;
			line[0].y = line[3].y = line[4].y = 0;
			line[1].y = line[2].y = rCopyMark.bottom-rCopyMark.top-1;
			line[2].x = line[3].x = rCopyMark.right-rCopyMark.left-1;
			bmCopyMark->oPolyline(line, 5);
			bmCopyMark->SetLine(&liCopyMark2);
			bmCopyMark->RLP.finc = 1.0;		bmCopyMark->RLP.fp = (cp_mark & 0x7);
			bmCopyMark->oPolyline(line, 5);
			oCopyMark->ShowBitmap(rCopyMark.left, rCopyMark.top, bmCopyMark);
			cp_mark++;
			if(bTxtCurIsVis && oTxtCur && ptTxtCurLine[0].y != ptTxtCurLine[1].y &&
				oTxtCur == oCopyMark && OverlapRect(&rCopyMark, &rTxtCur)){
				oTxtCur->ShowLine(ptTxtCurLine, 2, cTxtCur);
				}
			}
		if(!oTxtCur || (ptTxtCurLine[0].x == ptTxtCurLine[1].x &&
			ptTxtCurLine[0].y == ptTxtCurLine[1].y)) return 0;
		iTxtCurCount++;
		if(iTxtCurCount<0) oTxtCur->ShowLine(ptTxtCurLine, 2, cTxtCur);
		if(iTxtCurCount < 4) return 0;
		iTxtCurCount = 0;
		if(bTxtCur && oTxtCur) {
			if(!bTxtCurIsVis) {
				oTxtCur->ShowLine(ptTxtCurLine, 2, cTxtCur);
				bTxtCurIsVis = true;
				}
			else {
				oTxtCur->UpdateRect(&rTxtCur, false);
				bTxtCurIsVis = false;
				}
			}
		return 0;
	case WM_QUERYOPEN:
	case WM_SIZE:	
		return 0;
	case WM_DESTROY:
		KillTimer(hwnd, 1);
		break;
		}
	return DefWindowProc(hwnd, message, wParam, lParam);
}

void InitTextCursor(bool init)
{
	WNDCLASS wndclass;

	if (init) {
		wndclass.style = CS_BYTEALIGNWINDOW | CS_DBLCLKS;
		wndclass.lpfnWndProc = TimerWndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = 0L;
		wndclass.hCursor = 0L;
		wndclass.hbrBackground = NULL;
		wndclass.lpszMenuName = 0L;
		wndclass.lpszClassName = "RLP_TIMER";
		RegisterClass(&wndclass);
		if((hwndTxtCur = CreateWindow("RLP_TIMER", 0L, WS_OVERLAPPEDWINDOW,
			0, 0, 0, 0, NULL, NULL, hInstance, NULL))){
			SetTimer(hwndTxtCur, 1, 150, 0L);
			}
	}
	else if(hwndTxtCur) {
		DestroyWindow(hwndTxtCur);
		hwndTxtCur = 0L;
		}
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Process paste command: check for clipboard contents
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void TestClipboard(GraphObj *g)
{
	HANDLE hmem = 0;
	unsigned char *ptr;

	if(!g) return;
	OpenClipboard(MainWnd);
	if(g->Id == GO_SPREADDATA) {
		if((hmem = GetClipboardData(cf_rlpxml)) &&
			(ptr = (unsigned char*) GlobalLock(hmem))) g->Command(CMD_PASTE_XML, ptr, 0L);
		else if((hmem = GetClipboardData(CF_TEXT)) &&
			(ptr = (unsigned char*) GlobalLock(hmem))) ProcMemData(g, ptr, true);
		else if((hmem = GetClipboardData(cf_rlpobj)) &&
			(ptr = (unsigned char*) GlobalLock(hmem))) OpenGraph(g, 0L, ptr);
		else if((hmem = GetClipboardData(cf_rlpgraph)) &&
			(ptr = (unsigned char*) GlobalLock(hmem))) OpenGraph(g, 0L, ptr);
		}
	else if(g->Id == GO_PAGE) {
		if((hmem = GetClipboardData(cf_rlpobj)) &&
			(ptr = (unsigned char*) GlobalLock(hmem))) OpenGraph(g, 0L, ptr);
		else if((hmem = GetClipboardData(cf_rlpgraph)) &&
			(ptr = (unsigned char*) GlobalLock(hmem))) OpenGraph(g, 0L, ptr);
		}
	else if(g->Id == GO_GRAPH) TestClipboard(g->parent);
	if(hmem) GlobalUnlock(hmem);
	CloseClipboard();
}

void EmptyClip()
{
	HideCopyMark();
	OpenClipboard(MainWnd);
	EmptyClipboard();
	CloseClipboard();
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Get display (desktop) size
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void GetDesktopSize(int *width, int *height)
{
	RECT rc;

	GetClientRect(GetDesktopWindow(), &rc);
	*width = rc.right;
	*height = rc.bottom;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Common code for any Windows output class
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
bool com_oTextOut(int x, int y, char *txt, int cb, 
	HFONT *hFont, HDC *dc, TextDEF *td, bool win95mode, anyOutput *o)
{
	XFORM xf;
	w_char *uc;
	int i, ix, iy, align;

	if(!*hFont || !txt || !txt[0]) return false;
	SelectObject(*dc, *hFont);
	SetTextColor(*dc, td->ColTxt);
	SetBkColor(*dc, td->ColBg);
	align = ((td->Align & TXA_HRIGHT) ? TA_RIGHT : (td->Align &
		TXA_HCENTER) ? TA_CENTER : TA_LEFT) | ((td->Align & TXA_VBOTTOM) ?
		TA_BOTTOM : TA_TOP);
	SetTextAlign(*dc, align);
	SetBkMode(*dc, td->Mode ? TRANSPARENT : OPAQUE);
	ix = iy = 0;
	if(td->Style & TXS_SUB) {
		if((td->Align & TXA_VCENTER) == TXA_VCENTER) iy += o->un2iy(td->fSize*0.4);
		else if((td->Align & TXA_VBOTTOM) == TXA_VBOTTOM) iy += o->un2iy(td->fSize*0.2);
		else if((td->Align & TXA_VTOP) == TXA_VTOP) iy += o->un2iy(td->fSize*.6);
		}
	else if(td->Style & TXS_SUPER) {
		if((td->Align & TXA_VCENTER) == TXA_VCENTER) iy -= o->un2iy(td->fSize*0.4);
		else if((td->Align & TXA_VBOTTOM) == TXA_VBOTTOM) iy -= o->un2iy(td->fSize*0.6);
		else if((td->Align & TXA_VTOP) == TXA_VTOP) iy += o->un2iy(td->fSize*.0);
		}
	if(!win95mode && (fabs(td->RotBL) >.01 || fabs(td->RotCHAR) >.01)) {
		SetGraphicsMode(*dc, GM_ADVANCED);
		xf.eM11 = xf.eM22 = (float)cos(td->RotBL *0.01745329252);
		xf.eM12 = (float)-sin(td->RotBL *0.01745329252);
		xf.eM21 = -xf.eM12;
		xf.eDx = (float)x;
		xf.eDy = (float)y;
		SetWorldTransform(*dc, &xf);
		if(td->Font==FONT_GREEK && (uc=(w_char*)calloc(strlen(txt)+1, sizeof(w_char)))) {
			for(i = 0; txt[i]; i++) {
				if((txt[i] >= 'A' && txt[i] <= 'Z')) uc[i] = txt[i] - 'A' + 0x391;
				else if((txt[i] >= 'a' && txt[i] <= 'z')) uc[i] = txt[i] - 'a' + 0x3B1;
				else uc[i] = txt[i];
				}
			TextOutW(*dc, ix, iy+((td->Align & TXA_VCENTER) ? - td->iSize/2 : 0), uc, 
				(cb > 0) ? cb : strlen(txt));
			free(uc);
			}
		else {
			TextOut(*dc, ix, iy+((td->Align & TXA_VCENTER) ? - td->iSize/2 : 0), txt, 
				(cb > 0) ? cb : strlen(txt));
			}
//		DrawText(*dc, txt, (cb> 0)? cb : strlen(txt), 0L /*LPRECT*/, uFormat);
		ModifyWorldTransform(*dc, &xf, MWT_IDENTITY);
		SetGraphicsMode(*dc, GM_COMPATIBLE);
		return true;
		}
	else {
		if(!win95mode && td->Font==FONT_GREEK && (uc=(w_char*)calloc(strlen(txt)+1, sizeof(w_char)))) {
			for(i = 0; txt[i]; i++) {
				if((txt[i] >= 'A' && txt[i] <= 'Z')) uc[i] = txt[i] - 'A' + 0x391;
				else if((txt[i] >= 'a' && txt[i] <= 'z')) uc[i] = txt[i] - 'a' + 0x3B1;
				else uc[i] = txt[i];
				}
			TextOutW(*dc, x+ix, iy + ((td->Align & TXA_VCENTER) ? y - td->iSize/2 : y), uc, 
				(cb > 0) ? cb : strlen(txt));
			free(uc);
			return true;
			}
		else if(TextOut(*dc, x+ix, iy + ((td->Align & TXA_VCENTER) ? y - td->iSize/2 : y), txt, 
			(cb > 0) ? cb : strlen(txt))) return true;
		}
	return false;
}

bool com_SetTextSpec(TextDEF *set, anyOutput *o, HFONT *hFont,	TextDEF *TxtSet, 
	HDC *dc, bool win95mode)
{	
	bool IsModified, RetVal;
	LOGFONT FontRec;
	HFONT newFont;

	if(!set->iSize && set->fSize > 0.001f) set->iSize = o->un2iy(set->fSize);
	if(!set->iSize) return false;
	if(!*hFont || TxtSet->iSize != set->iSize || TxtSet->Style != set->Style ||
		TxtSet->RotBL != set->RotBL || TxtSet->RotCHAR != set->RotCHAR ||
		TxtSet->Font != set->Font || TxtSet->fSize != set->fSize) IsModified = true;
	else IsModified = false;
	RetVal = o->anyOutput::SetTextSpec(set);
	if (IsModified && RetVal) {
		// create font
		if((TxtSet->Style & TXS_SUPER) || (TxtSet->Style & TXS_SUB))
			FontRec.lfHeight = o->un2iy(set->fSize*0.71);
		else FontRec.lfHeight = TxtSet->iSize;
		if(FontRec.lfHeight <8) FontRec.lfHeight = 8;
		FontRec.lfWidth = 0;
		if(win95mode) {				//Win 95, 98
			FontRec.lfEscapement = iround(TxtSet->RotBL*10);		//text angle
			FontRec.lfOrientation = iround(TxtSet->RotBL*10);		//base line angle
			}
		else {						//Win NT, 2000, XP
			FontRec.lfEscapement = 0;		//text angle
			FontRec.lfOrientation = 0;		//base line angle
			}
		FontRec.lfWeight = (TxtSet->Style & TXS_BOLD) ? FW_BOLD : FW_NORMAL;
		FontRec.lfItalic = (TxtSet->Style & TXS_ITALIC) ? TRUE : FALSE;
		FontRec.lfUnderline = (TxtSet->Style & TXS_UNDERLINE) ? TRUE : FALSE;
		FontRec.lfStrikeOut = 0;
		FontRec.lfOutPrecision = OUT_DEFAULT_PRECIS;
		FontRec.lfClipPrecision = CLIP_DEFAULT_PRECIS;
		FontRec.lfQuality = PROOF_QUALITY;
		switch(TxtSet->Font){
		case FONT_HELVETICA:
		default:
			FontRec.lfCharSet = ANSI_CHARSET;
			FontRec.lfPitchAndFamily = VARIABLE_PITCH | FF_SWISS;
			strcpy(FontRec.lfFaceName, "Arial");
			break;
		case FONT_GREEK:		case FONT_TIMES:
			FontRec.lfCharSet = ANSI_CHARSET;
			FontRec.lfPitchAndFamily = VARIABLE_PITCH | FF_ROMAN;
			strcpy(FontRec.lfFaceName, "Times New Roman");
			break;
		case FONT_COURIER:
			FontRec.lfCharSet = ANSI_CHARSET;
			FontRec.lfPitchAndFamily = FIXED_PITCH | FF_MODERN;
			strcpy(FontRec.lfFaceName, "Courier New");
			break;
			}
		newFont = CreateFontIndirect(&FontRec);
		SelectObject(*dc, newFont);
		if(*hFont)DeleteObject(*hFont);
		*hFont = newFont;
		if(!(*hFont)) return false;
		}
	return RetVal;
}

bool com_Arc(HDC dc, int x1, int y1, int x2, int y2, int quads)
{
	int bx, by, ex, ey;

	if(x1 > x2) Swap(x1, x2);	if(y1 > y2) Swap(y1, y2);
	switch (quads) {
	case 1:
		bx = (x1+x2)>>1;	by = y2;
		ex = x2;			ey = (y1 +y2)>>1;
		break;
	case 2:
		bx = x1;	ex = x2;		by = ey = (y1 +y2)>>1;
		break;
	case 3:
		bx = (x1+x2)>>1;	by = y1;
		ex = x2;			ey = (y1 +y2)>>1;
		break;
	case 4:
		bx = ex = x2;		by = ey = (y1 +y2)>>1;
		break;
	default: return false;
		}
	if(Arc(dc, x1, y1, x2, y2, bx, by, ex, ey)) return true;
	return false;
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Output to windows bitmap
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BitMapWin::BitMapWin(GraphObj *g, HWND hw):anyOutput()
{
	HDC dc;
	HWND hwndDesk;

	memDC = 0L;		hgo = 0L;		go = g;
	dc = GetDC(hwndDesk = GetDesktopWindow());
	hres = (double)GetDeviceCaps(dc, LOGPIXELSX);
	vres = (double)GetDeviceCaps(dc, LOGPIXELSY);
	if(hw) GetClientRect(hw, &DeskRect);
	else GetClientRect(hwndDesk, &DeskRect);
	Box1.Xmin = DeskRect.left;		Box1.Xmax = DeskRect.right;
	Box1.Ymin = DeskRect.top;		Box1.Ymax = DeskRect.bottom;
	scr = CreateCompatibleBitmap(dc, DeskRect.right, DeskRect.bottom);
	memDC = CreateCompatibleDC(NULL);
	SelectObject(memDC, scr);
	ReleaseDC(hwndDesk, dc);
	hPen = CreatePen(PS_SOLID, 1, dLineCol = 0x00ffffffL);
	hBrush = CreateSolidBrush(dFillCol =dBgCol = 0x00ffffffL);
	dPattern = 0L;
	if(memDC) {
		oldPen = (HPEN)SelectObject(memDC, hPen);
		oldBrush = (HBRUSH)SelectObject(memDC, hBrush);
		}
	else {
		oldBrush = 0L;
		oldPen = 0L;
		}
	hFont = 0L;
}

BitMapWin::BitMapWin(int w, int h, double hr, double vr)
{
	HDC dc;
	HWND hwndDesk;

	memDC = 0L;		hgo = 0L;		go = 0L;
	hres = hr;		vres = vr;
	units = defs.cUnits;
	DeskRect.right = w;				DeskRect.bottom = h;
	DeskRect.left = DeskRect.top = 0;
	VPorg.fx = VPorg.fy = 0.0;
	dc = GetDC(hwndDesk = GetDesktopWindow());
	scr = CreateCompatibleBitmap(dc, DeskRect.right, DeskRect.bottom);
	memDC = CreateCompatibleDC(NULL);
	ReleaseDC(hwndDesk, dc);
	SelectObject(memDC, scr);
	hPen = CreatePen(PS_SOLID, 1, dLineCol = 0x00ffffffL);
	hBrush = CreateSolidBrush(dFillCol =dBgCol = 0x00ffffffL);
	dPattern = 0L;
	if(memDC) {
		SelectObject(memDC, hPen);
		SelectObject(memDC, hBrush);
		}
	hFont = 0L;
}

BitMapWin::BitMapWin(GraphObj *g):anyOutput()
{
	HDC dc;
	HWND hwndDesk;

	memDC = 0L;		hgo = 0L;		go = g;
	dc = GetDC(hwndDesk = GetDesktopWindow());
	hres = vres = 300.0;
	units = defs.cUnits;
	DeskRect.right = un2ix(go->GetSize(SIZE_GRECT_RIGHT) - go->GetSize(SIZE_GRECT_LEFT));
	DeskRect.bottom = un2iy(go->GetSize(SIZE_GRECT_BOTTOM) - go->GetSize(SIZE_GRECT_TOP));
	DeskRect.top = DeskRect.left = 0;
	VPorg.fy = -co2fiy(go->GetSize(SIZE_GRECT_TOP));
	VPorg.fx = -co2fix(go->GetSize(SIZE_GRECT_LEFT));
	scr = CreateCompatibleBitmap(dc, DeskRect.right, DeskRect.bottom);
	memDC = CreateCompatibleDC(NULL);
	SelectObject(memDC, scr);
	ReleaseDC(hwndDesk, dc);
	hPen = CreatePen(PS_SOLID, 1, dLineCol = 0x00ffffffL);
	hBrush = CreateSolidBrush(dFillCol =dBgCol = 0x00ffffffL);
	dPattern = 0L;
	if(memDC) {
		SelectObject(memDC, hPen);
		SelectObject(memDC, hBrush);
		}
	hFont = 0L;
}

BitMapWin::~BitMapWin()
{
	if(go) {
		go->Command(CMD_CAN_DELETE, 0L, 0L);
		}
	Undo.KillDisp(this);
	if(hgo) delete hgo;
	if(hFont) DeleteObject(hFont);
	if(scr) DeleteObject(scr);
	SelectObject(memDC, oldPen);
	SelectObject(memDC, oldBrush);
	if(memDC) DeleteDC(memDC);
	if(hPen) DeleteObject(hPen);
	if(hBrush) DeleteObject(hBrush);
	hgo = 0L;	hFont = 0L;	scr = 0L;	
	memDC = 0L;	hPen = 0L;	hBrush = 0L;
}

bool
BitMapWin::SetLine(LineDEF *lDef)
{
	int iw;
	HPEN newPen;

	if(!hPen || lDef->width != LineWidth || lDef->width != LineWidth || 
		lDef->pattern != dPattern || lDef->color != dLineCol) {
		LineWidth = lDef->width;
		iw = iround(un2fix(lDef->width));
		dPattern = lDef->pattern;
		RLP.finc = 256.0/un2fix(lDef->patlength*8.0);
		RLP.fp = 0.0;
		if(iLine == iw && dLineCol == lDef->color && hPen) return true;
		iLine = iw;
		dLineCol = lDef->color;
		newPen = CreatePen(PS_SOLID, iw > 0 ? iw : 1, dLineCol);
		SelectObject(memDC, newPen);
		if(hPen) DeleteObject(hPen);
		hPen = newPen;
		}
	return true;
}

bool
BitMapWin::SetFill(FillDEF *fill)
{
	HBRUSH newBrush;

	if(!fill) return false;
	if((fill->type & 0xff) != FILL_NONE) {
		if(!hgo) hgo = new HatchOut(this);
		if(hgo) hgo->SetFill(fill);
		}
	else {
		if(hgo) delete hgo;
		hgo = NULL;
		}
	if(dFillCol != fill->color) {
		newBrush = CreateSolidBrush(dFillCol = fill->color);
		SelectObject(memDC, newBrush);
		if(hBrush) DeleteObject(hBrush);
		hBrush = newBrush;
		}
	dFillCol = fill->color;
	dFillCol2 = fill->color2;
	return true;
}

bool
BitMapWin::SetTextSpec(TextDEF *set)
{
	return com_SetTextSpec(set, this, &hFont, &TxtSet, &memDC, isWIN95);
}

bool
BitMapWin::Erase(DWORD Color)
{
	HPEN hBGpen, hOldPen;
	HBRUSH hBGbrush, hOldBrush;

	hBGpen = CreatePen(PS_SOLID, 1, Color);
	hBGbrush = CreateSolidBrush(Color);
	if(hBGpen && memDC) {
		if(hBGbrush) {
			hOldBrush = (HBRUSH)SelectObject(memDC, hBGbrush);
			hOldPen = (HPEN)SelectObject(memDC, hBGpen);
			Rectangle(memDC, 0, 0, DeskRect.right, DeskRect.bottom);
			SelectObject(memDC, hOldBrush);
			SelectObject(memDC, hOldPen);
			DeleteObject(hBGbrush);
			DeleteObject(hBGpen);
			return true;
			}
		if(hBGpen) DeleteObject(hBGpen);
		}
	return false;
}

bool
BitMapWin::CopyBitmap(int x, int y, anyOutput* sr, int sx, int sy,
	int sw, int sh, bool invert)
{
	BitMapWin *src = (BitMapWin*)sr;

	return(0 != BitBlt(memDC, x, y, sw, sh, src->memDC, sx, sy, 
		invert ? DSTINVERT : SRCCOPY));
}

bool
BitMapWin::oGetTextExtent(char *text, int cb, int *width, int *height)
{
	SIZE TextExtent;
	double si, csi, d;

	if(!text) return false;
	if(!GetTextExtentPoint32(memDC, text, cb ? cb : strlen(text), &TextExtent))return false;
	if(fabs(TxtSet.RotBL) >0.01) {
		si = fabs(sin(TxtSet.RotBL * 0.01745329252));	csi = fabs(cos(TxtSet.RotBL * 0.01745329252));
		d = si > csi ? 1.0/si : 1.0/csi;
		d = (TextExtent.cx * ((7.0 + d)/8.0));
		TextExtent.cx = iround(d);
		}
	*width = TextExtent.cx;
	*height = TextExtent.cy;
	return true;
}

bool
BitMapWin::oGetPix(int x, int y, DWORD *col)
{
	DWORD pix;
	
	if(x >= DeskRect.left && x < DeskRect.right &&
		y >= DeskRect.top && y < DeskRect.bottom) {
		pix = GetPixel(memDC, x, y);
		*col = pix;
		return true;
		}
	else return false;
}

bool
BitMapWin::oDrawIcon(int type, int x, int y)
{
	HICON icon = 0L;
	
	switch(type) {
	case ICO_INFO:
		icon = LoadIcon(0L, IDI_ASTERISK);
		break;
	case ICO_ERROR:
		icon = LoadIcon(0L, IDI_HAND);
		break;
	case ICO_RLPLOT:
		icon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_EVAL));
		break;
		}
	if(icon){
		DrawIcon(memDC, x, y, icon);
		return true;
		}
	return false;
}

bool
BitMapWin::oCircle(int x1, int y1, int x2, int y2, char *nam)
{
	BOOL RetVal;
	
	RetVal = Ellipse(memDC, x1, y1, x2, y2);
	if(RetVal && hgo) return hgo->oCircle(x1, y1, x2, y2);
	else if(RetVal) return true;
	return false;
}

bool
BitMapWin::oPolyline(POINT * pts, int cp, char *nam)
{
	int i;

	if(cp < 1) return false;
	if (dPattern) {
		for (i = 1; i < cp; i++) PatLine(pts[i-1], pts[i]);
		return true;
		}
	else {
		if(Polyline(memDC, pts, cp))return true;
		else return false;
		}
}

bool
BitMapWin::oRectangle(int x1, int y1, int x2, int y2, char *name)
{
	BOOL RetVal;

	RetVal = Rectangle(memDC, x1, y1, x2, y2);
	if(RetVal && hgo) return hgo->oRectangle(x1, y1, x2, y2, 0L);
	else if (RetVal) return true;
	return false;
}

bool
BitMapWin::oSolidLine(POINT *p)
{
	if(Polyline(memDC, p, 2)) return true;
	return false;
}

bool
BitMapWin::oTextOut(int x, int y, char *txt, int cb)
{
	return com_oTextOut(x, y, txt, cb, &hFont, &memDC, &TxtSet, isWIN95, this);
}

bool
BitMapWin::oPolygon(POINT *pts, int cp, char *nam)
{
	BOOL RetVal;

	RetVal = Polygon(memDC, pts, cp);
	if(RetVal && hgo) return hgo->oPolygon(pts, cp);
	else if (RetVal) return true;
	return false;
}

bool
BitMapWin::oArc(int x1, int y1, int x2, int y2, int quads)
{
	return  com_Arc(memDC, x1, y1, x2, y2, quads);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Output to windows window
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
OutputWin::OutputWin(GraphObj *g, HWND hw):BitMapWin(g, hw)
{
	hdc = 0L;
	if(g) {
		if(!hw) CreateNewWindow(g);
		else hWnd = hw;
		}
	else {							//its a dialog window
		hWnd = hw;
		yAxis.flags = AXIS_INVERT;	//drawing origin upper left corner
		}
}

OutputWin::~OutputWin()
{
	HideTextCursorObj(this);
	SendMessage(hWnd, WM_CLOSE, 0, 0L);
	//Note: HGDI objects are deleted by the BitMapWin destructor
}

bool
OutputWin::ActualSize(RECT *rc)
{
	if(GetClientRect(hWnd, rc)) return true;
	return false;
}

void
OutputWin::Caption(char *txt)
{
	SetWindowText(hWnd, txt);
}

unsigned char hand_bits[] =	{	//hand cursor bitmap
	0x01, 0x80, 0x1b, 0xf0, 0x3f, 0xf8, 0x3f, 0xfa,
	0x1f, 0xff, 0x1f, 0xff, 0x6f, 0xff, 0xff, 0xff,
	0xff, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x3f, 0xfc,
	0x1f, 0xfc, 0x0f, 0xf8, 0x07, 0xf8, 0x07, 0xf8};

unsigned char hand_mask[] =	{	//hand cursor mask
	0xff, 0xff, 0xfe, 0x7f, 0xe6, 0x4f, 0xe6, 0x4f,
	0xf2, 0x4d, 0xf2, 0x49, 0x78, 0x09, 0x98, 0x01,
	0x88, 0x03, 0xc0, 0x03, 0xc0, 0x03, 0xe0, 0x07,
	0xf0, 0x07, 0xf8, 0x0f, 0xfc, 0x0f, 0xfc, 0x0f};

unsigned char zoom_bits[] =	{	//zoom cursor bitmap
	0x00, 0x00, 0x00, 0x00, 0x01, 0xa0, 0x06, 0x30,
	0x08, 0x08, 0x10, 0x84, 0x10, 0x84, 0x20, 0x02,
	0x26, 0x32, 0x20, 0x02, 0x10, 0x84, 0x10, 0x84,
	0x08, 0x08, 0x06, 0x30, 0x01, 0xa0, 0x00, 0x00};

unsigned char zoom_mask[] =	{	//zoom cursor mask
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

void
OutputWin::MouseCursor(int cid, bool force)
{
	HCURSOR hc, hoc = 0L;

	if(cid == cCursor && !force) return;
	if(cid == MC_LAST) cid = cCursor;
	switch(cid) {
	case MC_ARROW:
		hoc = SetCursor(LoadCursor(NULL, IDC_ARROW));	break;
	case MC_CROSS:	hoc = SetCursor(LoadCursor(NULL, IDC_CROSS));	break;
	case MC_WAIT:
		hoc = SetCursor(LoadCursor(NULL, IDC_WAIT));	break;
	case MC_TEXT:	hoc = SetCursor(LoadCursor(NULL, IDC_IBEAM));	break;
	case MC_NORTH:	hoc = SetCursor(LoadCursor(NULL, IDC_SIZENS));	break;
	case MC_NE:		hoc = SetCursor(LoadCursor(NULL, IDC_SIZENESW));break;
	case MC_EAST:	hoc = SetCursor(LoadCursor(NULL, IDC_SIZEWE));	break;
	case MC_SE:		hoc = SetCursor(LoadCursor(NULL, IDC_SIZENWSE));break;
	case MC_SALL:	hoc = SetCursor(LoadCursor(NULL, IDC_SIZEALL));	break;	
	case MC_MOVE:
		hc = CreateCursor(hInstance, 8, 8, 16, 16, hand_mask, hand_bits);
		hoc = SetCursor(hc);
		break;
	case MC_ZOOM:
		hc = CreateCursor(hInstance, 8, 8, 16, 16, zoom_mask, zoom_bits);
		hoc = SetCursor(hc);
		break;
	default:	return;
		}
	if(hoc) DestroyCursor(hoc);
	cCursor = cid;
}

bool
OutputWin::SetScroll(bool isVert, int iMin, int iMax, int iPSize, int iPos)
{
	SCROLLINFO si;

	if(iPos < iMin) return false;
	si.cbSize = sizeof(SCROLLINFO);
	si.fMask = SIF_ALL;
	si.nMin = iMin;
	si.nMax = iMax;
	si.nPage = iPSize < iMax ? iPSize : iMax;
	si.nPos = iPos;
	si.nTrackPos = 0;
	SetScrollInfo(hWnd, isVert ? SB_VERT : SB_HORZ, &si, TRUE);
	return true;
}

bool
OutputWin::Erase(DWORD Color)
{
	bool bRet;
	RECT ClientRect;

	if(bRet = BitMapWin::Erase(Color)) {
		GetClientRect(hWnd, &ClientRect);
		InvalidateRect(hWnd, &ClientRect, FALSE);
		}
	return bRet;
}

bool
OutputWin::StartPage()
{
	MrkMode = MRK_NONE;
	MrkRect = 0L;
	hdc = memDC;
	if(hgo && hdc) hgo->StartPage();
	return true;
}

bool
OutputWin::EndPage()
{
	RECT ClientRect;

	hdc = NULL;
	GetClientRect(hWnd, &ClientRect);
	return UpdateRect(&ClientRect, false);
}

bool
OutputWin::UpdateRect(RECT *rc, bool invert)
{
	HDC dc;
	BOOL RetVal = FALSE;

	if(dc = GetDC(hWnd)) {
		RetVal = BitBlt(dc, rc->left, rc->top, rc->right - rc->left,
			rc->bottom - rc->top, memDC, rc->left, rc->top, invert ? DSTINVERT : SRCCOPY);
		ReleaseDC(hWnd, dc);
		}
	return (RetVal != 0);
}

bool
OutputWin::UpdateRect(HDC dc, RECT rc)
{
	if(BitBlt(dc, rc.left, rc.top, rc.right - rc.left,
			rc.bottom - rc.top, memDC, rc.left, rc.top, SRCCOPY))return true;
	return false;
}

void
OutputWin::ShowBitmap(int x, int y, anyOutput* src)
{
	int w, h;
	HDC dc;
	BitMapWin *sr;

	if(!src) return;
	sr = (BitMapWin *) src;
	w = sr->DeskRect.right - sr->DeskRect.left;
	h = sr->DeskRect.bottom - sr->DeskRect.top;
	if(dc = GetDC(hWnd)) {
		BitBlt(dc, x, y, w,	h, sr->memDC, 0, 0, SRCCOPY);
		ReleaseDC(hWnd, dc);
		}
}

void
OutputWin::ShowLine(POINT * pts, int cp, DWORD color)
{
	HDC dc;
	HPEN hP, oP;
	
	if((hP = CreatePen(PS_SOLID, 0, color))&& (dc = GetDC(hWnd))) {
		oP = (HPEN)SelectObject(dc, hP);
		Polyline(dc, pts, cp);
		SelectObject(dc, oP);
		DeleteObject(hP);
		ReleaseDC(hWnd, dc);
		}
}

void
OutputWin::ShowEllipse(POINT p1, POINT p2, DWORD color)
{
	HDC dc;
	HPEN hP, oP;

	if((hP = CreatePen(PS_SOLID, 0, color)) && (dc = GetDC(hWnd))) {
		oP = (HPEN)SelectObject(dc, hP);
		Arc(dc, p1.x, p1.y, p2.x, p2.y, 0, 0, 0, 0);
		SelectObject(dc, oP);
		DeleteObject(hP);
		ReleaseDC(hWnd, dc);
		}
}

bool
OutputWin::SetMenu(int type)
{
	HMENU hMenu = 0L;

	switch(type) {
	case MENU_NONE:
		break;
	case MENU_SPREAD:
		hMenu = LoadMenu(hInstance, MAKEINTRESOURCE(MENU_2));
		break;
	case MENU_GRAPH:
		hMenu = LoadMenu(hInstance, MAKEINTRESOURCE(MENU_1));
		break;
	case MENU_PAGE:
		hMenu = LoadMenu(hInstance, MAKEINTRESOURCE(MENU_3));
		}
	::SetMenu(hWnd, hMenu);
	return true;
}

void
OutputWin::CheckMenu(int mid, bool check)
{
	HMENU hMenu = GetMenu(hWnd);

	if(mid < CM_T_STANDARD) switch(mid){					//tool mode identifier
	case TM_STANDARD:	mid = CM_T_STANDARD;	break;
	case TM_DRAW:		mid = CM_T_DRAW;		break;
	case TM_POLYLINE:	mid = CM_T_POLYLINE;	break;
	case TM_POLYGON:	mid = CM_T_POLYGON;		break;
	case TM_RECTANGLE:	mid = CM_T_RECTANGLE;	break;
	case TM_ROUNDREC:	mid = CM_T_ROUNDREC;	break;
	case TM_ELLIPSE:	mid = CM_T_ELLIPSE;		break;
	case TM_ARROW:		mid = CM_T_ARROW;		break;
	case TM_TEXT:		mid = CM_T_TEXT;		break;
	default:	return;
		}
	if(hMenu) CheckMenuItem(hMenu, mid, check ? MF_CHECKED : MF_UNCHECKED);
}

void
OutputWin::FileHistory() 
{
	HMENU hSubMenu;
	char **history[] = {&defs.File1, &defs.File2, &defs.File3, &defs.File4, &defs.File5, &defs.File6};
	int i, j, k;

	if(!hasHistMenu || !defs.File1) return;
	if(!(hSubMenu = GetSubMenu(GetMenu(hWnd), 0))) return;
	if(!HistMenuSize) AppendMenu(hSubMenu, MF_SEPARATOR, 0L, 0L);
    for(i = 0; i < 6 && *history[i]; i++) {
		k = strlen(*history[i]);
		for (j = 0; j < k && defs.currPath[j] == (*history[i])[j]; j++);
		if((*history[i])[j] == '\\' || (*history[i])[j] == '/') j++;
		if(i < HistMenuSize) {
			ModifyMenu(hSubMenu, CM_FILE1+i, MF_BYCOMMAND | MF_STRING, CM_FILE1+i, *history[i]+j);
			}
		else {
			AppendMenu(hSubMenu, MF_STRING, CM_FILE1+i, *history[i]+j);
			}
		}
	HistMenuSize = i;
}

void
OutputWin::CreateNewWindow(void *g)
{
	hWnd = CreateWindow(name, "RLPlot",
		WS_OVERLAPPEDWINDOW | WS_HSCROLL | WS_VSCROLL,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
	SetWindowLong(hWnd, 0, (long)g);		// g is the parent graphic obj
	SetWindowLong(hWnd, GWL_USERDATA, (long)this);
	ShowWindow(hWnd, SW_SHOW);
	UpdateWindow(hWnd);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Copy to Clipboard
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Create Windows Meta File for clipboard
WinCopyWMF::WinCopyWMF(GraphObj *g)
{
	DeskRect.left = DeskRect.top = 0;
	DeskRect.right = DeskRect.bottom = 0x4fffffffL;
	hPen = CreatePen(PS_SOLID, 1, dLineCol = 0x00ffffffL);
	hBrush = CreateSolidBrush(dFillCol =dBgCol = 0x00ffffffL);
	dPattern = 0L;
	go = g;
	hgo = 0L;
	hres = vres = 1000.0;
}

WinCopyWMF::~WinCopyWMF()
{
	if(hgo) delete hgo;
	if(hFont) DeleteObject(hFont);
	if(hBrush) DeleteObject(hBrush);
	if(hPen) DeleteObject(hPen);
}

bool
WinCopyWMF::SetLine(LineDEF *lDef)
{
	int iw;
	HPEN newPen;

	if(!hPen || lDef->width != LineWidth || lDef->width != LineWidth || 
		lDef->pattern != dPattern || lDef->color != dLineCol) {
		LineWidth = lDef->width;
		iw = iround(un2fix(lDef->width));
		dPattern = lDef->pattern;
		RLP.finc = 256.0/un2fix(lDef->patlength*8.0);
		RLP.fp = 0.0;
		if(iLine == iw && dLineCol == lDef->color && hPen) return true;
		iLine = iw;
		dLineCol = lDef->color;
		newPen = CreatePen(PS_SOLID, iw > 0 ? iw : 1, dLineCol);
		SelectObject(hdc, newPen);
		if(hPen) DeleteObject(hPen);
		hPen = newPen;
		}
	return true;
}

bool
WinCopyWMF::SetFill(FillDEF *fill)
{
	HBRUSH newBrush;

	if(!fill) return false;
	if((fill->type & 0xff) != FILL_NONE) {
		if(!hgo) hgo = new HatchOut(this);
		if(hgo) hgo->SetFill(fill);
		}
	else {
		if(hgo) delete hgo;
		hgo = NULL;
		}
	if(dFillCol != fill->color) {
		newBrush = CreateSolidBrush(dFillCol = fill->color);
		SelectObject(hdc, newBrush);
		if(hBrush) DeleteObject(hBrush);
		hBrush = newBrush;
		}
	dFillCol = fill->color;
	dFillCol2 = fill->color2;
	return true;
}

bool
WinCopyWMF::SetTextSpec(TextDEF *set)
{
	return com_SetTextSpec(set, this, &hFont, &TxtSet, &hdc, true);
}

bool
WinCopyWMF::StartPage()
{
	int w, h;


	if(!go) return false;
	w = un2ix(go->GetSize(SIZE_GRECT_RIGHT) - go->GetSize(SIZE_GRECT_LEFT));
	h = un2iy(go->GetSize(SIZE_GRECT_BOTTOM) - go->GetSize(SIZE_GRECT_TOP));
	w++; h++;
	if(!(hdc = CreateMetaFile(NULL))) return false;
	if(hPen)SelectObject(hdc, hPen);
	if(hBrush) SelectObject(hdc, hBrush);
	VPorg.fy = -co2fiy(go->GetSize(SIZE_GRECT_TOP));
	VPorg.fx = -co2fix(go->GetSize(SIZE_GRECT_LEFT));
	SetMapMode(hdc, MM_HIENGLISH); 
	SetWindowExtEx(hdc, w, h, 0L);
	SetWindowOrgEx(hdc, 0, 0, 0L);
	return true;
}

bool
WinCopyWMF::EndPage()
{
	HMETAFILE hmf;
	HGLOBAL hGMem;
	LPMETAFILEPICT pMFP;

	hmf = CloseMetaFile(hdc);
	hGMem = GlobalAlloc(GHND, sizeof(METAFILEPICT));
	pMFP = (LPMETAFILEPICT)GlobalLock(hGMem);
	pMFP->mm = MM_ANISOTROPIC;
	pMFP->xExt = (long)(Box1.Xmax+Box1.Xmin);
	pMFP->yExt = (long)(Box1.Ymax+Box1.Ymin);
	pMFP->hMF = hmf;
	GlobalUnlock(hGMem);
	// We do not open the Clipboard because we are responding to WM_RENDERFORMAT
	SetClipboardData(CF_METAFILEPICT, hGMem);
	return true;
}

bool
WinCopyWMF::oCircle(int x1, int y1, int x2, int y2, char* nam)
{
	BOOL RetVal;
	
	RetVal = Ellipse(hdc, x1, y1, x2, y2);
	if(RetVal && hgo) return hgo->oCircle(x1, y1, x2, y2);
	else if(RetVal) return true;
	return false;
}

bool
WinCopyWMF::oPolyline(POINT * pts, int cp, char *nam)
{
	int i;

	if(cp < 1) return false;
	if (dPattern) {
		for (i = 1; i < cp; i++) PatLine(pts[i-1], pts[i]);
		return true;
		}
	else {
		if(Polyline(hdc, pts, cp))return true;
		else return false;
		}
	return false;
}

bool
WinCopyWMF::oRectangle(int x1, int y1, int x2, int y2, char *name)
{
	BOOL RetVal;

	RetVal = Rectangle(hdc, x1, y1, x2, y2);
	if(RetVal && hgo) return hgo->oRectangle(x1, y1, x2, y2, 0L);
	else if (RetVal) return true;
	return false;
}

bool
WinCopyWMF::oSolidLine(POINT *p)
{
	if(Polyline(hdc, p, 2)) return true;
	return false;
}

bool
WinCopyWMF::oTextOut(int x, int y, char *txt, int cb)
{
	return com_oTextOut(x, y, txt, cb, &hFont, &hdc, &TxtSet, true, this);
}

bool
WinCopyWMF::oPolygon(POINT *pts, int cp, char *nam)
{
	BOOL RetVal;

	RetVal = Polygon(hdc, pts, cp);
	if(RetVal && hgo) return hgo->oPolygon(pts, cp);
	else if (RetVal) return true;
	return false;
}

bool
WinCopyWMF::oArc(int x1, int y1, int x2, int y2, int quads)
{
	return  com_Arc(hdc, x1, y1, x2, y2, quads);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Print 
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PrintWin::PrintWin()
{
	int i, j;
	double pw, ph;

	PrintDriver = PrintDevice = PrintPort = 0L;
	hPen = 0L;
	hBrush = 0L;
	hFont = 0L;
	hDC = 0L;
	hgo = 0L;
	units = defs.cUnits;
	i = j = 0;
	GetProfileString("windows", "device", "", TmpTxt, 4096);
	while(TmpTxt[i] && TmpTxt[i] != ',') i++;
	TmpTxt[i] = 0;
	if (i >2) {
		PrintDevice = strdup(TmpTxt);
		i++;
		j = i;
		while(TmpTxt[i] && TmpTxt[i] != ',') i++;
		if(i-j > 2) {
			TmpTxt[i] = 0;
			PrintDriver = strdup(TmpTxt+j);
			i++;
			j = i;
			while(TmpTxt[i] && TmpTxt[i] != ',') i++;
			if(i-j > 2) {
				TmpTxt[i] = 0;
				PrintPort = strdup(TmpTxt+j);
				//Get default paper setup
				if(hDC = CreateDC(PrintDriver, PrintDevice, PrintPort, 0L)) { 
					pw = GetDeviceCaps(hDC, PHYSICALWIDTH);
					pw /= (double)GetDeviceCaps(hDC, LOGPIXELSX);
					ph = GetDeviceCaps(hDC, PHYSICALHEIGHT);
					ph /= (double)GetDeviceCaps(hDC, LOGPIXELSY);
					switch (defs.cUnits){
					case 1:		pw *= 2.54;		ph *= 2.54;		break;
					case 2:		break;
					default:	pw *= 25.4;		ph *= 25.4;		break;
						}
					FindPaper(pw, ph, 0.01);
					DeleteDC(hDC);
					}
				hDC = 0L;
				}
			}
		}
}

PrintWin::~PrintWin()
{
	if(PrintDriver) free(PrintDriver);
	if(PrintDevice) free(PrintDevice);
	if(PrintPort) free(PrintPort);
	if(hPen) DeleteObject(hPen);
	if(hBrush) DeleteObject(hBrush);
	if(hFont) DeleteObject(hFont);
}

bool
PrintWin::SetLine(LineDEF *lDef)
{
	int iw;
	HPEN newPen;

	if(!hPen || lDef->width != LineWidth || lDef->width != LineWidth || 
		lDef->pattern != dPattern || lDef->color != dLineCol) {
		LineWidth = lDef->width;
		iw = iround(un2ix(lDef->width));
		dPattern = lDef->pattern;
		RLP.finc = 256.0/un2fix(lDef->patlength*8.0);
		RLP.fp = 0.0;
		if(iLine == iw && dLineCol == lDef->color && hPen) return true;
		iLine = iw;
		dLineCol = lDef->color;
		newPen = CreatePen(PS_SOLID, iw > 0 ? iw : 1, dLineCol);
		SelectObject(hDC, newPen);
		if(hPen) DeleteObject(hPen);
		hPen = newPen;
		}
	return true;
}

bool
PrintWin::SetFill(FillDEF *fill)
{
	HBRUSH newBrush;

	if(!fill) return false;
	if((fill->type & 0xff) != FILL_NONE) {
		if(!hgo) hgo = new HatchOut(this);
		if(hgo) hgo->SetFill(fill);
		}
	else {
		if(hgo) delete hgo;
		hgo = NULL;
		}
	newBrush = CreateSolidBrush(fill->color);
	SelectObject(hDC, newBrush);
	if(hBrush) DeleteObject(hBrush);
	hBrush = newBrush;
	dFillCol = fill->color;
	dFillCol2 = fill->color2;
	return true;
}

bool
PrintWin::SetTextSpec(TextDEF *set)
{
	return com_SetTextSpec(set, this, &hFont, &TxtSet, &hDC, isWIN95);
}

bool
PrintWin::StartPage()
{
	DOCINFO DocInfo;
	bool bRet = false;

	if(hDC = CreateDC(PrintDriver, PrintDevice, PrintPort, 0L)) { 
		hPen = CreatePen(PS_SOLID, 1, dLineCol = 0x00ffffffL);
		hBrush = CreateSolidBrush(dFillCol =dBgCol = 0x00ffffffL);
		dPattern = 0L;
		SelectObject(hDC, hPen);
		SelectObject(hDC, hBrush);
		memset(&DocInfo, 0, sizeof(DOCINFO));
		DocInfo.lpszDocName = "RLPlot graph";
		DocInfo.cbSize = sizeof(DOCINFO);
		DeskRect.left = DeskRect.top = 0;
		DeskRect.right = GetDeviceCaps(hDC, HORZRES);
		DeskRect.bottom = GetDeviceCaps(hDC, VERTRES);
		hres = (double)GetDeviceCaps(hDC, LOGPIXELSX);
		vres = (double)GetDeviceCaps(hDC, LOGPIXELSY);
		if(StartDoc(hDC, &DocInfo) >= 0) {
			if(::StartPage(hDC)>0) bRet = true;
			}
		}
	return bRet;
}

bool
PrintWin::EndPage()
{

	if(hDC) {
		::EndPage(hDC);		EndDoc(hDC);		DeleteDC(hDC);
		}
	hDC = 0L;
	return true;
}

bool
PrintWin::Eject()
{
	if(hDC) {
		::EndPage(hDC);		::StartPage(hDC);	return true;
		}
	return false;
}

bool
PrintWin::oCircle(int x1, int y1, int x2, int y2, char* nam)
{
	BOOL RetVal;
	
	RetVal = Ellipse(hDC, x1, y1, x2, y2);
	if(RetVal && hgo) return hgo->oCircle(x1, y1, x2, y2);
	else if(RetVal) return true;
	return false;
}

bool
PrintWin::oPolyline(POINT * pts, int cp, char *nam)
{
	int i;

	if(cp < 1) return FALSE;
	if (dPattern) {
		for (i = 1; i < cp; i++) PatLine(pts[i-1], pts[i]);
		return true;
		}
	else {
		if(Polyline(hDC, pts, cp))return true;
		else return false;
		}
}

bool
PrintWin::oRectangle(int x1, int y1, int x2, int y2, char *name)
{
	BOOL RetVal;

	RetVal = Rectangle(hDC, x1, y1, x2, y2);
	if(RetVal && hgo) return hgo->oRectangle(x1, y1, x2, y2, 0L);
	else if (RetVal) return true;
	return false;
}

bool
PrintWin::oSolidLine(POINT *p)
{
	if(Polyline(hDC, p, 2)) return true;
	return false;
}

bool
PrintWin::oTextOut(int x, int y, char *txt, int cb)
{
	return com_oTextOut(x, y, txt, cb, &hFont, &hDC, &TxtSet, isWIN95, this);
}

bool
PrintWin::oPolygon(POINT *pts, int cp, char *nam)
{
	BOOL RetVal;

	RetVal = Polygon(hDC, pts, cp);
	if(RetVal && hgo) return hgo->oPolygon(pts, cp);
	else if (RetVal) return true;
	return false;
}

bool
PrintWin::oArc(int x1, int y1, int x2, int y2, int quads)
{
	return  com_Arc(hDC, x1, y1, x2, y2, quads);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Find a suitable www browser
void FindBrowser()
{
	char text[600];
	long size = 599;
	HDC dc;
	HKEY hdl;
	HWND hwnd;
	int i;

	//find the default browser
	if(ERROR_SUCCESS == RegQueryValue(HKEY_CLASSES_ROOT, "http\\shell\\open\\command", 
		text, &size) && size > 7) {
		if(text[0] == '"') {
			for(i = size-2; i >3; i--) {
				if(text[i+1] == '"') {
					text[i+1] = 0;
					break;
					}
				else text[i+1] = 0;
				}
			WWWbrowser = strdup(text+1);
			}
		else {
			for(i = size-1; i >5; i--) {
				if(0 == stricmp(text+i-3, ".exe")) break;
				else text[i] = 0;
				}
			WWWbrowser = strdup(text);
			}
		}
	//find user default data directory
	if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_CURRENT_USER, "Environment", NULL,
		KEY_READ, &hdl)) {
		text[0] = 0;	size=599;
		RegQueryValueEx(hdl, "HOMEDRIVE", 0, 0, (unsigned char*)text, (unsigned long*)&size);
		size= 599;
		RegQueryValueEx(hdl, "HOMEPATH", 0, 0, (unsigned char*)(text+strlen(text)), 
			(unsigned long*)&size);
		defs.currPath = strdup(text);
		}
	//find user application data directory
	if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_CURRENT_USER, 
		"Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", NULL,
		KEY_READ, &hdl)) {
		text[0] = 0;	size=599;
		RegQueryValueEx(hdl, "AppData", 0, 0, (unsigned char*)text, (unsigned long*)&size);
		strcat(text, "\\RLPlot");
		defs.IniFile = strdup(text);
		}
	//find country specific information
	//  its not a perfect place to do it, but a good one
	GetProfileString("intl", "sDecimal", ".", text, 2);
	if(text[0]) defs.DecPoint[0] = text[0];
	GetProfileString("intl", "sList", ".", text, 2);
	if(text[0]) defs.ColSep[0] = text[0];
	if(GetProfileInt("intl", "iMeasure", 0)) defs.dUnits = defs.cUnits = 2;
	//test if windows95
	dc = GetDC(hwnd = GetDesktopWindow());
	isWIN95 = (0 == SetGraphicsMode(dc, GM_ADVANCED));
	SetGraphicsMode(dc, GM_COMPATIBLE);
	ReleaseDC(hwnd, dc);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Shutdown or reboot windows
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
void HardExit(bool reboot)
{
	int tpsize;
	HANDLE hProcess, hAccessToken;
	TOKEN_PRIVILEGES *tp;

	hProcess = GetCurrentProcess();
	tpsize = sizeof(TOKEN_PRIVILEGES) + sizeof(LUID_AND_ATTRIBUTES);
	tp = (TOKEN_PRIVILEGES *)malloc(tpsize);
	if(tp){
		tp->PrivilegeCount = 1;
		tp->Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
		if(LookupPrivilegeValue(NULL, SE_SHUTDOWN_NAME, &tp->Privileges[0].Luid)) {
			if(OpenProcessToken(hProcess, TOKEN_ADJUST_PRIVILEGES, &hAccessToken))
				AdjustTokenPrivileges(hAccessToken, FALSE, tp, tpsize, NULL, NULL);
			}
		free(tp);
		}
	if(reboot) ExitWindowsEx(EWX_REBOOT | EWX_FORCE, NULL);
	else ExitWindowsEx(EWX_POWEROFF | EWX_FORCE, NULL);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Windos entry point
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
WINAPI WinMain( HINSTANCE hInst, HINSTANCE hPrevInstance,
	 LPSTR lpCmdLine, int nCmdShow )
{
	WNDCLASS wndclass;
	MSG	msg;
	DefsRW *drw;

	//OS dependent initialization
	dlgtxtheight = 16;

	if(lpCmdLine && lpCmdLine[0] && FileExist(lpCmdLine)) LoadFile = strdup(lpCmdLine);
	hInstance = hInst;
	wndclass.style = CS_BYTEALIGNWINDOW | CS_DBLCLKS;
	wndclass.lpfnWndProc = WndProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = sizeof(GraphObj*);
	wndclass.hInstance = hInstance;
	wndclass.hIcon = LoadIcon(hInst, MAKEINTRESOURCE(IDI_EVAL));
	wndclass.hCursor = 0L;
	wndclass.hbrBackground = NULL;
	wndclass.lpszMenuName = 0L;
	wndclass.lpszClassName = name;

	RegisterClass(&wndclass);
	ShowBanner(true);
	InitTextCursor(true);
	Printer = new PrintWin();
	accel = LoadAccelerators(hInstance, MAKEINTRESOURCE(ACCELERATORS_1));
	while(GetMessage(&msg, NULL, 0, 0)){
		TranslateMessage(&msg);
		TranslateAccelerator(msg.hwnd, accel, &msg);
		DispatchMessage(&msg);
		}
	if(defs.IniFile) {
		if(drw = new DefsRW()){
			drw->FileIO(FILE_WRITE);		delete drw;
			}
		}
	if(WWWbrowser) free(WWWbrowser);
	if(LoadFile) free(LoadFile);
	SpreadMain(false);
	if(Printer) delete Printer;
	InitTextCursor(false);
	UnregisterClass(name, hInstance);
	return msg.wParam;
}

void CopyData(GraphObj *g, unsigned int cf)
{
	HGLOBAL hmem;
	long cb;
	unsigned char *dt = 0L;
	unsigned char *buf;

	if(!g || g->Id != GO_SPREADDATA) return;
	switch(cf) {
	case CF_TEXT:
		if(!g->Command(CMD_COPY_TSV, &dt, 0L))return;
		break;
	case CF_SYLK:
		if(!g->Command(CMD_COPY_SYLK, &dt, 0L))return;
		break;
	default:
		if(cf == cf_rlpxml && g->Command(CMD_COPY_XML, &dt, 0L)) break;
		else return;
		}
	cb = strlen((char*)dt);
	if(hmem = GlobalAlloc(GMEM_MOVEABLE, cb+2)) {
		if(buf = (unsigned char *)GlobalLock(hmem)) {
			memcpy(buf, dt, cb+1);
			GlobalUnlock(hmem);
			SetClipboardData(cf, hmem);
			}
		}
}

void CopyGraph(GraphObj *g, unsigned int cf)
{
	HGLOBAL hmem;
	char *dt, *buf;
	long cb;

	if(!(dt = GraphToMem(g, &cb)))return;
	if(hmem = GlobalAlloc(GMEM_MOVEABLE, cb+1)) {
		if(buf = (char *)GlobalLock(hmem)) {
			memcpy(buf, dt, cb);
			buf[cb] = 0;
			GlobalUnlock(hmem);
			SetClipboardData(cf, hmem);
			}
		}
	free(dt);
}

void ScrollEvent(bool bVert, HWND hwnd, UINT type, GraphObj *g, OutputWin *w)
{
	SCROLLINFO si;
	int LineStep, cmd, pos;

	if(hwnd && g && w) {
		cmd = bVert ? CMD_SETVPOS : CMD_SETHPOS;
		LineStep = g->Id == GO_GRAPH ? 8 : 1;
		si.fMask = SIF_ALL;
		si.cbSize = sizeof(SCROLLINFO);
		if(!(GetScrollInfo(hwnd, bVert ? SB_VERT : SB_HORZ, &si)))return;
		switch(type){
		case SB_LINEUP:
			pos = si.nPos - LineStep;
			break;
		case SB_LINEDOWN:
			pos = si.nPos + LineStep;
			break;
		case SB_PAGEUP:
			pos = (si.nPos - (int)si.nPage) >= si.nMin ?
				(si.nPos - si.nPage) : si.nMin;
			break;
		case SB_PAGEDOWN:
			pos = ((unsigned)si.nPos + si.nPage*2) < (unsigned)si.nMax ?
				(si.nPos + si.nPage) : (si.nMax - si.nPage+1);
			break;
		case SB_THUMBTRACK:
		case SB_THUMBPOSITION:
			pos = si.nTrackPos;
			break;
		default:
			return;
			}
		g->Command(cmd, (void*)(& pos), w);
		}
}

long OpenFileFromHistory(OutputWin *w, GraphObj *g, int id)
{
	char *name = 0L;

	switch (id) {
	case 0:			name = defs.File1;			break;
	case 1:			name = defs.File2;			break;
	case 2:			name = defs.File3;			break;
	case 3:			name = defs.File4;			break;
	case 4:			name = defs.File5;			break;
	case 5:			name = defs.File6;			break;
		}
	if(name && FileExist(name)) {
		g->Command(CMD_DROPFILE, name, w);
		defs.FileHistory(name);
		w->FileHistory();
		}
	return 0;
}

static GraphObj *copy_obj;

long FAR PASCAL WndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
	static WinCopyWMF *CopyWMF = NULL;
	static BitMapWin *CopyBMP = NULL;
	static bool CtrlDown = false;
	PAINTSTRUCT ps;
	OutputWin *w;
	GraphObj *g;
	MouseEvent mev;
	HDC dc;
	int cc;

	g = (GraphObj *) GetWindowLong(hwnd, 0);
	w = (OutputWin *) GetWindowLong(hwnd, GWL_USERDATA);
	if(g && w) switch(message) {
	case WM_SETFOCUS:
		if(g->Id == GO_GRAPH) CurrGraph = (Graph*)g;
		else CurrGraph = 0L;
		break;
	case WM_LBUTTONDOWN:	case WM_LBUTTONDBLCLK:
		HideTextCursor();
	case WM_MOUSEMOVE:		case WM_RBUTTONUP:		case WM_LBUTTONUP:
		mev.x = LOWORD(lParam);
		mev.y = HIWORD(lParam);
		mev.StateFlags = 0;
		if(wParam & MK_LBUTTON) mev.StateFlags |= 1;
		if(wParam & MK_MBUTTON) mev.StateFlags |= 2;
		if(wParam & MK_RBUTTON) mev.StateFlags |= 4;
		if(wParam & MK_SHIFT) mev.StateFlags |= 8;
		if(wParam & MK_CONTROL) mev.StateFlags |= 16;
		if(message == WM_LBUTTONUP) mev.Action = MOUSE_LBUP;
		else if(message == WM_RBUTTONUP) mev.Action = MOUSE_RBUP;
		else if(message == WM_LBUTTONDBLCLK) mev.Action = MOUSE_LBDOUBLECLICK;
		else if(message == WM_LBUTTONDOWN) mev.Action = MOUSE_LBDOWN;
		else if(message == WM_MOUSEMOVE)mev.Action = MOUSE_MOVE;
		g->Command(CMD_MOUSE_EVENT, (void *)&mev, w);
		break;
	case WM_KEYDOWN:
		if(g && w && (GetKeyState(VK_LCONTROL) || GetKeyState(VK_RCONTROL))){
			cc = (wParam & 0xff);
			if(cc == 0xbb || cc == 0x6b ) g->Command(CMD_ZOOM, &"+", w);
			else if(cc == 0xbd || cc == 0x6d ) g->Command(CMD_ZOOM, &"-", w);
			else break;
			return 0;
			}
		break;
	case WM_CHAR:
		cc = (wParam & 0xff);
		g->Command(CMD_ADDCHAR, (void *)(& cc), w);
		return 0;
	case WM_VSCROLL:		case WM_HSCROLL:
		ScrollEvent(message == WM_VSCROLL, hwnd, wParam & 0xffff, g, w);
		return 0;
		}  

	switch(message) {
	case WM_CREATE:
		//assume that the first window created is the main window
		if(!MainWnd) MainWnd = hwnd;
		break;
	case WM_SIZE:
		if(g && w) g->Command(CMD_SETSCROLL, 0L, w);
		break;
	case WM_INITMENUPOPUP:		case WM_NCMOUSEMOVE:
		SetCursor(LoadCursor(NULL, IDC_ARROW));
		break;
	case WM_SETCURSOR:
		if(w) w->MouseCursor(MC_LAST, true);
		return TRUE;
	case WM_SETFOCUS:
		if(g && w) if(!g->Command(message == WM_SETFOCUS ?
			CMD_SETFOCUS : CMD_KILLFOCUS, NULL, w))
			SetCursor(LoadCursor(NULL, IDC_ARROW));
		return 0;
	case WM_DESTROYCLIPBOARD:
		return 0;
	case WM_RENDERALLFORMATS:
		// we do not support leaving data on the clipboard after exit
		OpenClipboard(hwnd);
		EmptyClipboard();
		CloseClipboard();
		return 0;
	case WM_RENDERFORMAT:
		if(g && w) switch(wParam){
			case CF_METAFILEPICT:
				CopyWMF = new WinCopyWMF(copy_obj);
				if(CopyWMF && CopyWMF->StartPage()) {
					copy_obj->DoPlot(CopyWMF);
					CopyWMF->EndPage();
					}
				delete CopyWMF;
				CopyWMF = NULL;
				if(copy_obj->Id == GO_GRAPH || copy_obj->Id == GO_PAGE) copy_obj->DoPlot(0L);
				break;
			case CF_BITMAP:
				if((CopyBMP = new BitMapWin(copy_obj)) && CopyBMP->StartPage()) {
					copy_obj->DoPlot(CopyBMP);
					CopyBMP->EndPage();
					SetClipboardData(CF_BITMAP, CopyBMP->scr);
					CopyBMP->scr = 0L;
					}
				delete CopyBMP;
				CopyBMP = NULL;
				if(copy_obj->Id == GO_GRAPH || copy_obj->Id == GO_PAGE) copy_obj->DoPlot(0L);
				break;
			case CF_SYLK:		case CF_TEXT:
				if(g->Id == GO_SPREADDATA) CopyData(g, wParam);
				break;
			default:
				if(wParam == cf_rlpgraph) CopyGraph(copy_obj, wParam);
				if(wParam == cf_rlpxml) CopyData(g, wParam);
				break;
			}
		if(w->Erase(defs.Color(COL_BG))) g->DoPlot(w);
		return 0;
	case WM_COMMAND:
		wParam &= 0xffff;
		if(g && w) switch(wParam) {
		case CM_EXIT:
			g->Command(CMD_CAN_DELETE, 0L, 0L);
			SetWindowLong(hwnd, 0, 0L);
			SetWindowLong(hwnd, GWL_USERDATA, 0L);
			w->go = 0L;
			DestroyWindow(hwnd);
			return 0;
		case CM_PASTE:
			w->MouseCursor(MC_WAIT, true);
			if(g->Id == GO_SPREADDATA || g->Id == GO_PAGE ||
				g->Id == GO_GRAPH)TestClipboard(g);
			w->MouseCursor(MC_ARROW, true);
			return 0;
		case CM_COPY:			case CM_CUT:
			EmptyClip();
			OpenClipboard(hwnd);
			if(g->Id == GO_SPREADDATA && g->Command(wParam == CM_CUT ? CMD_CUT : CMD_QUERY_COPY, 0L, w)) {
				SetClipboardData(CF_TEXT, NULL);
				SetClipboardData(CF_SYLK, NULL);
				SetClipboardData(cf_rlpxml, NULL);
				}
			CloseClipboard();
			return 0;
		case CM_UPDATE:
			g->Command(CMD_UPDATE, 0L, w);
			return 0;
		case CM_COPYGRAPH:
			EmptyClip();
			OpenClipboard(GetFocus());
			SetClipboardData(CF_METAFILEPICT, NULL);
			SetClipboardData(CF_BITMAP, NULL);
			SetClipboardData(cf_rlpgraph, NULL);
			if(g->Id == GO_PAGE && CurrGraph) CopyGraph(CurrGraph, cf_rlpobj);
			copy_obj = g;
			CloseClipboard();
			return 0;
		case CM_OPEN:
			g->Command(CMD_OPEN, (void *)NULL, w);
			return 0;
		case CM_FILE1:	case CM_FILE2:	case CM_FILE3:
		case CM_FILE4:	case CM_FILE5:	case CM_FILE6:
			return OpenFileFromHistory(w, g, wParam - CM_FILE1);
		case CM_FILLRANGE:
			g->Command(CMD_FILLRANGE, (void *)NULL, w);
			return 0;
		case CM_ABOUT:
			RLPlotInfo();
			return 0;
		case CM_ZOOM25:
			g->Command(CMD_ZOOM, &"25", w);
			return 0;
		case CM_ZOOM50:
			g->Command(CMD_ZOOM, &"50", w);
			return 0;
		case CM_ZOOM100:
			g->Command(CMD_ZOOM, &"100", w);
			return 0;
		case CM_ZOOM200:
			g->Command(CMD_ZOOM, &"200", w);
			return 0;
		case CM_ZOOM400:
			g->Command(CMD_ZOOM, &"400", w);
			return 0;
		case CM_ZOOMIN:
			g->Command(CMD_ZOOM, &"+", w);
			return 0;
		case CM_ZOOMOUT:
			g->Command(CMD_ZOOM, &"-", w);
			return 0;
		case CM_ZOOMFIT:
			g->Command(CMD_ZOOM, &"fit", w);
			return 0;
		case CM_ADDPLOT:
			g->Command(CMD_ADDPLOT, 0L, w);
			return 0;
		case CM_LEGEND:
			g->Command(CMD_LEGEND, 0L, w);
			return 0;
		case CM_LAYERS:
			g->Command(CMD_LAYERS, 0L, w);
			return 0;
		case CM_NEWGRAPH:
			g->Command(CMD_NEWGRAPH, 0L, w);
			return 0;
		case CM_NEWPAGE:
			g->Command(CMD_NEWPAGE, 0L, w);
			return 0;
		case CM_DELGRAPH:
			g->Command(CMD_DELGRAPH, 0L, w);
			return 0;
		case CM_SAVEDATAAS:
			g->Command(CMD_SAVEDATAAS, 0L, w);
			return 0;
		case CM_REDRAW:
			if(w->Erase(defs.Color(COL_BG))) g->DoPlot(w);
			return 0;
		case CM_DELOBJ:
			if(CurrGO && CurrGO->parent && CurrGO->parent->
				Command(CMD_DELOBJ, (void*)CurrGO, w)) {
				CurrGO = 0L;
				if(w->Erase(defs.Color(COL_BG))) g->DoPlot(w);
				}
			else if(!CurrGO) InfoBox("No object selected!");
			return 0;
		case CM_SAVEGRAPHAS:
			SaveGraphAs(g);
			return 0;
		case CM_EXPORT:
			OpenExportName(g, "hello.svg");
			g->DoPlot(w);
			return 0;
		case CM_PRINT:
			if(g->Id == GO_SPREADDATA){
				g->Command(CMD_PRINT, 0L, Printer);
				return 0;
				}
			if(Printer && Printer->StartPage()) {
				SetCursor(LoadCursor(0L, IDC_WAIT));
				g->DoPlot(Printer);
				Printer->EndPage();
				w->Erase(defs.Color(COL_BG));
				g->DoPlot(w);
				SetCursor(LoadCursor(0L, IDC_ARROW));
				}
			return 0;
		case CM_ADDROWCOL:
			g->Command(CMD_ADDROWCOL, (void *)NULL, w);
			return 0;
		case CM_REBOOT:
			HardExit(true);
			return 0;
		case CM_SHUTDOWN:
			HardExit(false);
			return 0;
		case CM_DEFAULTS:
			g->Command(CMD_CONFIG, 0L, w);
			return 0;
		case CM_ADDAXIS:
			g->Command(CMD_ADDAXIS, 0L, w);
			return 0;
		case CM_T_STANDARD:
			cc = TM_STANDARD;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_T_DRAW:
			cc = TM_DRAW;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_T_POLYLINE:
			cc = TM_POLYLINE;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_T_POLYGON:
			cc = TM_POLYGON;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_T_RECTANGLE:
			cc = TM_RECTANGLE;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_T_ROUNDREC:
			cc = TM_ROUNDREC;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_T_ELLIPSE:
			cc = TM_ELLIPSE;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_T_ARROW:
			cc = TM_ARROW;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_T_TEXT:
			cc = TM_TEXT;
			g->Command(CMD_TOOLMODE, (void*)(& cc), w);
			return 0;
		case CM_DELKEY:		case CM_LEFTARRKEY:		case CM_RIGHTARRKEY:
		case CM_UPARRKEY:   case CM_DOWNARRKEY:		case CM_POS_FIRST:
		case CM_POS_LAST:	case CM_SHLEFT:			case CM_SHRIGHT:
		case CM_SHUP:		case CM_SHDOWN:			case CM_TAB:
		case CM_SHTAB:
			switch(wParam) {
			case CM_DELKEY:			cc = CMD_DELETE;		break;
			case CM_LEFTARRKEY:		cc = CMD_CURRLEFT;		break;
			case CM_RIGHTARRKEY:	cc = CMD_CURRIGHT;		break;
			case CM_UPARRKEY:		cc = CMD_CURRUP;		break;
			case CM_DOWNARRKEY:		cc = CMD_CURRDOWN;		break;
			case CM_POS_FIRST:		cc = CMD_POS_FIRST;		break;
			case CM_POS_LAST:		cc = CMD_POS_LAST;		break;
			case CM_SHLEFT:			cc = CMD_SHIFTLEFT;		break;
			case CM_SHRIGHT:		cc = CMD_SHIFTRIGHT;	break;
			case CM_SHUP:			cc = CMD_SHIFTUP;		break;
			case CM_SHDOWN:			cc = CMD_SHIFTDOWN;		break;
			case CM_TAB:			cc = CMD_TAB;			break;
			case CM_SHTAB:			cc = CMD_SHTAB;			break;
				}
			g->Command(cc, (void *)NULL, w);
			return 0;
		case CM_PGUP:		case CM_PGDOWN:
			g->Command(wParam == CM_PGUP ? CMD_PAGEUP : CMD_PAGEDOWN, 0L, w);
			return 0;
		case CM_UNDO:
			g->Command(CMD_UNDO, 0L, w);
			return 0;
		default:
			sprintf(TmpTxt, "Command 0x%x (%d)\nreceived", wParam & 0xffff,
				wParam & 0xffff);
			MessageBox(hwnd, TmpTxt, "Info", MB_OK | MB_ICONINFORMATION);
		}
		return 0;
	case WM_CLOSE:
		if(g) {
			g->Command(CMD_CAN_DELETE, 0L, 0L);
			SetWindowLong(hwnd, 0, 0L);
			SetWindowLong(hwnd, GWL_USERDATA, 0L);
			w->go = 0L;
			}
		DestroyWindow(hwnd);
		return 0;
	case WM_DESTROY:
		if(hwnd == MainWnd)PostQuitMessage(0);
		break;
	case WM_PAINT:
		dc = BeginPaint(hwnd, &ps);
		if(w && dc) w->UpdateRect(dc, ps.rcPaint);
		EndPaint(hwnd, &ps);
		break;
	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Dialog window: Windows specific
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
const char dlgname[] = "RLDLGWIN";

long FAR PASCAL DlgWndProc(HWND hwnd, UINT message, UINT wParam, LONG lParam)
{
	OutputWin *w;
	tag_DlgObj *d;
	PAINTSTRUCT ps;
	HDC dc;
	MouseEvent mev;
	int i, cc;

	d = (tag_DlgObj *) GetWindowLong(hwnd, 0);
	w = (OutputWin *) GetWindowLong(hwnd, GWL_USERDATA);
	switch(message) {
	case WM_CREATE:
		break;
	case WM_KILLFOCUS:
		HideTextCursorObj(w);
		if(d) d->Command(CMD_ENDDIALOG, NULL, w);
		return 0;
	case WM_TIMER:
		if(d) d->Command(CMD_ENDDIALOG, d, w);
		return 0;
	case WM_DESTROY:	case WM_CLOSE:
		if(d) {
			d->Command(CMD_UNLOCK, 0L, w);
			d->Command(CMD_ENDDIALOG, 0L, w);
			SetWindowLong(hwnd, 0, NULL);
			}
		if(w) {
			SetWindowLong(hwnd, GWL_USERDATA, NULL);
			delete w;
			}
		break;
	case WM_CHAR:
		if(0x09 == (cc = wParam & 0xff)) break;		//ignore Tab
		if(d && w) d->Command(CMD_ADDCHAR, (void *)(& cc), w);
		break;
	case WM_LBUTTONDOWN:	case WM_LBUTTONDBLCLK:
		HideTextCursor();
	case WM_RBUTTONUP:		case WM_LBUTTONUP:		case WM_MOUSEMOVE:
		mev.x = LOWORD(lParam);		mev.y = HIWORD(lParam);		mev.StateFlags = 0;
		if(wParam & MK_LBUTTON) mev.StateFlags |= 1;
		if(wParam & MK_MBUTTON) mev.StateFlags |= 2;
		if(wParam & MK_RBUTTON) mev.StateFlags |= 4;
		if(wParam & MK_SHIFT) mev.StateFlags |= 8;
		if(wParam & MK_CONTROL) mev.StateFlags |= 16;
		if(message == WM_MOUSEMOVE) mev.Action = MOUSE_MOVE;
		else if(message == WM_LBUTTONDOWN) mev.Action = MOUSE_LBDOWN;
		else if(message == WM_LBUTTONUP) mev.Action = MOUSE_LBUP;
		else if(message == WM_RBUTTONUP) mev.Action = MOUSE_RBUP;
		else if(message == WM_LBUTTONDBLCLK) mev.Action = MOUSE_LBDOUBLECLICK;
		if(d && w) d->Command(CMD_MOUSE_EVENT, (void *)&mev, w);
		break;
	case WM_COMMAND:
		wParam &= 0xffff;
		i = 0;
		switch(wParam) {
		case CM_DELKEY:			i = CMD_DELETE;		break;
		case CM_LEFTARRKEY:		i = CMD_CURRLEFT;	break;
		case CM_RIGHTARRKEY:	i = CMD_CURRIGHT;	break;
		case CM_UPARRKEY:		i = CMD_CURRUP;		break;
		case CM_DOWNARRKEY:		i = CMD_CURRDOWN;	break;
		case CM_TAB:			i = CMD_TAB;		break;
		case CM_SHTAB:			i = CMD_SHTAB;		break;
		case CM_POS_FIRST:		i = CMD_POS_FIRST;	break;
		case CM_POS_LAST:		i = CMD_POS_LAST;	break;
		case CM_SHLEFT:			i = CMD_SHIFTLEFT;	break;
		case CM_SHRIGHT:		i = CMD_SHIFTRIGHT;	break;
		case CM_UNDO:			i = CMD_UNDO;		break;
			}
		if(i && d && w) d->Command(i, 0L, w);
		return 0;
	case WM_PAINT:
		dc = BeginPaint(hwnd, &ps);
		if(w && dc){
      		w->HideMark();		w->UpdateRect(dc, ps.rcPaint);
			}
		EndPaint(hwnd, &ps);
		break;
	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}

void *CreateDlgWnd(char *title, int x, int y, int width, int height, tag_DlgObj *d, DWORD flags)
{
	WNDCLASS wndclass;
	OutputWin *w;
	HWND hDlg, hFoc;
	RECT rec, BoxRec, DeskRect;
	DWORD ws;

	wndclass.style = CS_BYTEALIGNWINDOW | CS_DBLCLKS;
	wndclass.lpfnWndProc = DlgWndProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = sizeof(tag_DlgObj *);
	wndclass.hInstance = hInstance;
	wndclass.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_EVAL));
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = NULL;
	wndclass.lpszMenuName = NULL;
	wndclass.lpszClassName = dlgname;
	RegisterClass(&wndclass);
	hFoc = GetFocus();
	if(hFoc) {
		GetWindowRect(hFoc, &rec);
		x += rec.left;
		y += rec.top;
		}
	ws = WS_POPUP | WS_VISIBLE | WS_CLIPSIBLINGS;
	if(!(flags & 0x2)) ws |= WS_CAPTION;
	hDlg = CreateWindow(dlgname, title,	ws,
		x, y, width, height, GetFocus(), NULL, hInstance, NULL);
	w = new OutputWin(0L, hDlg);
	w->units = defs.cUnits;
	if(hDlg && w && w->Erase(0x00c0c0c0L)) {
		SetWindowLong(hDlg, GWL_USERDATA, (long)w);
		SetWindowLong(hDlg, 0, (long)d);
		ShowWindow(hDlg, SW_SHOW);
		if(flags & 0x01) {					//center on screen
			GetWindowRect(hDlg, &BoxRec);
			GetClientRect(GetDesktopWindow(), &DeskRect);
			SetWindowPos(hDlg, HWND_TOPMOST, (DeskRect.right -DeskRect.left)/2 -
				(BoxRec.right - BoxRec.left)/2, (DeskRect.bottom -DeskRect.top)/2 -
				(BoxRec.bottom- BoxRec.top)/2, BoxRec.right - BoxRec.left,
				BoxRec.bottom - BoxRec.top, 0);
			}
		if(flags & 0x04)			SetTimer(hDlg, 1, 100, 0L);
		UpdateWindow(hDlg);			d->DoPlot(w);
		}
	else {
		if(w) delete (w);			return 0L;
		}
	return hDlg;
}

void LoopDlgWnd() 	//keep message processing running
{
	MSG	msg;
	
	GetMessage(&msg, NULL, 0, 0);	TranslateMessage(&msg);
	TranslateAccelerator(msg.hwnd, accel, &msg);
	DispatchMessage(&msg);
}

void CloseDlgWnd(void *hDlg)
{
	if(hDlg) SendMessage((HWND)hDlg, WM_CLOSE, 0, 0);
}

void ShowDlgWnd(void *hDlg)
{
	ShowWindow((HWND)hDlg, SW_SHOW);
	SetFocus((HWND)hDlg);
}

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// OS independent interface to Windows specific classes
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
anyOutput *NewDispClass(GraphObj *g)
{
	return new OutputWin(g, 0L);
}

bool DelDispClass(anyOutput *w)
{
	if (w) delete (OutputWin*) w;
	return true;
}

anyOutput *NewBitmapClass(int w, int h, double hr, double vr)
{
	return new BitMapWin(w, h, hr, vr);
}

bool DelBitmapClass(anyOutput *w)
{
	if (w) delete (BitMapWin*) w;
	return true;
}
