
from Ft.Server.Protocols.CORBA.FtOmniorb import Client
from Ft.Server.Console import Authenticate
import FtssExceptions, FtssTypes, FtServerResources
from Ft.Server import Error
from Ft.Server.Core import Constants


def RunWrappedModule(tester,mod):
    RunWrappedFunction(tester,mod.Test)
        

def RunWrappedFunction(tester,func):
    if not tester.test_data['has_omniorb']: return
    oldUtil = tester.test_data['util']
    newUtil = FtssCorbaTester()
    newUtil.__dict__.update(oldUtil.__dict__)
    tester.test_data['util'] = newUtil
    from Ft.Server.Console.ManagerCommands import Start, Stop
    Start.Run(['OmniorbServer'],tester.test_data['util'].configFileName,display=0)
    try:
        func(tester)
    finally:
        Stop.Run(['OmniorbServer'],tester.test_data['util'].configFileName,display=0)
    
    tester.test_data['util'] = oldUtil
    
    





class FtssCorbaTester:

        
    def getRepo(self,userName=None,passwd=None):
        self.called = 1
        fac = Client.GetFactory()
        return fac.getRepository(userName or self.userName,passwd or self.passwd)

    def getAnonRepo(self):
        self.called = 1
        fac = Client.GetFactory()
        return fac.getRepositoryAsAnonymous()

    


    def compareAclIdentifiers(self,expected,actual):
        self.tester.compare(len(expected),len(actual))
        for a in actual:
            self.tester.compareIn(expected,a)

    def testFtException(self,method,args,code):
        if not self.exceptionMap.has_key(code):
            raise "Unknown Exception Mapping %s" % code
        self.tester.testException(method,args,self.exceptionMap[code])


    def compareResourceType(self,expected,actual):
        if not self.toCorbaResourceType.has_key(expected):
            raise "Unknown Resource Type Mapping: %s" % expected
        self.tester.compare(self.toCorbaResourceType[expected],actual)


    def compareResourceItem(self,item,expectedName,expectedValue):
        self.tester.compare(expectedName,item.name)
        self.tester.compare(expectedValue.uri,item.value.uri)

    def compareIsResourceType(self,res,resType,expected):
        if not self.toCorbaResourceType.has_key(resType):
            raise "Unknown Resource Type Mapping: %s" % resType

        self.tester.compare(expected,res.isResourceType(self.toCorbaResourceType[resType]))

    def testDefaultGet(self,expected,res,attrName):
        return


    def isSystemUserContainer(self,res):
        self.tester.compare(1,isinstance(res,FtServerResources._objref_SystemUserContainerIf))

    def isSystemSuperUserContainer(self,res):
        self.tester.compare(1,isinstance(res,FtServerResources._objref_SystemSuperUserContainerIf))

    def isSystemGroupContainer(self,res):
        self.tester.compare(1,isinstance(res,FtServerResources._objref_SystemGroupContainerIf))

    def isSystemDocDefContainer(self,res):
        self.tester.compare(1,isinstance(res,FtServerResources._objref_SystemDocDefContainerIf))


    def compareValidationInfo(self,expected,actual):
        if expected is None or expected.validationType == Constants.ValidationType.NONE:
            self.tester.compare(FtssTypes.NONE,actual.type)
        elif expected.validationType == Constants.ValidationType.SCHEMATRON:
            self.tester.compare(FtssTypes.SCHEMATRON,actual.type)
            self.compareDocumentReference(expected.documentReference,actual.validationDoc)
        elif expected.validationType == Constants.ValidationType.DTD:
            self.tester.compare(FtssTypes.DTD,actual.type)
            self.compareDocumentReference(expected.documentReference,actual.validationDoc)

    def compareDocumentReference(self,expected,actual):
        if expected.referenceType == Constants.DocumentReferenceType.STRING:
            self.tester.compare(FtssTypes.DOCUMENT_STRING,actual.type)
            self.tester.compare(expected.data,actual.source)
            self.tester.compare(expected.baseUri,actual.baseUri)
        elif expected.referenceType == Constants.DocumentReferenceType.EXTERNAL:
            self.tester.compare(FtssTypes.EXTERNAL,actual.type)
            self.tester.compare(expected.uri,actual.theUri)
        elif expected.referenceType == Constants.DocumentReferenceType.INTERNAL:
            self.tester.compare(FtssTypes.INTERNAL,actual.type)
            self.tester.compare(expected.uri,actual.theUri)

    def compareAsDom(self,docElem,res):
        pass


    def compareAsStylesheet(self,res):
        pass

    def compareAsSchematron(self,res):
        pass

    def compareNsMap(self,expected,actual):
        self.tester.compare(len(expected.keys()),len(actual))
        for n in actual:
            self.tester.compare(1,expected.has_key(n.prefix))
            self.tester.compare(expected[n.prefix],n.namespaceURI)
                     
    def compareRdfMaps(self,expected,actual):
        self.tester.compare(len(expected),len(actual))
        for s,p,o in expected:
            for r in actual:
                if r.subjectExpression == s and r.predicateExpression == p and r.objectExpression == o:
                    break
            else:
                self.error("RdfMapping %s %s %s not present" % (s,p,o))
        
            
    def testCreationParams(self,expected,actual):
        self.tester.compare(expected.fullTextIndex,actual.fullTextIndex)
        if expected.creationFlags == Constants.CreationFlags.CREATE_AS_XML:
            self.tester.compare(actual._class,FtssTypes.XML_DOCUMENT)
            self.compareValidationInfo(expected.validationInfo,actual.validationInfo)
        elif expected.creationFlags == Constants.CreationFlags.CREATE_AS_XSLT:
            self.tester.compare(actual._class,FtssTypes.XSLT_DOCUMENT)
            self.tester.compare(expected.validate,actual.validate)
        elif expected.creationFlags == Constants.CreationFlags.CREATE_AS_SCHEMATRON:
            self.tester.compare(actual._class,FtssTypes.SCHEMATRON_DOCUMENT)
            self.tester.compare(expected.validate,actual.validate)


    def compareGeneratedStatements(self,expected,actual):

        for s,p,o in expected:
            for a in actual:
                if a.subject == s and a.predicate == p and a.object_ == o:
                    break
            else:
                self.error("Missing generated statent %s %s %s" % (s,p,o))

    def compareRdfStatements(self,expected,actual):

        for s,p,o,u,su in expected:
            for a in actual:
                #print a.subject, a.predicate, a.object_
                if a.subject == s and a.predicate == p and a.object_ == o and a.statementUri == u and a.domain == su:
                    break
            else:
                self.error("Missing generated statent '%s' '%s' '%s' '%s' '%s'" % (s,p,o,u,su))




    exceptionMap = {Error.INVALID_LOGIN:FtssExceptions.InvalidLoginException,
                    Error.OBJECT_DELETED:FtssExceptions.ObjectHasBeenDeletedException,
                    }


    toCorbaResourceType = {Constants.ResourceType.CONTAINER:FtssTypes.CONTAINER_RESOURCE,
                           Constants.ResourceType.ALIAS:FtssTypes.ALIAS_RESOURCE,
                           Constants.ResourceType.FILE:FtssTypes.FILE_RESOURCE,
                           Constants.ResourceType.XML_DOCUMENT:FtssTypes.XML_DOCUMENT_RESOURCE,
                           Constants.ResourceType.XSLT_DOCUMENT:FtssTypes.XSLT_DOCUMENT_RESOURCE,
                           Constants.ResourceType.SCHEMATRON_DOCUMENT:FtssTypes.SCHEMATRON_DOCUMENT_RESOURCE,
                           }


##    USER = 7
##    GROUP = 8
##    DOCUMENT_DEFINITION = 9
##    GROUP_SYSTEM_CONTAINER = 10
##    USER_SYSTEM_CONTAINER = 11
##    SUPER_USER_SYSTEM_CONTAINER = 12
##    DOCDEF_SYSTEM_CONTAINER = 13
##    REPOSITORY = 14
##    REPOSITORY_OBJECT = 15

